# A very rudimentary test for libfunutils.
#
# Given a path (defaults to ${prefix}) it expects to find libfunUtil.a
# in PREFIX/lib or PREFIX/lib/fun and fun/fun.h under PREFIX/include.
#
# usage:
# define this in your shared makefile: 
#
# configure_with_libfunutil = @configure_with_libfunutil@
# ifeq (1,$(configure_with_libfunutil))
# FUNLIB_INCLUDE_PATH = @FUNLIB_INCLUDE_PATH@ # abs path to fun headers
# FUNLIB_A = @FUNLIB_A@ # abs path to libfunUtil.a
# FUNLIB_SO = @FUNLIB_SO@ # abs path to libfunUtil.so
# endif
#
# Then do a similar ifeq() where you need to conditionally build:
#
# ifeq (1,$(configure_with_libfunutil))
# BIN_PRGRAMS_LDADD += -l$(FUNLIB_SO)
# INCLUDES += -I$(FUNLIB_INCLUDE_PATH)
# endif
#
# Then toc_test_require{ok} this. Use --with-libfunutil[=PREFIX] to enable it,
# or set the var configure_with_libfunutil to 1 or PREFIX. This test
# re-sets configure_with_libfunutil to 1 on success, 0 on error.
#
# It is assumed that C++ clients will use #include <fun/fun.h> instead
# of #include "fun.h", and the generated LIBFUN_INCLUDE_PATH path
# reflects that.
#
# --with-libfunutil  same as --with-libfunutil=${prefix}
# --with-libfunutil=PREFIX looks in PREFIX/include[/fun] and PREFIX/lib[/fun]
#
# This test sets HAVE_LIBFUNUTIL to 0 or 1 in config.h and sets the
# configure_withlibfunutil makefile and shell vars to 0 or 1.

toc_add_config_h HAVE_LIBFUNUTIL=0
toc_add_make configure_with_libfunutil=0

test "${configure_with_libfunutil-0}" = "0" && {
        configure_with_libfunutil=0
        echo "libfunutil has not been enabled. Use --with-libfunutil[=PREFIX] to enable it."
        return 1
}

test "${configure_with_libfunutil}" = "1" && configure_with_libfunutil=${prefix}
libpath=${configure_with_libfunutil}/lib:${configure_with_libfunutil}/lib/fun
toc_find_in_path libfunUtil.a $libpath || {
    echo "libfunUtil.a not found in [$libpath] ${TOC_EMOTICON_ERROR}"
    return 1
}
lfun=${TOC_FIND_RESULT}

toc_find libfunUtil.so $libpath || return 1
sofun=${TOC_FIND_FAILOK}

incpath=${configure_with_libfunutil}/include
toc_find fun/fun.h $incpath  || {
    return 1
}
hpath=${TOC_FIND_FAILOK%%/fun/*}
toc_add_config_h HAVE_LIBFUNUTIL=1
toc_add_make configure_with_libfunutil=1
toc_add_make FUNLIB_A=$lfun
toc_add_make FUNLIB_SO=$sofun
toc_add_make FUNLIB_INCLUDE_PATH="$hpath"
#echo "lib: $lfun"
#echo "headers root: $hpath"

return 0
