using System;
using System.Runtime.InteropServices;
 
//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbmlcs {

class libsbmlPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacks_libsbml(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_libsbml(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new global::System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new global::System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new global::System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new global::System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new global::System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new global::System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new global::System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new global::System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new global::System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new global::System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new global::System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new global::System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      global::System.Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new global::System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      global::System.Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new global::System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_libsbml(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_libsbml(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [global::System.ThreadStatic]
    private static global::System.Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(global::System.Exception e) {
      if (pendingException != null)
        throw new global::System.ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(libsbmlPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static global::System.Exception Retrieve() {
      global::System.Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(libsbmlPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="SWIGRegisterStringCallback_libsbml")]
    public static extern void SWIGRegisterStringCallback_libsbml(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_libsbml(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  static libsbmlPINVOKE() {
  }


  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelCreatorList")]
  public static extern global::System.IntPtr new_ModelCreatorList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ModelCreatorList")]
  public static extern void delete_ModelCreatorList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreatorList_add")]
  public static extern void ModelCreatorList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreatorList_get")]
  public static extern global::System.IntPtr ModelCreatorList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreatorList_prepend")]
  public static extern void ModelCreatorList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreatorList_remove")]
  public static extern global::System.IntPtr ModelCreatorList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreatorList_getSize")]
  public static extern uint ModelCreatorList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_DateList")]
  public static extern global::System.IntPtr new_DateList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_DateList")]
  public static extern void delete_DateList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_DateList_add")]
  public static extern void DateList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_DateList_get")]
  public static extern global::System.IntPtr DateList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_DateList_prepend")]
  public static extern void DateList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_DateList_remove")]
  public static extern global::System.IntPtr DateList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_DateList_getSize")]
  public static extern uint DateList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CVTermList")]
  public static extern global::System.IntPtr new_CVTermList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_CVTermList")]
  public static extern void delete_CVTermList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTermList_add")]
  public static extern void CVTermList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTermList_get")]
  public static extern global::System.IntPtr CVTermList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTermList_prepend")]
  public static extern void CVTermList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTermList_remove")]
  public static extern global::System.IntPtr CVTermList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTermList_getSize")]
  public static extern uint CVTermList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ASTNodeList")]
  public static extern global::System.IntPtr new_ASTNodeList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ASTNodeList")]
  public static extern void delete_ASTNodeList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeList_add")]
  public static extern void ASTNodeList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeList_get")]
  public static extern global::System.IntPtr ASTNodeList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeList_prepend")]
  public static extern void ASTNodeList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeList_remove")]
  public static extern global::System.IntPtr ASTNodeList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeList_getSize")]
  public static extern uint ASTNodeList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespacesList")]
  public static extern global::System.IntPtr new_SBMLNamespacesList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLNamespacesList")]
  public static extern void delete_SBMLNamespacesList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespacesList_add")]
  public static extern void SBMLNamespacesList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespacesList_get")]
  public static extern global::System.IntPtr SBMLNamespacesList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespacesList_prepend")]
  public static extern void SBMLNamespacesList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespacesList_remove")]
  public static extern global::System.IntPtr SBMLNamespacesList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespacesList_getSize")]
  public static extern uint SBMLNamespacesList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBaseList")]
  public static extern global::System.IntPtr new_SBaseList();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBaseList")]
  public static extern void delete_SBaseList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseList_add")]
  public static extern void SBaseList_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseList_get")]
  public static extern global::System.IntPtr SBaseList_get(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseList_prepend")]
  public static extern void SBaseList_prepend(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseList_remove")]
  public static extern global::System.IntPtr SBaseList_remove(global::System.Runtime.InteropServices.HandleRef jarg1, uint jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseList_getSize")]
  public static extern uint SBaseList_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  protected class SWIGWStringHelper {

    public delegate string SWIGWStringDelegate(global::System.IntPtr message);
    static SWIGWStringDelegate wstringDelegate = new SWIGWStringDelegate(CreateWString);

    [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="SWIGRegisterWStringCallback_libsbml")]
    public static extern void SWIGRegisterWStringCallback_libsbml(SWIGWStringDelegate wstringDelegate);

    static string CreateWString([global::System.Runtime.InteropServices.MarshalAs(global::System.Runtime.InteropServices.UnmanagedType.LPWStr)]global::System.IntPtr cString) {
      return global::System.Runtime.InteropServices.Marshal.PtrToStringUni(cString);
    }

    static SWIGWStringHelper() {
      SWIGRegisterWStringCallback_libsbml(wstringDelegate);
    }
  }

  static protected SWIGWStringHelper swigWStringHelper = new SWIGWStringHelper();


  class CustomExceptionHelper {
    // C# delegate for the C/C++ customExceptionCallback
    public delegate void CustomExceptionDelegate(string message, int type);
    static CustomExceptionDelegate customDelegate =
                                   new CustomExceptionDelegate(SetPendingCustomException);

    [DllImport("libsbmlcs", EntryPoint="CustomExceptionRegisterCallback")]
    public static extern
           void CustomExceptionRegisterCallback(CustomExceptionDelegate customCallback);

    static void SetPendingCustomException(string message, int type) {
      if (type == 0)
      SWIGPendingException.Set(new SBMLConstructorException(message));
	  else 
		SWIGPendingException.Set(new XMLConstructorException(message));
    }

    static CustomExceptionHelper() {
      CustomExceptionRegisterCallback(customDelegate);
    }
  }

  // The following pragma's disable the compiler warning that the variable is
  // never used.  Don't remove the actual code, though, or you will get 
  // compile-time errors.

  #pragma warning disable 0414
  static CustomExceptionHelper exceptionHelper = new CustomExceptionHelper();
  #pragma warning restore 0414


  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_OStream__SWIG_0")]
  public static extern global::System.IntPtr new_OStream__SWIG_0(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_OStream__SWIG_1")]
  public static extern global::System.IntPtr new_OStream__SWIG_1();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_OStream")]
  public static extern void delete_OStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OStream_get_ostream")]
  public static extern global::System.IntPtr OStream_get_ostream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OStream_endl")]
  public static extern void OStream_endl(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_OFStream__SWIG_0")]
  public static extern global::System.IntPtr new_OFStream__SWIG_0(string jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_OFStream__SWIG_1")]
  public static extern global::System.IntPtr new_OFStream__SWIG_1(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_OFStream")]
  public static extern void delete_OFStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OFStream_open__SWIG_0")]
  public static extern void OFStream_open__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OFStream_open__SWIG_1")]
  public static extern void OFStream_open__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OFStream_close")]
  public static extern void OFStream_close(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OFStream_is_open")]
  public static extern bool OFStream_is_open(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_OStringStream")]
  public static extern global::System.IntPtr new_OStringStream();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OStringStream_str__SWIG_0")]
  public static extern string OStringStream_str__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OStringStream_str__SWIG_1")]
  public static extern void OStringStream_str__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_OStringStream")]
  public static extern void delete_OStringStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getLibSBMLVersion")]
  public static extern int getLibSBMLVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getLibSBMLDottedVersion")]
  public static extern string getLibSBMLDottedVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getLibSBMLVersionString")]
  public static extern string getLibSBMLVersionString();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_isLibSBMLCompiledWith")]
  public static extern int isLibSBMLCompiledWith(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getLibSBMLDependencyVersionOf")]
  public static extern string getLibSBMLDependencyVersionOf(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OperationReturnValue_toString")]
  public static extern string OperationReturnValue_toString(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_IdList__SWIG_0")]
  public static extern global::System.IntPtr new_IdList__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_IdList__SWIG_1")]
  public static extern global::System.IntPtr new_IdList__SWIG_1(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_append")]
  public static extern void IdList_append(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_contains")]
  public static extern bool IdList_contains(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_empty")]
  public static extern bool IdList_empty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_removeIdsBefore")]
  public static extern void IdList_removeIdsBefore(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_size")]
  public static extern uint IdList_size(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_clear")]
  public static extern void IdList_clear(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdList_at")]
  public static extern string IdList_at(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_IdList")]
  public static extern void delete_IdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_IdentifierTransformer")]
  public static extern global::System.IntPtr new_IdentifierTransformer();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_IdentifierTransformer")]
  public static extern void delete_IdentifierTransformer(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdentifierTransformer_transform")]
  public static extern int IdentifierTransformer_transform(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdentifierTransformer_transformSwigExplicitIdentifierTransformer")]
  public static extern int IdentifierTransformer_transformSwigExplicitIdentifierTransformer(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_IdentifierTransformer_director_connect")]
  public static extern void IdentifierTransformer_director_connect(global::System.Runtime.InteropServices.HandleRef jarg1, IdentifierTransformer.SwigDelegateIdentifierTransformer_0 delegate0);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ElementFilter")]
  public static extern global::System.IntPtr new_ElementFilter();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ElementFilter")]
  public static extern void delete_ElementFilter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ElementFilter_filter")]
  public static extern bool ElementFilter_filter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ElementFilter_filterSwigExplicitElementFilter")]
  public static extern bool ElementFilter_filterSwigExplicitElementFilter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ElementFilter_director_connect")]
  public static extern void ElementFilter_director_connect(global::System.Runtime.InteropServices.HandleRef jarg1, ElementFilter.SwigDelegateElementFilter_0 delegate0);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLReader")]
  public static extern global::System.IntPtr new_SBMLReader();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLReader")]
  public static extern void delete_SBMLReader(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReader_readSBML")]
  public static extern global::System.IntPtr SBMLReader_readSBML(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReader_readSBMLFromFile")]
  public static extern global::System.IntPtr SBMLReader_readSBMLFromFile(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReader_readSBMLFromString")]
  public static extern global::System.IntPtr SBMLReader_readSBMLFromString(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReader_hasZlib")]
  public static extern bool SBMLReader_hasZlib();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReader_hasBzip2")]
  public static extern bool SBMLReader_hasBzip2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_readSBML")]
  public static extern global::System.IntPtr readSBML(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_readSBMLFromFile")]
  public static extern global::System.IntPtr readSBMLFromFile(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_readSBMLFromString")]
  public static extern global::System.IntPtr readSBMLFromString(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLWriter")]
  public static extern global::System.IntPtr new_SBMLWriter();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLWriter")]
  public static extern void delete_SBMLWriter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_setProgramName")]
  public static extern int SBMLWriter_setProgramName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_setProgramVersion")]
  public static extern int SBMLWriter_setProgramVersion(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_writeSBML__SWIG_0")]
  public static extern bool SBMLWriter_writeSBML__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_writeSBML__SWIG_1")]
  public static extern bool SBMLWriter_writeSBML__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_writeToString")]
  public static extern string SBMLWriter_writeToString(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_writeSBMLToFile")]
  public static extern bool SBMLWriter_writeSBMLToFile(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_writeSBMLToString")]
  public static extern string SBMLWriter_writeSBMLToString(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_hasZlib")]
  public static extern bool SBMLWriter_hasZlib();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLWriter_hasBzip2")]
  public static extern bool SBMLWriter_hasBzip2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_writeSBML")]
  public static extern int writeSBML(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_writeSBMLToString")]
  public static extern string writeSBMLToString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_writeSBMLToFile")]
  public static extern int writeSBMLToFile(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTypeCode_toString")]
  public static extern string SBMLTypeCode_toString(int jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBase")]
  public static extern void delete_SBase(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_clone")]
  public static extern global::System.IntPtr SBase_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getElementBySId__SWIG_0")]
  public static extern global::System.IntPtr SBase_getElementBySId__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getElementByMetaId__SWIG_0")]
  public static extern global::System.IntPtr SBase_getElementByMetaId__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_renameSIdRefs")]
  public static extern void SBase_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_renameMetaIdRefs")]
  public static extern void SBase_renameMetaIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_renameUnitSIdRefs")]
  public static extern void SBase_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_replaceSIDWithFunction")]
  public static extern void SBase_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_divideAssignmentsToSIdByFunction")]
  public static extern void SBase_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_multiplyAssignmentsToSIdByFunction")]
  public static extern void SBase_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getElementFromPluginsBySId")]
  public static extern global::System.IntPtr SBase_getElementFromPluginsBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getElementFromPluginsByMetaId")]
  public static extern global::System.IntPtr SBase_getElementFromPluginsByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasNonstandardIdentifierBeginningWith")]
  public static extern bool SBase_hasNonstandardIdentifierBeginningWith(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_prependStringToAllIdentifiers")]
  public static extern int SBase_prependStringToAllIdentifiers(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_transformIdentifiers")]
  public static extern int SBase_transformIdentifiers(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getMetaId")]
  public static extern string SBase_getMetaId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getId")]
  public static extern string SBase_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getIdAttribute")]
  public static extern string SBase_getIdAttribute(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getName")]
  public static extern string SBase_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNotes__SWIG_0")]
  public static extern global::System.IntPtr SBase_getNotes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNotesString__SWIG_0")]
  public static extern string SBase_getNotesString__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getAnnotation__SWIG_0")]
  public static extern global::System.IntPtr SBase_getAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getAnnotationString__SWIG_0")]
  public static extern string SBase_getAnnotationString__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNamespaces")]
  public static extern global::System.IntPtr SBase_getNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getSBMLDocument__SWIG_0")]
  public static extern global::System.IntPtr SBase_getSBMLDocument__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getParentSBMLObject__SWIG_0")]
  public static extern global::System.IntPtr SBase_getParentSBMLObject__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getAncestorOfType__SWIG_0")]
  public static extern global::System.IntPtr SBase_getAncestorOfType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getAncestorOfType__SWIG_1")]
  public static extern global::System.IntPtr SBase_getAncestorOfType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getSBOTerm")]
  public static extern int SBase_getSBOTerm(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getSBOTermID")]
  public static extern string SBase_getSBOTermID(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getSBOTermAsURL")]
  public static extern string SBase_getSBOTermAsURL(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getLine")]
  public static extern uint SBase_getLine(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getColumn")]
  public static extern uint SBase_getColumn(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getModelHistory__SWIG_0")]
  public static extern global::System.IntPtr SBase_getModelHistory__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetMetaId")]
  public static extern bool SBase_isSetMetaId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetId")]
  public static extern bool SBase_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetIdAttribute")]
  public static extern bool SBase_isSetIdAttribute(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetName")]
  public static extern bool SBase_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetNotes")]
  public static extern bool SBase_isSetNotes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetAnnotation")]
  public static extern bool SBase_isSetAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetSBOTerm")]
  public static extern bool SBase_isSetSBOTerm(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setMetaId")]
  public static extern int SBase_setMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetModelHistory")]
  public static extern bool SBase_isSetModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setId")]
  public static extern int SBase_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setIdAttribute")]
  public static extern int SBase_setIdAttribute(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setName")]
  public static extern int SBase_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setAnnotation__SWIG_0")]
  public static extern int SBase_setAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setAnnotation__SWIG_1")]
  public static extern int SBase_setAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_appendAnnotation__SWIG_0")]
  public static extern int SBase_appendAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_appendAnnotation__SWIG_1")]
  public static extern int SBase_appendAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_removeTopLevelAnnotationElement__SWIG_0")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_removeTopLevelAnnotationElement__SWIG_1")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_removeTopLevelAnnotationElement__SWIG_2")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_replaceTopLevelAnnotationElement__SWIG_0")]
  public static extern int SBase_replaceTopLevelAnnotationElement__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_replaceTopLevelAnnotationElement__SWIG_1")]
  public static extern int SBase_replaceTopLevelAnnotationElement__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setNotes__SWIG_0")]
  public static extern int SBase_setNotes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setNotes__SWIG_1")]
  public static extern int SBase_setNotes__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setNotes__SWIG_2")]
  public static extern int SBase_setNotes__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_appendNotes__SWIG_0")]
  public static extern int SBase_appendNotes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_appendNotes__SWIG_1")]
  public static extern int SBase_appendNotes__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setModelHistory")]
  public static extern int SBase_setModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_connectToParent")]
  public static extern void SBase_connectToParent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_connectToChild")]
  public static extern void SBase_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setSBOTerm__SWIG_0")]
  public static extern int SBase_setSBOTerm__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setSBOTerm__SWIG_1")]
  public static extern int SBase_setSBOTerm__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setNamespaces")]
  public static extern int SBase_setNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetMetaId")]
  public static extern int SBase_unsetMetaId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetId")]
  public static extern int SBase_unsetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetIdAttribute")]
  public static extern int SBase_unsetIdAttribute(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetName")]
  public static extern int SBase_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetNotes")]
  public static extern int SBase_unsetNotes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetAnnotation")]
  public static extern int SBase_unsetAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetSBOTerm")]
  public static extern int SBase_unsetSBOTerm(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_addCVTerm__SWIG_0")]
  public static extern int SBase_addCVTerm__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_addCVTerm__SWIG_1")]
  public static extern int SBase_addCVTerm__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getCVTerms__SWIG_0")]
  public static extern global::System.IntPtr SBase_getCVTerms__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNumCVTerms")]
  public static extern uint SBase_getNumCVTerms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getCVTerm")]
  public static extern global::System.IntPtr SBase_getCVTerm(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetCVTerms")]
  public static extern int SBase_unsetCVTerms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetModelHistory")]
  public static extern int SBase_unsetModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getResourceBiologicalQualifier")]
  public static extern int SBase_getResourceBiologicalQualifier(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getResourceModelQualifier")]
  public static extern int SBase_getResourceModelQualifier(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getModel")]
  public static extern global::System.IntPtr SBase_getModel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getLevel")]
  public static extern uint SBase_getLevel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getVersion")]
  public static extern uint SBase_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPackageCoreVersion")]
  public static extern uint SBase_getPackageCoreVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPackageVersion")]
  public static extern uint SBase_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPackageName")]
  public static extern string SBase_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getTypeCode")]
  public static extern int SBase_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasValidLevelVersionNamespaceCombination")]
  public static extern bool SBase_hasValidLevelVersionNamespaceCombination(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getElementName")]
  public static extern string SBase_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_toSBML")]
  public static extern string SBase_toSBML(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_toXMLNode")]
  public static extern global::System.IntPtr SBase_toXMLNode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPlugin__SWIG_0")]
  public static extern global::System.IntPtr SBase_getPlugin__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPlugin__SWIG_2")]
  public static extern global::System.IntPtr SBase_getPlugin__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getDisabledPlugin__SWIG_0")]
  public static extern global::System.IntPtr SBase_getDisabledPlugin__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNumPlugins")]
  public static extern uint SBase_getNumPlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getNumDisabledPlugins")]
  public static extern uint SBase_getNumDisabledPlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_deleteDisabledPlugins__SWIG_0")]
  public static extern void SBase_deleteDisabledPlugins__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_deleteDisabledPlugins__SWIG_1")]
  public static extern void SBase_deleteDisabledPlugins__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_enablePackage")]
  public static extern int SBase_enablePackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_disablePackage")]
  public static extern int SBase_disablePackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_enablePackageInternal")]
  public static extern void SBase_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isPackageURIEnabled")]
  public static extern bool SBase_isPackageURIEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isPackageEnabled")]
  public static extern bool SBase_isPackageEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isPkgURIEnabled")]
  public static extern bool SBase_isPkgURIEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isPkgEnabled")]
  public static extern bool SBase_isPkgEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_writeExtensionElements")]
  public static extern void SBase_writeExtensionElements(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasRequiredAttributes")]
  public static extern bool SBase_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasRequiredElements")]
  public static extern bool SBase_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_checkCompatibility")]
  public static extern int SBase_checkCompatibility(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_setSBMLNamespacesAndOwn")]
  public static extern void SBase_setSBMLNamespacesAndOwn(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getSBMLNamespaces")]
  public static extern global::System.IntPtr SBase_getSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_checkMathMLNamespace")]
  public static extern string SBase_checkMathMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getDerivedUnitDefinition")]
  public static extern global::System.IntPtr SBase_getDerivedUnitDefinition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_containsUndeclaredUnits")]
  public static extern bool SBase_containsUndeclaredUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_removeFromParentAndDelete")]
  public static extern int SBase_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_matchesSBMLNamespaces__SWIG_0")]
  public static extern bool SBase_matchesSBMLNamespaces__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0")]
  public static extern bool SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_isSetUserData")]
  public static extern bool SBase_isSetUserData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_unsetUserData")]
  public static extern int SBase_unsetUserData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getURI")]
  public static extern string SBase_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getPrefix")]
  public static extern string SBase_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasOptionalAttributes")]
  public static extern bool SBase_hasOptionalAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_hasOptionalElements")]
  public static extern bool SBase_hasOptionalElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_updateSBMLNamespace")]
  public static extern void SBase_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getListOfAllElements__SWIG_0")]
  public static extern global::System.IntPtr SBase_getListOfAllElements__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getListOfAllElements__SWIG_1")]
  public static extern global::System.IntPtr SBase_getListOfAllElements__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getListOfAllElementsFromPlugins__SWIG_0")]
  public static extern global::System.IntPtr SBase_getListOfAllElementsFromPlugins__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBase_getListOfAllElementsFromPlugins__SWIG_1")]
  public static extern global::System.IntPtr SBase_getListOfAllElementsFromPlugins__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOf__SWIG_0")]
  public static extern global::System.IntPtr new_ListOf__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOf__SWIG_1")]
  public static extern global::System.IntPtr new_ListOf__SWIG_1(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOf__SWIG_2")]
  public static extern global::System.IntPtr new_ListOf__SWIG_2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOf__SWIG_3")]
  public static extern global::System.IntPtr new_ListOf__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOf")]
  public static extern void delete_ListOf(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOf__SWIG_4")]
  public static extern global::System.IntPtr new_ListOf__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_clone")]
  public static extern global::System.IntPtr ListOf_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_append")]
  public static extern int ListOf_append(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_appendAndOwn")]
  public static extern int ListOf_appendAndOwn(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_appendFrom")]
  public static extern int ListOf_appendFrom(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_insert")]
  public static extern int ListOf_insert(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_insertAndOwn")]
  public static extern int ListOf_insertAndOwn(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_get__SWIG_0")]
  public static extern global::System.IntPtr ListOf_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_getElementBySId")]
  public static extern global::System.IntPtr ListOf_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_getElementByMetaId")]
  public static extern global::System.IntPtr ListOf_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_clear__SWIG_0")]
  public static extern void ListOf_clear__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_clear__SWIG_1")]
  public static extern void ListOf_clear__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_removeFromParentAndDelete")]
  public static extern int ListOf_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_remove")]
  public static extern global::System.IntPtr ListOf_remove(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_size")]
  public static extern uint ListOf_size(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_connectToChild")]
  public static extern void ListOf_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_getTypeCode")]
  public static extern int ListOf_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_getItemTypeCode")]
  public static extern int ListOf_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_getElementName")]
  public static extern string ListOf_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_enablePackageInternal")]
  public static extern void ListOf_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_updateSBMLNamespace")]
  public static extern void ListOf_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_hasOptionalElements")]
  public static extern bool ListOf_hasOptionalElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_isExplicitlyListed")]
  public static extern bool ListOf_isExplicitlyListed(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_setExplicitlyListed__SWIG_0")]
  public static extern void ListOf_setExplicitlyListed__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_setExplicitlyListed__SWIG_1")]
  public static extern void ListOf_setExplicitlyListed__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Model__SWIG_0")]
  public static extern global::System.IntPtr new_Model__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Model__SWIG_1")]
  public static extern global::System.IntPtr new_Model__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Model")]
  public static extern void delete_Model(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Model__SWIG_2")]
  public static extern global::System.IntPtr new_Model__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_clone")]
  public static extern global::System.IntPtr Model_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getElementBySId")]
  public static extern global::System.IntPtr Model_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getElementByMetaId")]
  public static extern global::System.IntPtr Model_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getId")]
  public static extern string Model_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getName")]
  public static extern string Model_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSubstanceUnits")]
  public static extern string Model_getSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getTimeUnits")]
  public static extern string Model_getTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getVolumeUnits")]
  public static extern string Model_getVolumeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getAreaUnits")]
  public static extern string Model_getAreaUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getLengthUnits")]
  public static extern string Model_getLengthUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getExtentUnits")]
  public static extern string Model_getExtentUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getConversionFactor")]
  public static extern string Model_getConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetId")]
  public static extern bool Model_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetName")]
  public static extern bool Model_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetSubstanceUnits")]
  public static extern bool Model_isSetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetTimeUnits")]
  public static extern bool Model_isSetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetVolumeUnits")]
  public static extern bool Model_isSetVolumeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetAreaUnits")]
  public static extern bool Model_isSetAreaUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetLengthUnits")]
  public static extern bool Model_isSetLengthUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetExtentUnits")]
  public static extern bool Model_isSetExtentUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isSetConversionFactor")]
  public static extern bool Model_isSetConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setId")]
  public static extern int Model_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setName")]
  public static extern int Model_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setSubstanceUnits")]
  public static extern int Model_setSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setTimeUnits")]
  public static extern int Model_setTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setVolumeUnits")]
  public static extern int Model_setVolumeUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setAreaUnits")]
  public static extern int Model_setAreaUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setLengthUnits")]
  public static extern int Model_setLengthUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setExtentUnits")]
  public static extern int Model_setExtentUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setConversionFactor")]
  public static extern int Model_setConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetId")]
  public static extern int Model_unsetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetName")]
  public static extern int Model_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetSubstanceUnits")]
  public static extern int Model_unsetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetTimeUnits")]
  public static extern int Model_unsetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetVolumeUnits")]
  public static extern int Model_unsetVolumeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetAreaUnits")]
  public static extern int Model_unsetAreaUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetLengthUnits")]
  public static extern int Model_unsetLengthUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetExtentUnits")]
  public static extern int Model_unsetExtentUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_unsetConversionFactor")]
  public static extern int Model_unsetConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addFunctionDefinition")]
  public static extern int Model_addFunctionDefinition(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addUnitDefinition")]
  public static extern int Model_addUnitDefinition(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addCompartmentType")]
  public static extern int Model_addCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addSpeciesType")]
  public static extern int Model_addSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addCompartment")]
  public static extern int Model_addCompartment(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addSpecies")]
  public static extern int Model_addSpecies(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addParameter")]
  public static extern int Model_addParameter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addInitialAssignment")]
  public static extern int Model_addInitialAssignment(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addRule")]
  public static extern int Model_addRule(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addConstraint")]
  public static extern int Model_addConstraint(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addReaction")]
  public static extern int Model_addReaction(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addEvent")]
  public static extern int Model_addEvent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createFunctionDefinition")]
  public static extern global::System.IntPtr Model_createFunctionDefinition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createUnitDefinition")]
  public static extern global::System.IntPtr Model_createUnitDefinition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createUnit")]
  public static extern global::System.IntPtr Model_createUnit(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createCompartmentType")]
  public static extern global::System.IntPtr Model_createCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createSpeciesType")]
  public static extern global::System.IntPtr Model_createSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createCompartment")]
  public static extern global::System.IntPtr Model_createCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createSpecies")]
  public static extern global::System.IntPtr Model_createSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createParameter")]
  public static extern global::System.IntPtr Model_createParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createInitialAssignment")]
  public static extern global::System.IntPtr Model_createInitialAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createAlgebraicRule")]
  public static extern global::System.IntPtr Model_createAlgebraicRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createAssignmentRule")]
  public static extern global::System.IntPtr Model_createAssignmentRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createRateRule")]
  public static extern global::System.IntPtr Model_createRateRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createConstraint")]
  public static extern global::System.IntPtr Model_createConstraint(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createReaction")]
  public static extern global::System.IntPtr Model_createReaction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createReactant")]
  public static extern global::System.IntPtr Model_createReactant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createProduct")]
  public static extern global::System.IntPtr Model_createProduct(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createModifier")]
  public static extern global::System.IntPtr Model_createModifier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createKineticLaw")]
  public static extern global::System.IntPtr Model_createKineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createKineticLawParameter")]
  public static extern global::System.IntPtr Model_createKineticLawParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createKineticLawLocalParameter")]
  public static extern global::System.IntPtr Model_createKineticLawLocalParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createEvent")]
  public static extern global::System.IntPtr Model_createEvent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createEventAssignment")]
  public static extern global::System.IntPtr Model_createEventAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createTrigger")]
  public static extern global::System.IntPtr Model_createTrigger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_createDelay")]
  public static extern global::System.IntPtr Model_createDelay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setAnnotation__SWIG_0")]
  public static extern int Model_setAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setAnnotation__SWIG_1")]
  public static extern int Model_setAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_appendAnnotation__SWIG_0")]
  public static extern int Model_appendAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_appendAnnotation__SWIG_1")]
  public static extern int Model_appendAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfFunctionDefinitions__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfFunctionDefinitions__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfUnitDefinitions__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfUnitDefinitions__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfCompartmentTypes__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfCompartmentTypes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfSpeciesTypes__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfSpeciesTypes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfCompartments__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfCompartments__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfSpecies__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfSpecies__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfParameters__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfParameters__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfInitialAssignments__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfInitialAssignments__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfRules__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfRules__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfConstraints__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfConstraints__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfReactions__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfReactions__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getListOfEvents__SWIG_0")]
  public static extern global::System.IntPtr Model_getListOfEvents__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getFunctionDefinition__SWIG_0")]
  public static extern global::System.IntPtr Model_getFunctionDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getFunctionDefinition__SWIG_2")]
  public static extern global::System.IntPtr Model_getFunctionDefinition__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Model_getUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getUnitDefinition__SWIG_2")]
  public static extern global::System.IntPtr Model_getUnitDefinition__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getCompartmentType__SWIG_0")]
  public static extern global::System.IntPtr Model_getCompartmentType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getCompartmentType__SWIG_2")]
  public static extern global::System.IntPtr Model_getCompartmentType__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSpeciesType__SWIG_0")]
  public static extern global::System.IntPtr Model_getSpeciesType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSpeciesType__SWIG_2")]
  public static extern global::System.IntPtr Model_getSpeciesType__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getCompartment__SWIG_0")]
  public static extern global::System.IntPtr Model_getCompartment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getCompartment__SWIG_2")]
  public static extern global::System.IntPtr Model_getCompartment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSpecies__SWIG_0")]
  public static extern global::System.IntPtr Model_getSpecies__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSpecies__SWIG_2")]
  public static extern global::System.IntPtr Model_getSpecies__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getParameter__SWIG_0")]
  public static extern global::System.IntPtr Model_getParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getParameter__SWIG_2")]
  public static extern global::System.IntPtr Model_getParameter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getInitialAssignment__SWIG_0")]
  public static extern global::System.IntPtr Model_getInitialAssignment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getInitialAssignment__SWIG_2")]
  public static extern global::System.IntPtr Model_getInitialAssignment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getInitialAssignmentBySymbol__SWIG_0")]
  public static extern global::System.IntPtr Model_getInitialAssignmentBySymbol__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getRule__SWIG_0")]
  public static extern global::System.IntPtr Model_getRule__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getRule__SWIG_2")]
  public static extern global::System.IntPtr Model_getRule__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getRuleByVariable__SWIG_0")]
  public static extern global::System.IntPtr Model_getRuleByVariable__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getAssignmentRule__SWIG_0")]
  public static extern global::System.IntPtr Model_getAssignmentRule__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getRateRule__SWIG_0")]
  public static extern global::System.IntPtr Model_getRateRule__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getAssignmentRuleByVariable__SWIG_0")]
  public static extern global::System.IntPtr Model_getAssignmentRuleByVariable__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getRateRuleByVariable__SWIG_0")]
  public static extern global::System.IntPtr Model_getRateRuleByVariable__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getConstraint__SWIG_0")]
  public static extern global::System.IntPtr Model_getConstraint__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getReaction__SWIG_0")]
  public static extern global::System.IntPtr Model_getReaction__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getReaction__SWIG_2")]
  public static extern global::System.IntPtr Model_getReaction__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getSpeciesReference__SWIG_0")]
  public static extern global::System.IntPtr Model_getSpeciesReference__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getModifierSpeciesReference__SWIG_0")]
  public static extern global::System.IntPtr Model_getModifierSpeciesReference__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getEvent__SWIG_0")]
  public static extern global::System.IntPtr Model_getEvent__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getEvent__SWIG_2")]
  public static extern global::System.IntPtr Model_getEvent__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumFunctionDefinitions")]
  public static extern uint Model_getNumFunctionDefinitions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumUnitDefinitions")]
  public static extern uint Model_getNumUnitDefinitions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumCompartmentTypes")]
  public static extern uint Model_getNumCompartmentTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumSpeciesTypes")]
  public static extern uint Model_getNumSpeciesTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumCompartments")]
  public static extern uint Model_getNumCompartments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumSpecies")]
  public static extern uint Model_getNumSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumSpeciesWithBoundaryCondition")]
  public static extern uint Model_getNumSpeciesWithBoundaryCondition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumParameters")]
  public static extern uint Model_getNumParameters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumInitialAssignments")]
  public static extern uint Model_getNumInitialAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumRules")]
  public static extern uint Model_getNumRules(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumConstraints")]
  public static extern uint Model_getNumConstraints(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumReactions")]
  public static extern uint Model_getNumReactions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getNumEvents")]
  public static extern uint Model_getNumEvents(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeFromParentAndDelete")]
  public static extern int Model_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_renameAllIds__SWIG_0")]
  public static extern int Model_renameAllIds__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_renameAllIds__SWIG_1")]
  public static extern int Model_renameAllIds__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_renameSIdRefs")]
  public static extern void Model_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_renameUnitSIdRefs")]
  public static extern void Model_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL1ToL2")]
  public static extern void Model_convertL1ToL2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL1ToL3__SWIG_0")]
  public static extern void Model_convertL1ToL3__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL1ToL3__SWIG_1")]
  public static extern void Model_convertL1ToL3__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL2ToL3__SWIG_0")]
  public static extern void Model_convertL2ToL3__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL2ToL3__SWIG_1")]
  public static extern void Model_convertL2ToL3__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL2ToL3__SWIG_2")]
  public static extern void Model_convertL2ToL3__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL2ToL1__SWIG_0")]
  public static extern void Model_convertL2ToL1__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL2ToL1__SWIG_1")]
  public static extern void Model_convertL2ToL1__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL3ToL1__SWIG_0")]
  public static extern void Model_convertL3ToL1__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL3ToL1__SWIG_1")]
  public static extern void Model_convertL3ToL1__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL3ToL2__SWIG_0")]
  public static extern void Model_convertL3ToL2__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertL3ToL2__SWIG_1")]
  public static extern void Model_convertL3ToL2__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertFromL3V2__SWIG_0")]
  public static extern void Model_convertFromL3V2__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertFromL3V2__SWIG_1")]
  public static extern void Model_convertFromL3V2__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithFast")]
  public static extern void Model_dealWithFast(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithL3Fast")]
  public static extern void Model_dealWithL3Fast(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addModifiers")]
  public static extern void Model_addModifiers(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addConstantAttribute")]
  public static extern void Model_addConstantAttribute(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setSpatialDimensions__SWIG_0")]
  public static extern void Model_setSpatialDimensions__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setSpatialDimensions__SWIG_1")]
  public static extern void Model_setSpatialDimensions__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_addDefinitionsForDefaultUnits")]
  public static extern void Model_addDefinitionsForDefaultUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithDefaultValues")]
  public static extern void Model_dealWithDefaultValues(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertParametersToLocals")]
  public static extern void Model_convertParametersToLocals(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_setSpeciesReferenceConstantValueAndStoichiometry")]
  public static extern void Model_setSpeciesReferenceConstantValueAndStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeParameterRuleUnits")]
  public static extern void Model_removeParameterRuleUnits(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_convertStoichiometryMath")]
  public static extern void Model_convertStoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_assignRequiredValues")]
  public static extern void Model_assignRequiredValues(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithModelUnits__SWIG_0")]
  public static extern void Model_dealWithModelUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithModelUnits__SWIG_1")]
  public static extern void Model_dealWithModelUnits__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithStoichiometry")]
  public static extern void Model_dealWithStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_dealWithEvents")]
  public static extern void Model_dealWithEvents(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeSpeciesTypes")]
  public static extern void Model_removeSpeciesTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeCompartmentTypes")]
  public static extern void Model_removeCompartmentTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_connectToChild")]
  public static extern void Model_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getTypeCode")]
  public static extern int Model_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getElementName")]
  public static extern string Model_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_populateListFormulaUnitsData")]
  public static extern void Model_populateListFormulaUnitsData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isPopulatedListFormulaUnitsData")]
  public static extern bool Model_isPopulatedListFormulaUnitsData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getFormulaUnitsDataForVariable")]
  public static extern global::System.IntPtr Model_getFormulaUnitsDataForVariable(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getFormulaUnitsDataForAssignment")]
  public static extern global::System.IntPtr Model_getFormulaUnitsDataForAssignment(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_populateAllElementIdList")]
  public static extern void Model_populateAllElementIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isPopulatedAllElementIdList")]
  public static extern bool Model_isPopulatedAllElementIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getAllElementIdList")]
  public static extern global::System.IntPtr Model_getAllElementIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_clearAllElementIdList")]
  public static extern void Model_clearAllElementIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_populateAllElementMetaIdList")]
  public static extern void Model_populateAllElementMetaIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_isPopulatedAllElementMetaIdList")]
  public static extern bool Model_isPopulatedAllElementMetaIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_getAllElementMetaIdList")]
  public static extern global::System.IntPtr Model_getAllElementMetaIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_clearAllElementMetaIdList")]
  public static extern void Model_clearAllElementMetaIdList(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_hasRequiredElements")]
  public static extern bool Model_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeFunctionDefinition__SWIG_0")]
  public static extern global::System.IntPtr Model_removeFunctionDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeFunctionDefinition__SWIG_1")]
  public static extern global::System.IntPtr Model_removeFunctionDefinition__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Model_removeUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeUnitDefinition__SWIG_1")]
  public static extern global::System.IntPtr Model_removeUnitDefinition__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeCompartmentType__SWIG_0")]
  public static extern global::System.IntPtr Model_removeCompartmentType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeCompartmentType__SWIG_1")]
  public static extern global::System.IntPtr Model_removeCompartmentType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeSpeciesType__SWIG_0")]
  public static extern global::System.IntPtr Model_removeSpeciesType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeSpeciesType__SWIG_1")]
  public static extern global::System.IntPtr Model_removeSpeciesType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeCompartment__SWIG_0")]
  public static extern global::System.IntPtr Model_removeCompartment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeCompartment__SWIG_1")]
  public static extern global::System.IntPtr Model_removeCompartment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeSpecies__SWIG_0")]
  public static extern global::System.IntPtr Model_removeSpecies__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeSpecies__SWIG_1")]
  public static extern global::System.IntPtr Model_removeSpecies__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeParameter__SWIG_0")]
  public static extern global::System.IntPtr Model_removeParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeParameter__SWIG_1")]
  public static extern global::System.IntPtr Model_removeParameter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeInitialAssignment__SWIG_0")]
  public static extern global::System.IntPtr Model_removeInitialAssignment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeInitialAssignment__SWIG_1")]
  public static extern global::System.IntPtr Model_removeInitialAssignment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeRule__SWIG_0")]
  public static extern global::System.IntPtr Model_removeRule__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeRule__SWIG_1")]
  public static extern global::System.IntPtr Model_removeRule__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeRuleByVariable")]
  public static extern global::System.IntPtr Model_removeRuleByVariable(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeConstraint")]
  public static extern global::System.IntPtr Model_removeConstraint(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeReaction__SWIG_0")]
  public static extern global::System.IntPtr Model_removeReaction__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeReaction__SWIG_1")]
  public static extern global::System.IntPtr Model_removeReaction__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeEvent__SWIG_0")]
  public static extern global::System.IntPtr Model_removeEvent__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_removeEvent__SWIG_1")]
  public static extern global::System.IntPtr Model_removeEvent__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_appendFrom")]
  public static extern int Model_appendFrom(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_enablePackageInternal")]
  public static extern void Model_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_updateSBMLNamespace")]
  public static extern void Model_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_renameIDs")]
  public static extern void Model_renameIDs(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getDefaultLevel")]
  public static extern uint SBMLDocument_getDefaultLevel();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getDefaultVersion")]
  public static extern uint SBMLDocument_getDefaultVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocument__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLDocument__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocument__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLDocument__SWIG_1(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocument__SWIG_2")]
  public static extern global::System.IntPtr new_SBMLDocument__SWIG_2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocument__SWIG_3")]
  public static extern global::System.IntPtr new_SBMLDocument__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLDocument")]
  public static extern void delete_SBMLDocument(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocument__SWIG_4")]
  public static extern global::System.IntPtr new_SBMLDocument__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_clone")]
  public static extern global::System.IntPtr SBMLDocument_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isSetModel")]
  public static extern bool SBMLDocument_isSetModel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getModel__SWIG_0")]
  public static extern global::System.IntPtr SBMLDocument_getModel__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getElementBySId")]
  public static extern global::System.IntPtr SBMLDocument_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getElementByMetaId")]
  public static extern global::System.IntPtr SBMLDocument_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_expandFunctionDefinitions")]
  public static extern bool SBMLDocument_expandFunctionDefinitions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_expandInitialAssignments")]
  public static extern bool SBMLDocument_expandInitialAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setLevelAndVersion__SWIG_0")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, bool jarg4, bool jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setLevelAndVersion__SWIG_1")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setLevelAndVersion__SWIG_2")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_updateSBMLNamespace")]
  public static extern void SBMLDocument_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setModel")]
  public static extern int SBMLDocument_setModel(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_createModel__SWIG_0")]
  public static extern global::System.IntPtr SBMLDocument_createModel__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_createModel__SWIG_1")]
  public static extern global::System.IntPtr SBMLDocument_createModel__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setLocationURI")]
  public static extern void SBMLDocument_setLocationURI(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getLocationURI__SWIG_0")]
  public static extern string SBMLDocument_getLocationURI__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setConsistencyChecks")]
  public static extern void SBMLDocument_setConsistencyChecks(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setConsistencyChecksForConversion")]
  public static extern void SBMLDocument_setConsistencyChecksForConversion(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkConsistency")]
  public static extern uint SBMLDocument_checkConsistency(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkConsistencyWithStrictUnits")]
  public static extern uint SBMLDocument_checkConsistencyWithStrictUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_validateSBML")]
  public static extern uint SBMLDocument_validateSBML(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkInternalConsistency")]
  public static extern uint SBMLDocument_checkInternalConsistency(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL1Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL1Compatibility__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL1Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL1Compatibility__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v1Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v1Compatibility__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v1Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v1Compatibility__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v2Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v2Compatibility__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v2Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v2Compatibility__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v3Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v3Compatibility__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v3Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v3Compatibility__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v4Compatibility")]
  public static extern uint SBMLDocument_checkL2v4Compatibility(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL2v5Compatibility")]
  public static extern uint SBMLDocument_checkL2v5Compatibility(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL3v1Compatibility")]
  public static extern uint SBMLDocument_checkL3v1Compatibility(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_checkL3v2Compatibility")]
  public static extern uint SBMLDocument_checkL3v2Compatibility(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getError")]
  public static extern global::System.IntPtr SBMLDocument_getError(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getErrorWithSeverity")]
  public static extern global::System.IntPtr SBMLDocument_getErrorWithSeverity(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getNumErrors__SWIG_0")]
  public static extern uint SBMLDocument_getNumErrors__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getNumErrors__SWIG_1")]
  public static extern uint SBMLDocument_getNumErrors__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_printErrors__SWIG_0")]
  public static extern void SBMLDocument_printErrors__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_printErrors__SWIG_1")]
  public static extern void SBMLDocument_printErrors__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_printErrors__SWIG_2")]
  public static extern void SBMLDocument_printErrors__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_connectToChild")]
  public static extern void SBMLDocument_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_convert")]
  public static extern int SBMLDocument_convert(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_enablePackageInternal")]
  public static extern void SBMLDocument_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getTypeCode")]
  public static extern int SBMLDocument_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getElementName")]
  public static extern string SBMLDocument_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getErrorLog__SWIG_0")]
  public static extern global::System.IntPtr SBMLDocument_getErrorLog__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getNamespaces")]
  public static extern global::System.IntPtr SBMLDocument_getNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_enableDefaultNS")]
  public static extern int SBMLDocument_enableDefaultNS(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isEnabledDefaultNS")]
  public static extern bool SBMLDocument_isEnabledDefaultNS(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setPackageRequired")]
  public static extern int SBMLDocument_setPackageRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getPackageRequired")]
  public static extern bool SBMLDocument_getPackageRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isSetPackageRequired")]
  public static extern bool SBMLDocument_isSetPackageRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isIgnoredPackage")]
  public static extern bool SBMLDocument_isIgnoredPackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isDisabledIgnoredPackage")]
  public static extern bool SBMLDocument_isDisabledIgnoredPackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setPkgRequired")]
  public static extern int SBMLDocument_setPkgRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getPkgRequired")]
  public static extern bool SBMLDocument_getPkgRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isSetPkgRequired")]
  public static extern bool SBMLDocument_isSetPkgRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_isIgnoredPkg")]
  public static extern bool SBMLDocument_isIgnoredPkg(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getApplicableValidators")]
  public static extern byte SBMLDocument_getApplicableValidators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getConversionValidators")]
  public static extern byte SBMLDocument_getConversionValidators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setApplicableValidators")]
  public static extern void SBMLDocument_setApplicableValidators(global::System.Runtime.InteropServices.HandleRef jarg1, byte jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_setConversionValidators")]
  public static extern void SBMLDocument_setConversionValidators(global::System.Runtime.InteropServices.HandleRef jarg1, byte jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getNumValidators")]
  public static extern uint SBMLDocument_getNumValidators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_clearValidators")]
  public static extern int SBMLDocument_clearValidators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_addValidator")]
  public static extern int SBMLDocument_addValidator(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getValidator")]
  public static extern global::System.IntPtr SBMLDocument_getValidator(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_addUnknownPackageRequired")]
  public static extern int SBMLDocument_addUnknownPackageRequired(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_hasUnknownPackage")]
  public static extern bool SBMLDocument_hasUnknownPackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getNumUnknownPackages")]
  public static extern int SBMLDocument_getNumUnknownPackages(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getUnknownPackageURI")]
  public static extern string SBMLDocument_getUnknownPackageURI(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_getUnknownPackagePrefix")]
  public static extern string SBMLDocument_getUnknownPackagePrefix(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_FunctionDefinition__SWIG_0")]
  public static extern global::System.IntPtr new_FunctionDefinition__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_FunctionDefinition__SWIG_1")]
  public static extern global::System.IntPtr new_FunctionDefinition__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_FunctionDefinition")]
  public static extern void delete_FunctionDefinition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_FunctionDefinition__SWIG_2")]
  public static extern global::System.IntPtr new_FunctionDefinition__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_clone")]
  public static extern global::System.IntPtr FunctionDefinition_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getId")]
  public static extern string FunctionDefinition_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getName")]
  public static extern string FunctionDefinition_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getMath")]
  public static extern global::System.IntPtr FunctionDefinition_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_isSetId")]
  public static extern bool FunctionDefinition_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_isSetName")]
  public static extern bool FunctionDefinition_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_isSetMath")]
  public static extern bool FunctionDefinition_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_setId")]
  public static extern int FunctionDefinition_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_setName")]
  public static extern int FunctionDefinition_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_setMath")]
  public static extern int FunctionDefinition_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_unsetName")]
  public static extern int FunctionDefinition_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getArgument__SWIG_0")]
  public static extern global::System.IntPtr FunctionDefinition_getArgument__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getArgument__SWIG_1")]
  public static extern global::System.IntPtr FunctionDefinition_getArgument__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getBody__SWIG_0")]
  public static extern global::System.IntPtr FunctionDefinition_getBody__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_isSetBody")]
  public static extern bool FunctionDefinition_isSetBody(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getNumArguments")]
  public static extern uint FunctionDefinition_getNumArguments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getTypeCode")]
  public static extern int FunctionDefinition_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_getElementName")]
  public static extern string FunctionDefinition_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_hasRequiredAttributes")]
  public static extern bool FunctionDefinition_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_hasRequiredElements")]
  public static extern bool FunctionDefinition_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_renameUnitSIdRefs")]
  public static extern void FunctionDefinition_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfFunctionDefinitions__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfFunctionDefinitions__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfFunctionDefinitions__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfFunctionDefinitions__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_clone")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_getItemTypeCode")]
  public static extern int ListOfFunctionDefinitions_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_getElementName")]
  public static extern string ListOfFunctionDefinitions_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfFunctionDefinitions")]
  public static extern void delete_ListOfFunctionDefinitions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitKind_equals")]
  public static extern int UnitKind_equals(int jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitKind_forName")]
  public static extern int UnitKind_forName(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitKind_toString")]
  public static extern string UnitKind_toString(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitKind_isValidUnitKindString")]
  public static extern int UnitKind_isValidUnitKindString(string jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Unit__SWIG_0")]
  public static extern global::System.IntPtr new_Unit__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Unit__SWIG_1")]
  public static extern global::System.IntPtr new_Unit__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Unit")]
  public static extern void delete_Unit(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Unit__SWIG_2")]
  public static extern global::System.IntPtr new_Unit__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_clone")]
  public static extern global::System.IntPtr Unit_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_initDefaults")]
  public static extern void Unit_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getKind")]
  public static extern int Unit_getKind(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getExponent")]
  public static extern int Unit_getExponent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getExponentAsDouble")]
  public static extern double Unit_getExponentAsDouble(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getScale")]
  public static extern int Unit_getScale(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getMultiplier")]
  public static extern double Unit_getMultiplier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getOffset")]
  public static extern double Unit_getOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isAmpere")]
  public static extern bool Unit_isAmpere(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isAvogadro")]
  public static extern bool Unit_isAvogadro(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isBecquerel")]
  public static extern bool Unit_isBecquerel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isCandela")]
  public static extern bool Unit_isCandela(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isCelsius")]
  public static extern bool Unit_isCelsius(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isCoulomb")]
  public static extern bool Unit_isCoulomb(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isDimensionless")]
  public static extern bool Unit_isDimensionless(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isFarad")]
  public static extern bool Unit_isFarad(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isGram")]
  public static extern bool Unit_isGram(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isGray")]
  public static extern bool Unit_isGray(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isHenry")]
  public static extern bool Unit_isHenry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isHertz")]
  public static extern bool Unit_isHertz(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isItem")]
  public static extern bool Unit_isItem(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isJoule")]
  public static extern bool Unit_isJoule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isKatal")]
  public static extern bool Unit_isKatal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isKelvin")]
  public static extern bool Unit_isKelvin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isKilogram")]
  public static extern bool Unit_isKilogram(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isLitre")]
  public static extern bool Unit_isLitre(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isLumen")]
  public static extern bool Unit_isLumen(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isLux")]
  public static extern bool Unit_isLux(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isMetre")]
  public static extern bool Unit_isMetre(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isMole")]
  public static extern bool Unit_isMole(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isNewton")]
  public static extern bool Unit_isNewton(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isOhm")]
  public static extern bool Unit_isOhm(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isPascal")]
  public static extern bool Unit_isPascal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isRadian")]
  public static extern bool Unit_isRadian(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSecond")]
  public static extern bool Unit_isSecond(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSiemens")]
  public static extern bool Unit_isSiemens(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSievert")]
  public static extern bool Unit_isSievert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSteradian")]
  public static extern bool Unit_isSteradian(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isTesla")]
  public static extern bool Unit_isTesla(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isVolt")]
  public static extern bool Unit_isVolt(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isWatt")]
  public static extern bool Unit_isWatt(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isWeber")]
  public static extern bool Unit_isWeber(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSetKind")]
  public static extern bool Unit_isSetKind(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSetExponent")]
  public static extern bool Unit_isSetExponent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSetScale")]
  public static extern bool Unit_isSetScale(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSetMultiplier")]
  public static extern bool Unit_isSetMultiplier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isSetOffset")]
  public static extern bool Unit_isSetOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setKind")]
  public static extern int Unit_setKind(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setExponent__SWIG_0")]
  public static extern int Unit_setExponent__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setExponent__SWIG_1")]
  public static extern int Unit_setExponent__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setScale")]
  public static extern int Unit_setScale(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setMultiplier")]
  public static extern int Unit_setMultiplier(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setOffset")]
  public static extern int Unit_setOffset(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_unsetKind")]
  public static extern int Unit_unsetKind(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_unsetExponent")]
  public static extern int Unit_unsetExponent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_unsetScale")]
  public static extern int Unit_unsetScale(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_unsetMultiplier")]
  public static extern int Unit_unsetMultiplier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_unsetOffset")]
  public static extern int Unit_unsetOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getTypeCode")]
  public static extern int Unit_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getElementName")]
  public static extern string Unit_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isBuiltIn")]
  public static extern bool Unit_isBuiltIn(string jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isUnitKind")]
  public static extern bool Unit_isUnitKind(string jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_areIdentical")]
  public static extern bool Unit_areIdentical(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_areEquivalent")]
  public static extern bool Unit_areEquivalent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_removeScale")]
  public static extern int Unit_removeScale(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_merge")]
  public static extern void Unit_merge(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_convertToSI")]
  public static extern global::System.IntPtr Unit_convertToSI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_hasRequiredAttributes")]
  public static extern bool Unit_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_setExponentUnitChecking")]
  public static extern void Unit_setExponentUnitChecking(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_getExponentUnitChecking__SWIG_0")]
  public static extern double Unit_getExponentUnitChecking__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_isUnitChecking__SWIG_0")]
  public static extern bool Unit_isUnitChecking__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfUnits__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfUnits__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfUnits__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfUnits__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_clone")]
  public static extern global::System.IntPtr ListOfUnits_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_getItemTypeCode")]
  public static extern int ListOfUnits_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_getElementName")]
  public static extern string ListOfUnits_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfUnits_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_remove")]
  public static extern global::System.IntPtr ListOfUnits_remove(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfUnits")]
  public static extern void delete_ListOfUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_UnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr new_UnitDefinition__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_UnitDefinition__SWIG_1")]
  public static extern global::System.IntPtr new_UnitDefinition__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_UnitDefinition")]
  public static extern void delete_UnitDefinition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_UnitDefinition__SWIG_2")]
  public static extern global::System.IntPtr new_UnitDefinition__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_clone")]
  public static extern global::System.IntPtr UnitDefinition_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getElementBySId")]
  public static extern global::System.IntPtr UnitDefinition_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getElementByMetaId")]
  public static extern global::System.IntPtr UnitDefinition_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getId")]
  public static extern string UnitDefinition_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getName")]
  public static extern string UnitDefinition_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isSetId")]
  public static extern bool UnitDefinition_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isSetName")]
  public static extern bool UnitDefinition_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_setId")]
  public static extern int UnitDefinition_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_setName")]
  public static extern int UnitDefinition_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_unsetName")]
  public static extern int UnitDefinition_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfArea__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfArea__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfArea__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfArea__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfLength__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfLength__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfLength__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfLength__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfSubstance__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfSubstance__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfSubstance__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfSubstance__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfTime__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfTime__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfTime__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfTime__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfVolume__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfVolume__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfVolume__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfVolume__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfDimensionless__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfDimensionless__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfDimensionless__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfDimensionless__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfMass__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfMass__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfMass__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfMass__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfSubstancePerTime__SWIG_0")]
  public static extern bool UnitDefinition_isVariantOfSubstancePerTime__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_isVariantOfSubstancePerTime__SWIG_1")]
  public static extern bool UnitDefinition_isVariantOfSubstancePerTime__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_addUnit")]
  public static extern int UnitDefinition_addUnit(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_createUnit")]
  public static extern global::System.IntPtr UnitDefinition_createUnit(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getListOfUnits__SWIG_0")]
  public static extern global::System.IntPtr UnitDefinition_getListOfUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getUnit__SWIG_0")]
  public static extern global::System.IntPtr UnitDefinition_getUnit__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getNumUnits")]
  public static extern uint UnitDefinition_getNumUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_removeUnit")]
  public static extern global::System.IntPtr UnitDefinition_removeUnit(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_connectToChild")]
  public static extern void UnitDefinition_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_enablePackageInternal")]
  public static extern void UnitDefinition_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_updateSBMLNamespace")]
  public static extern void UnitDefinition_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getTypeCode")]
  public static extern int UnitDefinition_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_getElementName")]
  public static extern string UnitDefinition_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_simplify")]
  public static extern void UnitDefinition_simplify(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_reorder")]
  public static extern void UnitDefinition_reorder(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_convertToSI")]
  public static extern global::System.IntPtr UnitDefinition_convertToSI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_areIdentical")]
  public static extern bool UnitDefinition_areIdentical(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_areEquivalent")]
  public static extern bool UnitDefinition_areEquivalent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_combine")]
  public static extern global::System.IntPtr UnitDefinition_combine(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_divide")]
  public static extern global::System.IntPtr UnitDefinition_divide(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_printUnits__SWIG_0")]
  public static extern string UnitDefinition_printUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_printUnits__SWIG_1")]
  public static extern string UnitDefinition_printUnits__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_hasRequiredAttributes")]
  public static extern bool UnitDefinition_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_hasRequiredElements")]
  public static extern bool UnitDefinition_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfUnitDefinitions__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfUnitDefinitions__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfUnitDefinitions__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfUnitDefinitions__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_clone")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_getItemTypeCode")]
  public static extern int ListOfUnitDefinitions_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_getElementName")]
  public static extern string ListOfUnitDefinitions_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_getElementBySId")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfUnitDefinitions")]
  public static extern void delete_ListOfUnitDefinitions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CompartmentType__SWIG_0")]
  public static extern global::System.IntPtr new_CompartmentType__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CompartmentType__SWIG_1")]
  public static extern global::System.IntPtr new_CompartmentType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_CompartmentType")]
  public static extern void delete_CompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CompartmentType__SWIG_2")]
  public static extern global::System.IntPtr new_CompartmentType__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_clone")]
  public static extern global::System.IntPtr CompartmentType_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_getId")]
  public static extern string CompartmentType_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_getName")]
  public static extern string CompartmentType_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_isSetId")]
  public static extern bool CompartmentType_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_isSetName")]
  public static extern bool CompartmentType_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_setId")]
  public static extern int CompartmentType_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_setName")]
  public static extern int CompartmentType_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_unsetName")]
  public static extern int CompartmentType_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_getTypeCode")]
  public static extern int CompartmentType_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_getElementName")]
  public static extern string CompartmentType_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_hasRequiredAttributes")]
  public static extern bool CompartmentType_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfCompartmentTypes__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfCompartmentTypes__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfCompartmentTypes__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfCompartmentTypes__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_clone")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_getItemTypeCode")]
  public static extern int ListOfCompartmentTypes_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_getElementName")]
  public static extern string ListOfCompartmentTypes_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfCompartmentTypes")]
  public static extern void delete_ListOfCompartmentTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesType__SWIG_0")]
  public static extern global::System.IntPtr new_SpeciesType__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesType__SWIG_1")]
  public static extern global::System.IntPtr new_SpeciesType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SpeciesType")]
  public static extern void delete_SpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesType__SWIG_2")]
  public static extern global::System.IntPtr new_SpeciesType__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_clone")]
  public static extern global::System.IntPtr SpeciesType_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_getId")]
  public static extern string SpeciesType_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_getName")]
  public static extern string SpeciesType_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_isSetId")]
  public static extern bool SpeciesType_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_isSetName")]
  public static extern bool SpeciesType_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_setId")]
  public static extern int SpeciesType_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_setName")]
  public static extern int SpeciesType_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_unsetName")]
  public static extern int SpeciesType_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_getTypeCode")]
  public static extern int SpeciesType_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_getElementName")]
  public static extern string SpeciesType_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_hasRequiredAttributes")]
  public static extern bool SpeciesType_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpeciesTypes__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfSpeciesTypes__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpeciesTypes__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfSpeciesTypes__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_clone")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_getItemTypeCode")]
  public static extern int ListOfSpeciesTypes_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_getElementName")]
  public static extern string ListOfSpeciesTypes_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfSpeciesTypes")]
  public static extern void delete_ListOfSpeciesTypes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Compartment__SWIG_0")]
  public static extern global::System.IntPtr new_Compartment__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Compartment__SWIG_1")]
  public static extern global::System.IntPtr new_Compartment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Compartment")]
  public static extern void delete_Compartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Compartment__SWIG_2")]
  public static extern global::System.IntPtr new_Compartment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_clone")]
  public static extern global::System.IntPtr Compartment_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_initDefaults")]
  public static extern void Compartment_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getId")]
  public static extern string Compartment_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getName")]
  public static extern string Compartment_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getCompartmentType")]
  public static extern string Compartment_getCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getSpatialDimensions")]
  public static extern uint Compartment_getSpatialDimensions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getSpatialDimensionsAsDouble")]
  public static extern double Compartment_getSpatialDimensionsAsDouble(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getSize")]
  public static extern double Compartment_getSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getVolume")]
  public static extern double Compartment_getVolume(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getUnits")]
  public static extern string Compartment_getUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getOutside")]
  public static extern string Compartment_getOutside(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getConstant")]
  public static extern bool Compartment_getConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetId")]
  public static extern bool Compartment_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetName")]
  public static extern bool Compartment_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetCompartmentType")]
  public static extern bool Compartment_isSetCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetSize")]
  public static extern bool Compartment_isSetSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetVolume")]
  public static extern bool Compartment_isSetVolume(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetUnits")]
  public static extern bool Compartment_isSetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetOutside")]
  public static extern bool Compartment_isSetOutside(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetSpatialDimensions")]
  public static extern bool Compartment_isSetSpatialDimensions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_isSetConstant")]
  public static extern bool Compartment_isSetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setId")]
  public static extern int Compartment_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setName")]
  public static extern int Compartment_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setCompartmentType")]
  public static extern int Compartment_setCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setSpatialDimensions__SWIG_0")]
  public static extern int Compartment_setSpatialDimensions__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setSpatialDimensions__SWIG_1")]
  public static extern int Compartment_setSpatialDimensions__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setSize")]
  public static extern int Compartment_setSize(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setVolume")]
  public static extern int Compartment_setVolume(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setUnits")]
  public static extern int Compartment_setUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setOutside")]
  public static extern int Compartment_setOutside(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_setConstant")]
  public static extern int Compartment_setConstant(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_renameSIdRefs")]
  public static extern void Compartment_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_renameUnitSIdRefs")]
  public static extern void Compartment_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetName")]
  public static extern int Compartment_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetCompartmentType")]
  public static extern int Compartment_unsetCompartmentType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetConstant")]
  public static extern int Compartment_unsetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetSize")]
  public static extern int Compartment_unsetSize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetVolume")]
  public static extern int Compartment_unsetVolume(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetUnits")]
  public static extern int Compartment_unsetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetOutside")]
  public static extern int Compartment_unsetOutside(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_unsetSpatialDimensions")]
  public static extern int Compartment_unsetSpatialDimensions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Compartment_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getTypeCode")]
  public static extern int Compartment_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_getElementName")]
  public static extern string Compartment_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_hasRequiredAttributes")]
  public static extern bool Compartment_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfCompartments__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfCompartments__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfCompartments__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfCompartments__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_clone")]
  public static extern global::System.IntPtr ListOfCompartments_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_getItemTypeCode")]
  public static extern int ListOfCompartments_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_getElementName")]
  public static extern string ListOfCompartments_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfCompartments_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfCompartments_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfCompartments_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfCompartments_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfCompartments")]
  public static extern void delete_ListOfCompartments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Species__SWIG_0")]
  public static extern global::System.IntPtr new_Species__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Species__SWIG_1")]
  public static extern global::System.IntPtr new_Species__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Species")]
  public static extern void delete_Species(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Species__SWIG_2")]
  public static extern global::System.IntPtr new_Species__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_clone")]
  public static extern global::System.IntPtr Species_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_initDefaults")]
  public static extern void Species_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getId")]
  public static extern string Species_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getName")]
  public static extern string Species_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getSpeciesType")]
  public static extern string Species_getSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getCompartment")]
  public static extern string Species_getCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getInitialAmount")]
  public static extern double Species_getInitialAmount(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getInitialConcentration")]
  public static extern double Species_getInitialConcentration(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getSubstanceUnits")]
  public static extern string Species_getSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getSpatialSizeUnits")]
  public static extern string Species_getSpatialSizeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getUnits")]
  public static extern string Species_getUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getHasOnlySubstanceUnits")]
  public static extern bool Species_getHasOnlySubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getBoundaryCondition")]
  public static extern bool Species_getBoundaryCondition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getCharge")]
  public static extern int Species_getCharge(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getConstant")]
  public static extern bool Species_getConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getConversionFactor")]
  public static extern string Species_getConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetId")]
  public static extern bool Species_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetName")]
  public static extern bool Species_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetSpeciesType")]
  public static extern bool Species_isSetSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetCompartment")]
  public static extern bool Species_isSetCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetInitialAmount")]
  public static extern bool Species_isSetInitialAmount(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetInitialConcentration")]
  public static extern bool Species_isSetInitialConcentration(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetSubstanceUnits")]
  public static extern bool Species_isSetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetSpatialSizeUnits")]
  public static extern bool Species_isSetSpatialSizeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetUnits")]
  public static extern bool Species_isSetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetCharge")]
  public static extern bool Species_isSetCharge(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetConversionFactor")]
  public static extern bool Species_isSetConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetBoundaryCondition")]
  public static extern bool Species_isSetBoundaryCondition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetHasOnlySubstanceUnits")]
  public static extern bool Species_isSetHasOnlySubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_isSetConstant")]
  public static extern bool Species_isSetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setId")]
  public static extern int Species_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setName")]
  public static extern int Species_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setSpeciesType")]
  public static extern int Species_setSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setCompartment")]
  public static extern int Species_setCompartment(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setInitialAmount")]
  public static extern int Species_setInitialAmount(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setInitialConcentration")]
  public static extern int Species_setInitialConcentration(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setSubstanceUnits")]
  public static extern int Species_setSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setSpatialSizeUnits")]
  public static extern int Species_setSpatialSizeUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setUnits")]
  public static extern int Species_setUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setHasOnlySubstanceUnits")]
  public static extern int Species_setHasOnlySubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setBoundaryCondition")]
  public static extern int Species_setBoundaryCondition(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setCharge")]
  public static extern int Species_setCharge(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setConstant")]
  public static extern int Species_setConstant(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_setConversionFactor")]
  public static extern int Species_setConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetName")]
  public static extern int Species_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetConstant")]
  public static extern int Species_unsetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetSpeciesType")]
  public static extern int Species_unsetSpeciesType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetInitialAmount")]
  public static extern int Species_unsetInitialAmount(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetInitialConcentration")]
  public static extern int Species_unsetInitialConcentration(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetSubstanceUnits")]
  public static extern int Species_unsetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetSpatialSizeUnits")]
  public static extern int Species_unsetSpatialSizeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetUnits")]
  public static extern int Species_unsetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetCharge")]
  public static extern int Species_unsetCharge(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetConversionFactor")]
  public static extern int Species_unsetConversionFactor(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetCompartment")]
  public static extern int Species_unsetCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetBoundaryCondition")]
  public static extern int Species_unsetBoundaryCondition(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_unsetHasOnlySubstanceUnits")]
  public static extern int Species_unsetHasOnlySubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Species_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getTypeCode")]
  public static extern int Species_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_getElementName")]
  public static extern string Species_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_hasRequiredAttributes")]
  public static extern bool Species_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_renameSIdRefs")]
  public static extern void Species_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_renameUnitSIdRefs")]
  public static extern void Species_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpecies__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfSpecies__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpecies__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfSpecies__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_clone")]
  public static extern global::System.IntPtr ListOfSpecies_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_getItemTypeCode")]
  public static extern int ListOfSpecies_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_getElementName")]
  public static extern string ListOfSpecies_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpecies_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfSpecies_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpecies_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfSpecies_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfSpecies")]
  public static extern void delete_ListOfSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Parameter__SWIG_0")]
  public static extern global::System.IntPtr new_Parameter__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Parameter__SWIG_1")]
  public static extern global::System.IntPtr new_Parameter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Parameter")]
  public static extern void delete_Parameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Parameter__SWIG_2")]
  public static extern global::System.IntPtr new_Parameter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_clone")]
  public static extern global::System.IntPtr Parameter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_initDefaults")]
  public static extern void Parameter_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getId")]
  public static extern string Parameter_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getName")]
  public static extern string Parameter_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getValue")]
  public static extern double Parameter_getValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getUnits")]
  public static extern string Parameter_getUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getConstant")]
  public static extern bool Parameter_getConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_isSetId")]
  public static extern bool Parameter_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_isSetName")]
  public static extern bool Parameter_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_isSetValue")]
  public static extern bool Parameter_isSetValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_isSetUnits")]
  public static extern bool Parameter_isSetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_isSetConstant")]
  public static extern bool Parameter_isSetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setId")]
  public static extern int Parameter_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setName")]
  public static extern int Parameter_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setValue")]
  public static extern int Parameter_setValue(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setUnits")]
  public static extern int Parameter_setUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setConstant")]
  public static extern int Parameter_setConstant(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_unsetName")]
  public static extern int Parameter_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_unsetConstant")]
  public static extern int Parameter_unsetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_unsetValue")]
  public static extern int Parameter_unsetValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_unsetUnits")]
  public static extern int Parameter_unsetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Parameter_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getTypeCode")]
  public static extern int Parameter_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_getElementName")]
  public static extern string Parameter_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_hasRequiredAttributes")]
  public static extern bool Parameter_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_renameUnitSIdRefs")]
  public static extern void Parameter_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_setCalculatingUnits")]
  public static extern void Parameter_setCalculatingUnits(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfParameters__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfParameters__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfParameters__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfParameters__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_clone")]
  public static extern global::System.IntPtr ListOfParameters_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_getItemTypeCode")]
  public static extern int ListOfParameters_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_getElementName")]
  public static extern string ListOfParameters_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfParameters_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfParameters_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfParameters_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfParameters_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfParameters")]
  public static extern void delete_ListOfParameters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_LocalParameter__SWIG_0")]
  public static extern global::System.IntPtr new_LocalParameter__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_LocalParameter__SWIG_1")]
  public static extern global::System.IntPtr new_LocalParameter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_LocalParameter")]
  public static extern void delete_LocalParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_LocalParameter__SWIG_2")]
  public static extern global::System.IntPtr new_LocalParameter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_LocalParameter__SWIG_3")]
  public static extern global::System.IntPtr new_LocalParameter__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_clone")]
  public static extern global::System.IntPtr LocalParameter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr LocalParameter_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_getTypeCode")]
  public static extern int LocalParameter_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_getElementName")]
  public static extern string LocalParameter_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_hasRequiredAttributes")]
  public static extern bool LocalParameter_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_getConstant")]
  public static extern bool LocalParameter_getConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_isSetConstant")]
  public static extern bool LocalParameter_isSetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_setConstant")]
  public static extern int LocalParameter_setConstant(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_unsetConstant")]
  public static extern int LocalParameter_unsetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfLocalParameters__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfLocalParameters__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfLocalParameters__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfLocalParameters__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_clone")]
  public static extern global::System.IntPtr ListOfLocalParameters_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_getItemTypeCode")]
  public static extern int ListOfLocalParameters_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_getElementName")]
  public static extern string ListOfLocalParameters_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfLocalParameters_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfLocalParameters_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_getElementBySId")]
  public static extern global::System.IntPtr ListOfLocalParameters_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfLocalParameters_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfLocalParameters_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfLocalParameters")]
  public static extern void delete_ListOfLocalParameters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_InitialAssignment__SWIG_0")]
  public static extern global::System.IntPtr new_InitialAssignment__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_InitialAssignment__SWIG_1")]
  public static extern global::System.IntPtr new_InitialAssignment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_InitialAssignment")]
  public static extern void delete_InitialAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_InitialAssignment__SWIG_2")]
  public static extern global::System.IntPtr new_InitialAssignment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_clone")]
  public static extern global::System.IntPtr InitialAssignment_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getSymbol")]
  public static extern string InitialAssignment_getSymbol(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getMath")]
  public static extern global::System.IntPtr InitialAssignment_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_isSetSymbol")]
  public static extern bool InitialAssignment_isSetSymbol(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_isSetMath")]
  public static extern bool InitialAssignment_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_setSymbol")]
  public static extern int InitialAssignment_setSymbol(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_unsetSymbol")]
  public static extern int InitialAssignment_unsetSymbol(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_setMath")]
  public static extern int InitialAssignment_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr InitialAssignment_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_containsUndeclaredUnits__SWIG_0")]
  public static extern bool InitialAssignment_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getTypeCode")]
  public static extern int InitialAssignment_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getElementName")]
  public static extern string InitialAssignment_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_hasRequiredAttributes")]
  public static extern bool InitialAssignment_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_hasRequiredElements")]
  public static extern bool InitialAssignment_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_getId")]
  public static extern string InitialAssignment_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_renameSIdRefs")]
  public static extern void InitialAssignment_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_renameUnitSIdRefs")]
  public static extern void InitialAssignment_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_replaceSIDWithFunction")]
  public static extern void InitialAssignment_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_divideAssignmentsToSIdByFunction")]
  public static extern void InitialAssignment_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_multiplyAssignmentsToSIdByFunction")]
  public static extern void InitialAssignment_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfInitialAssignments__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfInitialAssignments__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfInitialAssignments__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfInitialAssignments__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_clone")]
  public static extern global::System.IntPtr ListOfInitialAssignments_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_getItemTypeCode")]
  public static extern int ListOfInitialAssignments_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_getElementName")]
  public static extern string ListOfInitialAssignments_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfInitialAssignments_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfInitialAssignments_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfInitialAssignments_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfInitialAssignments_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_getElementBySId")]
  public static extern global::System.IntPtr ListOfInitialAssignments_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfInitialAssignments")]
  public static extern void delete_ListOfInitialAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Rule")]
  public static extern void delete_Rule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Rule")]
  public static extern global::System.IntPtr new_Rule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_clone")]
  public static extern global::System.IntPtr Rule_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getFormula")]
  public static extern string Rule_getFormula(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getMath")]
  public static extern global::System.IntPtr Rule_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getVariable")]
  public static extern string Rule_getVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getUnits")]
  public static extern string Rule_getUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isSetFormula")]
  public static extern bool Rule_isSetFormula(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isSetMath")]
  public static extern bool Rule_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isSetVariable")]
  public static extern bool Rule_isSetVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isSetUnits")]
  public static extern bool Rule_isSetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_setFormula")]
  public static extern int Rule_setFormula(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_setMath")]
  public static extern int Rule_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_setVariable")]
  public static extern int Rule_setVariable(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_setUnits")]
  public static extern int Rule_setUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_unsetVariable")]
  public static extern int Rule_unsetVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_unsetUnits")]
  public static extern int Rule_unsetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Rule_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_containsUndeclaredUnits__SWIG_0")]
  public static extern bool Rule_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getType")]
  public static extern int Rule_getType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isAlgebraic")]
  public static extern bool Rule_isAlgebraic(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isAssignment")]
  public static extern bool Rule_isAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isCompartmentVolume")]
  public static extern bool Rule_isCompartmentVolume(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isParameter")]
  public static extern bool Rule_isParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isRate")]
  public static extern bool Rule_isRate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isScalar")]
  public static extern bool Rule_isScalar(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_isSpeciesConcentration")]
  public static extern bool Rule_isSpeciesConcentration(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getTypeCode")]
  public static extern int Rule_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getL1TypeCode")]
  public static extern int Rule_getL1TypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getElementName")]
  public static extern string Rule_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_setL1TypeCode")]
  public static extern int Rule_setL1TypeCode(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_hasRequiredElements")]
  public static extern bool Rule_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_hasRequiredAttributes")]
  public static extern bool Rule_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_renameSIdRefs")]
  public static extern void Rule_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_renameUnitSIdRefs")]
  public static extern void Rule_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_getId")]
  public static extern string Rule_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_replaceSIDWithFunction")]
  public static extern void Rule_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_divideAssignmentsToSIdByFunction")]
  public static extern void Rule_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_multiplyAssignmentsToSIdByFunction")]
  public static extern void Rule_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfRules__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfRules__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfRules__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfRules__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_clone")]
  public static extern global::System.IntPtr ListOfRules_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_getItemTypeCode")]
  public static extern int ListOfRules_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_getElementName")]
  public static extern string ListOfRules_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfRules_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfRules_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfRules_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_getElementBySId")]
  public static extern global::System.IntPtr ListOfRules_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfRules_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfRules")]
  public static extern void delete_ListOfRules(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_AlgebraicRule__SWIG_0")]
  public static extern global::System.IntPtr new_AlgebraicRule__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_AlgebraicRule__SWIG_1")]
  public static extern global::System.IntPtr new_AlgebraicRule__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_AlgebraicRule")]
  public static extern void delete_AlgebraicRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AlgebraicRule_clone")]
  public static extern global::System.IntPtr AlgebraicRule_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AlgebraicRule_hasRequiredAttributes")]
  public static extern bool AlgebraicRule_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_AssignmentRule__SWIG_0")]
  public static extern global::System.IntPtr new_AssignmentRule__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_AssignmentRule__SWIG_1")]
  public static extern global::System.IntPtr new_AssignmentRule__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_AssignmentRule")]
  public static extern void delete_AssignmentRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AssignmentRule_clone")]
  public static extern global::System.IntPtr AssignmentRule_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AssignmentRule_hasRequiredAttributes")]
  public static extern bool AssignmentRule_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AssignmentRule_renameSIdRefs")]
  public static extern void AssignmentRule_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_RateRule__SWIG_0")]
  public static extern global::System.IntPtr new_RateRule__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_RateRule__SWIG_1")]
  public static extern global::System.IntPtr new_RateRule__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_RateRule")]
  public static extern void delete_RateRule(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RateRule_clone")]
  public static extern global::System.IntPtr RateRule_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RateRule_hasRequiredAttributes")]
  public static extern bool RateRule_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RateRule_renameSIdRefs")]
  public static extern void RateRule_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Constraint__SWIG_0")]
  public static extern global::System.IntPtr new_Constraint__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Constraint__SWIG_1")]
  public static extern global::System.IntPtr new_Constraint__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Constraint")]
  public static extern void delete_Constraint(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Constraint__SWIG_2")]
  public static extern global::System.IntPtr new_Constraint__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_clone")]
  public static extern global::System.IntPtr Constraint_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_getMessage")]
  public static extern global::System.IntPtr Constraint_getMessage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_getMessageString")]
  public static extern string Constraint_getMessageString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_getMath")]
  public static extern global::System.IntPtr Constraint_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_isSetMessage")]
  public static extern bool Constraint_isSetMessage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_isSetMath")]
  public static extern bool Constraint_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_setMessage__SWIG_0")]
  public static extern int Constraint_setMessage__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_setMessage__SWIG_1")]
  public static extern int Constraint_setMessage__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_setMessage__SWIG_2")]
  public static extern int Constraint_setMessage__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_setMath")]
  public static extern int Constraint_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_unsetMessage")]
  public static extern int Constraint_unsetMessage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_renameSIdRefs")]
  public static extern void Constraint_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_renameUnitSIdRefs")]
  public static extern void Constraint_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_replaceSIDWithFunction")]
  public static extern void Constraint_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_getTypeCode")]
  public static extern int Constraint_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_getElementName")]
  public static extern string Constraint_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_hasRequiredElements")]
  public static extern bool Constraint_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfConstraints__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfConstraints__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfConstraints__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfConstraints__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_clone")]
  public static extern global::System.IntPtr ListOfConstraints_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_getItemTypeCode")]
  public static extern int ListOfConstraints_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_getElementName")]
  public static extern string ListOfConstraints_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfConstraints_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_remove")]
  public static extern global::System.IntPtr ListOfConstraints_remove(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfConstraints")]
  public static extern void delete_ListOfConstraints(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Reaction__SWIG_0")]
  public static extern global::System.IntPtr new_Reaction__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Reaction__SWIG_1")]
  public static extern global::System.IntPtr new_Reaction__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Reaction")]
  public static extern void delete_Reaction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Reaction__SWIG_2")]
  public static extern global::System.IntPtr new_Reaction__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_clone")]
  public static extern global::System.IntPtr Reaction_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getElementBySId")]
  public static extern global::System.IntPtr Reaction_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getElementByMetaId")]
  public static extern global::System.IntPtr Reaction_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_renameSIdRefs")]
  public static extern void Reaction_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_initDefaults")]
  public static extern void Reaction_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getId")]
  public static extern string Reaction_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getName")]
  public static extern string Reaction_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getKineticLaw__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getKineticLaw__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getReversible")]
  public static extern bool Reaction_getReversible(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getFast")]
  public static extern bool Reaction_getFast(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getCompartment")]
  public static extern string Reaction_getCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetId")]
  public static extern bool Reaction_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetName")]
  public static extern bool Reaction_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetKineticLaw")]
  public static extern bool Reaction_isSetKineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetFast")]
  public static extern bool Reaction_isSetFast(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetCompartment")]
  public static extern bool Reaction_isSetCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_isSetReversible")]
  public static extern bool Reaction_isSetReversible(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setId")]
  public static extern int Reaction_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setName")]
  public static extern int Reaction_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setKineticLaw")]
  public static extern int Reaction_setKineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setReversible")]
  public static extern int Reaction_setReversible(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setFast")]
  public static extern int Reaction_setFast(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_setCompartment")]
  public static extern int Reaction_setCompartment(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_unsetName")]
  public static extern int Reaction_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_unsetKineticLaw")]
  public static extern int Reaction_unsetKineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_unsetFast")]
  public static extern int Reaction_unsetFast(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_unsetCompartment")]
  public static extern int Reaction_unsetCompartment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_unsetReversible")]
  public static extern int Reaction_unsetReversible(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addReactant__SWIG_0")]
  public static extern int Reaction_addReactant__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addReactant__SWIG_1")]
  public static extern int Reaction_addReactant__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3, string jarg4, bool jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addReactant__SWIG_2")]
  public static extern int Reaction_addReactant__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addReactant__SWIG_3")]
  public static extern int Reaction_addReactant__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addReactant__SWIG_4")]
  public static extern int Reaction_addReactant__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addProduct__SWIG_0")]
  public static extern int Reaction_addProduct__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addProduct__SWIG_1")]
  public static extern int Reaction_addProduct__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3, string jarg4, bool jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addProduct__SWIG_2")]
  public static extern int Reaction_addProduct__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addProduct__SWIG_3")]
  public static extern int Reaction_addProduct__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addProduct__SWIG_4")]
  public static extern int Reaction_addProduct__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addModifier__SWIG_0")]
  public static extern int Reaction_addModifier__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addModifier__SWIG_1")]
  public static extern int Reaction_addModifier__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_addModifier__SWIG_2")]
  public static extern int Reaction_addModifier__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_createReactant")]
  public static extern global::System.IntPtr Reaction_createReactant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_createProduct")]
  public static extern global::System.IntPtr Reaction_createProduct(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_createModifier")]
  public static extern global::System.IntPtr Reaction_createModifier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_createKineticLaw")]
  public static extern global::System.IntPtr Reaction_createKineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getListOfReactants__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getListOfReactants__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getListOfProducts__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getListOfProducts__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getListOfModifiers__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getListOfModifiers__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getReactant__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getReactant__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getReactant__SWIG_2")]
  public static extern global::System.IntPtr Reaction_getReactant__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getProduct__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getProduct__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getProduct__SWIG_2")]
  public static extern global::System.IntPtr Reaction_getProduct__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getModifier__SWIG_0")]
  public static extern global::System.IntPtr Reaction_getModifier__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getModifier__SWIG_2")]
  public static extern global::System.IntPtr Reaction_getModifier__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getNumReactants")]
  public static extern uint Reaction_getNumReactants(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getNumProducts")]
  public static extern uint Reaction_getNumProducts(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getNumModifiers")]
  public static extern uint Reaction_getNumModifiers(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeReactant__SWIG_0")]
  public static extern global::System.IntPtr Reaction_removeReactant__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeReactant__SWIG_1")]
  public static extern global::System.IntPtr Reaction_removeReactant__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeProduct__SWIG_0")]
  public static extern global::System.IntPtr Reaction_removeProduct__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeProduct__SWIG_1")]
  public static extern global::System.IntPtr Reaction_removeProduct__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeModifier__SWIG_0")]
  public static extern global::System.IntPtr Reaction_removeModifier__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_removeModifier__SWIG_1")]
  public static extern global::System.IntPtr Reaction_removeModifier__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_connectToChild")]
  public static extern void Reaction_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_enablePackageInternal")]
  public static extern void Reaction_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_updateSBMLNamespace")]
  public static extern void Reaction_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getTypeCode")]
  public static extern int Reaction_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_getElementName")]
  public static extern string Reaction_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_hasRequiredAttributes")]
  public static extern bool Reaction_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfReactions__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfReactions__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfReactions__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfReactions__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_clone")]
  public static extern global::System.IntPtr ListOfReactions_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_getItemTypeCode")]
  public static extern int ListOfReactions_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_getElementName")]
  public static extern string ListOfReactions_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfReactions_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfReactions_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfReactions_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfReactions_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfReactions")]
  public static extern void delete_ListOfReactions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_KineticLaw__SWIG_0")]
  public static extern global::System.IntPtr new_KineticLaw__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_KineticLaw__SWIG_1")]
  public static extern global::System.IntPtr new_KineticLaw__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_KineticLaw")]
  public static extern void delete_KineticLaw(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_KineticLaw__SWIG_2")]
  public static extern global::System.IntPtr new_KineticLaw__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_clone")]
  public static extern global::System.IntPtr KineticLaw_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getElementBySId")]
  public static extern global::System.IntPtr KineticLaw_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getElementByMetaId")]
  public static extern global::System.IntPtr KineticLaw_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getFormula")]
  public static extern string KineticLaw_getFormula(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getMath")]
  public static extern global::System.IntPtr KineticLaw_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getTimeUnits")]
  public static extern string KineticLaw_getTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getSubstanceUnits")]
  public static extern string KineticLaw_getSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_isSetFormula")]
  public static extern bool KineticLaw_isSetFormula(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_isSetMath")]
  public static extern bool KineticLaw_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_isSetTimeUnits")]
  public static extern bool KineticLaw_isSetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_isSetSubstanceUnits")]
  public static extern bool KineticLaw_isSetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_setFormula")]
  public static extern int KineticLaw_setFormula(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_setMath")]
  public static extern int KineticLaw_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_setTimeUnits")]
  public static extern int KineticLaw_setTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_setSubstanceUnits")]
  public static extern int KineticLaw_setSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_unsetTimeUnits")]
  public static extern int KineticLaw_unsetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_unsetSubstanceUnits")]
  public static extern int KineticLaw_unsetSubstanceUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_addParameter")]
  public static extern int KineticLaw_addParameter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_addLocalParameter")]
  public static extern int KineticLaw_addLocalParameter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_createParameter")]
  public static extern global::System.IntPtr KineticLaw_createParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_createLocalParameter")]
  public static extern global::System.IntPtr KineticLaw_createLocalParameter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getListOfParameters__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_getListOfParameters__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getListOfLocalParameters__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_getListOfLocalParameters__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getParameter__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_getParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getLocalParameter__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_getLocalParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getParameter__SWIG_2")]
  public static extern global::System.IntPtr KineticLaw_getParameter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getLocalParameter__SWIG_2")]
  public static extern global::System.IntPtr KineticLaw_getLocalParameter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getNumParameters")]
  public static extern uint KineticLaw_getNumParameters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getNumLocalParameters")]
  public static extern uint KineticLaw_getNumLocalParameters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_containsUndeclaredUnits__SWIG_0")]
  public static extern bool KineticLaw_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_removeParameter__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_removeParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_removeLocalParameter__SWIG_0")]
  public static extern global::System.IntPtr KineticLaw_removeLocalParameter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_removeParameter__SWIG_1")]
  public static extern global::System.IntPtr KineticLaw_removeParameter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_removeLocalParameter__SWIG_1")]
  public static extern global::System.IntPtr KineticLaw_removeLocalParameter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_connectToChild")]
  public static extern void KineticLaw_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_enablePackageInternal")]
  public static extern void KineticLaw_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_updateSBMLNamespace")]
  public static extern void KineticLaw_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getTypeCode")]
  public static extern int KineticLaw_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_getElementName")]
  public static extern string KineticLaw_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_hasRequiredAttributes")]
  public static extern bool KineticLaw_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_hasRequiredElements")]
  public static extern bool KineticLaw_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_removeFromParentAndDelete")]
  public static extern int KineticLaw_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_renameSIdRefs")]
  public static extern void KineticLaw_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_renameUnitSIdRefs")]
  public static extern void KineticLaw_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_replaceSIDWithFunction")]
  public static extern void KineticLaw_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_divideAssignmentsToSIdByFunction")]
  public static extern void KineticLaw_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_multiplyAssignmentsToSIdByFunction")]
  public static extern void KineticLaw_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SimpleSpeciesReference")]
  public static extern void delete_SimpleSpeciesReference(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_getId")]
  public static extern string SimpleSpeciesReference_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_getName")]
  public static extern string SimpleSpeciesReference_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_getSpecies")]
  public static extern string SimpleSpeciesReference_getSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_isSetId")]
  public static extern bool SimpleSpeciesReference_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_isSetName")]
  public static extern bool SimpleSpeciesReference_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_isSetSpecies")]
  public static extern bool SimpleSpeciesReference_isSetSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_setSpecies")]
  public static extern int SimpleSpeciesReference_setSpecies(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_setId")]
  public static extern int SimpleSpeciesReference_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_setName")]
  public static extern int SimpleSpeciesReference_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_unsetId")]
  public static extern int SimpleSpeciesReference_unsetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_unsetName")]
  public static extern int SimpleSpeciesReference_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_unsetSpecies")]
  public static extern int SimpleSpeciesReference_unsetSpecies(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_isModifier")]
  public static extern bool SimpleSpeciesReference_isModifier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_renameSIdRefs")]
  public static extern void SimpleSpeciesReference_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesReference__SWIG_0")]
  public static extern global::System.IntPtr new_SpeciesReference__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesReference__SWIG_1")]
  public static extern global::System.IntPtr new_SpeciesReference__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SpeciesReference")]
  public static extern void delete_SpeciesReference(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SpeciesReference__SWIG_2")]
  public static extern global::System.IntPtr new_SpeciesReference__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_clone")]
  public static extern global::System.IntPtr SpeciesReference_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_initDefaults")]
  public static extern void SpeciesReference_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getStoichiometry")]
  public static extern double SpeciesReference_getStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getStoichiometryMath__SWIG_0")]
  public static extern global::System.IntPtr SpeciesReference_getStoichiometryMath__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getDenominator")]
  public static extern int SpeciesReference_getDenominator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getConstant")]
  public static extern bool SpeciesReference_getConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_isSetStoichiometryMath")]
  public static extern bool SpeciesReference_isSetStoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_isSetConstant")]
  public static extern bool SpeciesReference_isSetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_isSetStoichiometry")]
  public static extern bool SpeciesReference_isSetStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setStoichiometry")]
  public static extern int SpeciesReference_setStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setStoichiometryMath")]
  public static extern int SpeciesReference_setStoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setDenominator")]
  public static extern int SpeciesReference_setDenominator(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setConstant")]
  public static extern int SpeciesReference_setConstant(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_unsetStoichiometryMath")]
  public static extern int SpeciesReference_unsetStoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_unsetStoichiometry")]
  public static extern int SpeciesReference_unsetStoichiometry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_unsetConstant")]
  public static extern int SpeciesReference_unsetConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_createStoichiometryMath")]
  public static extern global::System.IntPtr SpeciesReference_createStoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setAnnotation__SWIG_0")]
  public static extern int SpeciesReference_setAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_setAnnotation__SWIG_1")]
  public static extern int SpeciesReference_setAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_appendAnnotation__SWIG_0")]
  public static extern int SpeciesReference_appendAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_appendAnnotation__SWIG_1")]
  public static extern int SpeciesReference_appendAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getTypeCode")]
  public static extern int SpeciesReference_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_getElementName")]
  public static extern string SpeciesReference_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_hasRequiredAttributes")]
  public static extern bool SpeciesReference_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpeciesReferences__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfSpeciesReferences__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfSpeciesReferences__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfSpeciesReferences__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_clone")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_getItemTypeCode")]
  public static extern int ListOfSpeciesReferences_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_getElementName")]
  public static extern string ListOfSpeciesReferences_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_getType")]
  public static extern uint ListOfSpeciesReferences_getType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfSpeciesReferences")]
  public static extern void delete_ListOfSpeciesReferences(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModifierSpeciesReference__SWIG_0")]
  public static extern global::System.IntPtr new_ModifierSpeciesReference__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModifierSpeciesReference__SWIG_1")]
  public static extern global::System.IntPtr new_ModifierSpeciesReference__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ModifierSpeciesReference")]
  public static extern void delete_ModifierSpeciesReference(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModifierSpeciesReference_clone")]
  public static extern global::System.IntPtr ModifierSpeciesReference_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModifierSpeciesReference_getTypeCode")]
  public static extern int ModifierSpeciesReference_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModifierSpeciesReference_getElementName")]
  public static extern string ModifierSpeciesReference_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModifierSpeciesReference_hasRequiredAttributes")]
  public static extern bool ModifierSpeciesReference_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Event__SWIG_0")]
  public static extern global::System.IntPtr new_Event__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Event__SWIG_1")]
  public static extern global::System.IntPtr new_Event__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Event")]
  public static extern void delete_Event(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Event__SWIG_2")]
  public static extern global::System.IntPtr new_Event__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_clone")]
  public static extern global::System.IntPtr Event_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_initDefaults")]
  public static extern void Event_initDefaults(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getElementBySId")]
  public static extern global::System.IntPtr Event_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getElementByMetaId")]
  public static extern global::System.IntPtr Event_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getId")]
  public static extern string Event_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getName")]
  public static extern string Event_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getTrigger__SWIG_0")]
  public static extern global::System.IntPtr Event_getTrigger__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getDelay__SWIG_0")]
  public static extern global::System.IntPtr Event_getDelay__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getPriority__SWIG_0")]
  public static extern global::System.IntPtr Event_getPriority__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getTimeUnits")]
  public static extern string Event_getTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getUseValuesFromTriggerTime")]
  public static extern bool Event_getUseValuesFromTriggerTime(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetId")]
  public static extern bool Event_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetName")]
  public static extern bool Event_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetTrigger")]
  public static extern bool Event_isSetTrigger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetDelay")]
  public static extern bool Event_isSetDelay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetPriority")]
  public static extern bool Event_isSetPriority(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetTimeUnits")]
  public static extern bool Event_isSetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_isSetUseValuesFromTriggerTime")]
  public static extern bool Event_isSetUseValuesFromTriggerTime(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setId")]
  public static extern int Event_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setName")]
  public static extern int Event_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setTrigger")]
  public static extern int Event_setTrigger(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setDelay")]
  public static extern int Event_setDelay(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setPriority")]
  public static extern int Event_setPriority(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setTimeUnits")]
  public static extern int Event_setTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_setUseValuesFromTriggerTime")]
  public static extern int Event_setUseValuesFromTriggerTime(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetId")]
  public static extern int Event_unsetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetName")]
  public static extern int Event_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetUseValuesFromTriggerTime")]
  public static extern int Event_unsetUseValuesFromTriggerTime(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetDelay")]
  public static extern int Event_unsetDelay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetPriority")]
  public static extern int Event_unsetPriority(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetTrigger")]
  public static extern int Event_unsetTrigger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_unsetTimeUnits")]
  public static extern int Event_unsetTimeUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_addEventAssignment")]
  public static extern int Event_addEventAssignment(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_createEventAssignment")]
  public static extern global::System.IntPtr Event_createEventAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_createTrigger")]
  public static extern global::System.IntPtr Event_createTrigger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_createDelay")]
  public static extern global::System.IntPtr Event_createDelay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_createPriority")]
  public static extern global::System.IntPtr Event_createPriority(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getListOfEventAssignments__SWIG_0")]
  public static extern global::System.IntPtr Event_getListOfEventAssignments__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getEventAssignment__SWIG_0")]
  public static extern global::System.IntPtr Event_getEventAssignment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getEventAssignment__SWIG_2")]
  public static extern global::System.IntPtr Event_getEventAssignment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getNumEventAssignments")]
  public static extern uint Event_getNumEventAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_removeEventAssignment__SWIG_0")]
  public static extern global::System.IntPtr Event_removeEventAssignment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_removeEventAssignment__SWIG_1")]
  public static extern global::System.IntPtr Event_removeEventAssignment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_connectToChild")]
  public static extern void Event_connectToChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_enablePackageInternal")]
  public static extern void Event_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_updateSBMLNamespace")]
  public static extern void Event_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getTypeCode")]
  public static extern int Event_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_getElementName")]
  public static extern string Event_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_hasRequiredAttributes")]
  public static extern bool Event_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_hasRequiredElements")]
  public static extern bool Event_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfEvents__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfEvents__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfEvents__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfEvents__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_clone")]
  public static extern global::System.IntPtr ListOfEvents_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_getItemTypeCode")]
  public static extern int ListOfEvents_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_getElementName")]
  public static extern string ListOfEvents_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfEvents_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfEvents_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfEvents_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfEvents_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfEvents")]
  public static extern void delete_ListOfEvents(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_EventAssignment__SWIG_0")]
  public static extern global::System.IntPtr new_EventAssignment__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_EventAssignment__SWIG_1")]
  public static extern global::System.IntPtr new_EventAssignment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_EventAssignment")]
  public static extern void delete_EventAssignment(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_EventAssignment__SWIG_2")]
  public static extern global::System.IntPtr new_EventAssignment__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_clone")]
  public static extern global::System.IntPtr EventAssignment_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getVariable")]
  public static extern string EventAssignment_getVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getMath")]
  public static extern global::System.IntPtr EventAssignment_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_isSetVariable")]
  public static extern bool EventAssignment_isSetVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_isSetMath")]
  public static extern bool EventAssignment_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_setVariable")]
  public static extern int EventAssignment_setVariable(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_unsetVariable")]
  public static extern int EventAssignment_unsetVariable(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_setMath")]
  public static extern int EventAssignment_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr EventAssignment_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_containsUndeclaredUnits__SWIG_0")]
  public static extern bool EventAssignment_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getTypeCode")]
  public static extern int EventAssignment_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getElementName")]
  public static extern string EventAssignment_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_hasRequiredAttributes")]
  public static extern bool EventAssignment_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_hasRequiredElements")]
  public static extern bool EventAssignment_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_getId")]
  public static extern string EventAssignment_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_renameSIdRefs")]
  public static extern void EventAssignment_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_renameUnitSIdRefs")]
  public static extern void EventAssignment_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_replaceSIDWithFunction")]
  public static extern void EventAssignment_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_divideAssignmentsToSIdByFunction")]
  public static extern void EventAssignment_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_multiplyAssignmentsToSIdByFunction")]
  public static extern void EventAssignment_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfEventAssignments__SWIG_0")]
  public static extern global::System.IntPtr new_ListOfEventAssignments__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ListOfEventAssignments__SWIG_1")]
  public static extern global::System.IntPtr new_ListOfEventAssignments__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_clone")]
  public static extern global::System.IntPtr ListOfEventAssignments_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_getItemTypeCode")]
  public static extern int ListOfEventAssignments_getItemTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_getElementName")]
  public static extern string ListOfEventAssignments_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_get__SWIG_0")]
  public static extern global::System.IntPtr ListOfEventAssignments_get__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_get__SWIG_2")]
  public static extern global::System.IntPtr ListOfEventAssignments_get__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_remove__SWIG_0")]
  public static extern global::System.IntPtr ListOfEventAssignments_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_remove__SWIG_1")]
  public static extern global::System.IntPtr ListOfEventAssignments_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_getElementBySId")]
  public static extern global::System.IntPtr ListOfEventAssignments_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ListOfEventAssignments")]
  public static extern void delete_ListOfEventAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Trigger__SWIG_0")]
  public static extern global::System.IntPtr new_Trigger__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Trigger__SWIG_1")]
  public static extern global::System.IntPtr new_Trigger__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Trigger")]
  public static extern void delete_Trigger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Trigger__SWIG_2")]
  public static extern global::System.IntPtr new_Trigger__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_clone")]
  public static extern global::System.IntPtr Trigger_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_getMath")]
  public static extern global::System.IntPtr Trigger_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_getInitialValue")]
  public static extern bool Trigger_getInitialValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_getPersistent")]
  public static extern bool Trigger_getPersistent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_isSetMath")]
  public static extern bool Trigger_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_isSetInitialValue")]
  public static extern bool Trigger_isSetInitialValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_isSetPersistent")]
  public static extern bool Trigger_isSetPersistent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_setMath")]
  public static extern int Trigger_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_setInitialValue")]
  public static extern int Trigger_setInitialValue(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_setPersistent")]
  public static extern int Trigger_setPersistent(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_unsetInitialValue")]
  public static extern int Trigger_unsetInitialValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_unsetPersistent")]
  public static extern int Trigger_unsetPersistent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_getTypeCode")]
  public static extern int Trigger_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_getElementName")]
  public static extern string Trigger_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_renameSIdRefs")]
  public static extern void Trigger_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_renameUnitSIdRefs")]
  public static extern void Trigger_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_replaceSIDWithFunction")]
  public static extern void Trigger_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_hasRequiredElements")]
  public static extern bool Trigger_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_hasRequiredAttributes")]
  public static extern bool Trigger_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_removeFromParentAndDelete")]
  public static extern int Trigger_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Delay__SWIG_0")]
  public static extern global::System.IntPtr new_Delay__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Delay__SWIG_1")]
  public static extern global::System.IntPtr new_Delay__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Delay")]
  public static extern void delete_Delay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Delay__SWIG_2")]
  public static extern global::System.IntPtr new_Delay__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_clone")]
  public static extern global::System.IntPtr Delay_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_getMath")]
  public static extern global::System.IntPtr Delay_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_isSetMath")]
  public static extern bool Delay_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_setMath")]
  public static extern int Delay_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr Delay_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_containsUndeclaredUnits__SWIG_0")]
  public static extern bool Delay_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_getTypeCode")]
  public static extern int Delay_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_getElementName")]
  public static extern string Delay_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_hasRequiredElements")]
  public static extern bool Delay_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_removeFromParentAndDelete")]
  public static extern int Delay_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_renameSIdRefs")]
  public static extern void Delay_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_renameUnitSIdRefs")]
  public static extern void Delay_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_replaceSIDWithFunction")]
  public static extern void Delay_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Priority__SWIG_0")]
  public static extern global::System.IntPtr new_Priority__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Priority__SWIG_1")]
  public static extern global::System.IntPtr new_Priority__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Priority")]
  public static extern void delete_Priority(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Priority__SWIG_2")]
  public static extern global::System.IntPtr new_Priority__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_clone")]
  public static extern global::System.IntPtr Priority_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_getMath")]
  public static extern global::System.IntPtr Priority_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_isSetMath")]
  public static extern bool Priority_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_setMath")]
  public static extern int Priority_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_getTypeCode")]
  public static extern int Priority_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_getElementName")]
  public static extern string Priority_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_hasRequiredElements")]
  public static extern bool Priority_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_removeFromParentAndDelete")]
  public static extern int Priority_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_renameSIdRefs")]
  public static extern void Priority_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_renameUnitSIdRefs")]
  public static extern void Priority_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_replaceSIDWithFunction")]
  public static extern void Priority_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isQuantitativeParameter")]
  public static extern bool SBO_isQuantitativeParameter(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isParticipantRole")]
  public static extern bool SBO_isParticipantRole(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isModellingFramework")]
  public static extern bool SBO_isModellingFramework(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isMathematicalExpression")]
  public static extern bool SBO_isMathematicalExpression(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isKineticConstant")]
  public static extern bool SBO_isKineticConstant(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isReactant")]
  public static extern bool SBO_isReactant(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isProduct")]
  public static extern bool SBO_isProduct(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isModifier")]
  public static extern bool SBO_isModifier(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isRateLaw")]
  public static extern bool SBO_isRateLaw(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isEvent")]
  public static extern bool SBO_isEvent(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isPhysicalParticipant")]
  public static extern bool SBO_isPhysicalParticipant(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isParticipant")]
  public static extern bool SBO_isParticipant(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isInteraction")]
  public static extern bool SBO_isInteraction(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isEntity")]
  public static extern bool SBO_isEntity(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isFunctionalEntity")]
  public static extern bool SBO_isFunctionalEntity(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isMaterialEntity")]
  public static extern bool SBO_isMaterialEntity(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isConservationLaw")]
  public static extern bool SBO_isConservationLaw(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isSteadyStateExpression")]
  public static extern bool SBO_isSteadyStateExpression(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isFunctionalCompartment")]
  public static extern bool SBO_isFunctionalCompartment(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isContinuousFramework")]
  public static extern bool SBO_isContinuousFramework(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isDiscreteFramework")]
  public static extern bool SBO_isDiscreteFramework(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isLogicalFramework")]
  public static extern bool SBO_isLogicalFramework(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isMetadataRepresentation")]
  public static extern bool SBO_isMetadataRepresentation(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isOccurringEntityRepresentation")]
  public static extern bool SBO_isOccurringEntityRepresentation(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isPhysicalEntityRepresentation")]
  public static extern bool SBO_isPhysicalEntityRepresentation(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isSystemsDescriptionParameter")]
  public static extern bool SBO_isSystemsDescriptionParameter(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isQuantitativeSystemsDescriptionParameter")]
  public static extern bool SBO_isQuantitativeSystemsDescriptionParameter(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_isObselete")]
  public static extern bool SBO_isObselete(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_intToString")]
  public static extern string SBO_intToString(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_stringToInt")]
  public static extern int SBO_stringToInt(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_checkTerm__SWIG_0")]
  public static extern bool SBO_checkTerm__SWIG_0(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_checkTerm__SWIG_1")]
  public static extern bool SBO_checkTerm__SWIG_1(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBO_getParentBranch")]
  public static extern uint SBO_getParentBranch(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBO")]
  public static extern global::System.IntPtr new_SBO();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBO")]
  public static extern void delete_SBO(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidSBMLSId")]
  public static extern bool SyntaxChecker_isValidSBMLSId(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidXMLID")]
  public static extern bool SyntaxChecker_isValidXMLID(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidXMLanyURI")]
  public static extern bool SyntaxChecker_isValidXMLanyURI(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidUnitSId")]
  public static extern bool SyntaxChecker_isValidUnitSId(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0")]
  public static extern bool SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1")]
  public static extern bool SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidInternalSId")]
  public static extern bool SyntaxChecker_isValidInternalSId(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SyntaxChecker_isValidInternalUnitSId")]
  public static extern bool SyntaxChecker_isValidInternalUnitSId(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SyntaxChecker")]
  public static extern global::System.IntPtr new_SyntaxChecker();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SyntaxChecker")]
  public static extern void delete_SyntaxChecker(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_StoichiometryMath__SWIG_0")]
  public static extern global::System.IntPtr new_StoichiometryMath__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_StoichiometryMath__SWIG_1")]
  public static extern global::System.IntPtr new_StoichiometryMath__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_StoichiometryMath")]
  public static extern void delete_StoichiometryMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_StoichiometryMath__SWIG_2")]
  public static extern global::System.IntPtr new_StoichiometryMath__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_clone")]
  public static extern global::System.IntPtr StoichiometryMath_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_getMath")]
  public static extern global::System.IntPtr StoichiometryMath_getMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_isSetMath")]
  public static extern bool StoichiometryMath_isSetMath(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_setMath")]
  public static extern int StoichiometryMath_setMath(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_getDerivedUnitDefinition__SWIG_0")]
  public static extern global::System.IntPtr StoichiometryMath_getDerivedUnitDefinition__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_containsUndeclaredUnits__SWIG_0")]
  public static extern bool StoichiometryMath_containsUndeclaredUnits__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_getTypeCode")]
  public static extern int StoichiometryMath_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_getElementName")]
  public static extern string StoichiometryMath_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_hasRequiredElements")]
  public static extern bool StoichiometryMath_hasRequiredElements(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_removeFromParentAndDelete")]
  public static extern int StoichiometryMath_removeFromParentAndDelete(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_renameSIdRefs")]
  public static extern void StoichiometryMath_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_renameUnitSIdRefs")]
  public static extern void StoichiometryMath_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_replaceSIDWithFunction")]
  public static extern void StoichiometryMath_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_1(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_2")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_3")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_3(long jarg1, long jarg2, string jarg3, long jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_4")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_4(long jarg1, long jarg2, string jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLNamespaces")]
  public static extern void delete_SBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLNamespaces__SWIG_5")]
  public static extern global::System.IntPtr new_SBMLNamespaces__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_clone")]
  public static extern global::System.IntPtr SBMLNamespaces_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getSBMLNamespaceURI")]
  public static extern string SBMLNamespaces_getSBMLNamespaceURI(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getSupportedNamespaces")]
  public static extern global::System.IntPtr SBMLNamespaces_getSupportedNamespaces();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_freeSBMLNamespaces")]
  public static extern void SBMLNamespaces_freeSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getURI")]
  public static extern string SBMLNamespaces_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getLevel__SWIG_0")]
  public static extern uint SBMLNamespaces_getLevel__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getVersion__SWIG_0")]
  public static extern uint SBMLNamespaces_getVersion__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getNamespaces__SWIG_0")]
  public static extern global::System.IntPtr SBMLNamespaces_getNamespaces__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addNamespaces")]
  public static extern int SBMLNamespaces_addNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addNamespace")]
  public static extern int SBMLNamespaces_addNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_removeNamespace")]
  public static extern int SBMLNamespaces_removeNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPackageNamespace__SWIG_0")]
  public static extern int SBMLNamespaces_addPackageNamespace__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPackageNamespace__SWIG_1")]
  public static extern int SBMLNamespaces_addPackageNamespace__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPackageNamespaces")]
  public static extern int SBMLNamespaces_addPackageNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_removePackageNamespace")]
  public static extern int SBMLNamespaces_removePackageNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPkgNamespace__SWIG_0")]
  public static extern int SBMLNamespaces_addPkgNamespace__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPkgNamespace__SWIG_1")]
  public static extern int SBMLNamespaces_addPkgNamespace__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_addPkgNamespaces")]
  public static extern int SBMLNamespaces_addPkgNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_removePkgNamespace")]
  public static extern int SBMLNamespaces_removePkgNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_isSBMLNamespace")]
  public static extern bool SBMLNamespaces_isSBMLNamespace(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_isValidCombination")]
  public static extern bool SBMLNamespaces_isValidCombination(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLNamespaces_getPackageName")]
  public static extern string SBMLNamespaces_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_replaceFD__SWIG_0")]
  public static extern void SBMLTransforms_replaceFD__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_replaceFD__SWIG_1")]
  public static extern void SBMLTransforms_replaceFD__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_replaceFD__SWIG_2")]
  public static extern void SBMLTransforms_replaceFD__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_replaceFD__SWIG_3")]
  public static extern void SBMLTransforms_replaceFD__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_expandInitialAssignments")]
  public static extern bool SBMLTransforms_expandInitialAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_evaluateASTNode__SWIG_0")]
  public static extern double SBMLTransforms_evaluateASTNode__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_evaluateASTNode__SWIG_1")]
  public static extern double SBMLTransforms_evaluateASTNode__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_expandL3V2InitialAssignments")]
  public static extern bool SBMLTransforms_expandL3V2InitialAssignments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_mapComponentValues")]
  public static extern global::System.IntPtr SBMLTransforms_mapComponentValues(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_clearComponentValues")]
  public static extern void SBMLTransforms_clearComponentValues();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLTransforms_nodeContainsId")]
  public static extern bool SBMLTransforms_nodeContainsId(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLTransforms")]
  public static extern global::System.IntPtr new_SBMLTransforms();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLTransforms")]
  public static extern void delete_SBMLTransforms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConstructorException__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLConstructorException__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConstructorException__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLConstructorException__SWIG_1(string jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConstructorException__SWIG_2")]
  public static extern global::System.IntPtr new_SBMLConstructorException__SWIG_2(string jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLConstructorException")]
  public static extern void delete_SBMLConstructorException(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConstructorException_getSBMLErrMsg")]
  public static extern string SBMLConstructorException_getSBMLErrMsg(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_0")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_0(string jarg1, string jarg2, int jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_1")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_1(string jarg1, string jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_2")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_2(string jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_3")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_3(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_4")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_4(string jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_6")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_6(string jarg1, bool jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_7")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_7(string jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_8")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_8(string jarg1, double jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_9")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_9(string jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_10")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_10(string jarg1, float jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_11")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_11(string jarg1, float jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_12")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_12(string jarg1, int jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_13")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_13(string jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionOption__SWIG_14")]
  public static extern global::System.IntPtr new_ConversionOption__SWIG_14(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ConversionOption")]
  public static extern void delete_ConversionOption(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_clone")]
  public static extern global::System.IntPtr ConversionOption_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getKey")]
  public static extern string ConversionOption_getKey(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setKey")]
  public static extern void ConversionOption_setKey(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getValue")]
  public static extern string ConversionOption_getValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setValue")]
  public static extern void ConversionOption_setValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getDescription")]
  public static extern string ConversionOption_getDescription(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setDescription")]
  public static extern void ConversionOption_setDescription(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getType")]
  public static extern int ConversionOption_getType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setType")]
  public static extern void ConversionOption_setType(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getBoolValue")]
  public static extern bool ConversionOption_getBoolValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setBoolValue")]
  public static extern void ConversionOption_setBoolValue(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getDoubleValue")]
  public static extern double ConversionOption_getDoubleValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setDoubleValue")]
  public static extern void ConversionOption_setDoubleValue(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getFloatValue")]
  public static extern float ConversionOption_getFloatValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setFloatValue")]
  public static extern void ConversionOption_setFloatValue(global::System.Runtime.InteropServices.HandleRef jarg1, float jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_getIntValue")]
  public static extern int ConversionOption_getIntValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionOption_setIntValue")]
  public static extern void ConversionOption_setIntValue(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionProperties__SWIG_0")]
  public static extern global::System.IntPtr new_ConversionProperties__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionProperties__SWIG_1")]
  public static extern global::System.IntPtr new_ConversionProperties__SWIG_1();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ConversionProperties__SWIG_2")]
  public static extern global::System.IntPtr new_ConversionProperties__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_clone")]
  public static extern global::System.IntPtr ConversionProperties_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ConversionProperties")]
  public static extern void delete_ConversionProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getTargetNamespaces")]
  public static extern global::System.IntPtr ConversionProperties_getTargetNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_hasTargetNamespaces")]
  public static extern bool ConversionProperties_hasTargetNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setTargetNamespaces")]
  public static extern void ConversionProperties_setTargetNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getDescription")]
  public static extern string ConversionProperties_getDescription(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getType")]
  public static extern int ConversionProperties_getType(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getOption__SWIG_0")]
  public static extern global::System.IntPtr ConversionProperties_getOption__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getOption__SWIG_1")]
  public static extern global::System.IntPtr ConversionProperties_getOption__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_0")]
  public static extern void ConversionProperties_addOption__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_1")]
  public static extern void ConversionProperties_addOption__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, int jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_2")]
  public static extern void ConversionProperties_addOption__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_3")]
  public static extern void ConversionProperties_addOption__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_4")]
  public static extern void ConversionProperties_addOption__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_5")]
  public static extern void ConversionProperties_addOption__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_7")]
  public static extern void ConversionProperties_addOption__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_8")]
  public static extern void ConversionProperties_addOption__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_9")]
  public static extern void ConversionProperties_addOption__SWIG_9(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, double jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_10")]
  public static extern void ConversionProperties_addOption__SWIG_10(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_11")]
  public static extern void ConversionProperties_addOption__SWIG_11(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, float jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_12")]
  public static extern void ConversionProperties_addOption__SWIG_12(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, float jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_13")]
  public static extern void ConversionProperties_addOption__SWIG_13(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, int jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_addOption__SWIG_14")]
  public static extern void ConversionProperties_addOption__SWIG_14(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_removeOption")]
  public static extern global::System.IntPtr ConversionProperties_removeOption(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_hasOption")]
  public static extern bool ConversionProperties_hasOption(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getValue")]
  public static extern string ConversionProperties_getValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setValue")]
  public static extern void ConversionProperties_setValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getBoolValue")]
  public static extern bool ConversionProperties_getBoolValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setBoolValue")]
  public static extern void ConversionProperties_setBoolValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getDoubleValue")]
  public static extern double ConversionProperties_getDoubleValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setDoubleValue")]
  public static extern void ConversionProperties_setDoubleValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getFloatValue")]
  public static extern float ConversionProperties_getFloatValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setFloatValue")]
  public static extern void ConversionProperties_setFloatValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, float jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getIntValue")]
  public static extern int ConversionProperties_getIntValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_setIntValue")]
  public static extern void ConversionProperties_setIntValue(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ConversionProperties_getNumOptions")]
  public static extern int ConversionProperties_getNumOptions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLConverter__SWIG_1(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLConverter__SWIG_2")]
  public static extern global::System.IntPtr new_SBMLConverter__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLConverter")]
  public static extern void delete_SBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_clone")]
  public static extern global::System.IntPtr SBMLConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_cloneSwigExplicitSBMLConverter")]
  public static extern global::System.IntPtr SBMLConverter_cloneSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getDocument__SWIG_0")]
  public static extern global::System.IntPtr SBMLConverter_getDocument__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_0")]
  public static extern global::System.IntPtr SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_1")]
  public static extern global::System.IntPtr SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getDefaultPropertiesSwigExplicitSBMLConverter")]
  public static extern global::System.IntPtr SBMLConverter_getDefaultPropertiesSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getTargetNamespaces")]
  public static extern global::System.IntPtr SBMLConverter_getTargetNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getTargetNamespacesSwigExplicitSBMLConverter")]
  public static extern global::System.IntPtr SBMLConverter_getTargetNamespacesSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_matchesProperties")]
  public static extern bool SBMLConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_matchesPropertiesSwigExplicitSBMLConverter")]
  public static extern bool SBMLConverter_matchesPropertiesSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_setDocument")]
  public static extern int SBMLConverter_setDocument(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_setDocumentSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_setDocumentSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_setProperties")]
  public static extern int SBMLConverter_setProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_setPropertiesSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_setPropertiesSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getProperties")]
  public static extern global::System.IntPtr SBMLConverter_getProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getPropertiesSwigExplicitSBMLConverter")]
  public static extern global::System.IntPtr SBMLConverter_getPropertiesSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_convert")]
  public static extern int SBMLConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_convertSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_convertSwigExplicitSBMLConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_getName")]
  public static extern string SBMLConverter_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverter_director_connect")]
  public static extern void SBMLConverter_director_connect(global::System.Runtime.InteropServices.HandleRef jarg1, SBMLConverter.SwigDelegateSBMLConverter_0 delegate0, SBMLConverter.SwigDelegateSBMLConverter_1 delegate1, SBMLConverter.SwigDelegateSBMLConverter_2 delegate2, SBMLConverter.SwigDelegateSBMLConverter_3 delegate3, SBMLConverter.SwigDelegateSBMLConverter_4 delegate4, SBMLConverter.SwigDelegateSBMLConverter_5 delegate5, SBMLConverter.SwigDelegateSBMLConverter_6 delegate6, SBMLConverter.SwigDelegateSBMLConverter_7 delegate7, SBMLConverter.SwigDelegateSBMLConverter_8 delegate8, SBMLConverter.SwigDelegateSBMLConverter_9 delegate9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverterRegistry_getInstance")]
  public static extern global::System.IntPtr SBMLConverterRegistry_getInstance();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverterRegistry_addConverter")]
  public static extern int SBMLConverterRegistry_addConverter(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverterRegistry_getConverterByIndex")]
  public static extern global::System.IntPtr SBMLConverterRegistry_getConverterByIndex(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverterRegistry_getConverterFor")]
  public static extern global::System.IntPtr SBMLConverterRegistry_getConverterFor(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLConverterRegistry_getNumConverters")]
  public static extern int SBMLConverterRegistry_getNumConverters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLConverterRegistry")]
  public static extern void delete_SBMLConverterRegistry(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_init")]
  public static extern void SBMLFunctionDefinitionConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLFunctionDefinitionConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLFunctionDefinitionConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLFunctionDefinitionConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLFunctionDefinitionConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_clone")]
  public static extern global::System.IntPtr SBMLFunctionDefinitionConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLFunctionDefinitionConverter")]
  public static extern void delete_SBMLFunctionDefinitionConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_matchesProperties")]
  public static extern bool SBMLFunctionDefinitionConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_convert")]
  public static extern int SBMLFunctionDefinitionConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLFunctionDefinitionConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_init")]
  public static extern void SBMLIdConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLIdConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLIdConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLIdConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLIdConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_clone")]
  public static extern global::System.IntPtr SBMLIdConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLIdConverter")]
  public static extern void delete_SBMLIdConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_matchesProperties")]
  public static extern bool SBMLIdConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_convert")]
  public static extern int SBMLIdConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLIdConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_init")]
  public static extern void SBMLInferUnitsConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLInferUnitsConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLInferUnitsConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLInferUnitsConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLInferUnitsConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLInferUnitsConverter")]
  public static extern void delete_SBMLInferUnitsConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_clone")]
  public static extern global::System.IntPtr SBMLInferUnitsConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_matchesProperties")]
  public static extern bool SBMLInferUnitsConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_convert")]
  public static extern int SBMLInferUnitsConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLInferUnitsConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_init")]
  public static extern void SBMLInitialAssignmentConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLInitialAssignmentConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLInitialAssignmentConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLInitialAssignmentConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLInitialAssignmentConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_clone")]
  public static extern global::System.IntPtr SBMLInitialAssignmentConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLInitialAssignmentConverter")]
  public static extern void delete_SBMLInitialAssignmentConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_matchesProperties")]
  public static extern bool SBMLInitialAssignmentConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_convert")]
  public static extern int SBMLInitialAssignmentConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLInitialAssignmentConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_init")]
  public static extern void SBMLLevelVersionConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLevelVersionConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLLevelVersionConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLevelVersionConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLLevelVersionConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLLevelVersionConverter")]
  public static extern void delete_SBMLLevelVersionConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_clone")]
  public static extern global::System.IntPtr SBMLLevelVersionConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_matchesProperties")]
  public static extern bool SBMLLevelVersionConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_convert")]
  public static extern int SBMLLevelVersionConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLLevelVersionConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_getTargetLevel")]
  public static extern uint SBMLLevelVersionConverter_getTargetLevel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_getTargetVersion")]
  public static extern uint SBMLLevelVersionConverter_getTargetVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_getValidityFlag")]
  public static extern bool SBMLLevelVersionConverter_getValidityFlag(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_getAddDefaultUnits")]
  public static extern bool SBMLLevelVersionConverter_getAddDefaultUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_init")]
  public static extern void SBMLLevel1Version1Converter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLevel1Version1Converter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLLevel1Version1Converter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLevel1Version1Converter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLLevel1Version1Converter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLLevel1Version1Converter")]
  public static extern void delete_SBMLLevel1Version1Converter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_clone")]
  public static extern global::System.IntPtr SBMLLevel1Version1Converter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_matchesProperties")]
  public static extern bool SBMLLevel1Version1Converter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_convert")]
  public static extern int SBMLLevel1Version1Converter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLLevel1Version1Converter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_init")]
  public static extern void SBMLLocalParameterConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLocalParameterConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLLocalParameterConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLLocalParameterConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLLocalParameterConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_clone")]
  public static extern global::System.IntPtr SBMLLocalParameterConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLLocalParameterConverter")]
  public static extern void delete_SBMLLocalParameterConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_matchesProperties")]
  public static extern bool SBMLLocalParameterConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_convert")]
  public static extern int SBMLLocalParameterConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLLocalParameterConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_init")]
  public static extern void SBMLReactionConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLReactionConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLReactionConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLReactionConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLReactionConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_clone")]
  public static extern global::System.IntPtr SBMLReactionConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLReactionConverter")]
  public static extern void delete_SBMLReactionConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_matchesProperties")]
  public static extern bool SBMLReactionConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_convert")]
  public static extern int SBMLReactionConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLReactionConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_setDocument")]
  public static extern int SBMLReactionConverter_setDocument(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_init")]
  public static extern void SBMLRuleConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLRuleConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLRuleConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLRuleConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLRuleConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_clone")]
  public static extern global::System.IntPtr SBMLRuleConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLRuleConverter")]
  public static extern void delete_SBMLRuleConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_matchesProperties")]
  public static extern bool SBMLRuleConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_convert")]
  public static extern int SBMLRuleConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLRuleConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_init")]
  public static extern void SBMLStripPackageConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLStripPackageConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLStripPackageConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLStripPackageConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLStripPackageConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLStripPackageConverter")]
  public static extern void delete_SBMLStripPackageConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_clone")]
  public static extern global::System.IntPtr SBMLStripPackageConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_matchesProperties")]
  public static extern bool SBMLStripPackageConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_convert")]
  public static extern int SBMLStripPackageConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLStripPackageConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_getPackageToStrip")]
  public static extern string SBMLStripPackageConverter_getPackageToStrip(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_isStripAllUnrecognizedPackages")]
  public static extern bool SBMLStripPackageConverter_isStripAllUnrecognizedPackages(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_init")]
  public static extern void SBMLUnitsConverter_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLUnitsConverter__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLUnitsConverter__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLUnitsConverter__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLUnitsConverter__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLUnitsConverter")]
  public static extern void delete_SBMLUnitsConverter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_clone")]
  public static extern global::System.IntPtr SBMLUnitsConverter_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_matchesProperties")]
  public static extern bool SBMLUnitsConverter_matchesProperties(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_convert")]
  public static extern int SBMLUnitsConverter_convert(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_getDefaultProperties")]
  public static extern global::System.IntPtr SBMLUnitsConverter_getDefaultProperties(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLValidator__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLValidator__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLValidator__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLValidator__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLValidator")]
  public static extern void delete_SBMLValidator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_clone")]
  public static extern global::System.IntPtr SBMLValidator_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_cloneSwigExplicitSBMLValidator")]
  public static extern global::System.IntPtr SBMLValidator_cloneSwigExplicitSBMLValidator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getDocument__SWIG_0")]
  public static extern global::System.IntPtr SBMLValidator_getDocument__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0")]
  public static extern global::System.IntPtr SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_1")]
  public static extern global::System.IntPtr SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_setDocument")]
  public static extern int SBMLValidator_setDocument(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_setDocumentSwigExplicitSBMLValidator")]
  public static extern int SBMLValidator_setDocumentSwigExplicitSBMLValidator(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_validate__SWIG_0")]
  public static extern uint SBMLValidator_validate__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0")]
  public static extern uint SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_clearFailures")]
  public static extern void SBMLValidator_clearFailures(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_clearFailuresSwigExplicitSBMLValidator")]
  public static extern void SBMLValidator_clearFailuresSwigExplicitSBMLValidator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_logFailure")]
  public static extern void SBMLValidator_logFailure(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_validate__SWIG_1")]
  public static extern uint SBMLValidator_validate__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_validate__SWIG_2")]
  public static extern uint SBMLValidator_validate__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getErrorLog")]
  public static extern global::System.IntPtr SBMLValidator_getErrorLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getModel__SWIG_0")]
  public static extern global::System.IntPtr SBMLValidator_getModel__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getNumFailures")]
  public static extern uint SBMLValidator_getNumFailures(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_getFailure")]
  public static extern global::System.IntPtr SBMLValidator_getFailure(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLValidator_director_connect")]
  public static extern void SBMLValidator_director_connect(global::System.Runtime.InteropServices.HandleRef jarg1, SBMLValidator.SwigDelegateSBMLValidator_0 delegate0, SBMLValidator.SwigDelegateSBMLValidator_1 delegate1, SBMLValidator.SwigDelegateSBMLValidator_2 delegate2, SBMLValidator.SwigDelegateSBMLValidator_3 delegate3, SBMLValidator.SwigDelegateSBMLValidator_4 delegate4, SBMLValidator.SwigDelegateSBMLValidator_5 delegate5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLExternalValidator__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLExternalValidator__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLExternalValidator__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLExternalValidator__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_clone")]
  public static extern global::System.IntPtr SBMLExternalValidator_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLExternalValidator")]
  public static extern void delete_SBMLExternalValidator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_validate")]
  public static extern uint SBMLExternalValidator_validate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_getProgram")]
  public static extern string SBMLExternalValidator_getProgram(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_setProgram")]
  public static extern void SBMLExternalValidator_setProgram(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_getOutputFileName")]
  public static extern string SBMLExternalValidator_getOutputFileName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_setOutputFileName")]
  public static extern void SBMLExternalValidator_setOutputFileName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_getSBMLFileName")]
  public static extern string SBMLExternalValidator_getSBMLFileName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_setSBMLFileName")]
  public static extern void SBMLExternalValidator_setSBMLFileName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_clearArguments")]
  public static extern void SBMLExternalValidator_clearArguments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_addArgument")]
  public static extern void SBMLExternalValidator_addArgument(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_getNumArguments")]
  public static extern uint SBMLExternalValidator_getNumArguments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_getArgument")]
  public static extern string SBMLExternalValidator_getArgument(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLAttributes__SWIG_0")]
  public static extern global::System.IntPtr new_XMLAttributes__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLAttributes")]
  public static extern void delete_XMLAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLAttributes__SWIG_1")]
  public static extern global::System.IntPtr new_XMLAttributes__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_clone")]
  public static extern global::System.IntPtr XMLAttributes_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_add__SWIG_0")]
  public static extern int XMLAttributes_add__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_add__SWIG_1")]
  public static extern int XMLAttributes_add__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_add__SWIG_2")]
  public static extern int XMLAttributes_add__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_add__SWIG_3")]
  public static extern int XMLAttributes_add__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_removeResource")]
  public static extern int XMLAttributes_removeResource(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_remove__SWIG_0")]
  public static extern int XMLAttributes_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_remove__SWIG_1")]
  public static extern int XMLAttributes_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_remove__SWIG_2")]
  public static extern int XMLAttributes_remove__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_remove__SWIG_3")]
  public static extern int XMLAttributes_remove__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_clear")]
  public static extern int XMLAttributes_clear(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getIndex__SWIG_0")]
  public static extern int XMLAttributes_getIndex__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getIndex__SWIG_1")]
  public static extern int XMLAttributes_getIndex__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getIndex__SWIG_2")]
  public static extern int XMLAttributes_getIndex__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getLength")]
  public static extern int XMLAttributes_getLength(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getNumAttributes")]
  public static extern int XMLAttributes_getNumAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getName")]
  public static extern string XMLAttributes_getName(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getPrefix")]
  public static extern string XMLAttributes_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getPrefixedName")]
  public static extern string XMLAttributes_getPrefixedName(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getURI")]
  public static extern string XMLAttributes_getURI(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getValue__SWIG_0")]
  public static extern string XMLAttributes_getValue__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getValue__SWIG_1")]
  public static extern string XMLAttributes_getValue__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getValue__SWIG_2")]
  public static extern string XMLAttributes_getValue__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_getValue__SWIG_3")]
  public static extern string XMLAttributes_getValue__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_hasAttribute__SWIG_0")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_hasAttribute__SWIG_1")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_hasAttribute__SWIG_2")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_hasAttribute__SWIG_3")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLAttributes_isEmpty")]
  public static extern bool XMLAttributes_isEmpty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLConstructorException")]
  public static extern global::System.IntPtr new_XMLConstructorException();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLConstructorException")]
  public static extern void delete_XMLConstructorException(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNamespaces__SWIG_0")]
  public static extern global::System.IntPtr new_XMLNamespaces__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLNamespaces")]
  public static extern void delete_XMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNamespaces__SWIG_1")]
  public static extern global::System.IntPtr new_XMLNamespaces__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_clone")]
  public static extern global::System.IntPtr XMLNamespaces_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_add__SWIG_0")]
  public static extern int XMLNamespaces_add__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_add__SWIG_1")]
  public static extern int XMLNamespaces_add__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_remove__SWIG_0")]
  public static extern int XMLNamespaces_remove__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_remove__SWIG_1")]
  public static extern int XMLNamespaces_remove__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_clear")]
  public static extern int XMLNamespaces_clear(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getIndex")]
  public static extern int XMLNamespaces_getIndex(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_containsUri")]
  public static extern bool XMLNamespaces_containsUri(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getIndexByPrefix")]
  public static extern int XMLNamespaces_getIndexByPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getLength")]
  public static extern int XMLNamespaces_getLength(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getNumNamespaces")]
  public static extern int XMLNamespaces_getNumNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getPrefix__SWIG_0")]
  public static extern string XMLNamespaces_getPrefix__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getPrefix__SWIG_1")]
  public static extern string XMLNamespaces_getPrefix__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getURI__SWIG_0")]
  public static extern string XMLNamespaces_getURI__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getURI__SWIG_1")]
  public static extern string XMLNamespaces_getURI__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_getURI__SWIG_2")]
  public static extern string XMLNamespaces_getURI__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_isEmpty")]
  public static extern bool XMLNamespaces_isEmpty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_hasURI")]
  public static extern bool XMLNamespaces_hasURI(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_hasPrefix")]
  public static extern bool XMLNamespaces_hasPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNamespaces_hasNS")]
  public static extern bool XMLNamespaces_hasNS(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_0")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_1")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_2")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_3")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_4")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_5")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_6")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_7")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_8")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_9")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_9(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_10")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_10(string jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_11")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_11(string jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_12")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_12(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLToken")]
  public static extern void delete_XMLToken(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLToken__SWIG_13")]
  public static extern global::System.IntPtr new_XMLToken__SWIG_13(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_clone")]
  public static extern global::System.IntPtr XMLToken_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttributes")]
  public static extern global::System.IntPtr XMLToken_getAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setAttributes")]
  public static extern int XMLToken_setAttributes(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addAttr__SWIG_0")]
  public static extern int XMLToken_addAttr__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addAttr__SWIG_1")]
  public static extern int XMLToken_addAttr__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addAttr__SWIG_2")]
  public static extern int XMLToken_addAttr__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addAttr__SWIG_3")]
  public static extern int XMLToken_addAttr__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeAttr__SWIG_0")]
  public static extern int XMLToken_removeAttr__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeAttr__SWIG_1")]
  public static extern int XMLToken_removeAttr__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeAttr__SWIG_2")]
  public static extern int XMLToken_removeAttr__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeAttr__SWIG_3")]
  public static extern int XMLToken_removeAttr__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_clearAttributes")]
  public static extern int XMLToken_clearAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrIndex__SWIG_0")]
  public static extern int XMLToken_getAttrIndex__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrIndex__SWIG_1")]
  public static extern int XMLToken_getAttrIndex__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrIndex__SWIG_2")]
  public static extern int XMLToken_getAttrIndex__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttributesLength")]
  public static extern int XMLToken_getAttributesLength(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrName")]
  public static extern string XMLToken_getAttrName(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrPrefix")]
  public static extern string XMLToken_getAttrPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrPrefixedName")]
  public static extern string XMLToken_getAttrPrefixedName(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrURI")]
  public static extern string XMLToken_getAttrURI(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrValue__SWIG_0")]
  public static extern string XMLToken_getAttrValue__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrValue__SWIG_1")]
  public static extern string XMLToken_getAttrValue__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrValue__SWIG_2")]
  public static extern string XMLToken_getAttrValue__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getAttrValue__SWIG_3")]
  public static extern string XMLToken_getAttrValue__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasAttr__SWIG_0")]
  public static extern bool XMLToken_hasAttr__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasAttr__SWIG_1")]
  public static extern bool XMLToken_hasAttr__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasAttr__SWIG_2")]
  public static extern bool XMLToken_hasAttr__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasAttr__SWIG_3")]
  public static extern bool XMLToken_hasAttr__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isAttributesEmpty")]
  public static extern bool XMLToken_isAttributesEmpty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaces")]
  public static extern global::System.IntPtr XMLToken_getNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setNamespaces")]
  public static extern int XMLToken_setNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addNamespace__SWIG_0")]
  public static extern int XMLToken_addNamespace__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_addNamespace__SWIG_1")]
  public static extern int XMLToken_addNamespace__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeNamespace__SWIG_0")]
  public static extern int XMLToken_removeNamespace__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_removeNamespace__SWIG_1")]
  public static extern int XMLToken_removeNamespace__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_clearNamespaces")]
  public static extern int XMLToken_clearNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaceIndex")]
  public static extern int XMLToken_getNamespaceIndex(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaceIndexByPrefix")]
  public static extern int XMLToken_getNamespaceIndexByPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespacesLength")]
  public static extern int XMLToken_getNamespacesLength(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespacePrefix__SWIG_0")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespacePrefix__SWIG_1")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaceURI__SWIG_0")]
  public static extern string XMLToken_getNamespaceURI__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaceURI__SWIG_1")]
  public static extern string XMLToken_getNamespaceURI__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getNamespaceURI__SWIG_2")]
  public static extern string XMLToken_getNamespaceURI__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isNamespacesEmpty")]
  public static extern bool XMLToken_isNamespacesEmpty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasNamespaceURI")]
  public static extern bool XMLToken_hasNamespaceURI(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasNamespacePrefix")]
  public static extern bool XMLToken_hasNamespacePrefix(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_hasNamespaceNS")]
  public static extern bool XMLToken_hasNamespaceNS(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setTriple")]
  public static extern int XMLToken_setTriple(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getName")]
  public static extern string XMLToken_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getPrefix")]
  public static extern string XMLToken_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getURI")]
  public static extern string XMLToken_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getCharacters")]
  public static extern string XMLToken_getCharacters(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setCharacters")]
  public static extern int XMLToken_setCharacters(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_append")]
  public static extern int XMLToken_append(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getColumn")]
  public static extern uint XMLToken_getColumn(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_getLine")]
  public static extern uint XMLToken_getLine(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isElement")]
  public static extern bool XMLToken_isElement(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isEnd")]
  public static extern bool XMLToken_isEnd(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isEndFor")]
  public static extern bool XMLToken_isEndFor(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isEOF")]
  public static extern bool XMLToken_isEOF(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isStart")]
  public static extern bool XMLToken_isStart(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_isText")]
  public static extern bool XMLToken_isText(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setEnd")]
  public static extern int XMLToken_setEnd(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_setEOF")]
  public static extern int XMLToken_setEOF(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_unsetEnd")]
  public static extern int XMLToken_unsetEnd(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLToken_toString")]
  public static extern string XMLToken_toString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_0")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_1")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_2")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_3")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_4")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_5")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_6")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_7")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_8")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_9")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_9(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_10")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_10(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_11")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_11(string jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_12")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_12(string jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_13")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_13(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_14")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_14(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLNode")]
  public static extern void delete_XMLNode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLNode__SWIG_15")]
  public static extern global::System.IntPtr new_XMLNode__SWIG_15(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_clone")]
  public static extern global::System.IntPtr XMLNode_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_addChild")]
  public static extern int XMLNode_addChild(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_insertChild")]
  public static extern global::System.IntPtr XMLNode_insertChild(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_removeChild")]
  public static extern global::System.IntPtr XMLNode_removeChild(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_removeChildren")]
  public static extern int XMLNode_removeChildren(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_getChild__SWIG_0")]
  public static extern global::System.IntPtr XMLNode_getChild__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_getChild__SWIG_2")]
  public static extern global::System.IntPtr XMLNode_getChild__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_getIndex")]
  public static extern int XMLNode_getIndex(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_hasChild")]
  public static extern bool XMLNode_hasChild(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_equals__SWIG_0")]
  public static extern bool XMLNode_equals__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_equals__SWIG_1")]
  public static extern bool XMLNode_equals__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_equals__SWIG_2")]
  public static extern bool XMLNode_equals__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_getNumChildren")]
  public static extern uint XMLNode_getNumChildren(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_writeToStream")]
  public static extern void XMLNode_writeToStream(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_toXMLString")]
  public static extern string XMLNode_toXMLString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_convertXMLNodeToString")]
  public static extern string XMLNode_convertXMLNodeToString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_convertStringToXMLNode__SWIG_0")]
  public static extern global::System.IntPtr XMLNode_convertStringToXMLNode__SWIG_0(string jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_convertStringToXMLNode__SWIG_1")]
  public static extern global::System.IntPtr XMLNode_convertStringToXMLNode__SWIG_1(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLTriple__SWIG_0")]
  public static extern global::System.IntPtr new_XMLTriple__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLTriple__SWIG_1")]
  public static extern global::System.IntPtr new_XMLTriple__SWIG_1(string jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLTriple__SWIG_2")]
  public static extern global::System.IntPtr new_XMLTriple__SWIG_2(string jarg1, char jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLTriple__SWIG_3")]
  public static extern global::System.IntPtr new_XMLTriple__SWIG_3(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLTriple__SWIG_4")]
  public static extern global::System.IntPtr new_XMLTriple__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_clone")]
  public static extern global::System.IntPtr XMLTriple_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_getName")]
  public static extern string XMLTriple_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_getPrefix")]
  public static extern string XMLTriple_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_getURI")]
  public static extern string XMLTriple_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_getPrefixedName")]
  public static extern string XMLTriple_getPrefixedName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLTriple_isEmpty")]
  public static extern bool XMLTriple_isEmpty(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLTriple")]
  public static extern void delete_XMLTriple(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOutputStream__SWIG_0")]
  public static extern global::System.IntPtr new_XMLOutputStream__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3, string jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOutputStream__SWIG_1")]
  public static extern global::System.IntPtr new_XMLOutputStream__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOutputStream__SWIG_2")]
  public static extern global::System.IntPtr new_XMLOutputStream__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOutputStream__SWIG_3")]
  public static extern global::System.IntPtr new_XMLOutputStream__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOutputStream__SWIG_4")]
  public static extern global::System.IntPtr new_XMLOutputStream__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLOutputStream")]
  public static extern void delete_XMLOutputStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_endElement__SWIG_0")]
  public static extern void XMLOutputStream_endElement__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_endElement__SWIG_1")]
  public static extern void XMLOutputStream_endElement__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_endElement__SWIG_2")]
  public static extern void XMLOutputStream_endElement__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_endElement__SWIG_3")]
  public static extern void XMLOutputStream_endElement__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setAutoIndent")]
  public static extern void XMLOutputStream_setAutoIndent(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startElement__SWIG_0")]
  public static extern void XMLOutputStream_startElement__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startElement__SWIG_1")]
  public static extern void XMLOutputStream_startElement__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startElement__SWIG_2")]
  public static extern void XMLOutputStream_startElement__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startEndElement__SWIG_0")]
  public static extern void XMLOutputStream_startEndElement__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startEndElement__SWIG_1")]
  public static extern void XMLOutputStream_startEndElement__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_startEndElement__SWIG_2")]
  public static extern void XMLOutputStream_startEndElement__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_0")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_1")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_2")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_6")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_7")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_8")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_9")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_9(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_10")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_10(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, double jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_11")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_11(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, double jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_12")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_12(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_13")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_13(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_14")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_14(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeAttribute__SWIG_18")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_18(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeXMLDecl")]
  public static extern void XMLOutputStream_writeXMLDecl(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeComment__SWIG_0")]
  public static extern void XMLOutputStream_writeComment__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_writeComment__SWIG_1")]
  public static extern void XMLOutputStream_writeComment__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_downIndent")]
  public static extern void XMLOutputStream_downIndent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_upIndent")]
  public static extern void XMLOutputStream_upIndent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getSBMLNamespaces")]
  public static extern global::System.IntPtr XMLOutputStream_getSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setSBMLNamespaces")]
  public static extern void XMLOutputStream_setSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getWriteComment")]
  public static extern bool XMLOutputStream_getWriteComment();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setWriteComment")]
  public static extern void XMLOutputStream_setWriteComment(bool jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getWriteTimestamp")]
  public static extern bool XMLOutputStream_getWriteTimestamp();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setWriteTimestamp")]
  public static extern void XMLOutputStream_setWriteTimestamp(bool jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getLibraryName")]
  public static extern string XMLOutputStream_getLibraryName();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setLibraryName")]
  public static extern void XMLOutputStream_setLibraryName(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getLibraryVersion")]
  public static extern string XMLOutputStream_getLibraryVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setLibraryVersion")]
  public static extern void XMLOutputStream_setLibraryVersion(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_getIndent")]
  public static extern uint XMLOutputStream_getIndent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLOutputStream_setIndent")]
  public static extern void XMLOutputStream_setIndent(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputStringStream__SWIG_0")]
  public static extern global::System.IntPtr new_XMLOwningOutputStringStream__SWIG_0(string jarg1, bool jarg2, string jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputStringStream__SWIG_1")]
  public static extern global::System.IntPtr new_XMLOwningOutputStringStream__SWIG_1(string jarg1, bool jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputStringStream__SWIG_2")]
  public static extern global::System.IntPtr new_XMLOwningOutputStringStream__SWIG_2(string jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputStringStream__SWIG_3")]
  public static extern global::System.IntPtr new_XMLOwningOutputStringStream__SWIG_3(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputStringStream__SWIG_4")]
  public static extern global::System.IntPtr new_XMLOwningOutputStringStream__SWIG_4();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLOwningOutputStringStream")]
  public static extern void delete_XMLOwningOutputStringStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputFileStream__SWIG_0")]
  public static extern global::System.IntPtr new_XMLOwningOutputFileStream__SWIG_0(string jarg1, string jarg2, bool jarg3, string jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputFileStream__SWIG_1")]
  public static extern global::System.IntPtr new_XMLOwningOutputFileStream__SWIG_1(string jarg1, string jarg2, bool jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputFileStream__SWIG_2")]
  public static extern global::System.IntPtr new_XMLOwningOutputFileStream__SWIG_2(string jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputFileStream__SWIG_3")]
  public static extern global::System.IntPtr new_XMLOwningOutputFileStream__SWIG_3(string jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLOwningOutputFileStream__SWIG_4")]
  public static extern global::System.IntPtr new_XMLOwningOutputFileStream__SWIG_4(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLOwningOutputFileStream")]
  public static extern void delete_XMLOwningOutputFileStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLInputStream__SWIG_0")]
  public static extern global::System.IntPtr new_XMLInputStream__SWIG_0(string jarg1, bool jarg2, string jarg3, global::System.Runtime.InteropServices.HandleRef jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLInputStream__SWIG_1")]
  public static extern global::System.IntPtr new_XMLInputStream__SWIG_1(string jarg1, bool jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLInputStream__SWIG_2")]
  public static extern global::System.IntPtr new_XMLInputStream__SWIG_2(string jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLInputStream__SWIG_3")]
  public static extern global::System.IntPtr new_XMLInputStream__SWIG_3(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLInputStream")]
  public static extern void delete_XMLInputStream(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_getEncoding")]
  public static extern string XMLInputStream_getEncoding(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_getVersion")]
  public static extern string XMLInputStream_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_getErrorLog")]
  public static extern global::System.IntPtr XMLInputStream_getErrorLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_isEOF")]
  public static extern bool XMLInputStream_isEOF(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_isError")]
  public static extern bool XMLInputStream_isError(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_isGood")]
  public static extern bool XMLInputStream_isGood(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_next")]
  public static extern global::System.IntPtr XMLInputStream_next(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_peek")]
  public static extern global::System.IntPtr XMLInputStream_peek(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_skipPastEnd")]
  public static extern void XMLInputStream_skipPastEnd(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_skipText")]
  public static extern void XMLInputStream_skipText(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_setErrorLog")]
  public static extern int XMLInputStream_setErrorLog(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_toString")]
  public static extern string XMLInputStream_toString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_getSBMLNamespaces")]
  public static extern global::System.IntPtr XMLInputStream_getSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_setSBMLNamespaces")]
  public static extern void XMLInputStream_setSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_determineNumberChildren__SWIG_0")]
  public static extern uint XMLInputStream_determineNumberChildren__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_determineNumberChildren__SWIG_1")]
  public static extern uint XMLInputStream_determineNumberChildren__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_determineNumSpecificChildren")]
  public static extern uint XMLInputStream_determineNumSpecificChildren(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLInputStream_containsChild")]
  public static extern bool XMLInputStream_containsChild(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_0")]
  public static extern global::System.IntPtr new_XMLError__SWIG_0(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_1")]
  public static extern global::System.IntPtr new_XMLError__SWIG_1(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_2")]
  public static extern global::System.IntPtr new_XMLError__SWIG_2(int jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_3")]
  public static extern global::System.IntPtr new_XMLError__SWIG_3(int jarg1, string jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_4")]
  public static extern global::System.IntPtr new_XMLError__SWIG_4(int jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_5")]
  public static extern global::System.IntPtr new_XMLError__SWIG_5(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_6")]
  public static extern global::System.IntPtr new_XMLError__SWIG_6();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLError__SWIG_7")]
  public static extern global::System.IntPtr new_XMLError__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLError")]
  public static extern void delete_XMLError(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getErrorId")]
  public static extern uint XMLError_getErrorId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getMessage")]
  public static extern string XMLError_getMessage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getShortMessage")]
  public static extern string XMLError_getShortMessage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getLine")]
  public static extern uint XMLError_getLine(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getColumn")]
  public static extern uint XMLError_getColumn(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getSeverity")]
  public static extern uint XMLError_getSeverity(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getSeverityAsString")]
  public static extern string XMLError_getSeverityAsString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getCategory")]
  public static extern uint XMLError_getCategory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getCategoryAsString")]
  public static extern string XMLError_getCategoryAsString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isInfo")]
  public static extern bool XMLError_isInfo(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isWarning")]
  public static extern bool XMLError_isWarning(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isError")]
  public static extern bool XMLError_isError(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isFatal")]
  public static extern bool XMLError_isFatal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isInternal")]
  public static extern bool XMLError_isInternal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isSystem")]
  public static extern bool XMLError_isSystem(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isXML")]
  public static extern bool XMLError_isXML(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_isValid")]
  public static extern bool XMLError_isValid(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_setLine")]
  public static extern int XMLError_setLine(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_setColumn")]
  public static extern int XMLError_setColumn(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getStandardMessage")]
  public static extern string XMLError_getStandardMessage(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getPackage")]
  public static extern string XMLError_getPackage(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLError_getErrorIdOffset")]
  public static extern uint XMLError_getErrorIdOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_getNumErrors")]
  public static extern uint XMLErrorLog_getNumErrors(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_getError")]
  public static extern global::System.IntPtr XMLErrorLog_getError(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_clearLog")]
  public static extern void XMLErrorLog_clearLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLErrorLog__SWIG_0")]
  public static extern global::System.IntPtr new_XMLErrorLog__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_XMLErrorLog__SWIG_1")]
  public static extern global::System.IntPtr new_XMLErrorLog__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_XMLErrorLog")]
  public static extern void delete_XMLErrorLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_add__SWIG_0")]
  public static extern void XMLErrorLog_add__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_add__SWIG_1")]
  public static extern void XMLErrorLog_add__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_toString")]
  public static extern string XMLErrorLog_toString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_printErrors__SWIG_0")]
  public static extern void XMLErrorLog_printErrors__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_printErrors__SWIG_1")]
  public static extern void XMLErrorLog_printErrors__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_printErrors__SWIG_2")]
  public static extern void XMLErrorLog_printErrors__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_isSeverityOverridden")]
  public static extern bool XMLErrorLog_isSeverityOverridden(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_unsetSeverityOverride")]
  public static extern void XMLErrorLog_unsetSeverityOverride(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_getSeverityOverride")]
  public static extern int XMLErrorLog_getSeverityOverride(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_setSeverityOverride")]
  public static extern void XMLErrorLog_setSeverityOverride(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_changeErrorSeverity__SWIG_0")]
  public static extern void XMLErrorLog_changeErrorSeverity__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, int jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_changeErrorSeverity__SWIG_1")]
  public static extern void XMLErrorLog_changeErrorSeverity__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLErrorLog_contains")]
  public static extern bool XMLErrorLog_contains(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_getError")]
  public static extern global::System.IntPtr SBMLErrorLog_getError(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_getErrorWithSeverity")]
  public static extern global::System.IntPtr SBMLErrorLog_getErrorWithSeverity(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_getNumFailsWithSeverity__SWIG_0")]
  public static extern uint SBMLErrorLog_getNumFailsWithSeverity__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLErrorLog__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLErrorLog__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLErrorLog__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLErrorLog__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLErrorLog")]
  public static extern void delete_SBMLErrorLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_0")]
  public static extern void SBMLErrorLog_logError__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_1")]
  public static extern void SBMLErrorLog_logError__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_2")]
  public static extern void SBMLErrorLog_logError__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_3")]
  public static extern void SBMLErrorLog_logError__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_4")]
  public static extern void SBMLErrorLog_logError__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_5")]
  public static extern void SBMLErrorLog_logError__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_6")]
  public static extern void SBMLErrorLog_logError__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_7")]
  public static extern void SBMLErrorLog_logError__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logError__SWIG_8")]
  public static extern void SBMLErrorLog_logError__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_0")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9, long jarg10, long jarg11);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_1")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9, long jarg10);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_2")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_3")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_4")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_5")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_6")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_7")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_7(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_8")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_8(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_9")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_9(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_logPackageError__SWIG_10")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_10(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_add")]
  public static extern void SBMLErrorLog_add(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_remove")]
  public static extern void SBMLErrorLog_remove(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_removeAll")]
  public static extern void SBMLErrorLog_removeAll(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_contains")]
  public static extern bool SBMLErrorLog_contains(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_0(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8, string jarg9, long jarg10);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_1(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8, string jarg9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_2")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_2(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_3")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_3(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_4")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_4(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_5")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_5(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_6")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_6(long jarg1, long jarg2, long jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_7")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_7(long jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_8")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_8(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_9")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_9(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_10")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_10();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLError__SWIG_11")]
  public static extern global::System.IntPtr new_SBMLError__SWIG_11(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLError")]
  public static extern void delete_SBMLError(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CVTerm__SWIG_0")]
  public static extern global::System.IntPtr new_CVTerm__SWIG_0(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CVTerm__SWIG_1")]
  public static extern global::System.IntPtr new_CVTerm__SWIG_1();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CVTerm__SWIG_2")]
  public static extern global::System.IntPtr new_CVTerm__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_CVTerm")]
  public static extern void delete_CVTerm(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_CVTerm__SWIG_3")]
  public static extern global::System.IntPtr new_CVTerm__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_clone")]
  public static extern global::System.IntPtr CVTerm_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getQualifierType__SWIG_0")]
  public static extern int CVTerm_getQualifierType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getModelQualifierType__SWIG_0")]
  public static extern int CVTerm_getModelQualifierType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getBiologicalQualifierType__SWIG_0")]
  public static extern int CVTerm_getBiologicalQualifierType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getResources__SWIG_0")]
  public static extern global::System.IntPtr CVTerm_getResources__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getNumResources__SWIG_0")]
  public static extern uint CVTerm_getNumResources__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getResourceURI__SWIG_0")]
  public static extern string CVTerm_getResourceURI__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_setQualifierType")]
  public static extern int CVTerm_setQualifierType(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_setModelQualifierType__SWIG_0")]
  public static extern int CVTerm_setModelQualifierType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_setBiologicalQualifierType__SWIG_0")]
  public static extern int CVTerm_setBiologicalQualifierType__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_setModelQualifierType__SWIG_1")]
  public static extern int CVTerm_setModelQualifierType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_setBiologicalQualifierType__SWIG_1")]
  public static extern int CVTerm_setBiologicalQualifierType__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_addResource")]
  public static extern int CVTerm_addResource(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_removeResource")]
  public static extern int CVTerm_removeResource(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_hasRequiredAttributes__SWIG_0")]
  public static extern bool CVTerm_hasRequiredAttributes__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_hasBeenModified")]
  public static extern bool CVTerm_hasBeenModified(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_resetModifiedFlags")]
  public static extern void CVTerm_resetModifiedFlags(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getNumNestedCVTerms")]
  public static extern uint CVTerm_getNumNestedCVTerms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getNestedCVTerm__SWIG_0")]
  public static extern global::System.IntPtr CVTerm_getNestedCVTerm__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_getListNestedCVTerms__SWIG_0")]
  public static extern global::System.IntPtr CVTerm_getListNestedCVTerms__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_addNestedCVTerm")]
  public static extern int CVTerm_addNestedCVTerm(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CVTerm_removeNestedCVTerm")]
  public static extern global::System.IntPtr CVTerm_removeNestedCVTerm(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelQualifierType_toString")]
  public static extern string ModelQualifierType_toString(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_BiolQualifierType_toString")]
  public static extern string BiolQualifierType_toString(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelQualifierType_fromString")]
  public static extern int ModelQualifierType_fromString(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_BiolQualifierType_fromString")]
  public static extern int BiolQualifierType_fromString(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_0")]
  public static extern global::System.IntPtr new_Date__SWIG_0(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_1")]
  public static extern global::System.IntPtr new_Date__SWIG_1(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_2")]
  public static extern global::System.IntPtr new_Date__SWIG_2(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_3")]
  public static extern global::System.IntPtr new_Date__SWIG_3(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_4")]
  public static extern global::System.IntPtr new_Date__SWIG_4(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_5")]
  public static extern global::System.IntPtr new_Date__SWIG_5(long jarg1, long jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_6")]
  public static extern global::System.IntPtr new_Date__SWIG_6(long jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_7")]
  public static extern global::System.IntPtr new_Date__SWIG_7(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_8")]
  public static extern global::System.IntPtr new_Date__SWIG_8(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_9")]
  public static extern global::System.IntPtr new_Date__SWIG_9();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_10")]
  public static extern global::System.IntPtr new_Date__SWIG_10(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_Date")]
  public static extern void delete_Date(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_Date__SWIG_11")]
  public static extern global::System.IntPtr new_Date__SWIG_11(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_clone")]
  public static extern global::System.IntPtr Date_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getYear")]
  public static extern uint Date_getYear(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getMonth")]
  public static extern uint Date_getMonth(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getDay")]
  public static extern uint Date_getDay(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getHour")]
  public static extern uint Date_getHour(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getMinute")]
  public static extern uint Date_getMinute(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getSecond")]
  public static extern uint Date_getSecond(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getSignOffset")]
  public static extern uint Date_getSignOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getHoursOffset")]
  public static extern uint Date_getHoursOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getMinutesOffset")]
  public static extern uint Date_getMinutesOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_getDateAsString")]
  public static extern string Date_getDateAsString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setYear")]
  public static extern int Date_setYear(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setMonth")]
  public static extern int Date_setMonth(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setDay")]
  public static extern int Date_setDay(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setHour")]
  public static extern int Date_setHour(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setMinute")]
  public static extern int Date_setMinute(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setSecond")]
  public static extern int Date_setSecond(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setSignOffset")]
  public static extern int Date_setSignOffset(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setHoursOffset")]
  public static extern int Date_setHoursOffset(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setMinutesOffset")]
  public static extern int Date_setMinutesOffset(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_setDateAsString")]
  public static extern int Date_setDateAsString(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_representsValidDate")]
  public static extern bool Date_representsValidDate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_hasBeenModified")]
  public static extern bool Date_hasBeenModified(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Date_resetModifiedFlags")]
  public static extern void Date_resetModifiedFlags(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelCreator__SWIG_0")]
  public static extern global::System.IntPtr new_ModelCreator__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelCreator__SWIG_1")]
  public static extern global::System.IntPtr new_ModelCreator__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ModelCreator")]
  public static extern void delete_ModelCreator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelCreator__SWIG_2")]
  public static extern global::System.IntPtr new_ModelCreator__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_clone")]
  public static extern global::System.IntPtr ModelCreator_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getFamilyName")]
  public static extern string ModelCreator_getFamilyName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getGivenName")]
  public static extern string ModelCreator_getGivenName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getEmail")]
  public static extern string ModelCreator_getEmail(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getOrganization")]
  public static extern string ModelCreator_getOrganization(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getOrganisation")]
  public static extern string ModelCreator_getOrganisation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_getName")]
  public static extern string ModelCreator_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetFamilyName")]
  public static extern bool ModelCreator_isSetFamilyName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetGivenName")]
  public static extern bool ModelCreator_isSetGivenName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetEmail")]
  public static extern bool ModelCreator_isSetEmail(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetOrganization")]
  public static extern bool ModelCreator_isSetOrganization(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetOrganisation")]
  public static extern bool ModelCreator_isSetOrganisation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_isSetName")]
  public static extern bool ModelCreator_isSetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setFamilyName")]
  public static extern int ModelCreator_setFamilyName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setGivenName")]
  public static extern int ModelCreator_setGivenName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setEmail")]
  public static extern int ModelCreator_setEmail(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setOrganization")]
  public static extern int ModelCreator_setOrganization(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setOrganisation")]
  public static extern int ModelCreator_setOrganisation(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setName")]
  public static extern int ModelCreator_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetFamilyName")]
  public static extern int ModelCreator_unsetFamilyName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetGivenName")]
  public static extern int ModelCreator_unsetGivenName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetEmail")]
  public static extern int ModelCreator_unsetEmail(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetOrganization")]
  public static extern int ModelCreator_unsetOrganization(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetOrganisation")]
  public static extern int ModelCreator_unsetOrganisation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_unsetName")]
  public static extern int ModelCreator_unsetName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_hasRequiredAttributes")]
  public static extern bool ModelCreator_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_hasBeenModified")]
  public static extern bool ModelCreator_hasBeenModified(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_resetModifiedFlags")]
  public static extern void ModelCreator_resetModifiedFlags(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_usingFNVcard4")]
  public static extern bool ModelCreator_usingFNVcard4(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_usingSingleName")]
  public static extern bool ModelCreator_usingSingleName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelCreator_setUseSingleName")]
  public static extern void ModelCreator_setUseSingleName(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelHistory__SWIG_0")]
  public static extern global::System.IntPtr new_ModelHistory__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ModelHistory")]
  public static extern void delete_ModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ModelHistory__SWIG_1")]
  public static extern global::System.IntPtr new_ModelHistory__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_clone")]
  public static extern global::System.IntPtr ModelHistory_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getCreatedDate")]
  public static extern global::System.IntPtr ModelHistory_getCreatedDate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getModifiedDate__SWIG_0")]
  public static extern global::System.IntPtr ModelHistory_getModifiedDate__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_isSetCreatedDate")]
  public static extern bool ModelHistory_isSetCreatedDate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_isSetModifiedDate")]
  public static extern bool ModelHistory_isSetModifiedDate(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_setCreatedDate")]
  public static extern int ModelHistory_setCreatedDate(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_setModifiedDate")]
  public static extern int ModelHistory_setModifiedDate(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_addModifiedDate")]
  public static extern int ModelHistory_addModifiedDate(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getListModifiedDates")]
  public static extern global::System.IntPtr ModelHistory_getListModifiedDates(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getModifiedDate__SWIG_1")]
  public static extern global::System.IntPtr ModelHistory_getModifiedDate__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getNumModifiedDates")]
  public static extern uint ModelHistory_getNumModifiedDates(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_addCreator")]
  public static extern int ModelHistory_addCreator(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getListCreators")]
  public static extern global::System.IntPtr ModelHistory_getListCreators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getCreator")]
  public static extern global::System.IntPtr ModelHistory_getCreator(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_getNumCreators")]
  public static extern uint ModelHistory_getNumCreators(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_hasRequiredAttributes")]
  public static extern bool ModelHistory_hasRequiredAttributes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_hasBeenModified")]
  public static extern bool ModelHistory_hasBeenModified(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModelHistory_resetModifiedFlags")]
  public static extern void ModelHistory_resetModifiedFlags(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_0")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_1")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_2")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_createAnnotation")]
  public static extern global::System.IntPtr RDFAnnotationParser_createAnnotation();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_createRDFAnnotation__SWIG_0")]
  public static extern global::System.IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_0(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_createRDFAnnotation__SWIG_1")]
  public static extern global::System.IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_1(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_createRDFAnnotation__SWIG_2")]
  public static extern global::System.IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_createCVTerms")]
  public static extern global::System.IntPtr RDFAnnotationParser_createCVTerms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseCVTerms")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseCVTerms(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseModelHistory")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseOnlyModelHistory")]
  public static extern global::System.IntPtr RDFAnnotationParser_parseOnlyModelHistory(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_deleteRDFAnnotation")]
  public static extern global::System.IntPtr RDFAnnotationParser_deleteRDFAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_deleteRDFHistoryAnnotation")]
  public static extern global::System.IntPtr RDFAnnotationParser_deleteRDFHistoryAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_deleteRDFCVTermAnnotation")]
  public static extern global::System.IntPtr RDFAnnotationParser_deleteRDFCVTermAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_3")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_4")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3, global::System.Runtime.InteropServices.HandleRef jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RDFAnnotationParser_parseRDFAnnotation__SWIG_5")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_RDFAnnotationParser")]
  public static extern global::System.IntPtr new_RDFAnnotationParser();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_RDFAnnotationParser")]
  public static extern void delete_RDFAnnotationParser(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ISBMLExtensionNamespaces")]
  public static extern void delete_ISBMLExtensionNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ISBMLExtensionNamespaces_getURI")]
  public static extern string ISBMLExtensionNamespaces_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ISBMLExtensionNamespaces_getPackageVersion")]
  public static extern uint ISBMLExtensionNamespaces_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ISBMLExtensionNamespaces_getPackageName")]
  public static extern string ISBMLExtensionNamespaces_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ISBMLExtensionNamespaces_setPackageVersion")]
  public static extern void ISBMLExtensionNamespaces_setPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBaseExtensionPoint__SWIG_0")]
  public static extern global::System.IntPtr new_SBaseExtensionPoint__SWIG_0(string jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBaseExtensionPoint__SWIG_1")]
  public static extern global::System.IntPtr new_SBaseExtensionPoint__SWIG_1(string jarg1, int jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBaseExtensionPoint__SWIG_2")]
  public static extern global::System.IntPtr new_SBaseExtensionPoint__SWIG_2(string jarg1, int jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBaseExtensionPoint")]
  public static extern void delete_SBaseExtensionPoint(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBaseExtensionPoint__SWIG_3")]
  public static extern global::System.IntPtr new_SBaseExtensionPoint__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseExtensionPoint_clone")]
  public static extern global::System.IntPtr SBaseExtensionPoint_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseExtensionPoint_getPackageName")]
  public static extern string SBaseExtensionPoint_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseExtensionPoint_getTypeCode")]
  public static extern int SBaseExtensionPoint_getTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseExtensionPoint_getElementName")]
  public static extern string SBaseExtensionPoint_getElementName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBaseExtensionPoint_isElementOnly")]
  public static extern bool SBaseExtensionPoint_isElementOnly(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBasePlugin")]
  public static extern void delete_SBasePlugin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getElementNamespace")]
  public static extern string SBasePlugin_getElementNamespace(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getPrefix")]
  public static extern string SBasePlugin_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getPackageName")]
  public static extern string SBasePlugin_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_clone")]
  public static extern global::System.IntPtr SBasePlugin_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getElementBySId")]
  public static extern global::System.IntPtr SBasePlugin_getElementBySId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getElementByMetaId")]
  public static extern global::System.IntPtr SBasePlugin_getElementByMetaId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_connectToParent")]
  public static extern void SBasePlugin_connectToParent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_enablePackageInternal")]
  public static extern void SBasePlugin_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_stripPackage")]
  public static extern bool SBasePlugin_stripPackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getSBMLDocument__SWIG_0")]
  public static extern global::System.IntPtr SBasePlugin_getSBMLDocument__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getURI")]
  public static extern string SBasePlugin_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getParentSBMLObject__SWIG_0")]
  public static extern global::System.IntPtr SBasePlugin_getParentSBMLObject__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_setElementNamespace")]
  public static extern int SBasePlugin_setElementNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getLevel")]
  public static extern uint SBasePlugin_getLevel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getVersion")]
  public static extern uint SBasePlugin_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getPackageVersion")]
  public static extern uint SBasePlugin_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_replaceSIDWithFunction")]
  public static extern void SBasePlugin_replaceSIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_divideAssignmentsToSIdByFunction")]
  public static extern void SBasePlugin_divideAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_multiplyAssignmentsToSIdByFunction")]
  public static extern void SBasePlugin_multiplyAssignmentsToSIdByFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_hasIdentifierBeginningWith")]
  public static extern bool SBasePlugin_hasIdentifierBeginningWith(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_prependStringToAllIdentifiers")]
  public static extern int SBasePlugin_prependStringToAllIdentifiers(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_renameSIdRefs")]
  public static extern void SBasePlugin_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_renameMetaIdRefs")]
  public static extern void SBasePlugin_renameMetaIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_renameUnitSIdRefs")]
  public static extern void SBasePlugin_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_transformIdentifiers")]
  public static extern int SBasePlugin_transformIdentifiers(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getLine")]
  public static extern uint SBasePlugin_getLine(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getColumn")]
  public static extern uint SBasePlugin_getColumn(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getSBMLNamespaces")]
  public static extern global::System.IntPtr SBasePlugin_getSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_logUnknownElement")]
  public static extern void SBasePlugin_logUnknownElement(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_isValidTypeForList")]
  public static extern bool SBasePlugin_isValidTypeForList(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getSBMLExtension")]
  public static extern global::System.IntPtr SBasePlugin_getSBMLExtension(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_updateSBMLNamespace")]
  public static extern void SBasePlugin_updateSBMLNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getListOfAllElements__SWIG_0")]
  public static extern global::System.IntPtr SBasePlugin_getListOfAllElements__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBasePlugin_getListOfAllElements__SWIG_1")]
  public static extern global::System.IntPtr SBasePlugin_getListOfAllElements__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocumentPlugin__SWIG_0")]
  public static extern global::System.IntPtr new_SBMLDocumentPlugin__SWIG_0(string jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLDocumentPlugin__SWIG_1")]
  public static extern global::System.IntPtr new_SBMLDocumentPlugin__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLDocumentPlugin")]
  public static extern void delete_SBMLDocumentPlugin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_clone")]
  public static extern global::System.IntPtr SBMLDocumentPlugin_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_setRequired")]
  public static extern int SBMLDocumentPlugin_setRequired(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_getRequired")]
  public static extern bool SBMLDocumentPlugin_getRequired(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_isSetRequired")]
  public static extern bool SBMLDocumentPlugin_isSetRequired(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_unsetRequired")]
  public static extern int SBMLDocumentPlugin_unsetRequired(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_isCompFlatteningImplemented")]
  public static extern bool SBMLDocumentPlugin_isCompFlatteningImplemented(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_checkConsistency")]
  public static extern uint SBMLDocumentPlugin_checkConsistency(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLExtension")]
  public static extern void delete_SBMLExtension(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getNumOfSBasePlugins")]
  public static extern int SBMLExtension_getNumOfSBasePlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getNumOfSupportedPackageURI")]
  public static extern uint SBMLExtension_getNumOfSupportedPackageURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_isSupported")]
  public static extern bool SBMLExtension_isSupported(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getSupportedPackageURI")]
  public static extern string SBMLExtension_getSupportedPackageURI(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_clone")]
  public static extern global::System.IntPtr SBMLExtension_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getName")]
  public static extern string SBMLExtension_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getURI")]
  public static extern string SBMLExtension_getURI(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getLevel")]
  public static extern uint SBMLExtension_getLevel(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getVersion")]
  public static extern uint SBMLExtension_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getPackageVersion")]
  public static extern uint SBMLExtension_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getStringFromTypeCode")]
  public static extern string SBMLExtension_getStringFromTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getSBMLExtensionNamespaces")]
  public static extern global::System.IntPtr SBMLExtension_getSBMLExtensionNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_setEnabled")]
  public static extern bool SBMLExtension_setEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_isEnabled")]
  public static extern bool SBMLExtension_isEnabled(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_removeL2Namespaces")]
  public static extern void SBMLExtension_removeL2Namespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_addL2Namespaces")]
  public static extern void SBMLExtension_addL2Namespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_enableL2NamespaceForDocument")]
  public static extern void SBMLExtension_enableL2NamespaceForDocument(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_isInUse")]
  public static extern bool SBMLExtension_isInUse(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_hasMutiplePackageVersions")]
  public static extern bool SBMLExtension_hasMutiplePackageVersions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getErrorTableIndex")]
  public static extern uint SBMLExtension_getErrorTableIndex(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getErrorIdOffset")]
  public static extern uint SBMLExtension_getErrorIdOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getSeverity")]
  public static extern uint SBMLExtension_getSeverity(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getCategory")]
  public static extern uint SBMLExtension_getCategory(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getMessage")]
  public static extern string SBMLExtension_getMessage(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtension_getShortMessage")]
  public static extern string SBMLExtension_getShortMessage(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_SBMLExtensionException")]
  public static extern global::System.IntPtr new_SBMLExtensionException(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_SBMLExtensionException")]
  public static extern void delete_SBMLExtensionException(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getInstance")]
  public static extern global::System.IntPtr SBMLExtensionRegistry_getInstance();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_addExtension")]
  public static extern int SBMLExtensionRegistry_addExtension(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getExtension")]
  public static extern global::System.IntPtr SBMLExtensionRegistry_getExtension(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_removeL2Namespaces")]
  public static extern void SBMLExtensionRegistry_removeL2Namespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_addL2Namespaces")]
  public static extern void SBMLExtensionRegistry_addL2Namespaces(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_enableL2NamespaceForDocument")]
  public static extern void SBMLExtensionRegistry_enableL2NamespaceForDocument(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_disableUnusedPackages")]
  public static extern void SBMLExtensionRegistry_disableUnusedPackages(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_disablePackage")]
  public static extern void SBMLExtensionRegistry_disablePackage(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_isPackageEnabled")]
  public static extern bool SBMLExtensionRegistry_isPackageEnabled(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_enablePackage")]
  public static extern void SBMLExtensionRegistry_enablePackage(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getNumExtension")]
  public static extern uint SBMLExtensionRegistry_getNumExtension(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_setEnabled")]
  public static extern bool SBMLExtensionRegistry_setEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_isEnabled")]
  public static extern bool SBMLExtensionRegistry_isEnabled(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_isRegistered")]
  public static extern bool SBMLExtensionRegistry_isRegistered(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getAllRegisteredPackageNames")]
  public static extern global::System.IntPtr SBMLExtensionRegistry_getAllRegisteredPackageNames();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getNumRegisteredPackages")]
  public static extern uint SBMLExtensionRegistry_getNumRegisteredPackages();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getRegisteredPackageName")]
  public static extern string SBMLExtensionRegistry_getRegisteredPackageName(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getASTPlugins")]
  public static extern global::System.IntPtr SBMLExtensionRegistry_getASTPlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getNumASTPlugins")]
  public static extern uint SBMLExtensionRegistry_getNumASTPlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExtensionRegistry_getASTPlugin")]
  public static extern global::System.IntPtr SBMLExtensionRegistry_getASTPlugin(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ASTNode__SWIG_0")]
  public static extern global::System.IntPtr new_ASTNode__SWIG_0(int jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ASTNode__SWIG_1")]
  public static extern global::System.IntPtr new_ASTNode__SWIG_1();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ASTNode__SWIG_2")]
  public static extern global::System.IntPtr new_ASTNode__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ASTNode")]
  public static extern void delete_ASTNode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_freeName")]
  public static extern int ASTNode_freeName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_canonicalize")]
  public static extern bool ASTNode_canonicalize(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_addChild__SWIG_0")]
  public static extern int ASTNode_addChild__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_addChild__SWIG_1")]
  public static extern int ASTNode_addChild__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_prependChild")]
  public static extern int ASTNode_prependChild(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_removeChild")]
  public static extern int ASTNode_removeChild(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_replaceChild__SWIG_0")]
  public static extern int ASTNode_replaceChild__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_replaceChild__SWIG_1")]
  public static extern int ASTNode_replaceChild__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_insertChild")]
  public static extern int ASTNode_insertChild(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_deepCopy")]
  public static extern global::System.IntPtr ASTNode_deepCopy(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getChild")]
  public static extern global::System.IntPtr ASTNode_getChild(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getLeftChild")]
  public static extern global::System.IntPtr ASTNode_getLeftChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getRightChild")]
  public static extern global::System.IntPtr ASTNode_getRightChild(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getNumChildren")]
  public static extern uint ASTNode_getNumChildren(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_addSemanticsAnnotation")]
  public static extern int ASTNode_addSemanticsAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getNumSemanticsAnnotations")]
  public static extern uint ASTNode_getNumSemanticsAnnotations(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getSemanticsAnnotation")]
  public static extern global::System.IntPtr ASTNode_getSemanticsAnnotation(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getCharacter")]
  public static extern char ASTNode_getCharacter(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getId")]
  public static extern string ASTNode_getId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getClass")]
  public static extern string ASTNode_getClass(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getStyle")]
  public static extern string ASTNode_getStyle(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getInteger")]
  public static extern int ASTNode_getInteger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getName")]
  public static extern string ASTNode_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getOperatorName")]
  public static extern string ASTNode_getOperatorName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getNumerator")]
  public static extern int ASTNode_getNumerator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getDenominator")]
  public static extern int ASTNode_getDenominator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getReal")]
  public static extern double ASTNode_getReal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getMantissa")]
  public static extern double ASTNode_getMantissa(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getExponent")]
  public static extern int ASTNode_getExponent(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getValue")]
  public static extern double ASTNode_getValue(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getPrecedence")]
  public static extern int ASTNode_getPrecedence(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getType")]
  public static extern int ASTNode_getType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getUnits")]
  public static extern string ASTNode_getUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isAvogadro")]
  public static extern bool ASTNode_isAvogadro(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isBoolean")]
  public static extern bool ASTNode_isBoolean(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_returnsBoolean__SWIG_0")]
  public static extern bool ASTNode_returnsBoolean__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_returnsBoolean__SWIG_1")]
  public static extern bool ASTNode_returnsBoolean__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isConstant")]
  public static extern bool ASTNode_isConstant(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isCiNumber")]
  public static extern bool ASTNode_isCiNumber(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isConstantNumber")]
  public static extern bool ASTNode_isConstantNumber(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isCSymbolFunction")]
  public static extern bool ASTNode_isCSymbolFunction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isFunction")]
  public static extern bool ASTNode_isFunction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isInfinity")]
  public static extern bool ASTNode_isInfinity(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isInteger")]
  public static extern bool ASTNode_isInteger(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isLambda")]
  public static extern bool ASTNode_isLambda(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isLog10")]
  public static extern bool ASTNode_isLog10(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isLogical")]
  public static extern bool ASTNode_isLogical(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isName")]
  public static extern bool ASTNode_isName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isNaN")]
  public static extern bool ASTNode_isNaN(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isNegInfinity")]
  public static extern bool ASTNode_isNegInfinity(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isNumber")]
  public static extern bool ASTNode_isNumber(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isOperator")]
  public static extern bool ASTNode_isOperator(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isPiecewise")]
  public static extern bool ASTNode_isPiecewise(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isRational")]
  public static extern bool ASTNode_isRational(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isReal")]
  public static extern bool ASTNode_isReal(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isRelational")]
  public static extern bool ASTNode_isRelational(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSqrt")]
  public static extern bool ASTNode_isSqrt(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isUMinus")]
  public static extern bool ASTNode_isUMinus(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isUPlus")]
  public static extern bool ASTNode_isUPlus(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isUserFunction")]
  public static extern bool ASTNode_isUserFunction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_hasTypeAndNumChildren")]
  public static extern int ASTNode_hasTypeAndNumChildren(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isUnknown")]
  public static extern bool ASTNode_isUnknown(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetId")]
  public static extern bool ASTNode_isSetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetClass")]
  public static extern bool ASTNode_isSetClass(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetStyle")]
  public static extern bool ASTNode_isSetStyle(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetUnits")]
  public static extern bool ASTNode_isSetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_hasUnits")]
  public static extern bool ASTNode_hasUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setCharacter")]
  public static extern int ASTNode_setCharacter(global::System.Runtime.InteropServices.HandleRef jarg1, char jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setId")]
  public static extern int ASTNode_setId(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setClass")]
  public static extern int ASTNode_setClass(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setStyle")]
  public static extern int ASTNode_setStyle(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setName")]
  public static extern int ASTNode_setName(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setValue__SWIG_0")]
  public static extern int ASTNode_setValue__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setValue__SWIG_1")]
  public static extern int ASTNode_setValue__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setValue__SWIG_2")]
  public static extern int ASTNode_setValue__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setValue__SWIG_3")]
  public static extern int ASTNode_setValue__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, double jarg2, int jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setType")]
  public static extern int ASTNode_setType(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setUnits")]
  public static extern int ASTNode_setUnits(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_swapChildren")]
  public static extern int ASTNode_swapChildren(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_renameSIdRefs")]
  public static extern void ASTNode_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_renameUnitSIdRefs")]
  public static extern void ASTNode_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_replaceIDWithFunction")]
  public static extern void ASTNode_replaceIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_multiplyTimeBy")]
  public static extern void ASTNode_multiplyTimeBy(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetUnits")]
  public static extern int ASTNode_unsetUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetId")]
  public static extern int ASTNode_unsetId(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetClass")]
  public static extern int ASTNode_unsetClass(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetStyle")]
  public static extern int ASTNode_unsetStyle(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setDefinitionURL__SWIG_0")]
  public static extern int ASTNode_setDefinitionURL__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setDefinitionURL__SWIG_1")]
  public static extern int ASTNode_setDefinitionURL__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getDefinitionURL")]
  public static extern global::System.IntPtr ASTNode_getDefinitionURL(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_replaceArgument")]
  public static extern void ASTNode_replaceArgument(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getParentSBMLObject")]
  public static extern global::System.IntPtr ASTNode_getParentSBMLObject(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetParentSBMLObject")]
  public static extern int ASTNode_unsetParentSBMLObject(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetParentSBMLObject")]
  public static extern bool ASTNode_isSetParentSBMLObject(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_reduceToBinary")]
  public static extern void ASTNode_reduceToBinary(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_unsetUserData")]
  public static extern int ASTNode_unsetUserData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSetUserData")]
  public static extern bool ASTNode_isSetUserData(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isWellFormedASTNode")]
  public static extern bool ASTNode_isWellFormedASTNode(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_hasCorrectNumberArguments")]
  public static extern bool ASTNode_hasCorrectNumberArguments(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getDefinitionURLString")]
  public static extern string ASTNode_getDefinitionURLString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_representsBvar")]
  public static extern bool ASTNode_representsBvar(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isBvar")]
  public static extern bool ASTNode_isBvar(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_setBvar")]
  public static extern void ASTNode_setBvar(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_usesL3V2MathConstructs")]
  public static extern bool ASTNode_usesL3V2MathConstructs(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_usesRateOf")]
  public static extern bool ASTNode_usesRateOf(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isQualifier")]
  public static extern bool ASTNode_isQualifier(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_isSemantics")]
  public static extern bool ASTNode_isSemantics(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getNumBvars")]
  public static extern uint ASTNode_getNumBvars(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_addPlugin")]
  public static extern void ASTNode_addPlugin(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_loadASTPlugins")]
  public static extern void ASTNode_loadASTPlugins(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_loadASTPlugin")]
  public static extern void ASTNode_loadASTPlugin(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getASTPlugin__SWIG_0")]
  public static extern global::System.IntPtr ASTNode_getASTPlugin__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getASTPlugin__SWIG_1")]
  public static extern global::System.IntPtr ASTNode_getASTPlugin__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getASTPlugin__SWIG_2")]
  public static extern global::System.IntPtr ASTNode_getASTPlugin__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getASTPlugin__SWIG_3")]
  public static extern global::System.IntPtr ASTNode_getASTPlugin__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getPlugin__SWIG_0")]
  public static extern global::System.IntPtr ASTNode_getPlugin__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getPlugin__SWIG_2")]
  public static extern global::System.IntPtr ASTNode_getPlugin__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getNumPlugins")]
  public static extern uint ASTNode_getNumPlugins(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNode_getListOfNodes")]
  public static extern global::System.IntPtr ASTNode_getListOfNodes(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_readMathMLFromString")]
  public static extern global::System.IntPtr readMathMLFromString(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_readMathMLFromStringWithNamespaces")]
  public static extern global::System.IntPtr readMathMLFromStringWithNamespaces(string jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_writeMathMLToString")]
  public static extern string writeMathMLToString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_writeMathMLWithNamespaceToString")]
  public static extern string writeMathMLWithNamespaceToString(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_parseFormula")]
  public static extern global::System.IntPtr parseFormula(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_formulaToL3String")]
  public static extern string formulaToL3String(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_formulaToL3StringWithSettings")]
  public static extern string formulaToL3StringWithSettings(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_formulaToString")]
  public static extern string formulaToString(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_parseL3Formula")]
  public static extern global::System.IntPtr parseL3Formula(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_parseL3FormulaWithModel")]
  public static extern global::System.IntPtr parseL3FormulaWithModel(string jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_parseL3FormulaWithSettings")]
  public static extern global::System.IntPtr parseL3FormulaWithSettings(string jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getDefaultL3ParserSettings")]
  public static extern global::System.IntPtr getDefaultL3ParserSettings();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_getLastParseL3Error")]
  public static extern string getLastParseL3Error();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBML_deleteL3Parser")]
  public static extern void SBML_deleteL3Parser();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_0")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_1")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6, global::System.Runtime.InteropServices.HandleRef jarg7, bool jarg8, bool jarg9);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_2")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_2(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6, global::System.Runtime.InteropServices.HandleRef jarg7, bool jarg8);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_3")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_3(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6, global::System.Runtime.InteropServices.HandleRef jarg7);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_4")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_4(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_5")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3ParserSettings__SWIG_6")]
  public static extern global::System.IntPtr new_L3ParserSettings__SWIG_6(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_L3ParserSettings")]
  public static extern void delete_L3ParserSettings(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setModel")]
  public static extern void L3ParserSettings_setModel(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getModel")]
  public static extern global::System.IntPtr L3ParserSettings_getModel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_unsetModel")]
  public static extern void L3ParserSettings_unsetModel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseLog")]
  public static extern void L3ParserSettings_setParseLog(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseLog")]
  public static extern int L3ParserSettings_getParseLog(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseCollapseMinus")]
  public static extern void L3ParserSettings_setParseCollapseMinus(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseCollapseMinus")]
  public static extern bool L3ParserSettings_getParseCollapseMinus(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseUnits")]
  public static extern void L3ParserSettings_setParseUnits(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseUnits")]
  public static extern bool L3ParserSettings_getParseUnits(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseAvogadroCsymbol")]
  public static extern void L3ParserSettings_setParseAvogadroCsymbol(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseAvogadroCsymbol")]
  public static extern bool L3ParserSettings_getParseAvogadroCsymbol(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setComparisonCaseSensitivity")]
  public static extern void L3ParserSettings_setComparisonCaseSensitivity(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getComparisonCaseSensitivity")]
  public static extern bool L3ParserSettings_getComparisonCaseSensitivity(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseModuloL3v2")]
  public static extern void L3ParserSettings_setParseModuloL3v2(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseModuloL3v2")]
  public static extern bool L3ParserSettings_getParseModuloL3v2(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParseL3v2Functions")]
  public static extern void L3ParserSettings_setParseL3v2Functions(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParseL3v2Functions")]
  public static extern bool L3ParserSettings_getParseL3v2Functions(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_setParsePackageMath")]
  public static extern void L3ParserSettings_setParsePackageMath(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_getParsePackageMath")]
  public static extern bool L3ParserSettings_getParsePackageMath(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3ParserSettings_visitPackageInfixSyntax")]
  public static extern void L3ParserSettings_visitPackageInfixSyntax(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, global::System.Runtime.InteropServices.HandleRef jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_name_set")]
  public static extern void ASTNodeValues_t_name_set(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_name_get")]
  public static extern string ASTNodeValues_t_name_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_type_set")]
  public static extern void ASTNodeValues_t_type_set(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_type_get")]
  public static extern int ASTNodeValues_t_type_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_isFunction_set")]
  public static extern void ASTNodeValues_t_isFunction_set(global::System.Runtime.InteropServices.HandleRef jarg1, bool jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_isFunction_get")]
  public static extern bool ASTNodeValues_t_isFunction_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_csymbolURL_set")]
  public static extern void ASTNodeValues_t_csymbolURL_set(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_csymbolURL_get")]
  public static extern string ASTNodeValues_t_csymbolURL_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_allowedChildrenType_set")]
  public static extern void ASTNodeValues_t_allowedChildrenType_set(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_allowedChildrenType_get")]
  public static extern int ASTNodeValues_t_allowedChildrenType_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_numAllowedChildren_set")]
  public static extern void ASTNodeValues_t_numAllowedChildren_set(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTNodeValues_t_numAllowedChildren_get")]
  public static extern global::System.IntPtr ASTNodeValues_t_numAllowedChildren_get(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_ASTNodeValues_t")]
  public static extern global::System.IntPtr new_ASTNodeValues_t();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ASTNodeValues_t")]
  public static extern void delete_ASTNodeValues_t(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getStringFor")]
  public static extern string ASTBasePlugin_getStringFor(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getConstCharFor")]
  public static extern string ASTBasePlugin_getConstCharFor(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getConstCharCsymbolURLFor")]
  public static extern string ASTBasePlugin_getConstCharCsymbolURLFor(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getASTNodeTypeFor")]
  public static extern int ASTBasePlugin_getASTNodeTypeFor(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getASTNodeTypeForCSymbolURL")]
  public static extern int ASTBasePlugin_getASTNodeTypeForCSymbolURL(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_hasCorrectNamespace")]
  public static extern bool ASTBasePlugin_hasCorrectNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_defines__SWIG_0")]
  public static extern bool ASTBasePlugin_defines__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_defines__SWIG_1")]
  public static extern bool ASTBasePlugin_defines__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_isFunction")]
  public static extern bool ASTBasePlugin_isFunction(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_isLogical")]
  public static extern bool ASTBasePlugin_isLogical(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_isMathMLNodeTag__SWIG_0")]
  public static extern bool ASTBasePlugin_isMathMLNodeTag__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_isMathMLNodeTag__SWIG_1")]
  public static extern bool ASTBasePlugin_isMathMLNodeTag__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getExtendedMathType")]
  public static extern int ASTBasePlugin_getExtendedMathType(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_evaluateASTNode__SWIG_0")]
  public static extern double ASTBasePlugin_evaluateASTNode__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_evaluateASTNode__SWIG_1")]
  public static extern double ASTBasePlugin_evaluateASTNode__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getUnitDefinitionFromPackage")]
  public static extern global::System.IntPtr ASTBasePlugin_getUnitDefinitionFromPackage(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, bool jarg4, int jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_allowedInFunctionDefinition")]
  public static extern int ASTBasePlugin_allowedInFunctionDefinition(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_ASTBasePlugin")]
  public static extern void delete_ASTBasePlugin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_clone")]
  public static extern global::System.IntPtr ASTBasePlugin_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getElementNamespace")]
  public static extern string ASTBasePlugin_getElementNamespace(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getPrefix")]
  public static extern string ASTBasePlugin_getPrefix(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getPackageName")]
  public static extern string ASTBasePlugin_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_setSBMLExtension")]
  public static extern int ASTBasePlugin_setSBMLExtension(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_setPrefix")]
  public static extern int ASTBasePlugin_setPrefix(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_connectToParent")]
  public static extern void ASTBasePlugin_connectToParent(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_enablePackageInternal")]
  public static extern void ASTBasePlugin_enablePackageInternal(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_stripPackage")]
  public static extern bool ASTBasePlugin_stripPackage(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, bool jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getURI")]
  public static extern string ASTBasePlugin_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getParentASTObject__SWIG_0")]
  public static extern global::System.IntPtr ASTBasePlugin_getParentASTObject__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_setElementNamespace")]
  public static extern int ASTBasePlugin_setElementNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getLevel")]
  public static extern uint ASTBasePlugin_getLevel(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getVersion")]
  public static extern uint ASTBasePlugin_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getPackageVersion")]
  public static extern uint ASTBasePlugin_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getSBMLNamespaces")]
  public static extern global::System.IntPtr ASTBasePlugin_getSBMLNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_renameSIdRefs")]
  public static extern void ASTBasePlugin_renameSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_renameUnitSIdRefs")]
  public static extern void ASTBasePlugin_renameUnitSIdRefs(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, string jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_replaceIDWithFunction")]
  public static extern void ASTBasePlugin_replaceIDWithFunction(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_checkNumArguments")]
  public static extern int ASTBasePlugin_checkNumArguments(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_getL3PackageInfixPrecedence")]
  public static extern int ASTBasePlugin_getL3PackageInfixPrecedence(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_hasCorrectNumArguments")]
  public static extern bool ASTBasePlugin_hasCorrectNumArguments(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_hasPackageOnlyInfixSyntax")]
  public static extern bool ASTBasePlugin_hasPackageOnlyInfixSyntax(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_hasUnambiguousPackageInfixGrammar")]
  public static extern bool ASTBasePlugin_hasUnambiguousPackageInfixGrammar(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ASTBasePlugin_isPackageInfixFunction")]
  public static extern bool ASTBasePlugin_isPackageInfixFunction(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_0")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_0(long jarg1, long jarg2, long jarg3, string jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_1")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_1(long jarg1, long jarg2, long jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_2")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_2(long jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_3")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_3(long jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_4")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_4();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_L3v2extendedmathPkgNamespaces")]
  public static extern void delete_L3v2extendedmathPkgNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathPkgNamespaces__SWIG_5")]
  public static extern global::System.IntPtr new_L3v2extendedmathPkgNamespaces__SWIG_5(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathPkgNamespaces_clone")]
  public static extern global::System.IntPtr L3v2extendedmathPkgNamespaces_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathPkgNamespaces_getURI")]
  public static extern string L3v2extendedmathPkgNamespaces_getURI(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathPkgNamespaces_getPackageVersion")]
  public static extern uint L3v2extendedmathPkgNamespaces_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathPkgNamespaces_getPackageName")]
  public static extern string L3v2extendedmathPkgNamespaces_getPackageName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getPackageName")]
  public static extern string L3v2extendedmathExtension_getPackageName();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getDefaultLevel")]
  public static extern uint L3v2extendedmathExtension_getDefaultLevel();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getDefaultVersion")]
  public static extern uint L3v2extendedmathExtension_getDefaultVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getDefaultPackageVersion")]
  public static extern uint L3v2extendedmathExtension_getDefaultPackageVersion();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getXmlnsL3V1V1")]
  public static extern string L3v2extendedmathExtension_getXmlnsL3V1V1();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getXmlnsL3V2")]
  public static extern string L3v2extendedmathExtension_getXmlnsL3V2();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathExtension__SWIG_0")]
  public static extern global::System.IntPtr new_L3v2extendedmathExtension__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathExtension__SWIG_1")]
  public static extern global::System.IntPtr new_L3v2extendedmathExtension__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_clone")]
  public static extern global::System.IntPtr L3v2extendedmathExtension_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_L3v2extendedmathExtension")]
  public static extern void delete_L3v2extendedmathExtension(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getName")]
  public static extern string L3v2extendedmathExtension_getName(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getURI")]
  public static extern string L3v2extendedmathExtension_getURI(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getLevel")]
  public static extern uint L3v2extendedmathExtension_getLevel(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getVersion")]
  public static extern uint L3v2extendedmathExtension_getVersion(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getPackageVersion")]
  public static extern uint L3v2extendedmathExtension_getPackageVersion(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getSBMLExtensionNamespaces")]
  public static extern global::System.IntPtr L3v2extendedmathExtension_getSBMLExtensionNamespaces(global::System.Runtime.InteropServices.HandleRef jarg1, string jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getStringFromTypeCode")]
  public static extern string L3v2extendedmathExtension_getStringFromTypeCode(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getErrorTable")]
  public static extern global::System.IntPtr L3v2extendedmathExtension_getErrorTable(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getErrorTableIndex")]
  public static extern uint L3v2extendedmathExtension_getErrorTableIndex(global::System.Runtime.InteropServices.HandleRef jarg1, long jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_getErrorIdOffset")]
  public static extern uint L3v2extendedmathExtension_getErrorIdOffset(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_init")]
  public static extern void L3v2extendedmathExtension_init();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathSBMLDocumentPlugin__SWIG_0")]
  public static extern global::System.IntPtr new_L3v2extendedmathSBMLDocumentPlugin__SWIG_0(string jarg1, string jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathSBMLDocumentPlugin__SWIG_1")]
  public static extern global::System.IntPtr new_L3v2extendedmathSBMLDocumentPlugin__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathSBMLDocumentPlugin_clone")]
  public static extern global::System.IntPtr L3v2extendedmathSBMLDocumentPlugin_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_L3v2extendedmathSBMLDocumentPlugin")]
  public static extern void delete_L3v2extendedmathSBMLDocumentPlugin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathSBMLDocumentPlugin_isCompFlatteningImplemented")]
  public static extern bool L3v2extendedmathSBMLDocumentPlugin_isCompFlatteningImplemented(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathSBMLDocumentPlugin_checkConsistency")]
  public static extern uint L3v2extendedmathSBMLDocumentPlugin_checkConsistency(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathASTPlugin__SWIG_0")]
  public static extern global::System.IntPtr new_L3v2extendedmathASTPlugin__SWIG_0();

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathASTPlugin__SWIG_1")]
  public static extern global::System.IntPtr new_L3v2extendedmathASTPlugin__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_clone")]
  public static extern global::System.IntPtr L3v2extendedmathASTPlugin_clone(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_delete_L3v2extendedmathASTPlugin")]
  public static extern void delete_L3v2extendedmathASTPlugin(global::System.Runtime.InteropServices.HandleRef jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_hasCorrectNamespace")]
  public static extern bool L3v2extendedmathASTPlugin_hasCorrectNamespace(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_new_L3v2extendedmathASTPlugin__SWIG_2")]
  public static extern global::System.IntPtr new_L3v2extendedmathASTPlugin__SWIG_2(string jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_checkNumArguments")]
  public static extern int L3v2extendedmathASTPlugin_checkNumArguments(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_evaluateASTNode__SWIG_0")]
  public static extern double L3v2extendedmathASTPlugin_evaluateASTNode__SWIG_0(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_evaluateASTNode__SWIG_1")]
  public static extern double L3v2extendedmathASTPlugin_evaluateASTNode__SWIG_1(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_getUnitDefinitionFromRem")]
  public static extern global::System.IntPtr L3v2extendedmathASTPlugin_getUnitDefinitionFromRem(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, bool jarg4, int jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_getUnitDefinitionFromRateOf")]
  public static extern global::System.IntPtr L3v2extendedmathASTPlugin_getUnitDefinitionFromRateOf(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, bool jarg4, int jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_getUnitDefinitionFromPackage")]
  public static extern global::System.IntPtr L3v2extendedmathASTPlugin_getUnitDefinitionFromPackage(global::System.Runtime.InteropServices.HandleRef jarg1, global::System.Runtime.InteropServices.HandleRef jarg2, global::System.Runtime.InteropServices.HandleRef jarg3, bool jarg4, int jarg5);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_isLogical")]
  public static extern bool L3v2extendedmathASTPlugin_isLogical(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_allowedInFunctionDefinition")]
  public static extern int L3v2extendedmathASTPlugin_allowedInFunctionDefinition(global::System.Runtime.InteropServices.HandleRef jarg1, int jarg2);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OFStream_SWIGUpcast")]
  public static extern global::System.IntPtr OFStream_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_OStringStream_SWIGUpcast")]
  public static extern global::System.IntPtr OStringStream_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOf_SWIGUpcast")]
  public static extern global::System.IntPtr ListOf_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Model_SWIGUpcast")]
  public static extern global::System.IntPtr Model_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocument_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLDocument_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_FunctionDefinition_SWIGUpcast")]
  public static extern global::System.IntPtr FunctionDefinition_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfFunctionDefinitions_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfFunctionDefinitions_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Unit_SWIGUpcast")]
  public static extern global::System.IntPtr Unit_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnits_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfUnits_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_UnitDefinition_SWIGUpcast")]
  public static extern global::System.IntPtr UnitDefinition_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfUnitDefinitions_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfUnitDefinitions_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_CompartmentType_SWIGUpcast")]
  public static extern global::System.IntPtr CompartmentType_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartmentTypes_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfCompartmentTypes_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesType_SWIGUpcast")]
  public static extern global::System.IntPtr SpeciesType_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesTypes_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfSpeciesTypes_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Compartment_SWIGUpcast")]
  public static extern global::System.IntPtr Compartment_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfCompartments_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfCompartments_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Species_SWIGUpcast")]
  public static extern global::System.IntPtr Species_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpecies_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfSpecies_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Parameter_SWIGUpcast")]
  public static extern global::System.IntPtr Parameter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfParameters_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfParameters_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_LocalParameter_SWIGUpcast")]
  public static extern global::System.IntPtr LocalParameter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfLocalParameters_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfLocalParameters_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_InitialAssignment_SWIGUpcast")]
  public static extern global::System.IntPtr InitialAssignment_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfInitialAssignments_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfInitialAssignments_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Rule_SWIGUpcast")]
  public static extern global::System.IntPtr Rule_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfRules_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfRules_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AlgebraicRule_SWIGUpcast")]
  public static extern global::System.IntPtr AlgebraicRule_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_AssignmentRule_SWIGUpcast")]
  public static extern global::System.IntPtr AssignmentRule_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_RateRule_SWIGUpcast")]
  public static extern global::System.IntPtr RateRule_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Constraint_SWIGUpcast")]
  public static extern global::System.IntPtr Constraint_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfConstraints_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfConstraints_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Reaction_SWIGUpcast")]
  public static extern global::System.IntPtr Reaction_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfReactions_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfReactions_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_KineticLaw_SWIGUpcast")]
  public static extern global::System.IntPtr KineticLaw_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SimpleSpeciesReference_SWIGUpcast")]
  public static extern global::System.IntPtr SimpleSpeciesReference_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SpeciesReference_SWIGUpcast")]
  public static extern global::System.IntPtr SpeciesReference_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfSpeciesReferences_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfSpeciesReferences_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ModifierSpeciesReference_SWIGUpcast")]
  public static extern global::System.IntPtr ModifierSpeciesReference_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Event_SWIGUpcast")]
  public static extern global::System.IntPtr Event_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEvents_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfEvents_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_EventAssignment_SWIGUpcast")]
  public static extern global::System.IntPtr EventAssignment_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ListOfEventAssignments_SWIGUpcast")]
  public static extern global::System.IntPtr ListOfEventAssignments_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Trigger_SWIGUpcast")]
  public static extern global::System.IntPtr Trigger_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Delay_SWIGUpcast")]
  public static extern global::System.IntPtr Delay_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_Priority_SWIGUpcast")]
  public static extern global::System.IntPtr Priority_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_StoichiometryMath_SWIGUpcast")]
  public static extern global::System.IntPtr StoichiometryMath_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLFunctionDefinitionConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLFunctionDefinitionConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLIdConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLIdConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInferUnitsConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLInferUnitsConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLInitialAssignmentConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLInitialAssignmentConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevelVersionConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLLevelVersionConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLevel1Version1Converter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLLevel1Version1Converter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLLocalParameterConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLLocalParameterConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLReactionConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLReactionConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLRuleConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLRuleConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLStripPackageConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLStripPackageConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLUnitsConverter_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLUnitsConverter_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLExternalValidator_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLExternalValidator_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_XMLNode_SWIGUpcast")]
  public static extern global::System.IntPtr XMLNode_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLErrorLog_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLErrorLog_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLError_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLError_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_ISBMLExtensionNamespaces_SWIGUpcast")]
  public static extern global::System.IntPtr ISBMLExtensionNamespaces_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_SBMLDocumentPlugin_SWIGUpcast")]
  public static extern global::System.IntPtr SBMLDocumentPlugin_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathPkgNamespaces_SWIGUpcast")]
  public static extern global::System.IntPtr L3v2extendedmathPkgNamespaces_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathExtension_SWIGUpcast")]
  public static extern global::System.IntPtr L3v2extendedmathExtension_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathSBMLDocumentPlugin_SWIGUpcast")]
  public static extern global::System.IntPtr L3v2extendedmathSBMLDocumentPlugin_SWIGUpcast(global::System.IntPtr jarg1);

  [global::System.Runtime.InteropServices.DllImport("libsbmlcs", EntryPoint="CSharp_libsbmlcs_L3v2extendedmathASTPlugin_SWIGUpcast")]
  public static extern global::System.IntPtr L3v2extendedmathASTPlugin_SWIGUpcast(global::System.IntPtr jarg1);
}

}
