// Sample program: Print information about the current visual. Based
// on testvidinfo from SDL, but converted to C++ and SDLmm.

#include "sdlmm_config.h"
RCSID("$Id: vidinfo.cpp,v 1.13 2001/06/25 23:24:52 rad_ad Exp $");
#include "sdlmm.h"
#include <cstdio>
#include <cstdlib>

int main(int argc, char *argv[])
{
  SDLmm::VideoInfo info;
  int i;
  SDL_Rect **modes;

  printf("Using SDLmm version %s.\n", SDLmm::version());
  
  if (!SDLmm::Display::Init()) {
    fprintf(stderr, "Couldn't initialize SDL: %s\n", SDLmm::GetError());
    exit(1);
  }
  if(!info.GetVideoInfo()) {
    fprintf(stderr, "Failed to get video information\n");
  }
  SDLmm::PixelFormat format(info.GetPixelFormat());
  printf("Current display: %d bits-per-pixel\n",
	 format.BitsPerPixel());
  if ( format.palette() == NULL ) {
    printf("	Red Mask = 0x%.8x\n", format.Rmask());
    printf("	Green Mask = 0x%.8x\n", format.Gmask());
    printf("	Blue Mask = 0x%.8x\n", format.Bmask());
  }

  /* Print available fullscreen video modes */
  modes = SDLmm::Display::ListModes(0, SDL_FULLSCREEN);
  if ( modes == (SDL_Rect **)0 ) {
    printf("No available fullscreen video modes\n");
  } else if ( modes == (SDL_Rect **)-1 ) {
    printf("All resolutions available for fullscreen mode.\n");
  } else {
    printf("Fullscreen video modes:\n");
    for ( i=0; modes[i]; ++i ) {
      printf("\t%dx%d\n", modes[i]->w, modes[i]->h);
    }
  }
  
  if ( info.wm_available() ) {
    printf("A window manager is available\n");
  }
  if (info.hw_available() ) {
    printf("Hardware surfaces are available (%dK video memory):\n",
	   info.video_mem());
    /* Print available fullscreen video modes */
    modes = SDLmm::Display::ListModes(0, SDL_HWSURFACE);
    if ( modes == (SDL_Rect **)0 ) {
      printf("\tFound no available hardware video modes!\n");
    } else if ( modes == (SDL_Rect **)-1 ) {
      printf("\tall resolutions available.\n");
    } else {
      for ( i=0; modes[i]; ++i ) {
	printf("\t%dx%d\n", modes[i]->w, modes[i]->h);
      }
    }
  }
  if (info.blit_hw() ) {
    printf("Copy blits between hardware surfaces are accelerated\n");
  }
  if (info.blit_hw_CC()) {
    printf("Colorkey blits between hardware surfaces are accelerated\n");
  }
  if (info.blit_hw_A()) {
    printf("Alpha blits between hardware surfaces are accelerated\n");
  }
  if (info.blit_sw()) {
    printf("Copy blits from software surfaces to hardware surfaces are accelerated\n");
  }
  if (info.blit_sw_CC()) {
    printf("Colorkey blits from software surfaces to hardware surfaces are accelerated\n");
  }
  if (info.blit_sw_A()) {
    printf("Alpha blits from software surfaces to hardware surfaces are accelerated\n");
  }
  if (info.blit_fill()) {
    printf("Color fills on hardware surfaces are accelerated\n");
  }
  SDLmm::Quit();
  return 0;
}

