#!/bin/sh

# build script for remote VC .NET builds under cygwin.

    #export XERCES=z:\\windev\\xerces-c-windows_2000-msvc_71
    #export CPPUNIT=z:\\windev\\cppunit-1.10.2-VC71

# parse options
#
#  -x "Windows/Xerces/Path"
#  -X "cygwin/Xerces/Path"
#  -c "Windows/cppunit/Path"
#  -C "cygwin/cppunit/Path"

    export CPPUNIT_PATH=
    export XERCES_PATH=

    while getopts "x:c:X:C:o:O:" Option
    do
    case $Option in
        C)
            CPPUNIT_PATH=$(cygpath -a -w $OPTARG)
            ;;
        X)
            XERCES_PATH=$(cygpath -a -w $OPTARG)
            ;;
        c)
            CPPUNIT_PATH=$OPTARG
            ;;
        x)
            XERCES_PATH=$OPTARG
            ;;
        o)
            OUT=$OPTARG
            ;;
        O)
            OUT=$(cygpath -a -w $OPTARG)
            ;;
        *)
            help
            ;;
    esac
    done
    shift $(($OPTIND - 1))
    # Move argument pointer to next.

    [ -n "$OUT" ] || OUT=../../../

    export cppunit=$CPPUNIT_PATH
    export xerces=$XERCES_PATH
    export XercesLibTopDir=$xerces\\Build\\Win32\\VC7.1
    
    export PATH=$PATH:$(cygpath -u "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE\\")
    
    export OUTLIBDIR=$OUT/lib
    export OUTBINDIR=$OUT/bins_vc71
    
    export INCLUDE="$INCLUDE;$cppunit\\include\\;$xerces\\src\\"
    export LIB="$LIB;$cppunit\\lib"
    
    [ ! -e build.log ] || mv build.log build.log-OLD
    devenv ./libsmbios_full.sln /build release /out build.log /safemode 
    devenv ./libsmbios_full.sln /build debug /out build.log /safemode 


