/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DS_SERVER_INTERNALS_H_
#define _SML_DS_SERVER_INTERNALS_H_

typedef struct SmlWriteContext {
	SmlDsSessionWriteCb callback;
	char *uid;
	char *newuid;
	SmlStatus *status;
	void *userdata;
	SmlChangeType type;
	SmlDsSession *session;
} SmlWriteContext;

struct SmlDsSession {
	gint refCount;
	
	SmlDsServer *server;
	SmlSession *session;
	
	SmlLocation *target;
	SmlLocation *location;
	
	/** Callback that will receive the alert once it is received */
	SmlDsSessionAlertCb recvAlertCallback;
	void *recvAlertCallbackUserdata;
	SmlCommand *alertCommand;
	
	/** Callback that will receive the reply to the alert */
	SmlStatusReplyCb sentAlertCallback;
	void *sentAlertCallbackUserdata;
	
	/** Callback that will receive the sync command */
	SmlDsSessionSyncCb recvSyncCallback;
	void *recvSyncCallbackUserdata;
	SmlDsSessionChangesCb changesCallback;
	void *changesCallbackUserdata;
	/** List of received sync commands. We need a list here
	 * since sync commands might get split due to size limitations
	 * and the answer to a sync command might arrive after several
	 * sync commands have been received */
	GList *recvSync;
	GList *recvChanges;
	SmlErrorType syncReply;
	
	/** Callback that will receive the reply to the sync command */
	SmlStatusReplyCb sentSyncCallback;
	void *sentSyncCallbackUserdata;
	
	/** The temporary storage for the sync command to send */
	SmlCommand *syncCommand;
	
	GList *pendingMaps;
	GList *mapItems;
	//SmlCommand *mapCommand;
	
	GMutex *lock;
};

struct SmlDsServer {
	SmlLocation *location;
	/** The target if the ds server is in client mode */
	SmlLocation *target;
	char *contenttype;
	SmlDsServerType servertype;
	SmlManager *manager;
	
	/** Callback that will get called once a new client connects */
	SmlDsSessionConnectCb connectCallback;
	void *connectCallbackUserdata;
	
	SmlDsServerSanCb sanCallback;
	void *sanCallbackUserdata;
};

void smlDsSessionRecvAlert(SmlSession *session, SmlCommand *cmd, void *userdata);
void smlDsSessionRecvSync(SmlSession *session, SmlCommand *cmd, void *userdata);
void smlDsSessionRecvChange(SmlSession *session, SmlCommand *cmd, void *userdata);
void smlDsSessionRecvMap(SmlSession *session, SmlCommand *cmd, void *userdata);
SmlDsSession *smlDsServerRecvAlert(SmlDsServer *server, SmlSession *session, SmlCommand *cmd);

SmlDsSession *smlDsSessionNew(SmlDsServer *server, SmlSession *session, SmlError **error);
void smlDsSessionFree(SmlDsSession *dsession);

#endif //_SML_DS_SERVER_INTERNALS_H_
