/* Hey EMACS -*- linux-c -*- */
/* $Id: keys73.h 3175 2007-02-19 17:54:59Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2005  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TICALCS_KEYS73__
#define __TICALCS_KEYS73__

// Scan codes of the TI73 (TI's ti73.inc, line 1513)

#define KEY73_Right                 0x01
#define KEY73_Left                  0x02
#define KEY73_Up                    0x03
#define KEY73_Down                  0x04
#define KEY73_Enter                 0x05
#define KEY73_AlphaEnter            0x06
#define KEY73_AlphaUp               0x07
#define KEY73_AlphaDown             0x08
#define KEY73_Clear                 0x09
#define KEY73_Del                   0x0A
#define KEY73_Ins                   0x0B
#define KEY73_Recall                0x0C
#define KEY73_LastEnt               0x0D
#define KEY73_BOL                   0x0E
#define KEY73_EOL                   0x0F

#define KEY73_SelAll                0x10
#define KEY73_UnselAll              0x11
#define KEY73_LtoTI82               0x12
#define KEY73_Backup                0x13
#define KEY73_Recieve               0x14
#define KEY73_LnkQuit               0x15
#define KEY73_Trans                 0x16
#define KEY73_Rename                0x17
#define KEY73_Overw                 0x18
#define KEY73_Omit                  0x19
#define KEY73_Cont                  0x1A
#define KEY73_LtoTI83               0x1B
#define KEY73_SendApp               0x1C
#define KEY73_vApps                 0x1C
#define KEY73_SendId                0x1D
#define KEY73_SendSW                0x1E
#define KEY73_vALL                  0x1F
#define KEY73_vSendType             0x20
#define KEY73_NoWay                 0x21
#define KEY73_Yes                   0x22
#define KEY73_About                 0x23
#define KEY73_App                   0x24

#define KEY73_ProgExec              0x25
#define KEY73_Listflag              0x26



#define KEY73_menustart             0x2c





#define KEY74_AreYouSure			0x2c
#define KEY73_Prgm                  0x2D
#define KEY73_Zoom                  0x2E
#define KEY73_Draw                  0x2F
#define KEY73_SPlot                 0x30
#define KEY73_Stat                  0x31
#define KEY73_Math                  0x32
#define KEY73_Test                  0x33
#define KEY73_AppsMenu              0x34
#define KEY73_Vars                  0x35
#define KEY73_Mem                   0x36
#define KEY73_ConstSetmenu          0x37
#define KEY73_ConvMenu              0x38
#define KEY73_Trigmenu              0x39
#define KEY73_LIST                  0x3A
#define KEY73_ConstMenu             0x3B



#define KEY73_Const                 0x3C


#define KEY73_Alpha                 0x3d
#define KEY73_Catalog               0x3e
#define KEY73_InputDone             0x3f





#define KEY73_Quit                  0x40
#define KEY73_LinkIO                0x41
#define KEY73_ChkApps               0x42
#define KEY73_StatEd                0x43
#define KEY73_Graph                 0x44
#define KEY73_Mode                  0x45
#define KEY73_PrgmEd                0x46
#define KEY73_PrgmCr                0x47
#define KEY73_Window                0x48
#define KEY73_Y                     0x49
#define KEY73_Table                 0x4A
#define KEY73_TblSet                0x4B
#define KEY73_ChkRAM                0x4C
#define KEY73_DelMem                0x4D
#define KEY73_ResetMem              0x4E
#define KEY73_ResetDef				0x4F
#define KEY73_PrgmInput             0x50
#define KEY73_ZFactEd               0x51
#define KEY73_Error                 0x52
#define KEY73_ExtApps               0x53
#define KEY73_SolveRoot				0x54
#define KEY73_StatP                 0x55
#define KEY73_ConstEd               0x56
#define KEY73_PrgmSetVar            0x57
#define KEY73_Format                0x58






#define KEY73_echoStart1			0x5a






#define KEY73_Trace                 0x5a
#define KEY73_ZFit                  0x5b
#define KEY73_ZIn                   0x5c
#define KEY73_ZOut                  0x5d
#define KEY73_ZPrev                 0x5e
#define KEY73_ZBox                  0x5f
#define KEY73_ZDecml                0x60
#define KEY73_SetZm                 0x61
#define KEY73_ZSquar                0x62
#define KEY73_ZStd                  0x63
#define KEY73_ZTrig                 0x64
#define KEY73_ZQuad1                0x65
#define KEY73_ZInt                  0x67
#define KEY73_ZStat                 0x68






#define echoStart2					0x69


#define KEY73_Select                0x69
#define KEY73_Circl                 0x6a
#define KEY73_ClDrw                 0x6b
#define KEY73_Line                  0x6c
#define KEY73_Pen                   0x6d
#define KEY73_PtChg                 0x6e
#define KEY73_PtOff                 0x6f
#define KEY73_PtOn                  0x70
#define KEY73_Vert                  0x71
#define KEY73_Horiz                 0x72
#define KEY73_Text                  0x73
#define KEY73_TanLn                 0x74
#define KEY73_ManFit                0x75



#define KEY73_Eval                  0x76

#define echoStart					0x7d



#define KEY73_Remain                0x7d
#define KEY73_Plot3                 0x7e
#define KEY73_ListName              0x7f
#define KEY73_Add                   0x80
#define KEY73_Sub                   0x81
#define KEY73_Mul                   0x82
#define KEY73_Div                   0x83
#define KEY73_Expon                 0x84
#define KEY73_LParen                0x85
#define KEY73_RParen                0x86
#define KEY73_LBrack                0x87
#define KEY73_RBrack                0x88
#define KEY73_Shade                 0x89
#define KEY73_Store                 0x8a
#define KEY73_Comma                 0x8b
#define KEY73_Chs                   0x8c
#define KEY73_DecPnt                0x8d
#define KEY73_0                     0x8e
#define KEY73_1                     0x8f
#define KEY73_2                     0x90
#define KEY73_3                     0x91
#define KEY73_4                     0x92
#define KEY73_5                     0x93
#define KEY73_6                     0x94
#define KEY73_7                     0x95
#define KEY73_8                     0x96
#define KEY73_9                     0x97
#define KEY73_EE                    0x98
#define KEY73_Space                 0x99
#define KEY73_CapA                  0x9A
#define KEY73_CapB                  0x9B
#define KEY73_CapC                  0x9C
#define KEY73_CapD                  0x9D
#define KEY73_CapE                  0x9E
#define KEY73_CapF                  0x9F
#define KEY73_CapG                  0xA0
#define KEY73_CapH                  0xA1
#define KEY73_CapI                  0xA2
#define KEY73_CapJ                  0xA3
#define KEY73_CapK                  0xA4
#define KEY73_CapL                  0xA5
#define KEY73_CapM                  0xA6
#define KEY73_CapN                  0xA7
#define KEY73_CapO                  0xA8
#define KEY73_CapP                  0xA9
#define KEY73_CapQ                  0xAA
#define KEY73_CapR                  0xAB
#define KEY73_CapS                  0xAC
#define KEY73_CapT                  0xAD
#define KEY73_CapU                  0xAE
#define KEY73_CapV                  0xAF
#define KEY73_CapW                  0xB0
#define KEY73_CapX                  0xB1
#define KEY73_CapY                  0xB2
#define KEY73_CapZ                  0xB3
#define KEY73_Varx                  0xB4
#define KEY73_Pi                    0xB5
#define KEY73_Inv                   0xB6
#define KEY73_Sin                   0xB7
#define KEY73_ASin                  0xB8
#define KEY73_Cos                   0xB9
#define KEY73_ACos                  0xBA
#define KEY73_Tan                   0xBB
#define KEY73_ATan                  0xBC
#define KEY73_Square                0xBD
#define KEY73_Sqrt                  0xBE
#define KEY73_Ln                    0xBF
#define KEY73_Exp                   0xC0
#define KEY73_Log                   0xC1
#define KEY73_ALog                  0xC2
#define KEY73_ToABC                 0xC3



#define KEY73_Ans                   0xc5
#define KEY73_Colon                 0xc6


#define KEY73_Unit                  0xc7
#define KEY73_FracSlash             0xc8
#define KEY73_Root                  0xc9

#define KEY73_Quest                 0xca
#define KEY73_Quote                 0xcb
#define KEY73_Theta                 0xcc
#define KEY73_If                    0xcd
#define KEY73_Then                  0xce
#define KEY73_Else                  0xcf
#define KEY73_For                   0xd0
#define KEY73_While                 0xd1
#define KEY73_Repeat                0xd2
#define KEY73_End                   0xd3
#define KEY73_Pause                 0xd4
#define KEY73_Lbl                   0xd5
#define KEY73_Goto                  0xd6
#define KEY73_ISG                   0xd7
#define KEY73_DSL                   0xd8
#define KEY73_Menu                  0xd9
#define KEY73_Exec                  0xda
#define KEY73_Return                0xdb
#define KEY73_Stop                  0xdc
#define KEY73_Input                 0xdd
#define KEY73_Prompt                0xde
#define KEY73_Disp                  0xdf
#define KEY73_DispG                 0xe0
#define KEY73_DispT                 0xe1
#define KEY73_Output                0xe2
#define KEY73_GetKey                0xe3
#define KEY73_ClrHome               0xe4



#define KEY73_Percent               0xe6
#define KEY73_MixSimp               0xe7
#define KEY73_FracDec               0xe8
#define KEY73_Simp                  0xe9
#define KEY73_UnredF                0xea
#define KEY73_IDiv                  0xeb
#define KEY73_Convert               0xec
#define KEY73_LBrace                0xed
#define KEY73_RBrace                0xee
#define KEY73_L1A                   0xef
#define KEY73_L2A                   0xf0
#define KEY73_L3A                   0xf1
#define KEY73_L4A                   0xf2
#define KEY73_L5A                   0xf3
#define KEY73_L6A                   0xf4
#define KEY73_ConvLength            0xf5
#define KEY73_ConvArea              0xf6
#define KEY73_ConvVolume            0xf7
#define KEY73_ConvTime              0xf8
#define KEY73_ConvTemp              0xf9
#define KEY73_ConvMass              0xfa
#define KEY73_ConvSpeed             0xfb

// FE (ExtendEcho) prefixed keys:

#define KE1BT					0xfe00
#define KEY73_DrawInv          0xfe00
#define KEY73_DrawF            0xfe01
#define KEY73_PixelOn          0xfe02
#define KEY73_PixelOff         0xfe03
#define KEY73_PxlTest          0xfe04
#define KEY73_RCGDB            0xfe05
#define KEY73_RCPic            0xfe06
#define KEY73_STGDB            0xfe07
#define KEY73_STPic            0xfe08
#define KEY73_Abs              0xfe09
#define KEY73_TEqu             0xfe0a
#define KEY73_TNoteQ           0xfe0b
#define KEY73_TGT              0xfe0c
#define KEY73_TGTE             0xfe0d
#define KEY73_TLT              0xfe0e
#define KEY73_TLTE             0xfe0f

#define KEY73_And              0xfe10
#define KEY73_Or               0xfe11
#define KEY73_Xor              0xfe12
#define KEY73_Not              0xfe13



#define KEY73_XRoot            0xfe15
#define KEY73_Cube             0xfe16
#define KEY73_CbRt             0xfe17
#define KEY73_ToDec            0xfe18

#define KEY73_CubicR           0xfe19
#define KEY73_QuartR           0xfe1a

#define KEY73_Plot1            0xfe1b
#define KEY73_Plot2            0xfe1c


#define KEY73_Round            0xfe1d
#define KEY73_IPart            0xfe1e
#define KEY73_FPart            0xfe1f
#define KEY73_Int              0xfe20

#define KEY73_Rand             0xfe21
#define KEY73_NPR              0xfe22
#define KEY73_NCR              0xfe23
#define KEY73_XFactorial       0xfe24

#define KEY73_Rad              0xfe25
#define KEY73_Degr             0xfe26
#define KEY73_APost            0xfe27
#define KEY73_ToDMS            0xfe28
#define KEY73_RToPo            0xfe29
#define KEY73_RToPr            0xfe2a
#define KEY73_PToRx            0xfe2b
#define KEY73_PToRy            0xfe2c

#define KEY73_RowSwap          0xfe2d
#define KEY73_RowPlus          0xfe2e
#define KEY73_TimRow           0xfe2f
#define KEY73_TRowP            0xfe30

#define KEY73_SortA            0xfe31
#define KEY73_SortD            0xfe32
#define KEY73_Seq              0xfe33

#define KEY73_Min              0xfe34
#define KEY73_Max              0xfe35
#define KEY73_Mean             0xfe36
#define KEY73_Median           0xfe37
#define KEY73_Sum              0xfe38
#define KEY73_Prod             0xfe39

#define KEY73_Det              0xfe3a
#define KEY73_Transp           0xfe3b
#define KEY73_Dim              0xfe3c
#define KEY73_Fill             0xfe3d
#define KEY73_Ident            0xfe3e
#define KEY73_Randm            0xfe3f
#define KEY73_Aug              0xfe40

#define KEY73_LstMode          0xfe41


#define KEY73_mRad             0xfe43
#define KEY73_mDeg             0xfe44
#define KEY73_mNormF           0xfe45
#define KEY73_mSci             0xfe46
#define KEY73_Fix              0xfe47
#define KEY73_mFloat           0xfe48
#define KEY73_SetMenu          0xfe49
#define KEY73_EOFrac           0xfe4a

#define KEY73_BoyIcon          0xfe4b
#define KEY73_TreeIcon         0xfe4c
#define KEY73_FaceIcon         0xfe4d
#define KEY73_CircleIcon       0xfe4e
#define KEY73_DiamonIcon       0xfe4f
#define KEY73_StartIcon        0xfe50
#define KEY73_DollarIcon       0xfe51



#define KEY73_FNOn             0xfe54
#define KEY73_FNOff            0xfe55

#define KEY73_PlotsOn          0xfe56
#define KEY73_PlotsOff         0xfe57

#define KEY73_PixelChg         0xfe58

#define KEY73_SendMBL          0xfe59
#define KEY73_RecvMBL          0xfe5a

#define KEY73_BoxPlot          0xfe5b
#define KEY73_BoxIcon          0xfe5c

#define KEY73_CrossIcon        0xfe5d
#define KEY73_DotIcon          0xfe5e

#define KE2BT						(0xfe00+95)

#define KEY73_Seqential			   kE2BT
#define KEY73_SimulG               kE2BT+1  
#define KEY73_CoordOn              kE2BT+2  
#define KEY73_CoordOff             kE2BT+3  
#define KEY73_DrawLine             kE2BT+4  
#define KEY73_DrawDot              kE2BT+5  
#define KEY73_AxisOn               kE2BT+6  
#define KEY73_AxisOff              kE2BT+7  
#define KEY73_GridOn               kE2BT+8  
#define KEY73_GridOff              kE2BT+9  
#define KEY73_LblOn                kE2BT+10 
#define KEY73_OblOff               kE2BT+11 
#define KEY73_PolarG               kE2BT+12 
#define KEY73_RectG                kE2BT+13 

#define KEY73_L1                   kE2BT+14 
#define KEY73_L2                   kE2BT+15
#define KEY73_L3                   kE2BT+16
#define KEY73_L4                   kE2BT+17
#define KEY73_L5                   kE2BT+18
#define KEY73_L6                   kE2BT+19

#define KEY73_MatA                 kE2BT+20
#define KEY73_MatB                 kE2BT+21
#define KEY73_MatC                 kE2BT+22
#define KEY73_MatD                 kE2BT+23
#define KEY73_MatE                 kE2BT+24

#define KEY73_Xmin                 kE2BT+25
#define KEY73_Xmax                 kE2BT+26
#define KEY73_Xscl                 kE2BT+27
#define KEY73_Ymin                 kE2BT+28
#define KEY73_Ymax                 kE2BT+29
#define KEY73_Yscl                 kE2BT+30
#define KEY73_Tmin                 kE2BT+31
#define KEY73_Tmax                 kE2BT+32
#define KEY73_TStep                kE2BT+33
#define KEY73_Omin                 kE2BT+34
#define KEY73_Omax                 kE2BT+35
#define KEY73_OStep                kE2BT+36
#define KEY73_u0                   kE2BT+37
#define KEY73_v0                   kE2BT+38
#define KEY73_nMin                 kE2BT+39
#define KEY73_nMax                 kE2BT+40
#define KEY73_DeltaY               kE2BT+41
#define KEY73_DeltaX               kE2BT+42

#define KEY73_ZXmin                kE2BT+43
#define KEY73_ZXmax                kE2BT+44
#define KEY73_ZXscl                kE2BT+45
#define KEY73_ZYmin                kE2BT+46
#define KEY73_ZYmax                kE2BT+47
#define KEY73_ZYscl                kE2BT+48
#define KEY73_ZTmin                kE2BT+49
#define KEY73_ZTmax                kE2BT+50
#define KEY73_ZTStep               kE2BT+51
#define KEY73_ZOmin                kE2BT+52
#define KEY73_ZOmax                kE2BT+53
#define KEY73_ZOStep               kE2BT+54

#define KEY73_ABC                  kE2BT+55
#define KEY73_BC                   kE2BT+56
#define KEY73_AutoSimp             kE2BT+57
#define KEY73_ManSimp              kE2BT+58

#define KEY73_DelLast              kE2BT+59
#define KEY73_singleC              kE2BT+60
#define KEY73_MultiC               kE2BT+61

#define KEY73_Pic1                 kE2BT+62
#define KEY73_Pic2                 kE2BT+63
#define KEY73_Pic3                 kE2BT+64

#define KEY73_DelVar               kE2BT+65
#define KEY73_GetCalc              kE2BT+66

#define KEY73_Stndrd               kE2BT+67
#define KEY73_Param                kE2BT+68
#define KEY73_Polar                kE2BT+69
#define KEY73_AFillOn              kE2BT+70
#define KEY73_AFillOff             kE2BT+71
#define KEY73_ACalcOn              kE2BT+72
#define KEY73_ACalcOff             kE2BT+73

#define KEY73_SetConst             kE2BT+74

#define KEY73_GraphStyle           kE2BT+75

#define KEY73_ExprOn               kE2BT+76
#define KEY73_ExprOff              kE2BT+77
#define KEY73_StatA                kE2BT+78
#define KEY73_StatB                kE2BT+79
#define KEY73_StatC                kE2BT+80
#define KEY73_Corr                 kE2BT+81
#define KEY73_StatD                kE2BT+82
#define KEY73_StatE                kE2BT+83
#define KEY73_RegEq                kE2BT+84
#define KEY73_MinX                 kE2BT+85
#define KEY73_Q1                   kE2BT+86
#define KEY73_MD                   kE2BT+87
#define KEY73_Q3                   kE2BT+88
#define KEY73_MaxX                 kE2BT+89
#define KEY73_StatX1               kE2BT+90
#define KEY73_StatY1               kE2BT+91
#define KEY73_StatX2               kE2BT+92
#define KEY73_StatY2               kE2BT+93
#define KEY73_StatX3               kE2BT+94
#define KEY73_StatY3               kE2BT+95
#define KEY73_TblMin               kE2BT+96
#define KEY73_TblStep              kE2BT+97
#define KEY73_SetupLst             kE2BT+98
#define KEY73_ClrAllLst            kE2BT+99
#define KEY73_Logistic             kE2BT+100
#define KEY73_c1                   kE2BT+101   
#define KEY73_c2                   kE2BT+102   
#define KEY73_c3                   kE2BT+103   
#define KEY73_c4                   kE2BT+104   
#define KEY73_PlotStart            kE2BT+105   
#define KEY73_ZPlotStart           kE2BT+106   
#define KEY73_XFact                kE2BT+107   
#define KEY73_YFact                kE2BT+108   
#define KEY73_MaxY                 kE2BT+109   
#define KEY73_TblInput             kE2BT+110   
#define KEY73_PlotStep             kE2BT+111
#define KEY73_ZPlotStep            kE2BT+112
#define KEY73_SelectA              kE2BT+113
#define KEY73_ZFitA                kE2BT+114
#define KEY73_OneVar               kE2BT+115
#define KEY73_TwoVar               kE2BT+116
#define KEY73_LR                   kE2BT+117
#define KEY73_LRExp                kE2BT+118
#define KEY73_LRLn                 kE2BT+119


#define KEY73_MedMed               kE2BT+120
#define KEY73_Quad                 kE2BT+121
#define KEY73_ClrLst               kE2BT+122
#define KEY73_Hist                 kE2BT+123
#define KEY73_XYLine               kE2BT+124
#define KEY73_Scatter              kE2BT+125
#define KEY73_LR1                  kE2BT+126
#define KEY73_ClrTbl               kE2BT+127

// FC (ExtendEcho2) prefixed keys:

#define KE2BT2					0xfc00
#define KEY73_GDB1             0xfc00
#define KEY73_GDB2             0xfc01
#define KEY73_GDB3             0xfc02
#define KEY73_Y1               0xfc03
#define KEY73_Y2               0xfc04
#define KEY73_Y3               0xfc05
#define KEY73_Y4               0xfc06
#define KEY73_Y5               0xfc07
#define KEY73_Y6               0xfc08
#define KEY73_Y7               0xfc09
#define KEY73_Y8               0xfc0a
#define KEY73_Y9               0xfc0b
#define KEY73_Y0               0xfc0c
#define KEY73_X1T              0xfc0d
#define KEY73_Y1T              0xfc0e
#define KEY73_X2T              0xfc0f
#define KEY73_Y2T              0xfc10
#define KEY73_X3T              0xfc11
#define KEY73_Y3T              0xfc12
#define KEY73_X4T              0xfc13
#define KEY73_Y4T              0xfc14
#define KEY73_X5T              0xfc15
#define KEY73_Y5T              0xfc16
#define KEY73_X6T              0xfc17
#define KEY73_Y6T              0xfc18
#define KEY73_R1               0xfc19
#define KEY73_R2               0xfc1a
#define KEY73_R3               0xfc1b
#define KEY73_R4               0xfc1c
#define KEY73_R5               0xfc1d
#define KEY73_R6               0xfc1e
#define KEY73_GDB4             0xfc1f
#define KEY73_GDB5             0xfc20
#define KEY73_GDB6             0xfc21
#define KEY73_Pic4             0xfc22
#define KEY73_Pic5             0xfc23
#define KEY73_Pic6             0xfc24
#define KEY73_GDB7             0xfc25
#define KEY73_GDB8             0xfc26
#define KEY73_GDB9             0xfc27
#define KEY73_GDB0             0xfc28
#define KEY73_Pic7             0xfc29
#define KEY73_Pic8             0xfc2a
#define KEY73_Pic9             0xfc2b
#define KEY73_Pic0             0xfc2c
#define KEY73_StatN            0xfc2d
#define KEY73_XMean            0xfc2e



#define KEY73_LCM              0xfc32
#define KEY73_GCD              0xfc33
#define KEY73_RandInt          0xfc34
#define KEY73_RandNorm         0xfc35
#define KEY73_ToPolar          0xfc36
#define KEY73_ToRect           0xfc37
#define KEY73_YMean            0xfc38
#define KEY73_StdX             0xfc39
#define KEY73_StdX1            0xfc3a
#define KEY73_w0               0xfc3b
#define KEY73_MatF             0xfc3c
#define KEY73_MatG             0xfc3d
#define KEY73_MatRH            0xfc3e
#define KEY73_MatI             0xfc3f
#define KEY73_MatJ             0xfc40
#define KEY73_YMean1           0xfc41
#define KEY73_StdY             0xfc42
#define KEY73_StdY1            0xfc43
#define KEY73_MatToLst         0xfc44
#define KEY73_LstToMat         0xfc45
#define KEY73_CumSum           0xfc46
#define KEY73_DeltaLst         0xfc47
#define KEY73_StdDev           0xfc48
#define KEY73_Variance         0xfc49
#define KEY73_Length           0xfc4a
#define KEY73_EquToStrng       0xfc4b
#define KEY73_StrngToEqu       0xfc4c
#define KEY73_Expr             0xfc4d
#define KEY73_SubStrng         0xfc4e
#define KEY73_InStrng          0xfc4f
#define KEY73_Str1             0xfc50
#define KEY73_Str2             0xfc51
#define KEY73_Str3             0xfc52
#define KEY73_Str4             0xfc53
#define KEY73_Str5             0xfc54
#define KEY73_Str6             0xfc55
#define KEY73_Str7             0xfc56
#define KEY73_Str8             0xfc57
#define KEY73_Str9             0xfc58
#define KEY73_Str0             0xfc59
#define KEY73_SimpFact         0xfc5a
#define KEY73_PictPlot         0xfc5b
#define KEY73_CirclePlot       0xfc5c
#define KEY73_StemPlot         0xfc5d
#define KEY73_BarPlot          0xfc5e
#define KEY73_SumX             0xfc66
#define KEY73_SumX2            0xfc67

#define KEY73_SumY             0xfc68
#define XRes				   0xfc69

#define KEY73_SumY2            0xfc6a
#define KEY73_SumXY            0xfc6b
#define KEY73_uXRes            0xfc6c
#define KEY73_ModBox           0xfc6d
#define KEY73_NormProb         0xfc6e
#define KEY73_MinY             0xfc6f
#define KEY73_Ref              0xfc70
#define KEY73_RRef             0xfc71
#define KEY73_LRSqr            0xfc72
#define KEY73_BRSqr            0xfc73
#define KEY73_DiagOn           0xfc74
#define KEY73_DiagOff          0xfc75

#endif
