/*  tiffep - Ti File Format Engine & Proxy
 *  Copyright (C) 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * This file contains the commands use for communication
 * between tiffep and libtiffep
 */

#ifndef __TIFFEP_COMMANDS__
#define __TIFFEP_COMMANDS__

#include "tiffep.h"


/************/
/* Commands */
/************/
#define CMD_NONE           0 + 0
#define CMD_OK             0 + 1
#define CMD_NOK            0 + 2
#define CMD_ACK            0 + 3 // acknowledge
#define CMD_NAK            0 + 4 // not acknowledge
#define CMD_STRING         0 + 5 // send a string

#define CMD_ECHO           50 + 0
#define CMD_BROADCAST      50 + 1

#define CMD_EXEC_PLUGIN   100 + 0
#define CMD_EXEC_LINKPROG 100 + 1

#define CMD_TI_ISREADY       200 + 0
#define CMD_TI_SEND_KEY      200 + 1
#define CMD_TI_SCRDMP        200 + 2
#define CMD_TI_SEND_BACKUP   200 + 3
#define CMD_TI_RECV_BACKUP   200 + 4
#define CMD_TI_SEND_VAR      200 + 5
#define CMD_TI_RECV_VAR      200 + 6
#define CMD_TI_SEND_FLASH    200 + 7


/*******************/
/* Do not use them */
/*******************/
/* Cable functions */
#define CMD_INIT  1
#define CMD_OPEN  2
#define CMD_PUT   3
#define CMD_GET   4
#define CMD_PROBE 5
#define CMD_CLOSE 6
#define CMD_TERM  7
/* DLL functions */
#define CMD_CHOOSE   8
#define CMD_STIMEOUT 9
#define CMD_GTIMEOUT 10
#define CMD_SDELAY   11
#define CMD_GDELAY   12


/*************/
/* Functions */
/*************/
#define is_msg_none(x)   ((x.cmd) == CMD_NONE) 
#define is_msg_ok(x)     ((x.cmd) == CMD_OK)
#define is_msg_nok(x)    ((x.cmd) == CMD_NOK)
#define is_msg_ack(x)    ((x.cmd) == CMD_ACK)
#define is_msg_nak(x)    ((x.cmd) == CMD_NAK)
#define is_msg_string(x) ((x.cmd) == CMD_STRING)

#define is_cmd_exec_plugin(x)   ((x) == CMD_EXEC_PLUGIN)
#define is_cmd_exec_linkprog(x) ((x) == CMD_EXEC_LINKPROG)

TIEXPORT int cmd_remove           (TiffepShm s);
TIEXPORT int cmd_is_available     (TiffepShm s);

TIEXPORT int cmd_send_ack         (TiffepShm s);
TIEXPORT int cmd_send_nak         (TiffepShm s);
TIEXPORT int cmd_send_ok          (TiffepShm s);
TIEXPORT int cmd_send_nok         (TiffepShm s);

TIEXPORT int cmd_send_exec_plugin (TiffepShm s, gchar *path, gchar* filename);
TIEXPORT int cmd_send_string      (TiffepShm s, char *str);
TIEXPORT int cmd_send_sbackup     (TiffepShm s, char *backup_file);
TIEXPORT int cmd_send_rbackup     (TiffepShm s, char *backup_file);
TIEXPORT int cmd_send_echo        (TiffepShm s);

TIEXPORT int cmd_recv_ack    (TiffepShm s);
TIEXPORT int cmd_recv_nak    (TiffepShm s);
TIEXPORT int cmd_recv_ok     (TiffepShm s);
TIEXPORT int cmd_recv_nok    (TiffepShm s);

TIEXPORT int cmd_recv_string (TiffepShm s, char **str);


/**********************/
/* Exported functions */
/**********************/

#define tiffep_cmd_remove			cmd_remove
#define tiffep_cmd_is_available		cmd_is_available

#define tiffep_cmd_send_ack         cmd_send_ack
#define tiffep_cmd_send_nak         cmd_send_nak
#define tiffep_cmd_send_ok          cmd_send_ok
#define tiffep_cmd_send_nok         cmd_send_nok 

#define tiffep_cmd_send_exec_plugin cmd_send_exec_plugin
#define tiffep_cmd_send_string      cmd_send_string
#define tiffep_cmd_send_sbackup     cmd_send_sbackup
#define tiffep_cmd_send_rbackup     cmd_send_rbackup
#define tiffep_cmd_send_echo        cmd_send_echo

#define tiffep_cmd_recv_ack         cmd_recv_ack
#define tiffep_cmd_recv_nak         cmd_recv_nak
#define tiffep_cmd_recv_ok          cmd_recv_ok
#define tiffep_cmd_recv_nok         cmd_recv_nok
#define tiffep_cmd_recv_string      cmd_recv_string

#endif

