/*  tiffep - Ti File Format Engine & Proxy
 *  Copyright (C) 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * This file contains the commands use for communication
 * between tiffep and libtiffep
 */

#ifndef __TIFFEP_MESSAGES__
#define __TIFFEP_MESSAGES__

#include "tiffep.h"

/*****************/
/* Basic message */
/*****************/

#define STR_LEN 1024
struct tiffep_msg_
{
  int type; // type of emitter
  int id;   // id of emitter
  int cmd;  // command (used for dispatching the request)
  int ack;  // acknoledgement
  int len;  // length of data (used only when transmitting splitted strings 
  int data; // raw data (string, int, and so on...)
  char str[STR_LEN+1];
};
typedef struct tiffep_msg_ TiffepMsg;
#define TiffepMsgSize (sizeof(TiffepMsg))


/*******************************/
/* Type of the message emitter */
/*******************************/

#define TP_UNKNOWN  0
#define TP_TIFFEP   1
#define TP_LINKPROG 2
#define TP_PLUGIN   3


/*************/
/* Functions */
/*************/

int msg_clear (       TiffepMsg *m);
int msg_send  (TiffepShm s, TiffepMsg  m);
TIEXPORT int msg_recv  (TiffepShm s, TiffepMsg *m);
TIEXPORT int msg_check (TiffepShm s);
#define msg_is_available msg_check
int msg_remove(TiffepShm s);


/**********************/
/* Exported functions */
/**********************/

#define tiffep_msg_clear        msg_clear
#define tiffep_msg_send         msg_send 
#define tiffep_msg_recv         msg_recv
#define tiffep_msg_is_available msg_is_available
#define tiffep_msg_remove       msg_remove

#endif


