# -*- ruby -*-
#
# Select nodes without attributes, sort and reverse them.
#

require 'xtemplate'

data = {
  'members' => [
    {'name' => 'name1', 'age' => 21, '@uid' => 1},
    {'name' => 'name2', 'age' => 23, '@uid' => 2},
    {'name' => 'name3', 'age' => 22, '@uid' => 3},
    {'name' => 'name4', 'age' => 25, '@uid' => 4},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members>
  <member id="members[age &gt; 21]{node();sort(age);reverse()}">
     <name id="name" />
     <age id="age" />
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
