/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Id$
*/
#ifndef MAGPIE_H
#define MAGPIE_H

extern const char *sections[];
extern const char *categories[];
extern const char *priorities[];
extern const char *architectures[];

#define CNT_SECTIONS		11
#define CNT_CATEGORIES		30
#define CNT_PRIORITIES		5
#define CNT_ARCHITECTURES	8

#define MAX_DESCCNT	100

/*+
This structure describes a list of packages.
+*/
struct package_list {
	char *name;
	char *restriction;
	struct package_list *next;	/* and... */
	struct package_list *down;  /* or... */
};

/*+
This structure describes a single package.
+*/
struct package_info {
	char *name;
	char *version;
	int priority;
	int section;
	int category;
	int essential;
	char *filename;
	char *maintainer;
	char *md5sum;
	char *summary;
	int architecture;
	long size;
	long installed_size;
	char *status[3];
	char *config_version;

	int desccnt;
	char *description[MAX_DESCCNT];

	int cfcnt;
	char *conffiles[MAX_DESCCNT];

	struct package_list *source;
	struct package_list *depends;
	struct package_list *predepends;
	struct package_list *recommends;
	struct package_list *suggests;
	struct package_list *conflicts;
	struct package_list *replaces;
	struct package_list *provides;

	struct package_list *r_depends;
	struct package_list *r_recommends;
	struct package_list *r_suggests;

	int installed;
	int unpacked;

	int dupfile;

	char *installed_version;

	char *tag;
	int selected;
	int flag;	/* description vs conffiles flag */
};

#define MAGPIE_VERSION				((0 << 16) | (1 << 8) | (0))

#define	MAGPIE_ALL_PACKAGES			0
#define	MAGPIE_INSTALLED_PACKAGES	1

/*+
This package describes a magpie module.
+*/
struct magpie_module {
	int version;
	int status;
	const char *description;
	int (*database) (void);
	int (*init) (void);
	int (*cleanup) (void);
	int (*annotated_index) (FILE *, int);
	int (*unannotated_index) (FILE *, int);
	int (*miscellaneous) (FILE *);
} magpie_module;


/*+
We use a simple array to access the structures allocated by the
parser.  This allows us to easily sort the contents.
+*/
extern struct package_info *cache[];
extern int cachecnt;

/*+
arrays containing the number of packages in each category.  This
allows us to avoid creating empty files.
+*/
extern int matrixcnt_s[CNT_SECTIONS];
extern int matrixcnt_sc[CNT_SECTIONS][CNT_CATEGORIES];
extern int matrixcnt_scp[CNT_SECTIONS][CNT_CATEGORIES][CNT_PRIORITIES];
extern int matrixcnt_sp[CNT_SECTIONS][CNT_PRIORITIES];
extern int matrixcnt_p[CNT_PRIORITIES];

extern struct package_info *mp_lookup (const char *name);

extern int gzip (const char *);


extern void mp_text (FILE *fp, const char *s);

extern void mp_doc_open (FILE *fp, const char *fmt,...);
extern void mp_doc_close (FILE *fp);

extern void mp_abstract (FILE *fp, const char *fmt,...);

extern void mp_name (FILE *fp, const char *name);
extern void mp_url (FILE *fp, const char *fmt1, const char *fmt2,...);

extern void mp_title (FILE *fp, int level, const char *fmt,...);
extern void mp_title_open (FILE *fp, int level, const char *fmt,...);
extern void mp_title_close (FILE *fp, int level);

extern void mp_list_open (FILE *fp);
extern void mp_list_close (FILE *fp);

extern void mp_item_open (FILE *fp);
extern void mp_item_close (FILE *fp);

extern void mp_literal_open (FILE *fp);
extern void mp_literal_close (FILE *fp);

extern void mp_nbsp (FILE *fp);
extern void mp_break (FILE *fp);

extern void mp_tt (FILE *fp, const char *str);

extern void mp_tag (FILE *fp, const char *fmt,...);

extern void mp_item (FILE *fp, const struct package_list *d);

extern void mp_package (FILE *fp, struct package_info *p, int mode, int type);

extern void mp_histogram (FILE *fp, const int data[], int nelms);

#endif
