



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include "config.h"
#include "mailleds.h"


extern int uid;
extern sig_atomic_t exit_now;
extern char *username;
extern char opt_u;

char *
 get_mailfile()
{
	char *mailfile;
	if (opt_u || (mailfile = getenv("MAIL")) == (char *) NULL) {
		mailfile = xmalloc((strlen(MAILDIR) + 1 + strlen(username) + 1) * sizeof(char));
		sprintf(mailfile, "%s/%s", MAILDIR, username);
	}
	return (mailfile);
}

int count_occurences(file, exp)
FILE *file;
char *exp;
{
	char buf[1024];
	int len, matches;

	len = strlen(exp);
	matches = 0;

	while (fgets(buf, 1024, file) != NULL) {
		if (strncmp(buf, exp, len) == 0)
			matches++;
	}

	rewind(file);
	return (matches);
}

/* Subtract messages from messages w/ a "status:" line to get new messages */
int count_mail(mailbox)
FILE *mailbox;
{
	int From, Status;
	From = count_occurences(mailbox, "From ");
	Status = count_occurences(mailbox, "Status: R");
	return (From - Status);
}

/* Test and open the mailbox file -- hang on the mailbox if -f */
FILE *
 open_mailbox_file(file)
char *file;
{
	FILE *mailbox;
	char *errmsg;
	if ((mailbox = fopen(file, "r")) == (FILE *) NULL) {
		if (errno == ENOENT) {
			while ((mailbox = fopen(file, "r")) == NULL) {
				if (exit_now)
					exit_cleanly();
				sleep(INTERVAL_BETWEEN_CHECKS);
			}
		} else {
			errmsg = xmalloc((strlen("mailleds: ") + strlen(file) + 1) * sizeof(char));
			sprintf(errmsg, "mailleds: %s", file);
			perror(errmsg);
			exit_fatal("Cannot read mailbox file");
		}
	}
	return (mailbox);
}
