/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <kurl.h>
#include <kurldrag.h>
#include "composertextedit.h"

namespace Mailody {

ComposerTextEdit::ComposerTextEdit(QWidget* parent)
    : KTextEdit( parent )
{
}

void ComposerTextEdit::contentsDropEvent(QDropEvent *e)
{
    // looked at KMail for a hint how to do this.
    if(KURLDrag::canDecode(e))
    {
        KURL::List urlList;
        if(KURLDrag::decode(e, urlList))
        {
            for ( KURL::List::Iterator it = urlList.begin();
                     it != urlList.end(); ++it )
                emit addAttachment(*it);
        }
    }
}


}

#include "composertextedit.moc"
