#   MailScanner - SMTP E-Mail Virus Scanner
#   Copyright (C) 2001  Julian Field
#
#   $Id: logger.pl,v 1.7 2001/12/10 16:49:50 nwp Exp $
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The author, Julian Field, can be contacted by email at
#      Jules@JulianField.net
#   or by paper mail at
#      Julian Field
#      Dept of Electronics & Computer Science
#      University of Southampton
#      Southampton
#      SO17 1BJ
#      United Kingdom
#

###########################################################
# Syslog library calls
###########################################################

use strict;
use Sys::Syslog;

package Log;

sub Start {
  Sys::Syslog::openlog(@_, 'pid, nowait', 'mail');
}

sub Stop {
  Sys::Syslog::closelog();
}

sub DieLog {
  # Bug fix here thanks to Nick Phillips
  # (closelog changes $! in @_)
  my(@x) = @_;
  
  my $logmessage = sprintf shift @x, @x;
  
  foreach(split /\n/,$logmessage) {
      Sys::Syslog::syslog('err', $_);
  }

  Sys::Syslog::closelog();
  die $logmessage;
}

sub WarnLog {
  my(@x) = @_;
  Sys::Syslog::syslog('warning', @_);
  #warn sprintf shift @x, @x;
}

sub InfoLog {
  my(@x) = @_;
  Sys::Syslog::syslog('info', @_);
  #print "@x\n";
}

sub DebugLog {
  my(@x) = @_;
  Sys::Syslog::syslog('debug', @_) if $Config::Debugging;
  #print "@x\n";
}

1;
