/*
                            Color Selection Dialog
 */

#ifndef CSD_H
#define CSD_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Color selection dialog color structure:
 */
typedef struct {

	/* Color values as coefficent in [0.0, 1.0]. */
	gdouble r, g, b, a;


	/* Indicates that member gdk_color is allocated. */
	gbool gdk_color_is_allocated;

	/* Current allocated GdkColor for this color. */
	GdkColor gdk_color;

} csd_color_struct;


extern gint CSDInit(void);
extern void CSDSetTransientFor(GtkWidget *w);
extern gbool CSDIsQuery(void);
extern void CSDBreakQuery(void);
extern gbool CSDGetResponse(
        const gchar *title,
        const gchar *ok_label, const gchar *cancel_label,
	csd_color_struct *start_color,
	csd_color_struct **color_rtn,
	gpointer client_data,
	void (*color_changed_cb)(gpointer, csd_color_struct *)
);
extern void CSDMap(void);
extern void CSDUnmap(void);
extern void CSDShutdown(void);


#endif	/* CSD_H */
