/*
             Manual Page Editor: DND Handling and Callbacks
 */

#ifndef EDITORDND_H
#define EDITORDND_H

#include <gtk/gtk.h>

#include "editor.h"


extern void EditorDNDParseCmd(
        const char *string,
        editor_struct **editor_ptr,
        GtkCTreeNode ***branch, int *total_branches
);
extern gchar *EditorDNDParseURL(
        const gchar *string, gint len
);

extern void EditorDNDSetIcon(
        editor_struct *editor, editor_item_struct *item_ptr
);
extern void EditorDNDDataRequestCB(
        GtkWidget *widget, GdkDragContext *dc,
        GtkSelectionData *selection_data, guint info, guint t,
        gpointer data
);
extern void EditorDNDDataRecievedCB(
        GtkWidget *widget,
        GdkDragContext *dc,
        gint x, gint y,
        GtkSelectionData *selection_data,
        guint info, guint t,
        gpointer data
);
extern void EditorDNDDataDeleteCB(
        GtkWidget *widget, GdkDragContext *dc, gpointer data
);

#endif	/* EDITORDND_H */
