/*
                              Manual Page Editor
 */

#ifndef MANEDIT_H
#define MANEDIT_H

#include <sys/types.h>

#ifdef _AIX
# include <stdlib.h>
# include <strings.h>
#endif

#include <gtk/gtk.h>

#include "fb.h"

#include "editor.h"
#include "viewer.h"
#include "pref.h"
#include "aboutdialog.h"


#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Program name and version:
 */
#define PROG_NAME	"Manual Page Editor"
#define PROG_VERSION	"0.5.6"

#define PROG_VERSION_MAJOR	0
#define PROG_VERSION_MINOR	5
#define PROG_VERSION_RELEASE	6

/*
 *	Program copyright:
 */
#define PROG_COPYRIGHT	"\
Copyright (C) 2000-2002 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law."

/*
 *	Program usage message:
 */
#define PROG_USAGE_MESG	"\
Usage: manedit [manual_page] [options] [GUI_options]\n\
\n\
    [manual_page] is the path to the manual page file you want to\n\
    open on start up.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --rcfile <file>         Load configuration from <file>.\n\
        -f                      Same as --rcfile.\n\
        --viewer                Start up with a viewer instead of an\n\
                                editor.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    Most customizations can be performed in the options menu.\n\
\n\
    Command line options override any options in the configuration file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult your\n\
    GUI's manual for available options.\n\
\n"


/*
 *	Default editor size in pixels:
 */
#define MEDIT_DEF_WIDTH		800
#define MEDIT_DEF_HEIGHT	600

/*
 *	Default viewer size in pixels.
 */
#define MEDIT_VIEWER_DEF_WIDTH	640
#define MEDIT_VIEWER_DEF_HEIGHT	512

/*
 *	Default Preferences & Options window size in pixels:
 */
#define MEDIT_PREF_DEF_WIDTH	640
#define MEDIT_PREF_DEF_HEIGHT	480

/*
 *	Default paned widget size in pixels:
 */
#define MEDIT_DEF_PANED_GUTTER_SIZE	12
#define MEDIT_DEF_PANED_HANDLE_SIZE	10

/*
 *	Spacing between list item icons and text in pixels:
 */
#define MEDIT_LIST_ICON_TEXT_SPACING	2


/*
 *	Viewer window title:
 */
#define MEDIT_VIEWER_TITLE	"Manual Page Viewer"

/*
 *	Preferences & Options window title:
 */
#define MEDIT_PREF_TITLE	"Manual Page Editor: Preferences"


/*
 *	Global marker to close all windows if set to TRUE:
 */
extern gbool need_close_all_windows;

/*
 *	Global switch to use gtk_text_*() function for GtkText widget
 *	text deleting instead of gtk_editable_*() functions.
 */
extern gbool use_text_delete;


/*
 *	Pointer cursors list structure:
 */
typedef struct {

	GdkCursor	*busy,
			*text;

} medit_cursors_list_struct;

/*
 *	Styles list structure:
 */
typedef struct {

	/* Each style contains a loaded GdkFont and allocated colors.
	 * Each loaded GdkFont will have a ref count of atleast one.
	 */
	GtkStyle	*standard,		/* Do not unref, this
						 * came from GTK internal.
						 */
			*heading1_text,
			*heading2_text,
			*heading3_text,
			*heading4_text,
			*heading5_text,
			*heading6_text,

			*heading1_rev_text,
			*heading2_rev_text,
			*heading3_rev_text,
			*heading4_rev_text,

			*edit_text_standard,	/* Standard. */
			*edit_text_background,	/* Background. */
			*edit_text_tag_deliminator,	/* Tag deliminator. */
			*edit_text_tag_text,	/* Tag text. */
			*edit_text_tag_symrep,	/* Symbol representation. */
			*manpage_text_standard,	/* Manpage output std. */
			*manpage_text_background,	/* Manpage bg. */
			*manpage_text_bold,	/* Manpage output bold. */
			*manpage_text_underline;	/* Manpage output underline. */

} medit_styles_list_struct;

/*
 *	Pixmaps list structure:
 */
typedef struct {

	GdkPixmap	*medit_icon_48x48;
	GdkBitmap	*medit_icon_48x48_mask;

	/* Icons for list items. */
	GdkPixmap       *folder_closed_20x20;
	GdkBitmap       *folder_closed_20x20_mask;

        GdkPixmap       *folder_opened_20x20;
        GdkBitmap       *folder_opened_20x20_mask;

	GdkPixmap	*manual_closed_20x20;
	GdkBitmap	*manual_closed_20x20_mask;

	GdkPixmap	*manual_opened_20x20;
	GdkBitmap	*manual_opened_20x20_mask;

	GdkPixmap	*manpage_heading_20x20;
	GdkBitmap	*manpage_heading_20x20_mask;

	GdkPixmap	*manpage_section_20x20;
	GdkBitmap	*manpage_section_20x20_mask;

} medit_pixmaps_list_struct;

/*
 *	File extensions type list structure:
 */
typedef struct {

	fb_type_struct		**manual_page;
	int			total_manual_pages;

} medit_fetype_list_struct;


/*
 *	Manual page editor core structure:
 */
typedef struct {

	int untitled_count;

	gbool	alt_key_state,
		control_key_state,
		shift_key_state;

	medit_cursors_list_struct cursors_list;
	medit_styles_list_struct styles_list;
	medit_pixmaps_list_struct pixmaps_list;
	medit_fetype_list_struct fetype_list;

	/* Need to add file paths here. */

	/* Editor windows. */
	editor_struct **editor;
	int total_editors;

	/* Viewer windows. */
	viewer_struct **viewer;
	int total_viewers;

	/* Preferences window struct. */
	pref_struct *pref;

	/* About dialog struct. */
	about_dialog_struct *about;

} medit_core_struct;
extern medit_core_struct *context_core_ptr;


extern int MEditInit(medit_core_struct *core_ptr, int argc, char **argv);
extern gint MEditManage(gpointer data);
extern void MEditShutdown(medit_core_struct *core_ptr);




#endif	/* MANEDIT_H */
