/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

// 34 Verticies
// 40 Texture Coordinates
// 49 Normals
// 64 Triangles

static char TUNA_face_indicies[64][9] = {
// ChamferCyl
	{0,1,2 ,0,0,0 ,0,1,2 }, {0,2,3 ,0,0,0 ,0,2,3 }, {0,3,4 ,0,0,0 ,0,3,4 },
	{0,4,5 ,0,0,0 ,0,4,5 }, {0,5,6 ,0,0,0 ,0,5,6 }, {0,6,7 ,0,0,0 ,0,6,7 },
	{0,7,8 ,0,0,0 ,0,7,8 }, {0,8,1 ,0,0,0 ,0,8,1 }, {1,9,10 ,1,2,3 ,1,9,10 },
	{1,10,2 ,1,3,4 ,1,10,2 }, {2,10,11 ,4,3,5 ,2,10,11 }, {2,11,3 ,4,5,6 ,2,11,3 },
	{3,11,12 ,6,5,7 ,3,11,12 }, {3,12,4 ,6,7,8 ,3,12,4 }, {4,12,13 ,8,7,9 ,4,12,13 },
	{4,13,5 ,8,9,10 ,4,13,5 }, {5,13,14 ,10,9,11 ,5,13,14 }, {5,14,6 ,10,11,12 ,5,14,6 },
	{6,14,15 ,12,11,13 ,15,16,17 }, {6,15,7 ,12,13,14 ,15,17,18 },
	{7,15,16 ,14,13,15 ,18,17,19 }, {7,16,8 ,14,15,16 ,7,20,8 },
	{8,16,9 ,16,15,2 ,8,20,9 }, {8,9,1 ,16,2,1 ,8,9,1 }, {9,17,18 ,17,17,17 ,21,22,23 },
	{9,18,10 ,17,17,17 ,21,23,24 }, {10,18,19 ,18,18,18 ,24,23,25 },
	{10,19,11 ,18,18,18 ,24,25,26 }, {11,19,20 ,19,19,19 ,26,25,27 },
	{11,20,12 ,19,19,19 ,26,27,28 }, {12,20,21 ,20,20,20 ,28,27,29 },
	{12,21,13 ,20,20,20 ,28,29,30 }, {13,21,22 ,21,21,21 ,30,29,31 },
	{13,22,14 ,21,21,21 ,30,31,32 }, {14,22,23 ,22,22,22 ,32,31,33 },
	{14,23,15 ,22,22,22 ,32,33,34 }, {15,23,24 ,23,23,23 ,34,33,35 },
	{15,24,16 ,23,23,23 ,34,35,36 }, {16,24,17 ,24,24,24 ,36,35,37 },
	{16,17,9 ,24,24,24 ,36,37,38 }, {17,25,26 ,25,26,27 ,9,1,2 },
	{17,26,18 ,28,27,28 ,9,2,10 }, {18,26,27 ,29,27,30 ,10,2,3 },
	{18,27,19 ,29,30,29 ,10,3,11 }, {19,27,28 ,31,30,32 ,11,3,4 },
	{19,28,20 ,33,32,33 ,11,4,12 }, {20,28,29 ,34,32,35 ,12,4,5 },
	{20,29,21 ,36,35,36 ,12,5,13 }, {21,29,30 ,37,35,38 ,13,5,6 },
	{21,30,22 ,39,38,39 ,13,6,14 }, {22,30,31 ,40,38,41 ,14,6,7 },
	{22,31,23 ,42,41,42 ,16,18,17 }, {23,31,32 ,43,41,44 ,17,18,39 },
	{23,32,24 ,45,44,45 ,17,39,19 }, {24,32,25 ,46,44,26 ,20,8,1 },
	{24,25,17 ,47,26,47 ,20,1,9 }, {25,33,26 ,48,48,48 ,1,0,2 },
	{26,33,27 ,48,48,48 ,2,0,3 }, {27,33,28 ,48,48,48 ,3,0,4 }, {28,33,29 ,48,48,48 ,4,0,5 },
	{29,33,30 ,48,48,48 ,5,0,6 }, {30,33,31 ,48,48,48 ,6,0,7 }, {31,33,32 ,48,48,48 ,7,0,8 },
	{32,33,25 ,48,48,48 ,8,0,1 }
};
static GLfloat TUNA_vertices [34][3] = {
{-2.55468e-08f,0.0f,0.0669694f},{0.161875f,0.0329338f,0.0669694f},{0.0911751f,0.137751f,0.0669694f},
{-0.0329339f,0.161875f,0.0669694f},{-0.137751f,0.0911751f,0.0669694f},{-0.161875f,-0.0329339f,0.0669694f},
{-0.0911752f,-0.137751f,0.0669694f},{0.0329338f,-0.161875f,0.0669694f},{0.137751f,-0.0911751f,0.0669694f},
{0.175f,0.0356041f,0.0535755f},{0.0985677f,0.14892f,0.0535755f},{-0.0356042f,0.175f,0.0535755f},
{-0.14892f,0.0985677f,0.0535755f},{-0.175f,-0.0356042f,0.0535755f},{-0.0985677f,-0.14892f,0.0535755f},
{0.0356041f,-0.175f,0.0535755f},{0.14892f,-0.0985677f,0.0535755f},{0.175f,0.0356041f,-0.0535755f},
{0.0985677f,0.14892f,-0.0535755f},{-0.0356042f,0.175f,-0.0535755f},{-0.14892f,0.0985677f,-0.0535755f},
{-0.175f,-0.0356042f,-0.0535755f},{-0.0985677f,-0.14892f,-0.0535755f},{0.0356041f,-0.175f,-0.0535755f},
{0.14892f,-0.0985677f,-0.0535755f},{0.161875f,0.0329338f,-0.0669694f},{0.0911751f,0.137751f,-0.0669694f},
{-0.0329339f,0.161875f,-0.0669694f},{-0.137751f,0.0911751f,-0.0669694f},{-0.161875f,-0.0329339f,-0.0669694f},
{-0.0911752f,-0.137751f,-0.0669694f},{0.0329338f,-0.161875f,-0.0669694f},{0.137751f,-0.0911751f,-0.0669694f},
{-2.55468e-08f,0.0f,-0.0669694f}
};
static GLfloat TUNA_normals [49][3] = {
{0.0f,0.0f,1.0f},{0.67026f,0.235526f,0.703761f},{0.709005f,0.0450889f,0.703761f},
{0.469459f,0.533225f,0.703761f},{0.307404f,0.640487f,0.703761f},{-0.0450889f,0.709005f,0.703761f},
{-0.235526f,0.67026f,0.703761f},{-0.533225f,0.469459f,0.703761f},{-0.640487f,0.307404f,0.703761f},
{-0.709005f,-0.0450892f,0.703761f},{-0.67026f,-0.235526f,0.70376f},{-0.46946f,-0.533225f,0.70376f},
{-0.307404f,-0.640487f,0.70376f},{0.045089f,-0.709005f,0.703761f},{0.235526f,-0.67026f,0.703761f},
{0.533225f,-0.469459f,0.703761f},{0.640487f,-0.307404f,0.703761f},{0.829038f,0.559193f,0.0f},
{0.190809f,0.981627f,0.0f},{-0.559193f,0.829038f,0.0f},{-0.981627f,0.190809f,0.0f},
{-0.829038f,-0.559193f,0.0f},{-0.190809f,-0.981627f,0.0f},{0.559193f,-0.829037f,0.0f},
{0.981627f,-0.190809f,0.0f},{0.608936f,0.410733f,-0.678598f},{0.709005f,0.0450889f,-0.703761f},
{0.469459f,0.533225f,-0.703761f},{0.608936f,0.410733f,-0.678598f},{0.140151f,0.721014f,-0.678598f},
{-0.0450889f,0.709005f,-0.703761f},{-0.410733f,0.608936f,-0.678598f},{-0.533225f,0.469459f,-0.703761f},
{-0.410733f,0.608936f,-0.678598f},{-0.721015f,0.140151f,-0.678598f},{-0.709005f,-0.0450891f,-0.703761f},
{-0.721015f,0.140151f,-0.678598f},{-0.608936f,-0.410733f,-0.678598f},{-0.46946f,-0.533225f,-0.70376f},
{-0.608936f,-0.410733f,-0.678598f},{-0.140151f,-0.721015f,-0.678598f},{0.045089f,-0.709005f,-0.703761f},
{-0.140151f,-0.721015f,-0.678598f},{0.410733f,-0.608936f,-0.678598f},{0.533225f,-0.469459f,-0.703761f},
{0.410733f,-0.608936f,-0.678598f},{0.721014f,-0.140151f,-0.678598f},{0.721014f,-0.140151f,-0.678598f},
{0.0f,0.0f,-1.0f}
};
static GLfloat TUNA_textures [40][2] = {
{0.5f,0.5f},{0.9625f,0.5f},{0.827037f,0.827037f},
{0.5f,0.9625f},{0.172963f,0.827037f},{0.0375f,0.5f},
{0.172963f,0.172963f},{0.5f,0.0375f},{0.827037f,0.172963f},
{1.0f,0.5f},{0.853553f,0.853553f},{0.5f,1.0f},
{0.146447f,0.853553f},{0.0f,0.5f},{0.146447f,0.146447f},
{0.172963f,1.17296f},{0.146447f,1.14645f},{0.5f,1.0f},
{0.5f,1.0375f},{0.853553f,1.14645f},{0.853553f,0.146447f},
{0.0f,2.0f},{0.0f,1.0f},{0.125f,1.0f},
{0.125f,2.0f},{0.25f,1.0f},{0.25f,2.0f},
{0.375f,1.0f},{0.375f,2.0f},{0.5f,1.0f},
{0.5f,2.0f},{0.625f,1.0f},{0.625f,2.0f},
{0.75f,1.0f},{0.75f,2.0f},{0.875f,1.0f},
{0.875f,2.0f},{1.0f,1.0f},{1.0f,2.0f},
{0.827037f,1.17296f}
};

GLint genListeTunasBox()
{
  unsigned int i;
  int j;

  GLint lid = 0;

  lid = glGenLists(1);

  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(TUNA_face_indicies) / sizeof(TUNA_face_indicies[0]); i++)
  {

    for (j = 0; j < 3; j++)
    {
      int vi = TUNA_face_indicies[i][j];
      int ni = TUNA_face_indicies[i][j + 3]; // Normal index
      int ti = TUNA_face_indicies[i][j + 6]; // Texture index

      glNormal3f(TUNA_normals[ni][0], TUNA_normals[ni][1], TUNA_normals[ni][2]);
      glTexCoord2f(TUNA_textures[ti][0], TUNA_textures[ti][1]);
      glVertex3f(TUNA_vertices[vi][0], TUNA_vertices[vi][1], TUNA_vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
};