/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "menus.h"

extern player_t *player;
extern game_data_t *world;
extern char *filename;

hud_t *hud;

const char *i_vie = SHXMAN_DATA "hud/vie.png";
char *i_mask_vie = SHXMAN_DATA "hud/vie_mask.png";

const char *i_aiguille = SHXMAN_DATA "hud/boussole_aiguille.png";
const char *i_mask_aiguille = SHXMAN_DATA "hud/boussole_aiguille_mask.png";
const char *i_boussole_socle = SHXMAN_DATA "hud/boussole_socle.png";
const char *i_mask_boussole_socle = SHXMAN_DATA "hud/boussole_socle_mask.png";

const char *i_barre[N_TEXTURES_BARRE] = 
{
    SHXMAN_DATA "hud/interf_01m.png", // 0
    SHXMAN_DATA "hud/interf_01.png", 

    SHXMAN_DATA "hud/interf_02m.png", 
    SHXMAN_DATA "hud/interf_02.png", 
    SHXMAN_DATA "hud/interf_03m.png", 
    SHXMAN_DATA "hud/interf_03.png", 
    SHXMAN_DATA "hud/interf_04m.png", 
    SHXMAN_DATA "hud/interf_04.png", 

    SHXMAN_DATA "hud/interf_05m.png", // 8
    SHXMAN_DATA "hud/interf_05.png", 

    SHXMAN_DATA "hud/interf_06m.png", // 10
    SHXMAN_DATA "hud/interf_06.png", 

    SHXMAN_DATA "hud/interf_07m.png",
    SHXMAN_DATA "hud/interf_07.png", 
    
    SHXMAN_DATA "hud/interf_11m.png", // 14
    SHXMAN_DATA "hud/interf_11.png", 
    SHXMAN_DATA "hud/interf_12m.png",
    SHXMAN_DATA "hud/interf_12.png", 
    SHXMAN_DATA "hud/interf_13m.png",
    SHXMAN_DATA "hud/interf_13.png", 
    SHXMAN_DATA "hud/interf_14m.png",
    SHXMAN_DATA "hud/interf_14.png",

    SHXMAN_DATA "hud/interf_21m.png", 
    SHXMAN_DATA "hud/interf_21.png", 
    SHXMAN_DATA "hud/interf_22m.png",
    SHXMAN_DATA "hud/interf_22.png", 
    SHXMAN_DATA "hud/interf_23m.png",
    SHXMAN_DATA "hud/interf_23.png",   

    SHXMAN_DATA "hud/interf_31m.png", 
    SHXMAN_DATA "hud/interf_31.png", 
    SHXMAN_DATA "hud/interf_32m.png",
    SHXMAN_DATA "hud/interf_32.png", 
};

const char *i_Bstocks[4]=
{
    SHXMAN_DATA "hud/stock1.png",
    SHXMAN_DATA "hud/stock2.png",
    SHXMAN_DATA "hud/stock3.png",
    SHXMAN_DATA "hud/stock4.png"
};

void draw_HUD()
{
  glPushMatrix();
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, hud->mat_amb_diff);

  glEnable(GL_TEXTURE_2D);

  draw_bottom_bar();

  draw_full_minimap();
  draw_stocks();
  draw_lives();
  draw_active_bonus();
  draw_compas();

  draw_message_box();  

  glPopMatrix();
  //glPushMatrix();
  glDisable(GL_TEXTURE_2D);
  //glEnable(GL_LIGHTING);

  hud->tgaFont[1].SetSize(18);
  hud->tgaFont[1].Color3f(1.0, 1.0, 1.0);
  hud->tgaFont[1].SetShadow(1);
  hud->tgaFont[1].ShadowColor3f(0.0, 0.0, 0.0);
  hud->tgaFont[1].Draw(666, 520, "%.5d", player->score);

  hud->tgaFont[0].SetSize(12);
  hud->tgaFont[0].Color3f(0.0, 0.0, 0.0);
  if (world->time_limit > 0) {
    hud->tgaFont[0].Draw(725, 63, "%.2d:%.2d", world->game_timer->getRestMin(),
                 world->game_timer->getRestSec());
  }

  else {
    hud->tgaFont[0].Draw(725, 63, "%.2d:%.2d", world->game_timer->getMinutes(),
                 world->game_timer->getSecondes());

  }

  hud->tgaFont[0].SetSize(12);
  hud->tgaFont[0].Color3f(1.0, 1.0, 1.0);
  hud->tgaFont[0].Draw(666, 580, "FPS: %d", world->game_sync->getFpsInstant());

  hud->tgaFont[0].SetSize(12);
  hud->tgaFont[0].Color3f(1.0, 1.0, 1.0);
  hud->tgaFont[0].Draw(618, 560, "average: %0.0f", world->game_sync->getMoyenneFps());

  hud_update_messages();

  if (world->game_paused) draw_pause();

  switch (player->status)
    {
    case STATUS_WAITING: draw_waiting(); break;
    case STATUS_DEAD: draw_dead(); break;
    case GAME_OVER: draw_gameover(); break;
    case STATUS_WIN: draw_you_win(); break;

    }

  if (hud->draw_bigminimap) 
    draw_big_hud_map();
  //glPopMatrix(); /* CHANGED */

  if (world->in_ingame_menu) {
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);
    draw_ingame_menu();
  }


  glEnable(GL_TEXTURE_2D);
}

int load_hud()
{
  hud = new hud_t;
  hud->t_barre = new GLuint [N_TEXTURES_BARRE];
  hud->t_Bstocks = new GLuint [4];    

if (!(hud->tgaFont[0].Load(SHXMAN_DATA "fonts/font_2.tga")))
    {
      fprintf(stderr, "Error loading font : fonts/font_2.tga");
    }

  if (!(hud->tgaFont[1].Load(SHXMAN_DATA "fonts/font_1.tga")))
    {
      fprintf(stderr, "Error loading font : fonts/font_1.tga");
    }
  
  load_mm_textures();
  load_bottom_bar();
  load_hud_icons();
  load_compas();

  hud->num_messages=0;
  hud->messages = new hud_message_t [MAX_HUD_MESSAGES];
  for (int i=0; i < MAX_HUD_MESSAGES; i++) {
    hud->messages[i].timer = new CHRONOMETRE;
    hud->messages[i].timer->initialise();

    hud->messages[i].text_message = new char [MAX_MESSAGE_LENGTH];
    memset(hud->messages[i].text_message,0,MAX_MESSAGE_LENGTH*sizeof(char));
    hud->messages[i].is_active = 0;
  }

  hud->mat_amb_diff[0] = 0.937;
  hud->mat_amb_diff[1]= 0.937;
  hud->mat_amb_diff[2] = 0.937;
  hud->mat_amb_diff[3] = 1.0;

  hud->draw_bigminimap=0;

  return 1;
}

void cleanup_hud()
{
  for (int i=0; i < MAX_HUD_MESSAGES; i++) {
    delete hud->messages[i].timer;
    delete hud->messages[i].text_message;
  }

   glDeleteTextures(4, hud->t_Bstocks);
   glDeleteTextures(1, &hud->t_boussole_socle);
   glDeleteTextures(1, &hud->t_mask_boussole_socle);
   glDeleteTextures(1, &hud->t_aiguille);
   glDeleteTextures(1, &hud->t_mask_aiguille);

   glDeleteTextures(N_TEXTURES_BARRE, hud->t_barre);

  delete hud;
}

void load_bottom_bar()
{
  SDL_Surface *images_interf[N_TEXTURES_BARRE];

  hud->listeGrandCarre = glGenLists(1);
  glNewList(hud->listeGrandCarre, GL_COMPILE);
  glBegin(GL_TRIANGLES);

  glTexCoord2f(0, 0);
  glVertex2f(-GRANDE_INTERF/2, -GRANDE_INTERF/2);
  glTexCoord2f(1, 0);
  glVertex2f( GRANDE_INTERF/2, -GRANDE_INTERF / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-GRANDE_INTERF / 2, GRANDE_INTERF / 2);
  
  glTexCoord2f(0, 1);
  glVertex2f(-GRANDE_INTERF / 2, GRANDE_INTERF / 2);
  glTexCoord2f(1, 0);
  glVertex2f(GRANDE_INTERF / 2, -GRANDE_INTERF / 2);
  glTexCoord2f(1, 1);
  glVertex2f(GRANDE_INTERF / 2, GRANDE_INTERF / 2);
  
  glEnd();
  glEndList();

  hud->listePetitCarre = glGenLists(1);
  glNewList(hud->listePetitCarre, GL_COMPILE);
  glBegin(GL_TRIANGLES);

  glTexCoord2f(0, 0);
  glVertex2f(-PETITE_INTERF / 2, -PETITE_INTERF / 2);
  glTexCoord2f(1, 0);
  glVertex2f(PETITE_INTERF / 2, -PETITE_INTERF / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-PETITE_INTERF / 2, PETITE_INTERF / 2);
  
  glTexCoord2f(0, 1);
  glVertex2f(-PETITE_INTERF / 2, PETITE_INTERF / 2);
  glTexCoord2f(1, 0);
  glVertex2f(PETITE_INTERF / 2, -PETITE_INTERF / 2);
  glTexCoord2f(1, 1);
  glVertex2f(PETITE_INTERF / 2, PETITE_INTERF / 2);
  
  glEnd();
  glEndList();

  glGenTextures(N_TEXTURES_BARRE, hud->t_barre);
  for (int i=0; i<N_TEXTURES_BARRE; i++)
    {
      images_interf[i] = ImageLoad(i_barre[i]);
      
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_interf[i]->w, images_interf[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_interf[i]->pixels);

      SDL_FreeSurface(images_interf[i]);
    }
}

void load_hud_icons()
{

  SDL_Surface *images_stocks[4];

  glGenTextures(4, hud->t_Bstocks);
  for (int i=0; i<4; i++)
    {
      images_stocks[i] = ImageLoad(i_Bstocks[i]);
      
      glBindTexture(GL_TEXTURE_2D, hud->t_Bstocks[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_LINEAR_MIPMAP_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      
      gluBuild2DMipmaps(GL_TEXTURE_2D, 3, images_stocks[i]->w, images_stocks[i]->h,
			GL_RGB, GL_UNSIGNED_BYTE, images_stocks[i]->pixels);

      SDL_FreeSurface(images_stocks[i]);
    }

  LoadTexture(i_vie, &hud->t_vie);
  LoadTexture(i_mask_vie, &hud->t_mask_vie);

}

void load_compas()
{
  LoadTexture(i_boussole_socle, &hud->t_boussole_socle);
  LoadTexture(i_mask_boussole_socle, &hud->t_mask_boussole_socle);
  LoadTexture(i_aiguille, &hud->t_aiguille);
  LoadTexture(i_mask_aiguille, &hud->t_mask_aiguille);
}

void draw_compas()
{
  glPushMatrix();
  glTranslatef(COMPAS_W / 2, 600 - COMPAS_H / 2, 0);

  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);

  glBindTexture(GL_TEXTURE_2D, hud->t_mask_boussole_socle);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(-COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 0);
  glVertex2f(COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 1);
  glVertex2f(COMPAS_W / 2, COMPAS_H / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-COMPAS_W / 2, COMPAS_H / 2);

  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, hud->t_boussole_socle);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(-COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 0);
  glVertex2f(COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 1);
  glVertex2f(COMPAS_W / 2, COMPAS_H / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-COMPAS_W / 2, COMPAS_H / 2);

  glEnd();

  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);
  glPopMatrix();

  glPushMatrix();
  glTranslatef(COMPAS_W / 2, 600 - COMPAS_H / 2, 0);

  glRotatef(player->y_rot, 0.0f, 0.0f, 1.0f);

  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);

  glBindTexture(GL_TEXTURE_2D, hud->t_mask_aiguille);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(-COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 0);
  glVertex2f(COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 1);
  glVertex2f(COMPAS_W / 2, COMPAS_H / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-COMPAS_W / 2, COMPAS_H / 2);

  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, hud->t_aiguille);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(-COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 0);
  glVertex2f(COMPAS_W / 2, -COMPAS_H / 2);
  glTexCoord2f(1, 1);
  glVertex2f(COMPAS_W / 2, COMPAS_H / 2);
  glTexCoord2f(0, 1);
  glVertex2f(-COMPAS_W / 2, COMPAS_H / 2);

  glEnd();

  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);
  glPopMatrix();
}

void draw_bottom_bar()
{
  int i=0;
  glPushMatrix();
  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);

  // groupe 0
  glTranslatef(PETITE_INTERF/2,PETITE_INTERF/2+136, 0);
  for (i=0; i<7; i+=2)
    {
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glCallList(hud->listePetitCarre);

      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i+1]);
      glCallList(hud->listePetitCarre);
      glTranslatef(PETITE_INTERF, 0, 0);
    }
  
  // coin
  glTranslatef(0, -8, 0);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  glBindTexture(GL_TEXTURE_2D, hud->t_barre[8]);
  glCallList(hud->listePetitCarre);
  
  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, hud->t_barre[9]);
  glCallList(hud->listePetitCarre);
  
  // descente
  glTranslatef(8, -PETITE_INTERF, 0);
  for (i=10; i<13; i+=2)
    {
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glCallList(hud->listePetitCarre);

      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i+1]);
      glCallList(hud->listePetitCarre);
      glTranslatef(0, -PETITE_INTERF, 0);
    }
  
  glTranslatef(16, -16, 0);
  
  for (i=14; i<21; i+=2)
    {
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glCallList(hud->listeGrandCarre);
  
      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i+1]);
      glCallList(hud->listeGrandCarre);
      glTranslatef(GRANDE_INTERF, 0, 0);
    }
  
  glTranslatef(136, 0, 0);
  for (i=22; i<27; i+=2)
    {
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glCallList(hud->listeGrandCarre);
  
      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i+1]);
      glCallList(hud->listeGrandCarre);
      glTranslatef(GRANDE_INTERF, 0, 0);
    }

  glTranslatef(-8, 40, 0);
  for (i=28; i<31; i+=2)
    {
  
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i]);
      glCallList(hud->listeGrandCarre);
  
      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, hud->t_barre[i+1]);
      glCallList(hud->listeGrandCarre);
      glTranslatef(GRANDE_INTERF, 0, 0);
    }
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);
  glPopMatrix();
}

void draw_lives()
{
int i = 0;

  glPushMatrix();

  glTranslatef(800 - VIE_W/2 - 97 , VIE_H / 2 + 11, 0);

  for (i = 0; i < player->num_lives; i++)
  {

    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);

    glBindTexture(GL_TEXTURE_2D, hud->t_mask_vie);
    glBegin(GL_QUADS);

    glTexCoord2f(0, 0);
    glVertex2f(-VIE_W / 2, -VIE_H / 2);
    glTexCoord2f(1, 0);
    glVertex2f(VIE_W / 2, -VIE_H / 2);
    glTexCoord2f(1, 1);
    glVertex2f(VIE_W / 2, VIE_H / 2);
    glTexCoord2f(0, 1);
    glVertex2f(-VIE_W / 2, VIE_H / 2);

    glEnd();

    glBlendFunc(GL_ONE, GL_ONE);
    glBindTexture(GL_TEXTURE_2D, hud->t_vie);

    glBegin(GL_QUADS);

    glTexCoord2f(0, 0);
    glVertex2f(-VIE_W / 2, -VIE_H / 2);
    glTexCoord2f(1, 0);
    glVertex2f(VIE_W / 2, -VIE_H / 2);
    glTexCoord2f(1, 1);
    glVertex2f(VIE_W / 2, VIE_H / 2);
    glTexCoord2f(0, 1);
    glVertex2f(-VIE_W / 2, VIE_H / 2);

    glEnd();

    glEnable(GL_DEPTH_TEST);
    glDisable(GL_BLEND);

    glTranslatef(-32, 0, 0);

  }
  glPopMatrix();
}

void draw_stocks()
{
  int i=0;
  glPushMatrix();
  glTranslatef(160, 7, 0);

  for (i=0; i<4; i++)
    {
      if (player->stockBonus[i]) {

	if (i==player->selected_stocked_bonus) {
//	  glColor4f(0.9,0.9,1.0,0.85);
	  glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	  glEnable(GL_BLEND);
	}

	else {
//	  glColor4f(1.0,1.0,1.0,1.0);
	  glDisable(GL_BLEND);
	}

	glBindTexture(GL_TEXTURE_2D, hud->t_Bstocks[i]);
	
	
	glBegin(GL_QUADS);
       
	glTexCoord2f(0, 0);
	glVertex2f(0, 0);
	glTexCoord2f(1, 0);
	glVertex2f(41, 0);
	glTexCoord2f(1, 1);
	glVertex2f(41,41);
	glTexCoord2f(0, 1);
	glVertex2f(0, 41);
	
	glEnd();
      }
      glTranslatef(55, 0, 0);
      
    }
  glPopMatrix();

  glDisable(GL_BLEND);
}

void draw_active_bonus()
{
  if (world->tab_bonus[E_SHMIXGOMME]->actif)
    {
      hud->tgaFont[0].SetSize(10);
      hud->tgaFont[0].Color3f(1.0,1.0,1.0);
      hud->tgaFont[0].Draw(8, 359, "%.2d:%.2d", 
		   world->b_shmixgomme->timer->getRestMin(),
		   world->b_shmixgomme->timer->getRestSec());

      glBindTexture(GL_TEXTURE_2D, world->tab_bonus[E_SHMIXGOMME]->texture);

      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 0);
      glVertex2f(13, 373);

      glTexCoord2f(1, 0);
      glVertex2f(53, 373);
      
      glTexCoord2f(1,1);
      glVertex2f(53, 413);
      
      glTexCoord2f(0, 1);
      glVertex2f(13,413);
      
      glEnd();
    }

  if (world->current_bonus > -1)
    {
      hud->tgaFont[0].SetSize(10);
      hud->tgaFont[0].Draw(8, 429, "%.2d:%.2d", 
		   world->tab_bonus[world->current_bonus]->timer->getRestMin(),
		   world->tab_bonus[world->current_bonus]->timer->getRestSec());
      glBindTexture(GL_TEXTURE_2D, world->tab_bonus[world->current_bonus]->texture);

      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 0);
      glVertex2f(13, 443);

      glTexCoord2f(1, 0);
      glVertex2f(53, 443);
      
      glTexCoord2f(1,1);
      glVertex2f(53, 483);
      
      glTexCoord2f(0, 1);
      glVertex2f(13,483);
      
      glEnd();
    }
}

void draw_message_box()
{
  GLfloat y_bottom = 595-MAX_HUD_MESSAGES*(17+2);
  glLineWidth(0.5);
  glDisable(GL_TEXTURE_2D);
  glColor3f(1.0,1.0,1.0);

  glBegin(GL_LINES);

  glVertex2f(130,595);
  glVertex2f(600,595);

  glVertex2f(130,y_bottom);
  glVertex2f(600,y_bottom);

  glVertex2f(130,595);
  glVertex2f(130,y_bottom);

  glVertex2f(600,y_bottom);
  glVertex2f(600,595);

  glEnd();
  glEnable(GL_TEXTURE_2D);
}

void draw_waiting()
{
  hud->tgaFont[1].SetSize(20);
  hud->tgaFont[1].Color3f(1.0, 1.0, 1.0);
  hud->tgaFont[1].Draw(150, 300, "Left-click to begin !");
}

void draw_dead()
{
  hud->tgaFont[0].SetSize(26);
  hud->tgaFont[0].Color3f(1.0, 0.3, 0.3);
  hud->tgaFont[0].Draw(200, 400, "AAAAAAAARGHLLL!");

  hud->tgaFont[0].SetSize(20);
  hud->tgaFont[0].Color3f(1.0, 0.3, 0.3);
  hud->tgaFont[0].Draw(200, 300, "You are dead... :-(");
}

void draw_pause()
{
  hud->tgaFont[0].SetSize(16);
  hud->tgaFont[0].Color3f(1.0, 1.0, 1.0);
  hud->tgaFont[0].Draw(300, 300, "Paused");
}

void draw_gameover()
{
  hud->tgaFont[0].SetSize(26);
  hud->tgaFont[0].Color3f(1.0, 0.1, 0.1);
  hud->tgaFont[0].Draw(200, 400, "Game over");

  hud->tgaFont[0].SetSize(20);
  hud->tgaFont[0].Color3f(1.0, 0.2, 0.2);
  hud->tgaFont[0].Draw(200, 300, "Press SPACE bar to quit.");
}

void draw_you_win()
{
  hud->tgaFont[0].SetSize(26);
  hud->tgaFont[0].Color3f(1.0, 0.2, 0.2);
  hud->tgaFont[0].Draw(200, 400, "Congratulations !");
  
  hud->tgaFont[0].SetSize(20);
  hud->tgaFont[0].Color3f(1.0, 0.3, 0.3);
  hud->tgaFont[0].Draw(200, 350, "You win !");

  hud->tgaFont[0].SetSize(20);
  hud->tgaFont[0].Color3f(1.0, 0.3, 0.3);
  hud->tgaFont[0].Draw(200, 300, "Press SPACE bar to quit.");
}

void hud_update_messages()
{
  for (int i=0; i < MAX_HUD_MESSAGES; i++) {

    if ( hud->messages[i].is_active) {
      if (hud->messages[i].timer->update_temps()) {
    	hud_delete_message(i);
      }

      else {
	hud->tgaFont[0].SetSize(10);
	hud->tgaFont[0].Color3f(1.0, 1.0, 1.0);
	hud->tgaFont[0].Draw(140, hud->messages[i].pos_y, 
			     hud->messages[i].text_message);
      }
    }
  }

}

void hud_delete_all_messages()
{
  for (int i=0; i < MAX_HUD_MESSAGES; i++) {
    if ( hud->messages[i].is_active) {
    	hud_delete_message(i);
    }
  }
}

void hud_toggle_pause_messages()
{
  for (int i=0; i < MAX_HUD_MESSAGES; i++) {

    //if ( hud->messages[i].is_active) {
      hud->messages[i].timer->togglePaused();
      //}
  }
}

int hud_new_message(char *text)
{

  if ( strlen(text) < MAX_MESSAGE_LENGTH) {
    if (hud->num_messages >= MAX_HUD_MESSAGES) 
      {
	hud_delete_message(-1);
      }

    //we look for an empty slot
    for (int i=0; i < MAX_HUD_MESSAGES; i++) {

      if (hud->messages[i].is_active == 0)
	{
	  hud->num_messages++;
	  hud->messages[i].timer->resetTemps();
	  hud->messages[i].timer->setAlarm(MESSAGE_TIME);
	  strcpy(hud->messages[i].text_message,text);
	  hud->messages[i].slot = hud->num_messages-1;
	  hud->messages[i].pos_y = 575-17*hud->messages[i].slot;
	  hud->messages[i].is_active=1;
	  hud->last_message = i;

	  //printf("Found number #%d (slot %d)\n",i,hud->messages[i].slot);
	  return 1;
	}
    }
  }

  return 0;
}

void hud_delete_message(int number)
{
  int i=0;
  if (number == -1) 
    {
      //printf("we force deletion\n");
      for (i=0; i < MAX_HUD_MESSAGES; i++)
	{
	  if (hud->messages[i].is_active)
	    {
	      if (hud->messages[i].slot == 0) number=i;
	    }
	}
    }
  //printf("we delete message #%d (slot %d)\n",number, hud->messages[number].slot);
  hud->num_messages--;
  hud->messages[number].is_active = 0;
  memset(hud->messages[number].text_message,0, MAX_MESSAGE_LENGTH*sizeof(char));

  // we change other messages coordinates
  for (i=0; i < MAX_HUD_MESSAGES; i++) 
    {
      if (hud->messages[i].is_active)
	{
	  //printf("#%d: slot %d is now slot %d\n",i,hud->messages[i].slot, hud->messages[i].slot-1);
	  hud->messages[i].slot -=1;
	  hud->messages[i].pos_y += 17;
	  hud->last_message = i;
	}

    }
}
