/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_H
#define _MAS_H

/***********************************************************************
 * mas.h
 *
 * MAS Client API
 ***********************************************************************/

#include <stdlib.h>
#include "mas/mas_constants.h"
#include "mas/mas_types.h"
#include "mas/mas_error.h"
#include "mas/mas_misc.h"
#include "mas/mas_common.h"

/***********************************************************************
 * API-only types
 ***********************************************************************/
typedef struct _mas_api_internal_device*  mas_device_t;
typedef struct _mas_api_internal_port*    mas_port_t;
typedef struct _mas_api_internal_channel* mas_channel_t;

/***********************************************************************
 * 
 ***********************************************************************/
extern int32 mas_init( void );
extern int32 mas_make_data_channel_on_channel( char* name, mas_channel_t* data_channel, mas_port_t* source, mas_port_t* sink, mas_channel_t control_channel );
extern int32 mas_make_data_channel( char* name, mas_channel_t* data_channel, mas_port_t* source, mas_port_t* sink );
extern int32 mas_make_control_channel( char* hostname, mas_channel_t* control_channel );
extern int32 mas_get_local_control_channel( mas_channel_t* channel );
extern int32 mas_get_display_control_channel( mas_channel_t* channel );
extern int32 mas_send( mas_channel_t channel, struct mas_data* data );
extern int32 mas_send_to_local( struct mas_data* data );
extern int32 mas_send_to_display( struct mas_data* data );
extern int32 mas_send_package( mas_channel_t channel, struct mas_package* package );
extern int32 mas_send_package_to_local( struct mas_package* package );
extern int32 mas_send_package_to_display( struct mas_package* package );
extern int32 mas_send_event( struct mas_event *event, mas_channel_t channel );
extern int32 mas_recv( mas_channel_t channel, struct mas_data* data );
extern int32 mas_recv_from_local( struct mas_data* data );
extern int32 mas_recv_from_display( struct mas_data* data );
extern int32 mas_recv_package( mas_channel_t channel, struct mas_package* package );
extern int32 mas_recv_package_from_local( struct mas_package* package );
extern int32 mas_recv_package_from_display( struct mas_package* package );
extern int32 mas_test_recv_data_waiting( mas_channel_t channel );
extern int32 mas_test_recv_data_waiting_from_display( void );
extern int32 mas_test_recv_data_waiting_from_local( void );

/***********************************************************************
 * assembler
 ***********************************************************************/

extern int32 mas_asm_instantiate_device( char* name, void* predicate, int32 predicate_len, mas_device_t* device );
extern int32 mas_asm_instantiate_device_on_channel( char* name, void* predicate, int32 predicate_len, mas_device_t* device, mas_channel_t channel );
extern int32 mas_asm_terminate_device_instance( mas_device_t device, int32 secs_to_live );
extern int32 mas_asm_connect_source_sink( mas_port_t source, mas_port_t sink, struct  mas_data_characteristic* dc );
extern int32 mas_asm_connect_ports( mas_port_t source, mas_port_t sink );
extern int32 mas_asm_disconnect_port( mas_port_t port );
extern int32 mas_asm_get_port_by_name( mas_device_t device, char* name, mas_port_t* port );
extern int32 mas_asm_get_device_by_name_on_channel( char* name, mas_device_t* device, mas_channel_t channel );
extern int32 mas_asm_get_device_by_name( char* name,  mas_device_t* device );
extern int32 mas_asm_get_dc( mas_port_t port, struct mas_data_characteristic** retval_dc );
extern int32 mas_dev_show_state( mas_device_t device );
extern int32 mas_get_asm_device_on_channel( mas_device_t* device, mas_channel_t channel );
extern int32 mas_get_sch_device_on_channel( mas_device_t* device, mas_channel_t channel );
extern int32 mas_get_mc_device_on_channel( mas_device_t* device, mas_channel_t channel );
extern int32 mas_get_asm_device( mas_device_t* device );
extern int32 mas_get_sch_device( mas_device_t* device );
extern int32 mas_get_mc_device( mas_device_t* device );
extern int32 mas_get_portnum( mas_port_t port );
extern int32 mas_get_port( int32 portnum, mas_channel_t channel, mas_port_t *port );
extern int32 mas_get_device( int32 di, mas_channel_t channel, mas_device_t *device );
extern int32 mas_asm_get_connport( mas_port_t port, mas_port_t* connport_ptr );
extern int32 mas_asm_connect_devices( mas_device_t src, mas_device_t snk, char* srcp_name, char* sinkp_name );
extern int32 mas_asm_connect_devices_dc( mas_device_t src, mas_device_t snk, char* srcp_name, char* sinkp_name, struct mas_data_characteristic* dc );
extern int32 mas_asm_connect_inline( mas_port_t srca, mas_port_t snkb, struct  mas_data_characteristic* ab_dc, mas_port_t srcc, mas_port_t snkd, struct  mas_data_characteristic* cd_dc, int config );
extern int32 mas_asm_disconnect_inline( mas_port_t srca, mas_port_t snkb, mas_port_t srcc, mas_port_t snkd, struct  mas_data_characteristic* dc, int config );

/* master clock */
extern int32 mas_mc_add_fixed_clock( char *name, double freq, mas_channel_t channel );

/** opaque ***********/
extern void mas_free_device( mas_device_t device );
extern void mas_free_port( mas_port_t port );
extern void mas_free_channel( mas_channel_t channel );

#endif /* _MAS_H */

