/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#ifndef _PROFILE_H
#define _PROFILE_H

#include "mas/mas_types.h"
#include "mas/mas_cmatrix.h"

const char   profile_name[]         = "codec_mp1a_mad";
const char   profile_purpose[]      = "Decode MPEG 1 (including .mp3) audio data using the MAD decoder";
const char   profile_description[]  = "The codec_mp1a_mad device decodes data in the compressed MPEG 1 format.  The decompression is performed using the high-quality, integer MAD library.";
const char   profile_license[]      = "Copyright (c) 2001-2003 Shiman Associates Inc.\nCopyright (C) 2000-2001 Robert Leslie\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n";
const uint8  profile_major_version  = 0;
const uint8  profile_minor_version  = 6;
const uint8  profile_teeny_version  = 0;
const uint8  profile_patchlevel  = 0;
const char   profile_build_host[]   = "mas.shiman.com";
const char   profile_build_date[]   = __DATE__;
const char   profile_reentrant      = TRUE;
const char   profile_ntpts_acc      = FALSE;
const char   profile_mts_acc        = FALSE;


const char*  profile_action_names[] =
{
    "mas_dev_init_instance",
    "mas_dev_exit_instance",
    "mas_dev_terminate",
    "mas_dev_configure_port",
    "mas_dev_disconnect_port",
    "mas_dev_show_state",
    "mas_codec_mp1a_convert",
    "mas_source_flush",
    "" /* needs terminator */
};

const char* mas_mp1a_in_cmatrix[][8] = 
{
    { "format",     "version", "layer", "bit rate", "sampling rate", "channels", "mt rate", "" },
    { "MPEG Audio", "1",       "*",     "*",        "*",             "*",        "90000", ""  },
    { "",           "",        "",      "",         "",              "",         "", ""  },
};

const char* mas_mp1a_out_cmatrix[][6] = 
{
    { "format",  "resolution", "channels", "sampling rate", "endian", "" },
    { "linear",  "24",         "*",        "*",             "host",    "" },
    { "linear",  "20",         "*",        "*",             "host",    "" },
    { "linear",  "16",         "*",        "*",             "host",    "" },
    { "",        "",           "",         "",              "",       "" },
};


/* These are the symbol names of the characteristic matrices used by
   this device.  The loader must resolve these.  They may include
   local characteristic matrices, or standard ones from
   mas_cmatrix.h.  The list must be null terminated. */
char* profile_cmatrix_names[] =
{
    "mas_mp1a_in_cmatrix",
    "mas_mp1a_out_cmatrix",
    "" /* needs terminator */
};

const char* profile_ports[][3] =
{
    { "sink", "sink", "mas_mp1a_in_cmatrix" },
    { "source", "source", "mas_mp1a_out_cmatrix" },
    { "", "", "" },
};

void *profile_clock_names = NULL;
void *mas_dev_init_library = NULL;

#endif /* _PROFILE_H */
