/***************************************************************************
 * tex_table.cpp is part of Math Graphic Library
 * Copyright (C) 2007-2014 Alexey Balakin <mathgl.abalakin@gmail.ru>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 3 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mgl2/font.h"

/// Table of LaTeX symbols and its UTF8 codes. This array MUST BE sorted!!!
MGL_EXPORT mglTeXsymb mgl_tex_symb[] = {
	{0x23, L"#"},
	{0x25, L"%"},
	{0x26, L"&"},
	{0xc5, L"AA"},
	{0xc6, L"AE"},
	{0x2370, L"APLboxquestion"},
	{0x2353, L"APLboxupcaret"},
	{0x2340, L"APLnotbackslash"},
	{0x233f, L"APLnotslash"},
	{0x391, L"Alpha"},
	{0x26, L"And"},
	{0x212b, L"Angstrom"},
	{0x2ae7, L"Barv"},
	{0x2102, L"BbbC"},
	{0x213e, L"BbbGamma"},
	{0x210d, L"BbbH"},
	{0x2115, L"BbbN"},
	{0x2119, L"BbbP"},
	{0x213f, L"BbbPi"},
	{0x211a, L"BbbQ"},
	{0x211d, L"BbbR"},
	{0x2124, L"BbbZ"},
	{0x213d, L"Bbbgamma"},
	{0x213c, L"Bbbpi"},
	{0x2140, L"Bbbsum"},
	{0x392, L"Beta"},
	{0x224e, L"Bumpeq"},
	{0x22d2, L"Cap"},
	{0x3a7, L"Chi"},
	{0x2237, L"Colon"},
	{0x2a74, L"Coloneq"},
	{0x22d3, L"Cup"},
	{0x27f1, L"DDownarrow"},
	{0xd0, L"DH"},
	{0x110, L"DJ"},
	{0x2ae5, L"DashV"},
	{0x27da, L"DashVDash"},
	{0x2ae4, L"Dashv"},
	{0x290b, L"Ddownarrow"},
	{0x394, L"Delta"},
	{0x3dc, L"Digamma"},
	{0x2251, L"Doteq"},
	{0x21d3, L"Downarrow"},
	{0x395, L"Epsilon"},
	{0x2263, L"Equiv"},
	{0x397, L"Eta"},
	{0x2107, L"Eulerconst"},
	{0x203c, L"Exclam"},
	{0x2132, L"Finv"},
	{0x2141, L"Game"},
	{0x393, L"Gamma"},
	{0x2aa2, L"Gt"},
	{0x26a5, L"Hermaphrodite"},
	{0x2111, L"Im"},
	{0x399, L"Iota"},
	{0x39a, L"Kappa"},
	{0x3de, L"Koppa"},
	{0x141, L"L"},
	{0x2b45, L"LLeftarrow"},
	{0x39b, L"Lambda"},
	{0x27ec, L"Lbrbrak"},
	{0x21b2, L"Ldsh"},
	{0x21d0, L"Leftarrow"},
	{0x21d4, L"Leftrightarrow"},
	{0x21da, L"Lleftarrow"},
	{0x27f8, L"Longleftarrow"},
	{0x27fa, L"Longleftrightarrow"},
	{0x27fd, L"Longmapsfrom"},
	{0x27fe, L"Longmapsto"},
	{0x27f9, L"Longrightarrow"},
	{0x2995, L"Lparengtr"},
	{0x21b0, L"Lsh"},
	{0x2aa1, L"Lt"},
	{0x29da, L"Lvzigzag"},
	{0x2906, L"Mapsfrom"},
	{0x2907, L"Mapsto"},
	{0x39c, L"Mu"},
	{0x14a, L"NG"},
	{0x21d7, L"Nearrow"},
	{0x2aec, L"Not"},
	{0x39d, L"Nu"},
	{0x21d6, L"Nwarrow"},
	{0xd8, L"O"},
	{0x152, L"OE"},
	{0x1a0, L"Ohorn"},
	{0x3a9, L"Omega"},
	{0x39f, L"Omicron"},
	{0x2a37, L"Otimes"},
	{0xb6, L"P"},
	{0x3a6, L"Phi"},
	{0x3a0, L"Pi"},
	{0x210e, L"Planckconst"},
	{0x2abb, L"Prec"},
	{0x214a, L"PropertyLine"},
	{0x3a8, L"Psi"},
	{0x220e, L"QED"},
	{0x2047, L"Question"},
	{0x2b46, L"RRightarrow"},
	{0x27ed, L"Rbrbrak"},
	{0x21b3, L"Rdsh"},
	{0x211c, L"Re"},
	{0x3a1, L"Rho"},
	{0x21d2, L"Rightarrow"},
	{0x2996, L"Rparenless"},
	{0x21db, L"Rrightarrow"},
	{0x21b1, L"Rsh"},
	{0x29db, L"Rvzigzag"},
	{0xa7, L"S"},
	{0x2abc, L"Sc"},
	{0x21d8, L"Searrow"},
	{0x3a3, L"Sigma"},
	{0x2a4e, L"Sqcap"},
	{0x2a4f, L"Sqcup"},
	{0x3da, L"Stigma"},
	{0x22d0, L"Subset"},
	{0x22d1, L"Supset"},
	{0x21d9, L"Swarrow"},
	{0xde, L"TH"},
	{0x3a4, L"Tau"},
	{0x398, L"Theta"},
	{0x27f0, L"UUparrow"},
	{0x1af, L"Uhorn"},
	{0x21d1, L"Uparrow"},
	{0x21d5, L"Updownarrow"},
	{0x290a, L"Uuparrow"},
	{0x22ab, L"VDash"},
	{0x2aeb, L"Vbar"},
	{0x22a9, L"Vdash"},
	{0x2a54, L"Vee"},
	{0x2016, L"Vert"},
	{0x22aa, L"Vvdash"},
	{0x2980, L"Vvert"},
	{0x2a53, L"Wedge"},
	{0x2612, L"XBox"},
	{0x39e, L"Xi"},
	{0x2144, L"Yup"},
	{0x1b5, L"Zbar"},
	{0x396, L"Zeta"},
	{0x5e, L"^"},
	{0xe5, L"aa"},
	{0x223e, L"ac"},
	{0x23e6, L"accurrent"},
	{0x267e, L"acidfree"},
	{0x2940, L"acwcirclearrow"},
	{0x27f2, L"acwgapcirclearrow"},
	{0x2939, L"acwleftarcarrow"},
	{0x21ba, L"acwopencirclearrow"},
	{0x293a, L"acwoverarcarrow"},
	{0x293b, L"acwundercurvearrow"},
	{0x22f0, L"adots"},
	{0xe6, L"ae"},
	{0x2135, L"aleph"},
	{0x3b1, L"alpha"},
//	{0x2210, L"amalg"},
	{0x2a3f, L"amalg"},
	{0x299f, L"angdnr"},
	{0x2220, L"angle"},
	{0x299e, L"angles"},
	{0x29a4, L"angleubar"},
	{0x2248, L"approx"},
	{0x224a, L"approxeq"},
	{0x2a70, L"approxeqq"},
	{0x224b, L"approxident"},
	{0x2258, L"arceq"},
	{0x2648, L"aries"},
	{0x22a6, L"assert"},
	{0x2217, L"ast"},
	{0x2a6e, L"asteq"},
	{0x2609, L"astrosun"},
	{0x224d, L"asymp"},
	{0x2a11, L"awint"},
	{0x2aed, L"bNot"},
	{0x224c, L"backcong"},
	{0x2036, L"backdprime"},
	{0x3f6, L"backepsilon"},
	{0x2035, L"backprime"},
	{0x223d, L"backsim"},
	{0x22cd, L"backsimeq"},
	{0x5c, L"backslash"},
	{0x2037, L"backtrprime"},
	{0x22ff, L"bagmember"},
	{0x2aea, L"barV"},
	{0x2a43, L"barcap"},
	{0x2a42, L"barcup"},
	{0x2961, L"bardownharpoonleft"},
	{0x295d, L"bardownharpoonright"},
	{0x21e4, L"barleftarrow"},
	{0x21b9, L"barleftarrowrightarrowbar"},
	{0x2956, L"barleftharpoondown"},
	{0x2952, L"barleftharpoonup"},
	{0x21b8, L"barovernorthwestarrow"},
	{0x2920, L"barrightarrowdiamond"},
	{0x295f, L"barrightharpoondown"},
	{0x295b, L"barrightharpoonup"},
	{0x2912, L"baruparrow"},
	{0x2958, L"barupharpoonleft"},
	{0x2954, L"barupharpoonright"},
	{0x22bd, L"barvee"},
	{0x22bc, L"barwedge"},
	{0x23b6, L"bbrktbrk"},
	{0x2550, L"bdHrule"},
	{0x2551, L"bdVrule"},
	{0x256c, L"bdbVbH"},
	{0x256b, L"bdbVbh"},
	{0x2563, L"bdbVlH"},
	{0x2562, L"bdbVlh"},
	{0x2560, L"bdbVrH"},
	{0x255f, L"bdbVrh"},
	{0x256a, L"bdbvbH"},
	{0x253c, L"bdbvbh"},
	{0x2561, L"bdbvlH"},
	{0x2524, L"bdbvlh"},
	{0x255e, L"bdbvrH"},
	{0x251c, L"bdbvrh"},
	{0x2566, L"bddVbH"},
	{0x2565, L"bddVbh"},
	{0x2557, L"bddVlH"},
	{0x2556, L"bddVlh"},
	{0x2554, L"bddVrH"},
	{0x2553, L"bddVrh"},
	{0x2564, L"bddvbH"},
	{0x252c, L"bddvbh"},
	{0x2555, L"bddvlH"},
	{0x2510, L"bddvlh"},
	{0x2552, L"bddvrH"},
	{0x250c, L"bddvrh"},
	{0x2500, L"bdhrule"},
	{0x2571, L"bdnesw"},
	{0x2572, L"bdnwse"},
	{0x2508, L"bdquadhdash"},
	{0x250a, L"bdquadvdash"},
	{0x2506, L"bdtriplevdash"},
	{0x2569, L"bduVbH"},
	{0x2568, L"bduVbh"},
	{0x255d, L"bduVlH"},
	{0x255c, L"bduVlh"},
	{0x255a, L"bduVrH"},
	{0x2559, L"bduVrh"},
	{0x2567, L"bduvbH"},
	{0x2534, L"bduvbh"},
	{0x255b, L"bduvlH"},
	{0x2518, L"bduvlh"},
	{0x2558, L"bduvrH"},
	{0x2514, L"bduvrh"},
	{0x2502, L"bdvrule"},
	{0x2235, L"because"},
	{0x23e3, L"benzenr"},
	{0x3b2, L"beta"},
	{0x2136, L"beth"},
	{0x226c, L"between"},
	{0x25bc, L"bigblacktriangledown"},
	{0x25b2, L"bigblacktriangleup"},
	{0x27d8, L"bigbot"},
	{0x22c2, L"bigcap"},
	{0x22c3, L"bigcup"},
	{0x2a57, L"bigslopedvee"},
	{0x2a58, L"bigslopedwedge"},
	{0x2605, L"bigstar"},
	{0x27d9, L"bigtop"},
	{0x25bd, L"bigtriangledown"},
	{0x25b3, L"bigtriangleup"},
	{0x22c1, L"bigvee"},
	{0x22c0, L"bigwedge"},
	{0x2606, L"bigwhitestar"},
	{0x29ed, L"blackcircledownarrow"},
	{0x2688, L"blackcircledrightdot"},
	{0x2791, L"blackcircledsanseight"},
	{0x278e, L"blackcircledsansfive"},
	{0x278d, L"blackcircledsansfour"},
	{0x2792, L"blackcircledsansnine"},
	{0x278a, L"blackcircledsansone"},
	{0x2790, L"blackcircledsansseven"},
	{0x278f, L"blackcircledsanssix"},
	{0x2793, L"blackcircledsansten"},
	{0x278c, L"blackcircledsansthree"},
	{0x278b, L"blackcircledsanstwo"},
	{0x2689, L"blackcircledtwodots"},
	{0x25d5, L"blackcircleulquadwhite"},
	{0x29ea, L"blackdiamonddownarrow"},
	{0x29d7, L"blackhourglass"},
	{0x25c8, L"blackinwhitediamond"},
	{0x25a3, L"blackinwhitesquare"},
	{0x25d6, L"blacklefthalfcircle"},
	{0x25c4, L"blackpointerleft"},
	{0x25ba, L"blackpointerright"},
	{0x25d7, L"blackrighthalfcircle"},
	{0x263b, L"blacksmiley"},
	{0x25b4, L"blacktriangle"},
	{0x25be, L"blacktriangledown"},
	{0x25c0, L"blacktriangleleft"},
	{0x25b6, L"blacktriangleright"},
	{0x2b2c, L"blkhorzoval"},
	{0x2b2e, L"blkvertoval"},
	{0x2588, L"blockfull"},
	{0x2592, L"blockhalfshaded"},
	{0x258c, L"blocklefthalf"},
	{0x2584, L"blocklowhalf"},
	{0x2591, L"blockqtrshaded"},
	{0x2590, L"blockrighthalf"},
	{0x2593, L"blockthreeqtrshaded"},
	{0x2580, L"blockuphalf"},
	{0x22a5, L"bot"},
	{0x25e1, L"botsemicircle"},
	{0x22c8, L"bowtie"},
	{0x25fb, L"box"},
	{0x29c6, L"boxast"},
	{0x25eb, L"boxbar"},
	{0x29c8, L"boxbox"},
	{0x29c5, L"boxbslash"},
	{0x29c7, L"boxcircle"},
	{0x29c4, L"boxdiag"},
	{0x22a1, L"boxdot"},
	{0x229f, L"boxminus"},
	{0x29c9, L"boxonbox"},
	{0x229e, L"boxplus"},
	{0x22a0, L"boxtimes"},
	{0x2b41, L"bsimilarleftarrow"},
	{0x2b47, L"bsimilarrightarrow"},
	{0x27c8, L"bsolhsub"},
	{0x2a32, L"btimes"},
	{0x2219, L"bullet"},
	{0x25ce, L"bullseye"},
	{0x224f, L"bumpeq"},
	{0x2aae, L"bumpeqq"},
	{0x212c, L"calB"},
	{0x2130, L"calE"},
	{0x2131, L"calF"},
	{0x210b, L"calH"},
	{0x2133, L"calM"},
	{0x211b, L"calR"},
	{0x2229, L"cap"},
	{0x2a40, L"capdot"},
	{0x2a44, L"capwedge"},
	{0x2038, L"caretinsert"},
	{0x23ce, L"carreturn"},
	{0x21b5, L"carriagereturn"},
	{0x293f, L"ccwundercurvearrow"},
	{0x22c5, L"cdot"},
	{0xb7, L"cdotp"},
	{0x22ef, L"cdots"},
	{0x2ba, L"cdprime"},
	{0x2713, L"checkmark"},
	{0x3c7, L"chi"},
	{0x29c3, L"cirE"},
	{0x27df, L"cirbot"},
	{0x2218, L"circ"},
	{0x2257, L"circeq"},
	{0x2a10, L"circfint"},
	{0x25d2, L"circlebottomhalfblack"},
	{0x24b6, L"circledA"},
	{0x24b7, L"circledB"},
	{0x24b8, L"circledC"},
	{0x24b9, L"circledD"},
	{0x24ba, L"circledE"},
	{0x24bb, L"circledF"},
	{0x24bc, L"circledG"},
	{0x24bd, L"circledH"},
	{0x24be, L"circledI"},
	{0x24bf, L"circledJ"},
	{0x24c0, L"circledK"},
	{0x24c1, L"circledL"},
	{0x24c2, L"circledM"},
	{0x24c3, L"circledN"},
	{0x24c4, L"circledO"},
	{0x24c5, L"circledP"},
	{0x24c6, L"circledQ"},
	{0x24c7, L"circledR"},
	{0x24c8, L"circledS"},
	{0x24c9, L"circledT"},
	{0x24ca, L"circledU"},
	{0x24cb, L"circledV"},
	{0x24cc, L"circledW"},
	{0x24cd, L"circledX"},
	{0x24ce, L"circledY"},
	{0x24cf, L"circledZ"},
	{0x24d0, L"circleda"},
	{0x229b, L"circledast"},
	{0x24d1, L"circledb"},
	{0x29bf, L"circledbullet"},
	{0x24d2, L"circledc"},
	{0x229a, L"circledcirc"},
	{0x24d3, L"circledd"},
	{0x229d, L"circleddash"},
	{0x24d4, L"circlede"},
	{0x2467, L"circledeight"},
	{0x229c, L"circledequal"},
	{0x24d5, L"circledf"},
	{0x2464, L"circledfive"},
	{0x2463, L"circledfour"},
	{0x24d6, L"circledg"},
	{0x24d7, L"circledh"},
	{0x24d8, L"circledi"},
	{0x24d9, L"circledj"},
	{0x24da, L"circledk"},
	{0x24db, L"circledl"},
	{0x24dc, L"circledm"},
	{0x24dd, L"circledn"},
	{0x2468, L"circlednine"},
	{0x24de, L"circledo"},
	{0x2460, L"circledone"},
	{0x29ec, L"circledownarrow"},
	{0x24df, L"circledp"},
	{0x29b7, L"circledparallel"},
	{0x24e0, L"circledq"},
	{0x24e1, L"circledr"},
	{0x2686, L"circledrightdot"},
	{0x24e2, L"circleds"},
	{0x2787, L"circledsanseight"},
	{0x2784, L"circledsansfive"},
	{0x2783, L"circledsansfour"},
	{0x2788, L"circledsansnine"},
	{0x2780, L"circledsansone"},
	{0x2786, L"circledsansseven"},
	{0x2785, L"circledsanssix"},
	{0x2789, L"circledsansten"},
	{0x2782, L"circledsansthree"},
	{0x2781, L"circledsanstwo"},
	{0x2466, L"circledseven"},
	{0x2465, L"circledsix"},
	{0x272a, L"circledstar"},
	{0x24e3, L"circledt"},
	{0x2462, L"circledthree"},
	{0x2461, L"circledtwo"},
	{0x2687, L"circledtwodots"},
	{0x24e4, L"circledu"},
	{0x24e5, L"circledv"},
	{0x29b6, L"circledvert"},
	{0x24e6, L"circledw"},
	{0x29be, L"circledwhitebullet"},
	{0x24e7, L"circledx"},
	{0x24e8, L"circledy"},
	{0x24e9, L"circledz"},
	{0x24ea, L"circledzero"},
	{0x29b5, L"circlehbar"},
	{0x25d0, L"circlelefthalfblack"},
	{0x25f5, L"circlellquad"},
	{0x25f6, L"circlelrquad"},
	{0x2b30, L"circleonleftarrow"},
	{0x21f4, L"circleonrightarrow"},
	{0x25d1, L"circlerighthalfblack"},
	{0x25d3, L"circletophalfblack"},
	{0x25f4, L"circleulquad"},
	{0x25f7, L"circleurquad"},
	{0x25d4, L"circleurquadblack"},
	{0x25cd, L"circlevertfill"},
	{0x2aef, L"cirmid"},
	{0x29c2, L"cirscir"},
	{0x2329, L"clangle"},
	{0x2a4d, L"closedvarcap"},
	{0x2a4c, L"closedvarcup"},
	{0x2a50, L"closedvarcupsmashprod"},
	{0x2050, L"closure"},
	{0x2318, L"cloverleaf"},
	{0x2663, L"clubsuit"},
	{0x3a, L"colon"},
	{0x2236, L"colon"},
	{0x2254, L"coloneq"},
	{0x2a29, L"commaminus"},
	{0x2201, L"complement"},
	{0x27e1, L"concavediamond"},
	{0x27e2, L"concavediamondtickleft"},
	{0x27e3, L"concavediamondtickright"},
	{0x2245, L"cong"},
	{0x2a6d, L"congdot"},
	{0x2332, L"conictaper"},
	{0x260c, L"conjunction"},
	{0x2210, L"coprod"},
	{0x2b9, L"cprime"},
	{0x232a, L"crangle"},
	{0x2acf, L"csub"},
	{0x2ad1, L"csube"},
	{0x2ad0, L"csup"},
	{0x2ad2, L"csupe"},
	{0x221b, L"cuberoot"},
	{0x222a, L"cup"},
	{0x228d, L"cupdot"},
	{0x228c, L"cupleftarrow"},
	{0x2a45, L"cupvee"},
	{0x22de, L"curlyeqprec"},
	{0x22df, L"curlyeqsucc"},
	{0x22ce, L"curlyvee"},
	{0x22cf, L"curlywedge"},
	{0x21b6, L"curvearrowleft"},
	{0x293d, L"curvearrowleftplus"},
	{0x21b7, L"curvearrowright"},
	{0x293c, L"curvearrowrightminus"},
	{0x2941, L"cwcirclearrow"},
	{0x27f3, L"cwgapcirclearrow"},
	{0x21bb, L"cwopencirclearrow"},
	{0x2938, L"cwrightarcarrow"},
	{0x293e, L"cwundercurvearrow"},
	{0x232d, L"cylcty"},
	{0x2020, L"dag"},
	{0x2020, L"dagger"},
	{0x2138, L"daleth"},
	{0x2621, L"danger"},
	{0x2ae3, L"dashV"},
	{0x27db, L"dashVdash"},
	{0x2239, L"dashcolon"},
	{0x296b, L"dashleftharpoondown"},
	{0x296d, L"dashrightharpoondown"},
	{0x22a3, L"dashv"},
	{0x290f, L"dbkarow"},
	{0x2021, L"ddag"},
	{0x2021, L"ddagger"},
	{0x22f1, L"ddots"},
	{0x2a77, L"ddotseq"},
	{0xb0, L"degree"},
	{0x3b4, L"delta"},
	{0xf0, L"dh"},
	{0x2300, L"diameter"},
	{0x25c7, L"diamond"},
	{0x2b19, L"diamondbotblack"},
	{0x27d0, L"diamondcdot"},
	{0x291d, L"diamondleftarrow"},
	{0x291f, L"diamondleftarrowbar"},
	{0x2b16, L"diamondleftblack"},
	{0x2b17, L"diamondrightblack"},
	{0x2662, L"diamondsuit"},
	{0x2b18, L"diamondtopblack"},
	{0x2680, L"dicei"},
	{0x2681, L"diceii"},
	{0x2682, L"diceiii"},
	{0x2683, L"diceiv"},
	{0x2684, L"dicev"},
	{0x2685, L"dicevi"},
	{0x3dd, L"digamma"},
	{0x273d, L"dingasterisk"},
	{0x2393, L"dircurrent"},
	{0x22f2, L"disin"},
	{0xf7, L"div"},
	{0x22c7, L"divideontimes"},
	{0x111, L"dj"},
	{0x230d, L"dlcrop"},
	{0x2250, L"doteq"},
	{0x2a67, L"dotequiv"},
	{0x2238, L"dotminus"},
	{0x2214, L"dotplus"},
	{0x2026, L"dots"},
	{0x2a6a, L"dotsim"},
	{0x223a, L"dotsminusdots"},
	{0x25cc, L"dottedcircle"},
	{0x2b1a, L"dottedsquare"},
	{0x2a30, L"dottimes"},
	{0x2a62, L"doublebarvee"},
	{0x2a5e, L"doublebarwedge"},
	{0x29fa, L"doubleplus"},
	{0x2193, L"downarrow"},
	{0x2913, L"downarrowbar"},
	{0x2908, L"downarrowbarred"},
	{0x21e3, L"downdasharrow"},
	{0x21ca, L"downdownarrows"},
	{0x297f, L"downfishtail"},
	{0x21c3, L"downharpoonleft"},
	{0x2959, L"downharpoonleftbar"},
	{0x21c2, L"downharpoonright"},
	{0x2955, L"downharpoonrightbar"},
	{0x2965, L"downharpoonsleftright"},
	{0x2935, L"downrightcurvedarrow"},
	{0x29e8, L"downtriangleleftblack"},
	{0x29e9, L"downtrianglerightblack"},
	{0x21f5, L"downuparrows"},
	{0x296f, L"downupharpoonsleftright"},
	{0x21e9, L"downwhitearrow"},
	{0x21af, L"downzigzagarrow"},
	{0x2033, L"dprime"},
	{0x279b, L"draftingarrow"},
	{0x2910, L"drbkarow"},
	{0x230c, L"drcrop"},
	{0x29f6, L"dsol"},
	{0x2a64, L"dsub"},
	{0x29df, L"dualmap"},
	{0x2641, L"earth"},
	{0x2a98, L"egsdot"},
	{0x266a, L"eighthnote"},
	{0x23e7, L"elinters"},
	{0x2113, L"ell"},
	{0x2a97, L"elsdot"},
	{0x2014, L"emdash"},
	{0x2205, L"emptyset"},
	{0x29b3, L"emptysetoarr"},
	{0x29b4, L"emptysetoarrl"},
	{0x29b1, L"emptysetobar"},
	{0x29b2, L"emptysetocirc"},
	{0x2013, L"endash"},
	{0x2025, L"enleadertwodots"},
	{0x2709, L"envelope"},
	{0x29e3, L"eparsl"},
	{0x3f5, L"epsilon"},
	{0x2256, L"eqcirc"},
	{0x2255, L"eqcolon"},
	{0x225d, L"eqdef"},
	{0x2a66, L"eqdot"},
	{0x2a75, L"eqeq"},
	{0x2a76, L"eqeqeq"},
	{0x22dd, L"eqgtr"},
	{0x22dc, L"eqless"},
	{0x2a9a, L"eqqgtr"},
	{0x2a99, L"eqqless"},
	{0x2a71, L"eqqplus"},
	{0x2a73, L"eqqsim"},
	{0x2a9c, L"eqqslantgtr"},
	{0x2a9b, L"eqqslantless"},
	{0x2242, L"eqsim"},
	{0x2a96, L"eqslantgtr"},
	{0x2a95, L"eqslantless"},
	{0x2b40, L"equalleftarrow"},
	{0x22d5, L"equalparallel"},
	{0x2971, L"equalrightarrow"},
	{0x2261, L"equiv"},
	{0x2a78, L"equivDD"},
	{0x2a68, L"equivVert"},
	{0x2a69, L"equivVvert"},
	{0x29e5, L"eqvparsl"},
	{0x29f3, L"errbarblackcircle"},
	{0x29f1, L"errbarblackdiamond"},
	{0x29ef, L"errbarblacksquare"},
	{0x29f2, L"errbarcircle"},
	{0x29f0, L"errbardiamond"},
	{0x29ee, L"errbarsquare"},
	{0x3b7, L"eta"},
	{0x20ac, L"euro"},
	{0x2203, L"exists"},
	{0x2252, L"fallingdotseq"},
	{0x29d3, L"fbowtie"},
	{0x2a3e, L"fcmp"},
	{0x292f, L"fdiagovnearrow"},
	{0x292c, L"fdiagovrdiag"},
	{0x2640, L"female"},
	{0x2012, L"figdash"},
	{0x2a0f, L"fint"},
	{0x25c9, L"fisheye"},
	{0x266d, L"flat"},
	{0x23e5, L"fltns"},
	{0x2200, L"forall"},
	{0x2adc, L"forks"},
	{0x2add, L"forksnot"},
	{0x2ad9, L"forkv"},
	{0x221c, L"fourthroot"},
	{0x2999, L"fourvdots"},
	{0x215d, L"fracfiveeighths"},
	{0x215a, L"fracfivesixths"},
	{0x2158, L"fracfourfifths"},
	{0x215b, L"fraconeeighth"},
	{0x2155, L"fraconefifth"},
	{0x2159, L"fraconesixth"},
	{0x2153, L"fraconethird"},
	{0x215e, L"fracseveneights"},
	{0x2044, L"fracslash"},
	{0x215c, L"fracthreeeighths"},
	{0x2157, L"fracthreefifths"},
	{0x2156, L"fractwofifths"},
	{0x2154, L"fractwothirds"},
	{0x212d, L"frakC"},
	{0x210c, L"frakH"},
	{0x2128, L"frakZ"},
	{0x2322, L"frown"},
	{0x2639, L"frownie"},
	{0x27d7, L"fullouterjoin"},
	{0x3b3, L"gamma"},
	{0x2265, L"ge"},
	{0x2265, L"geq"},
	{0x2267, L"geqq"},
	{0x2a7e, L"geqslant"},
	{0x2aa9, L"gescc"},
	{0x2a80, L"gesdot"},
	{0x2a82, L"gesdoto"},
	{0x2a84, L"gesdotol"},
	{0x2a94, L"gesles"},
	{0x2190, L"gets"},
	{0x226b, L"gg"},
	{0x22d9, L"ggg"},
	{0x2af8, L"gggnest"},
	{0x2137, L"gimel"},
	{0x2a92, L"glE"},
	{0x2aa5, L"gla"},
	{0x29e6, L"gleichstark"},
	{0x2aa4, L"glj"},
	{0x2a8a, L"gnapprox"},
	{0x2a88, L"gneq"},
	{0x2269, L"gneqq"},
	{0x22e7, L"gnsim"},
	{0x3e, L"greater"},
	{0x2a8e, L"gsime"},
	{0x2a90, L"gsiml"},
	{0x2aa7, L"gtcc"},
	{0x2a7a, L"gtcir"},
	{0x29a0, L"gtlpar"},
	{0x2a7c, L"gtquest"},
	{0x2a86, L"gtrapprox"},
	{0x2978, L"gtrarr"},
	{0x22d7, L"gtrdot"},
	{0x22db, L"gtreqless"},
	{0x2a8c, L"gtreqqless"},
	{0x2277, L"gtrless"},
	{0x2273, L"gtrsim"},
	{0xab, L"guillemotleft"},
	{0xbb, L"guillemotright"},
	{0x2039, L"guilsinglleft"},
	{0x203a, L"guilsinglright"},
	{0x23af, L"harrowextender"},
	{0x2a6f, L"hatapprox"},
	{0x210f, L"hbar"},
	{0x2661, L"heartsuit"},
	{0x22b9, L"hermitmatrix"},
	{0x2394, L"hexagon"},
	{0x2b23, L"hexagonblack"},
	{0x306e, L"hiraganano"},
	{0x2924, L"hknearrow"},
	{0x2923, L"hknwarrow"},
	{0x2925, L"hksearow"},
	{0x2926, L"hkswarow"},
	{0x21a9, L"hookleftarrow"},
	{0x21aa, L"hookrightarrow"},
	{0x2015, L"horizbar"},
	{0x29d6, L"hourglass"},
	{0x2302, L"house"},
	{0x25ad, L"hrectangle"},
	{0x25ac, L"hrectangleblack"},
	{0x210f, L"hslash"},
	{0x2043, L"hyphenbullet"},
	{0x3030, L"hzigzag"},
	{0x2a0c, L"iiiint"},
	{0x222d, L"iiint"},
	{0x29dc, L"iinfin"},
	{0x222c, L"iint"},
	{0x22b7, L"imageof"},
	{0x2208, L"in"},
	{0x2105, L"incare"},
	{0x2206, L"increment"},
	{0x221e, L"infty"},
	{0x222b, L"int"},
	{0x2a0e, L"intBar"},
	{0x2a0d, L"intbar"},
	{0x2321, L"intbottom"},
	{0x2a19, L"intcap"},
	{0x2231, L"intclockwise"},
	{0x2a1a, L"intcup"},
	{0x22ba, L"intercal"},
	{0x2af4, L"interleave"},
	{0x23ae, L"intextender"},
	{0x2a17, L"intlharhk"},
	{0x2a3c, L"intprod"},
	{0x2a3d, L"intprodr"},
	{0x2320, L"inttop"},
	{0x2a18, L"intx"},
	{0x25d8, L"inversebullet"},
	{0x25d9, L"inversewhitecircle"},
	{0x2310, L"invnot"},
	{0x25db, L"invwhitelowerhalfcircle"},
	{0x25da, L"invwhiteupperhalfcircle"},
	{0x3b9, L"iota"},
	{0x2e0, L"ipasupgamma"},
	{0x2e1, L"ipasupl"},
	{0x2e4, L"ipasuprerglotstpp"},
	{0x2e2, L"ipasups"},
	{0x2e3, L"ipasupx"},
	{0x2ed, L"ipaunaspirated"},
	{0x2ec, L"ipavoicing"},
	{0x22f9, L"isinE"},
	{0x22f5, L"isindot"},
	{0x22f7, L"isinobar"},
	{0x22f4, L"isins"},
	{0x22f8, L"isinvb"},
	{0x2145, L"itBbbD"},
	{0x2146, L"itBbbd"},
	{0x2147, L"itBbbe"},
	{0x2148, L"itBbbi"},
	{0x2149, L"itBbbj"},
	{0x2643, L"jupiter"},
	{0x3ba, L"kappa"},
	{0x223b, L"kernelcontraction"},
	{0x3df, L"koppa"},
	{0x142, L"l"},
	{0x27ea, L"lAngle"},
	{0x2983, L"lBrace"},
	{0x27e6, L"lBrack"},
	{0x2985, L"lParen"},
	{0x3bb, L"lambda"},
	{0x19b, L"lambdabar"},
	{0x27e8, L"langle"},
	{0x2991, L"langledot"},
	{0x29e0, L"laplac"},
	{0x2bd, L"lasp"},
	{0x2aab, L"lat"},
	{0x2aad, L"late"},
	{0x27c5, L"lbag"},
	{0x2997, L"lblkbrbrak"},
	{0x7b, L"lbrace"},
	{0x23a9, L"lbracelend"},
	{0x23a8, L"lbracemid"},
	{0x23a7, L"lbraceuend"},
	{0x5b, L"lbrack"},
	{0x23a2, L"lbrackextender"},
	{0x23a3, L"lbracklend"},
	{0x298f, L"lbracklltick"},
	{0x298b, L"lbrackubar"},
	{0x23a1, L"lbrackuend"},
	{0x298d, L"lbrackultick"},
	{0x2772, L"lbrbrak"},
	{0x2308, L"lceil"},
	{0x29fc, L"lcurvyangle"},
	{0x21e0, L"ldasharrhead"},
	{0x2264, L"le"},
	{0x219d, L"leadsto"},
	{0x2190, L"leftarrow"},
	{0x2b4a, L"leftarrowapprox"},
	{0x2b42, L"leftarrowbackapprox"},
	{0x2b4b, L"leftarrowbsimilar"},
	{0x2977, L"leftarrowless"},
	{0x2b32, L"leftarrowonoplus"},
	{0x2946, L"leftarrowplus"},
	{0x2943, L"leftarrowshortrightarrow"},
	{0x2973, L"leftarrowsimilar"},
	{0x297a, L"leftarrowsubset"},
	{0x21a2, L"leftarrowtail"},
	{0x21fd, L"leftarrowtriangle"},
	{0x2b3e, L"leftarrowx"},
	{0x290c, L"leftbkarrow"},
	{0x2b3f, L"leftcurvedarrow"},
	{0x21e0, L"leftdasharrow"},
	{0x21e1, L"leftdasharrowhead"},
	{0x290e, L"leftdbkarrow"},
	{0x291b, L"leftdbltail"},
	{0x2b38, L"leftdotarrow"},
	{0x2936, L"leftdowncurvedarrow"},
	{0x297c, L"leftfishtail"},
	{0x21bd, L"leftharpoondown"},
	{0x295e, L"leftharpoondownbar"},
	{0x2962, L"leftharpoonsupdown"},
	{0x21bc, L"leftharpoonup"},
	{0x295a, L"leftharpoonupbar"},
	{0x296a, L"leftharpoonupdash"},
	{0x21c7, L"leftleftarrows"},
	{0x263e, L"leftmoon"},
	{0x27d5, L"leftouterjoin"},
	{0x2194, L"leftrightarrow"},
	{0x2948, L"leftrightarrowcircle"},
	{0x21c6, L"leftrightarrows"},
	{0x21ff, L"leftrightarrowtriangle"},
	{0x2950, L"leftrightharpoondowndown"},
	{0x294b, L"leftrightharpoondownup"},
	{0x21cb, L"leftrightharpoons"},
	{0x2967, L"leftrightharpoonsdown"},
	{0x2966, L"leftrightharpoonsup"},
	{0x294a, L"leftrightharpoonupdown"},
	{0x294e, L"leftrightharpoonupup"},
	{0x21ad, L"leftrightsquigarrow"},
	{0x219c, L"leftsquigarrow"},
	{0x21dc, L"leftsquigarrow"},
	{0x2919, L"lefttail"},
	{0x2b31, L"leftthreearrows"},
	{0x22cb, L"leftthreetimes"},
	{0x21e6, L"leftwhitearrow"},
	{0x2264, L"leq"},
	{0x2266, L"leqq"},
	{0x2af9, L"leqqslant"},
	{0x2afa, L"leqqslant"},
	{0x2a7d, L"leqslant"},
	{0x2aa8, L"lescc"},
	{0x2a7f, L"lesdot"},
	{0x2a81, L"lesdoto"},
	{0x2a83, L"lesdotor"},
	{0x2a93, L"lesges"},
	{0x3c, L"less"},
	{0x2a85, L"lessapprox"},
	{0x22d6, L"lessdot"},
	{0x22da, L"lesseqgtr"},
	{0x2a8b, L"lesseqqgtr"},
	{0x2276, L"lessgtr"},
	{0x2272, L"lesssim"},
	{0x29d1, L"lfbowtie"},
	{0x230a, L"lfloor"},
	{0x29d4, L"lftimes"},
	{0x2a91, L"lgE"},
	{0x2b24, L"lgblkcircle"},
	{0x2b1b, L"lgblksquare"},
	{0x25ef, L"lgwhtcircle"},
	{0x2b1c, L"lgwhtsquare"},
	{0x22b2, L"lhd"},
	{0x21b4, L"linefeed"},
	{0x226a, L"ll"},
	{0x2989, L"llangle"},
	{0x25df, L"llarc"},
	{0x25e3, L"llblacktriangle"},
	{0x231e, L"llcorner"},
	{0x22d8, L"lll"},
	{0x2af7, L"lllnest"},
	{0x2987, L"llparenthesis"},
	{0x25fa, L"lltriangle"},
	{0x23b0, L"lmoustache"},
	{0x2a89, L"lnapprox"},
	{0x2a87, L"lneq"},
	{0x2268, L"lneqq"},
	{0x22e6, L"lnsim"},
	{0x27de, L"longdashv"},
	{0x27cc, L"longdivision"},
	{0x27f5, L"longleftarrow"},
	{0x27f7, L"longleftrightarrow"},
	{0x2b33, L"longleftsquigarrow"},
	{0x27fb, L"longmapsfrom"},
	{0x27fc, L"longmapsto"},
	{0x27f6, L"longrightarrow"},
	{0x27ff, L"longrightsquigarrow"},
	{0x21ab, L"looparrowleft"},
	{0x21ac, L"looparrowright"},
	{0x2a1c, L"lowint"},
	{0x25ca, L"lozenge"},
	{0x27e0, L"lozengeminus"},
	{0x239c, L"lparenextender"},
	{0x239d, L"lparenlend"},
	{0x2993, L"lparenless"},
	{0x239b, L"lparenuend"},
	{0x2018, L"lq"},
	{0x25de, L"lrarc"},
	{0x25e2, L"lrblacktriangle"},
	{0x231f, L"lrcorner"},
	{0x25ff, L"lrtriangle"},
	{0x29e1, L"lrtriangleeq"},
	{0x2a8d, L"lsime"},
	{0x2a8f, L"lsimg"},
	{0x2acd, L"lsqhook"},
	{0x2aa6, L"ltcc"},
	{0x2a79, L"ltcir"},
	{0x22c9, L"ltimes"},
	{0x2976, L"ltlarr"},
	{0x2a7b, L"ltquest"},
	{0x29cf, L"ltrivb"},
	{0x23b8, L"lvboxline"},
	{0x29d8, L"lvzigzag"},
	{0x2642, L"male"},
	{0x2720, L"maltese"},
	{0x21a7, L"mapsdown"},
	{0x21a4, L"mapsfrom"},
	{0x21a6, L"mapsto"},
	{0x21a5, L"mapsup"},
	{0x2b25, L"mdblkdiamond"},
	{0x2b27, L"mdblklozenge"},
	{0x26ab, L"mdblkrcl"},
	{0x25fc, L"mdblksquare"},
	{0x25cf, L"mdlgblkcircle"},
	{0x25c6, L"mdlgblkdiamond"},
	{0x29eb, L"mdlgblklozenge"},
	{0x25a0, L"mdlgblksquare"},
	{0x25cb, L"mdlgwhtcircle"},
	{0x25c7, L"mdlgwhtdiamond"},
	{0x25a1, L"mdlgwhtsquare"},
	{0x2981, L"mdsmblkcircle"},
	{0x25fe, L"mdsmblksquare"},
	{0x26ac, L"mdsmwhtcircl"},
	{0x25fd, L"mdsmwhtsquare"},
	{0x26aa, L"mdwhtcircl"},
	{0x2b26, L"mdwhtdiamond"},
	{0x2b28, L"mdwhtlozenge"},
	{0x25fb, L"mdwhtsquare"},
	{0x29af, L"measangledltosw"},
	{0x29ae, L"measangledrtose"},
	{0x29ab, L"measangleldtosw"},
	{0x29a9, L"measanglelutonw"},
	{0x29aa, L"measanglerdtose"},
	{0x29a8, L"measanglerutone"},
	{0x29ad, L"measangleultonw"},
	{0x29ac, L"measangleurtone"},
	{0x225e, L"measeq"},
	{0x2221, L"measuredangle"},
	{0x299b, L"measuredangleleft"},
	{0x22be, L"measuredrightangle"},
	{0x2b51, L"medblackstar"},
	{0x205f, L"medmathspace"},
	{0x2b50, L"medwhitestar"},
	{0x263f, L"mercury"},
	{0x2127, L"mho"},
	{0x2223, L"mid"},
	{0x2a5d, L"midbarvee"},
	{0x2a5c, L"midbarwedge"},
	{0x2af0, L"midcir"},
	{0x2212, L"minus"},
	{0x2a2a, L"minusdot"},
	{0x2a2b, L"minusfdots"},
	{0x2a2c, L"minusrdots"},
	{0x2adb, L"mlcp"},
	{0x22a7, L"models"},
	{0x2213, L"mp"},
	{0x3bc, L"mu"},
	{0x22b8, L"multimap"},
	{0x27dc, L"multimapinv"},
	{0x21df, L"nHdownarrow"},
	{0x21de, L"nHuparrow"},
	{0x21cd, L"nLeftarrow"},
	{0x21ce, L"nLeftrightarrow"},
	{0x21cf, L"nRightarrow"},
	{0x22af, L"nVDash"},
	{0x22ae, L"nVdash"},
	{0x21fa, L"nVleftarrow"},
	{0x2b3a, L"nVleftarrowtail"},
	{0x21fc, L"nVleftrightarrow"},
	{0x21fb, L"nVrightarrow"},
	{0x2915, L"nVrightarrowtail"},
	{0x2b35, L"nVtwoheadleftarrow"},
	{0x2b3d, L"nVtwoheadleftarrowtail"},
	{0x2901, L"nVtwoheadrightarrow"},
	{0x2918, L"nVtwoheadrightarrowtail"},
	{0x2207, L"nabla"},
	{0x2249, L"napprox"},
	{0x226d, L"nasymp"},
	{0x266e, L"natural"},
	{0x2247, L"ncong"},
	{0x2260, L"ne"},
	{0x2197, L"nearrow"},
	{0xac, L"neg"},
	{0x2931, L"neovnwarrow"},
	{0x292e, L"neovsearrow"},
	{0x2646, L"neptune"},
	{0x2260, L"neq"},
	{0x2262, L"nequiv"},
	{0x2922, L"neswarrow"},
	{0x26b2, L"neuter"},
	{0x2204, L"nexists"},
	{0x14b, L"ng"},
	{0x2271, L"ngeq"},
	{0x226f, L"ngtr"},
	{0x2279, L"ngtrless"},
	{0x2275, L"ngtrsim"},
	{0x2af5, L"nhVvert"},
	{0x2af2, L"nhpar"},
	{0x220b, L"ni"},
	{0x22fe, L"niobar"},
	{0x22fc, L"nis"},
	{0x22fa, L"nisd"},
	{0x219a, L"nleftarrow"},
	{0x21ae, L"nleftrightarrow"},
	{0x2270, L"nleq"},
	{0x226e, L"nless"},
	{0x2278, L"nlessgtr"},
	{0x2274, L"nlesssim"},
	{0x2224, L"nmid"},
	{0x220c, L"nni"},
	{0x2011, L"nobreakhyphen"},
	{0x2209, L"notin"},
	{0x2226, L"nparallel"},
	{0x2a14, L"npolint"},
	{0x2280, L"nprec"},
	{0x22e0, L"npreccurlyeq"},
	{0x219b, L"nrightarrow"},
	{0x2241, L"nsim"},
	{0x2244, L"nsime"},
	{0x22e2, L"nsqsubseteq"},
	{0x22e3, L"nsqsupseteq"},
	{0x2284, L"nsubset"},
	{0x2288, L"nsubseteq"},
	{0x2281, L"nsucc"},
	{0x22e1, L"nsucccurlyeq"},
	{0x2285, L"nsupset"},
	{0x2289, L"nsupseteq"},
	{0x22ea, L"ntriangleleft"},
	{0x22ec, L"ntrianglelefteq"},
	{0x22eb, L"ntriangleright"},
	{0x22ed, L"ntrianglerighteq"},
	{0x3bd, L"nu"},
	{0x22ad, L"nvDash"},
	{0x2902, L"nvLeftarrow"},
	{0x2904, L"nvLeftrightarrow"},
	{0x2903, L"nvRightarrow"},
	{0x22ac, L"nvdash"},
	{0x29de, L"nvinfty"},
	{0x21f7, L"nvleftarrow"},
	{0x2b39, L"nvleftarrowtail"},
	{0x21f9, L"nvleftrightarrow"},
	{0x21f8, L"nvrightarrow"},
	{0x2914, L"nvrightarrowtail"},
	{0x2b34, L"nvtwoheadleftarrow"},
	{0x2b3c, L"nvtwoheadleftarrowtail"},
	{0x2900, L"nvtwoheadrightarrow"},
	{0x2917, L"nvtwoheadrightarrowtail"},
	{0x2196, L"nwarrow"},
	{0x2932, L"nwovnearrow"},
	{0x2921, L"nwsearrow"},
	{0xf8, L"o"},
	{0x233d, L"obar"},
	{0x29ba, L"obot"},
	{0x23e0, L"obrbrak"},
	{0x29b8, L"obslash"},
	{0x2a38, L"odiv"},
	{0x2299, L"odot"},
	{0x29bc, L"odotslashdot"},
	{0x153, L"oe"},
	{0x29c1, L"ogreaterthan"},
	{0x1a1, L"ohorn"},
	{0x2230, L"oiiint"},
	{0x222f, L"oiint"},
	{0x222e, L"oint"},
	{0x2233, L"ointctrclockwise"},
	{0x29bb, L"olcross"},
	{0x3d8, L"oldKoppa"},
	{0x3d9, L"oldkoppa"},
	{0x29c0, L"olessthan"},
	{0x3c9, L"omega"},
	{0x3bf, L"omicron"},
	{0x2296, L"ominus"},
	{0x29b9, L"operp"},
	{0x2295, L"oplus"},
	{0x2a2d, L"opluslhrim"},
	{0x2a2e, L"oplusrhrim"},
	{0x22b6, L"origof"},
	{0x2298, L"oslash"},
	{0x2297, L"otimes"},
	{0x2a36, L"otimeshat"},
	{0x2a34, L"otimeslhrim"},
	{0x2a35, L"otimesrhrim"},
	{0x23de, L"overbrace"},
	{0x23b4, L"overbracket"},
	{0x203e, L"overline"},
	{0x23dc, L"overparen"},
	{0x220b, L"owns"},
	{0x2225, L"parallel"},
	{0x25b1, L"parallelogram"},
	{0x25b0, L"parallelogramblack"},
	{0x2af3, L"parsim"},
	{0x2202, L"partial"},
	{0x2aa3, L"partialmeetcontraction"},
	{0x2b20, L"pentagon"},
	{0x2b1f, L"pentagonblack"},
	{0x27c2, L"perp"},
	{0x2ae1, L"perps"},
	{0x3d5, L"phi"},
	{0x260e, L"phone"},
	{0x3c0, L"pi"},
	{0x22d4, L"pitchfork"},
	{0x2a25, L"plusdot"},
	{0x2a72, L"pluseqq"},
	{0x2a23, L"plushat"},
	{0x2a26, L"plussim"},
	{0x2a27, L"plussubtwo"},
	{0x2a28, L"plustrif"},
	{0x2647, L"pluto"},
	{0xb1, L"pm"},
	{0x2a15, L"pointnt"},
	{0x3012, L"postalmark"},
	{0x227a, L"prec"},
	{0x2ab7, L"precapprox"},
	{0x227c, L"preccurlyeq"},
	{0x2aaf, L"preceq"},
	{0x2ab3, L"preceqq"},
	{0x2ab9, L"precnapprox"},
	{0x2ab1, L"precneq"},
	{0x2ab5, L"precneqq"},
	{0x22e8, L"precnsim"},
	{0x227e, L"precsim"},
	{0x2032, L"prime"},
	{0x220f, L"prod"},
	{0x232e, L"profalar"},
	{0x2312, L"profline"},
	{0x2313, L"profsurf"},
	{0x221d, L"propto"},
	{0x22b0, L"prurel"},
	{0x3c8, L"psi"},
	{0x27d3, L"pullback"},
	{0x27d4, L"pushout"},
	{0x2057, L"qprime"},
	{0x2669, L"quarternote"},
	{0x225f, L"questeq"},
	{0x201e, L"quotdblbase"},
	{0x201f, L"quotdblright"},
	{0x201a, L"quotsinglbase"},
	{0x201b, L"quotsinglright"},
	{0x27eb, L"rAngle"},
	{0x2984, L"rBrace"},
	{0x27e7, L"rBrack"},
	{0x2986, L"rParen"},
	{0x27e9, L"rangle"},
	{0x2992, L"rangledot"},
	{0x237c, L"rangledownzigzagarrow"},
	{0x2bc, L"rasp"},
	{0x27c6, L"rbag"},
	{0x2998, L"rblkbrbrak"},
	{0x7d, L"rbrace"},
	{0x23ad, L"rbracelend"},
	{0x23ac, L"rbracemid"},
	{0x23ab, L"rbraceuend"},
	{0x5d, L"rbrack"},
	{0x23a5, L"rbrackextender"},
	{0x23a6, L"rbracklend"},
	{0x298e, L"rbracklrtick"},
	{0x298c, L"rbrackubar"},
	{0x23a4, L"rbrackuend"},
	{0x2990, L"rbrackurtick"},
	{0x2773, L"rbrbrak"},
	{0x2309, L"rceil"},
	{0x29fd, L"rcurvyangle"},
	{0x292b, L"rdiagovfdiag"},
	{0x2930, L"rdiagovsearrow"},
	{0x2315, L"recorder"},
	{0x29a3, L"revangle"},
	{0x29a5, L"revangleubar"},
	{0x29b0, L"revemptyset"},
	{0x2aee, L"revnmid"},
	{0x29d2, L"rfbowtie"},
	{0x230b, L"rfloor"},
	{0x29d5, L"rftimes"},
	{0x22b3, L"rhd"},
	{0x3c1, L"rho"},
	{0x2b4c, L"righarrowbsimilar"},
	{0x221f, L"rightangle"},
	{0x299d, L"rightanglemdot"},
	{0x299c, L"rightanglesqr"},
	{0x2192, L"rightarrow"},
	{0x2975, L"rightarrowapprox"},
	{0x2b48, L"rightarrowbackapprox"},
	{0x21e5, L"rightarrowbar"},
	{0x291e, L"rightarrowdiamond"},
	{0x2b43, L"rightarrowgtr"},
	{0x27f4, L"rightarrowonoplus"},
	{0x2945, L"rightarrowplus"},
	{0x2942, L"rightarrowshortleftarrow"},
	{0x2974, L"rightarrowsimilar"},
	{0x2b44, L"rightarrowsupset"},
	{0x21a3, L"rightarrowtail"},
	{0x21fe, L"rightarrowtriangle"},
	{0x2947, L"rightarrowx"},
	{0x290d, L"rightbkarrow"},
	{0x2933, L"rightcurvedarrow"},
	{0x21e2, L"rightdasharrow"},
	{0x291c, L"rightdbltail"},
	{0x2911, L"rightdotarrow"},
	{0x2937, L"rightdowncurvedarrow"},
	{0x297d, L"rightfishtail"},
	{0x21c1, L"rightharpoondown"},
	{0x2957, L"rightharpoondownbar"},
	{0x2964, L"rightharpoonsupdown"},
	{0x21c0, L"rightharpoonup"},
	{0x2953, L"rightharpoonupbar"},
	{0x296c, L"rightharpoonupdash"},
	{0x2970, L"rightimply"},
	{0x21c4, L"rightleftarrows"},
	{0x21cc, L"rightleftharpoons"},
	{0x2969, L"rightleftharpoonsdown"},
	{0x2968, L"rightleftharpoonsup"},
	{0x263d, L"rightmoon"},
	{0x27d6, L"rightouterjoin"},
	{0x2b54, L"rightpentagon"},
	{0x2b53, L"rightpentagonblack"},
	{0x21c9, L"rightrightarrows"},
	{0x219d, L"rightsquigarrow"},
	{0x21dd, L"rightsquigarrow"},
	{0x291a, L"righttail"},
	{0x21f6, L"rightthreearrows"},
	{0x22cc, L"rightthreetimes"},
	{0x21e8, L"rightwhitearrow"},
	{0x2a22, L"ringplus"},
	{0x2253, L"risingdotseq"},
	{0x23b1, L"rmoustache"},
	{0x239f, L"rparenextender"},
	{0x2994, L"rparengtr"},
	{0x23a0, L"rparenlend"},
	{0x239e, L"rparenuend"},
	{0x2a12, L"rppolint"},
	{0x2019, L"rq"},
	{0x298a, L"rrangle"},
	{0x2988, L"rrparenthesis"},
	{0x29f7, L"rsolbar"},
	{0x2ace, L"rsqhook"},
	{0x2a65, L"rsub"},
	{0x22ca, L"rtimes"},
	{0x29ce, L"rtriltri"},
	{0x29f4, L"ruledelayed"},
	{0x23b9, L"rvboxline"},
	{0x29d9, L"rvzigzag"},
	{0x3e1, L"sampi"},
	{0x2143, L"sansLmirrored"},
	{0x2142, L"sansLturned"},
	{0x2644, L"saturn"},
	{0x2702, L"scissors"},
	{0x2a13, L"scpolint"},
	{0x212c, L"scrB"},
	{0x2130, L"scrE"},
	{0x2131, L"scrF"},
	{0x210b, L"scrH"},
	{0x2110, L"scrI"},
	{0x2112, L"scrL"},
	{0x2133, L"scrM"},
	{0x211b, L"scrR"},
	{0x212f, L"scre"},
	{0x210a, L"scrg"},
	{0x2134, L"scro"},
	{0x22b1, L"scurel"},
	{0x2198, L"searrow"},
	{0x292d, L"seovnearrow"},
	{0x2216, L"setminus"},
	{0x29f5, L"setminus"},
	{0x266f, L"sharp"},
	{0x2adf, L"shortdowntack"},
	{0x2190, L"shortleftarrow"},
	{0x2ade, L"shortlefttack"},
	{0x2192, L"shortrightarrow"},
	{0x2944, L"shortrightarrowleftarrow"},
	{0x2ae0, L"shortuptack"},
	{0x29e2, L"shuffle"},
	{0x3c3, L"sigma"},
	{0x3c5, L"silon"},
	{0x3d2, L"silon"},
	{0x223c, L"sim"},
	{0x2243, L"simeq"},
	{0x2aa0, L"simgE"},
	{0x2a9e, L"simgtr"},
	{0x2b49, L"similarleftarrow"},
	{0x2972, L"similarrightarrow"},
	{0x2a9f, L"simlE"},
	{0x2a9d, L"simless"},
	{0x2a6c, L"simminussim"},
	{0x2246, L"simneqq"},
	{0x2a24, L"simplus"},
	{0x2a6b, L"simrdots"},
	{0x223f, L"sinewave"},
	{0x2215, L"slash"},
	{0x25c2, L"smallblacktriangleleft"},
	{0x25b8, L"smallblacktriangleright"},
	{0x22c4, L"smalldiamond"},
	{0x220a, L"smallin"},
	{0x222b, L"smallint"},
	{0x220d, L"smallni"},
	{0x2216, L"smallsetminus"},
	{0x25c3, L"smalltriangleleft"},
	{0x25b9, L"smalltriangleright"},
	{0x2a33, L"smashtimes"},
	{0x2b29, L"smblkdiamond"},
	{0x2b2a, L"smblklozenge"},
	{0x25aa, L"smblksquare"},
	{0x29e4, L"smeparsl"},
	{0x2323, L"smile"},
	{0x263a, L"smiley"},
	{0x2aaa, L"smt"},
	{0x2aac, L"smte"},
	{0x2b52, L"smwhitestar"},
	{0x25e6, L"smwhtcircle"},
	{0x2b2b, L"smwhtlozenge"},
	{0x25ab, L"smwhtsquare"},
	{0x2660, L"spadesuit"},
	{0x2222, L"sphericalangle"},
	{0x29a1, L"sphericalangleup"},
	{0x2293, L"sqcap"},
	{0x2294, L"sqcup"},
	{0x2a16, L"sqint"},
	{0x2311, L"sqlozenge"},
	{0x800221a, L"sqrt"},
	{0x800221b, L"sqrt3"},
	{0x800221c, L"sqrt4"},
	{0x23b7, L"sqrtbottom"},
	{0x228f, L"sqsubset"},
	{0x2291, L"sqsubseteq"},
	{0x22e4, L"sqsubsetneq"},
	{0x2290, L"sqsupset"},
	{0x2292, L"sqsupseteq"},
	{0x22e5, L"sqsupsetneq"},
	{0x25a9, L"squarecrossfill"},
	{0x25a9, L"squaregrayfill"},
	{0x25a4, L"squarehfill"},
	{0x25a6, L"squarehvfill"},
	{0x25e7, L"squareleftblack"},
	{0x25e8, L"squareleftblack"},
	{0x2b15, L"squarellblack"},
	{0x25f1, L"squarellquad"},
	{0x25ea, L"squarelrblack"},
	{0x25f2, L"squarelrquad"},
	{0x25a8, L"squareneswfill"},
	{0x25a7, L"squarenwsefill"},
	{0x25e9, L"squareulblack"},
	{0x25f0, L"squareulquad"},
	{0x2b14, L"squareurblack"},
	{0x25f3, L"squareurquad"},
	{0x25a5, L"squarevfill"},
	{0x25a2, L"squoval"},
	{0xdf, L"ss"},
	{0x22c6, L"star"},
	{0x225b, L"stareq"},
	{0xa3, L"sterling"},
	{0x3db, L"stigma"},
	{0x23e4, L"strns"},
	{0x2ac3, L"subedot"},
	{0x2ac1, L"submult"},
	{0x2979, L"subrarr"},
	{0x2282, L"subset"},
	{0x2ac9, L"subsetapprox"},
	{0x27c3, L"subsetcirc"},
	{0x2abd, L"subsetdot"},
	{0x2286, L"subseteq"},
	{0x2ac5, L"subseteqq"},
	{0x228a, L"subsetneq"},
	{0x2acb, L"subsetneqq"},
	{0x2abf, L"subsetplus"},
	{0x2ac7, L"subsim"},
	{0x2ad5, L"subsub"},
	{0x2ad3, L"subsup"},
	{0x227b, L"succ"},
	{0x2ab8, L"succapprox"},
	{0x227d, L"succcurlyeq"},
	{0x2ab0, L"succeq"},
	{0x2ab4, L"succeqq"},
	{0x2aba, L"succnapprox"},
	{0x2ab2, L"succneq"},
	{0x2ab6, L"succneqq"},
	{0x22e9, L"succnsim"},
	{0x227f, L"succsim"},
	{0x2211, L"sum"},
	{0x23b3, L"sumbottom"},
	{0x2a0b, L"sumint"},
	{0x23b2, L"sumtop"},
	{0x263c, L"sun"},
	{0x2ad8, L"supdsub"},
	{0x2ac4, L"supedot"},
	{0x27c9, L"suphsol"},
	{0x2ad7, L"suphsub"},
	{0x297b, L"suplarr"},
	{0x2ac2, L"supmult"},
	{0x207f, L"supn"},
	{0x2283, L"supset"},
	{0x2aca, L"supsetapprox"},
	{0x27c4, L"supsetcirc"},
	{0x2abe, L"supsetdot"},
	{0x2287, L"supseteq"},
	{0x2ac6, L"supseteqq"},
	{0x228b, L"supsetneq"},
	{0x2acc, L"supsetneqq"},
	{0x2ac0, L"supsetplus"},
	{0x2ac8, L"supsim"},
	{0x2ad4, L"supsub"},
	{0x2ad6, L"supsup"},
	{0x221a, L"surd"},
	{0x2199, L"swarrow"},
	{0x2afe, L"talloblong"},
	{0x2316, L"target"},
	{0x3c4, L"tau"},
	{0x2649, L"taurus"},
	{0x1d8d, L"testhookx"},
	{0x2051, L"textAsterisks"},
	{0x2ca, L"textacute"},
	{0x2d6, L"textadvanced"},
	{0x2bf, L"textain"},
	{0xb4, L"textasciiacute"},
	{0x5e, L"textasciicircum"},
	{0xa8, L"textasciidieresis"},
	{0x60, L"textasciigrave"},
	{0xaf, L"textasciimacron"},
	{0x7e, L"textasciitilde"},
	{0x204e, L"textasterisklow"},
	{0x2036, L"textbackdprime"},
	{0x2035, L"textbackprime"},
	{0x2037, L"textbacktrprime"},
	{0x25f, L"textbardotlessj"},
	{0x284, L"textbardotlessjvar"},
	{0x2a1, L"textbarglotstop"},
	{0x268, L"textbari"},
	{0x19a, L"textbarl"},
	{0x275, L"textbaro"},
	{0x2a2, L"textbarrevglotstop"},
	{0x289, L"textbaru"},
	{0x26c, L"textbeltl"},
	{0x1ba, L"textbenttailyogh"},
	{0x2d8, L"textbreve"},
	{0xa6, L"textbrokenbar"},
	{0x2022, L"textbullet"},
	{0x298, L"textbullseye"},
	{0xa2, L"textcent"},
	{0x2117, L"textcircledP"},
	{0x29a, L"textcloseepsilon"},
	{0x277, L"textcloseomega"},
	{0x25e, L"textcloserevepsilon"},
	{0xa9, L"textcopyright"},
	{0x180, L"textcrb"},
	{0x127, L"textcrh"},
	{0x1be, L"textcrinvglotstop"},
	{0x19b, L"textcrlambda"},
	{0x1bb, L"textcrtwo"},
	{0x255, L"textctc"},
	{0x221, L"textctd"},
	{0x286, L"textctesh"},
	{0x29d, L"textctj"},
	{0x234, L"textctl"},
	{0x235, L"textctn"},
	{0x236, L"textctt"},
	{0x293, L"textctyogh"},
	{0x291, L"textctz"},
	{0xa4, L"textcurrency"},
	{0x2a5, L"textdctzlig"},
	{0xb0, L"textdegree"},
	{0x2052, L"textdiscount"},
	{0x24, L"textdollar"},
	{0x2d9, L"textdotaccent"},
	{0x237, L"textdotlessj"},
	{0x2dd, L"textdoubleacute"},
	{0x1c2, L"textdoublebarpipe"},
	{0x1c1, L"textdoublepipe"},
	{0x2033, L"textdprime"},
	{0x2c5, L"textdptr"},
	{0x2a4, L"textdyoghlig"},
	{0x2a3, L"textdzlig"},
	{0x25b, L"textepsilon"},
	{0x283, L"textesh"},
	{0x212e, L"textestimated"},
	{0x1c3, L"textexclam"},
	{0xa1, L"textexclamdown"},
	{0x27e, L"textfishhookr"},
	{0x192, L"textflorin"},
	{0x20a3, L"textfranc"},
	{0x263, L"textgamma"},
	{0x294, L"textglotstop"},
	{0x2cb, L"textgrave"},
	{0x2d1, L"texthalflength"},
	{0x2be, L"texthamza"},
	{0xa727, L"texthen"},
	{0xa727, L"textheng"},
	{0x1d8a, L"texthooks"},
	{0x1d8e, L"texthookz"},
	{0x253, L"texthtb"},
	{0x188, L"texthtc"},
	{0x257, L"texthtd"},
	{0x260, L"texthtg"},
	{0x266, L"texthth"},
	{0x267, L"texththeng"},
	{0x199, L"texthtk"},
	{0x1a5, L"texthtp"},
	{0x2a0, L"texthtq"},
	{0x29b, L"texthtscg"},
	{0x1ad, L"texthtt"},
	{0x195, L"texthvlig"},
	{0x2010, L"texthyphen"},
	{0x296, L"textinvglotstop"},
	{0x281, L"textinvscr"},
	{0x269, L"textiota"},
	{0x2d0, L"textlengthmark"},
	{0x2d3, L"textlhalfring"},
	{0x1d81, L"textlhookd"},
	{0x1d84, L"textlhookk"},
	{0x1d85, L"textlhookl"},
	{0x1ab, L"textlhookt"},
	{0x27f, L"textlhti"},
	{0x20a4, L"textlira"},
	{0x27c, L"textlonglegr"},
	{0x2ae, L"textlongy"},
	{0x2af, L"textlongy"},
	{0x1aa, L"textlooptoprevesh"},
	{0x2cf, L"textlowacute"},
	{0x2d5, L"textlowered"},
	{0x2ce, L"textlowgrave"},
	{0x2cd, L"textlowmacron"},
	{0x2c2, L"textlptr"},
	{0x271, L"textltailm"},
	{0x272, L"textltailn"},
	{0x26b, L"textltilde"},
	{0x26e, L"textlyoghlig"},
	{0x2c9, L"textmacron"},
	{0xb5, L"textmu"},
	{0x2116, L"textnumero"},
	{0x2db, L"textogonek"},
	{0x2126, L"textohm"},
	{0xbd, L"textonehalf"},
	{0xbc, L"textonequarter"},
	{0xb9, L"textonesuperior"},
	{0x254, L"textopeno"},
	{0xaa, L"textordfeminine"},
	{0xba, L"textordmasculine"},
	{0x2df, L"textovercross"},
	{0x2125, L"textoz"},
	{0x2031, L"textpertenthousand"},
	{0x2030, L"textperthousand"},
	{0x20a7, L"textpesetas"},
	{0x278, L"textphi"},
	{0x1c0, L"textpipe"},
	{0x2032, L"textprime"},
	{0x2c8, L"textprimstress"},
	{0x2057, L"textqprime"},
	{0xbf, L"textquestiondown"},
	{0x22, L"textquotedbl"},
	{0x201c, L"textquotedblleft"},
	{0x201d, L"textquotedblright"},
	{0x2d4, L"textraised"},
	{0x2c0, L"textraiseglotstop"},
	{0x2c1, L"textraiserevglotstop"},
	{0x264, L"textramshorns"},
	{0x211e, L"textrecipe"},
	{0x203b, L"textreferencemark"},
	{0xae, L"textregistered"},
	{0x2d7, L"textretracted"},
	{0x258, L"textreve"},
	{0x25c, L"textrevepsilon"},
	{0x295, L"textrevglotstop"},
	{0x2d2, L"textrhalfring"},
	{0x25d, L"textrhookrevepsilon"},
	{0x25a, L"textrhookschwa"},
	{0x2de, L"textrhoticity"},
	{0x2da, L"textringaccent"},
	{0x2c3, L"textrptr"},
	{0x256, L"textrtaild"},
	{0x26d, L"textrtaill"},
	{0x273, L"textrtailn"},
	{0x27d, L"textrtailr"},
	{0x282, L"textrtails"},
	{0x288, L"textrtailt"},
	{0x290, L"textrtailz"},
	{0x1d00, L"textsca"},
	{0x299, L"textscb"},
	{0x1d07, L"textsce"},
	{0x262, L"textscg"},
	{0x29c, L"textsch"},
	{0x259, L"textschwa"},
	{0x26a, L"textsci"},
	{0x29f, L"textscl"},
	{0x274, L"textscn"},
	{0x276, L"textscoelig"},
	{0x280, L"textscr"},
	{0x251, L"textscripta"},
	{0x261, L"textscriptg"},
	{0x28b, L"textscriptv"},
	{0x1d1c, L"textscu"},
	{0x28f, L"textscy"},
	{0x2cc, L"textsecstress"},
	{0x204f, L"textsemicolonreversed"},
	{0x3a5, L"textsilon"},
	{0x2dc, L"textsmalltilde"},
	{0x297, L"textstretchcvar"},
	{0x77, L"textsubw"},
	{0x2b0, L"textsuph"},
	{0x2b1, L"textsuphth"},
	{0x2b6, L"textsupinvscr"},
	{0x2b2, L"textsupj"},
	{0x2b3, L"textsupr"},
	{0x2b4, L"textsupturnr"},
	{0x2b5, L"textsupturnrrtail"},
	{0x2b7, L"textsupw"},
	{0x2b8, L"textsupy"},
	{0x2a7, L"texttctctlig"},
	{0x2a8, L"texttctctlig"},
	{0xbe, L"textthreequarters"},
	{0xb3, L"textthreesuperior"},
	{0x2122, L"texttrademark"},
	{0x2034, L"texttrprime"},
	{0x2a6, L"texttslig"},
	{0x250, L"textturna"},
	{0x2bb, L"textturncomma"},
	{0x265, L"textturnh"},
	{0x29e, L"textturnk"},
	{0x27a, L"textturnlonglegr"},
	{0x26f, L"textturnm"},
	{0x270, L"textturnmrleg"},
	{0x279, L"textturnr"},
	{0x27b, L"textturnrrtail"},
	{0x252, L"textturnscripta"},
	{0x287, L"textturnt"},
	{0x28c, L"textturnv"},
	{0x28d, L"textturnw"},
	{0x28e, L"textturny"},
	{0xb2, L"texttwosuperior"},
	{0x28a, L"textupsilon"},
	{0x2c4, L"textuptr"},
	{0x285, L"textvibyi"},
	{0x2423, L"textvisiblespace"},
	{0x292, L"textyogh"},
	{0xfe, L"th"},
	{0x2234, L"therefore"},
	{0x29e7, L"thermod"},
	{0x3b8, L"theta"},
	{0x2248, L"thickapprox"},
	{0x223c, L"thicksim"},
	{0x27c0, L"threedangle"},
	{0x2af6, L"threedotcolon"},
	{0x2040, L"tieconcat"},
	{0x29dd, L"tieinfty"},
	{0xd7, L"times"},
	{0x2a31, L"timesbar"},
	{0x29ff, L"tminus"},
	{0x2192, L"to"},
	{0x2928, L"toea"},
	{0x2927, L"tona"},
	{0x2e5, L"tonebarextrahigh"},
	{0x2e9, L"tonebarextralow"},
	{0x2e6, L"tonebarhigh"},
	{0x2e8, L"tonebarlow"},
	{0x2e7, L"tonebarmid"},
	{0x22a4, L"top"},
	{0x2336, L"topbot"},
	{0x2af1, L"topcir"},
	{0x2ada, L"topfork"},
	{0x25e0, L"topsemicircle"},
	{0x2929, L"tosa"},
	{0x292a, L"towa"},
	{0x29fe, L"tplus"},
	{0x23e2, L"trapezium"},
	{0x25ec, L"trianglecdot"},
	{0x25bf, L"triangledown"},
	{0x26a0, L"triangleexclam"},
	{0x25c1, L"triangleleft"},
	{0x25ed, L"triangleleftblack"},
	{0x22b4, L"trianglelefteq"},
	{0x2a3a, L"triangleminus"},
	{0x29ca, L"triangleodot"},
	{0x2a39, L"triangleplus"},
	{0x225c, L"triangleq"},
	{0x25b7, L"triangleright"},
	{0x25ee, L"trianglerightblack"},
	{0x22b5, L"trianglerighteq"},
	{0x29cc, L"triangles"},
	{0x29cd, L"triangleserifs"},
	{0x2a3b, L"triangletimes"},
	{0x29cb, L"triangleubar"},
	{0x29fb, L"tripleplus"},
	{0x2034, L"trprime"},
	{0x29a2, L"turnangle"},
	{0x2129, L"turnediota"},
	{0x2319, L"turnednot"},
	{0x2a4b, L"twocaps"},
	{0x2a4a, L"twocups"},
	{0x21a1, L"twoheaddownarrow"},
	{0x219e, L"twoheadleftarrow"},
	{0x2b3b, L"twoheadleftarrowtail"},
	{0x2b37, L"twoheadleftdbkarrow"},
	{0x2b36, L"twoheadmapsfrom"},
	{0x2905, L"twoheadmapsto"},
	{0x21a0, L"twoheadrightarrow"},
	{0x2916, L"twoheadrightarrowtail"},
	{0x219f, L"twoheaduparrow"},
	{0x2949, L"twoheaduparrowcircle"},
	{0x2017, L"twolowline"},
	{0x266b, L"twonotes"},
	{0x2982, L"typecolon"},
	{0x23e1, L"ubrbrak"},
	{0x1b0, L"uhorn"},
	{0x25dc, L"ularc"},
	{0x25e4, L"ulblacktriangle"},
	{0x231c, L"ulcorner"},
	{0x230f, L"ulcrop"},
	{0x25f8, L"ultriangle"},
	{0x2a41, L"uminus"},
	{0x23df, L"underbrace"},
	{0x23b5, L"underbracket"},
	{0x23dd, L"underparen"},
	{0x22b4, L"unlhd"},
	{0x22b5, L"unrhd"},
	{0x214b, L"upand"},
	{0x2191, L"uparrow"},
	{0x2909, L"uparrowbarred"},
	{0x29bd, L"uparrowoncircle"},
	{0x21e2, L"updasharrow"},
	{0x2195, L"updownarrow"},
	{0x21a8, L"updownarrowbar"},
	{0x21c5, L"updownarrows"},
	{0x2951, L"updownharpoonleftleft"},
	{0x294d, L"updownharpoonleftright"},
	{0x294c, L"updownharpoonrightleft"},
	{0x294f, L"updownharpoonrightright"},
	{0x296e, L"updownharpoonsleftright"},
	{0x297e, L"upfishtail"},
	{0x21bf, L"upharpoonleft"},
	{0x2960, L"upharpoonleftbar"},
	{0x21be, L"upharpoonright"},
	{0x295c, L"upharpoonrightbar"},
	{0x2963, L"upharpoonsleftright"},
	{0x27d2, L"upin"},
	{0x2a1b, L"upint"},
	{0x228e, L"uplus"},
	{0x2934, L"uprightcurvearrow"},
	{0x21c8, L"upuparrows"},
	{0x21e7, L"upwhitearrow"},
	{0x25dd, L"urarc"},
	{0x25e5, L"urblacktriangle"},
	{0x231d, L"urcorner"},
	{0x230e, L"urcrop"},
	{0x25f9, L"urtriangle"},
	{0x2c7, L"v"},
	{0x2ae8, L"vBar"},
	{0x2ae9, L"vBarv"},
	{0x22a8, L"vDash"},
	{0x2ae2, L"vDdash"},
	{0x3f4, L"varTheta"},
	{0x2ae6, L"varVdash"},
	{0x2305, L"varbarwedge"},
	{0x3d0, L"varbeta"},
	{0x2667, L"varclubsuit"},
	{0x2666, L"vardiamondsuit"},
	{0x2306, L"vardoublebarwedge"},
	{0x3b5, L"varepsilon"},
	{0x2665, L"varheartsuit"},
	{0x2b21, L"varhexagon"},
	{0x2b22, L"varhexagonblack"},
	{0x232c, L"varhexagonlrbonds"},
	{0x2208, L"varin"},
	{0x22f6, L"varisinobar"},
	{0x22f3, L"varisins"},
	{0x3f0, L"varkappa"},
	{0x22bf, L"varlrtriangle"},
	{0x220b, L"varni"},
	{0x22fd, L"varniobar"},
	{0x22fb, L"varnis"},
	{0x2205, L"varnothing"},
	{0x2232, L"varointclockwise"},
	{0x3c6, L"varphi"},
	{0x3d6, L"varpi"},
	{0x221d, L"varpropto"},
	{0x3f1, L"varrho"},
	{0x23d0, L"varrowextender"},
	{0x3c2, L"varsigma"},
	{0x2664, L"varspadesuit"},
	{0x2736, L"varstar"},
	{0x3d1, L"vartheta"},
	{0x25b5, L"vartriangle"},
	{0x22b2, L"vartriangleleft"},
	{0x22b3, L"vartriangleright"},
	{0x2a61, L"varveebar"},
	{0x23aa, L"vbraceextender"},
	{0x29d0, L"vbrtri"},
	{0x22a2, L"vdash"},
	{0x22ee, L"vdots"},
	{0x2a2f, L"vectimes"},
	{0x2228, L"vee"},
	{0x22bb, L"veebar"},
	{0x27c7, L"veedot"},
	{0x2a63, L"veedoublebar"},
	{0x225a, L"veeeq"},
	{0x2a5b, L"veemidvert"},
	{0x2a52, L"veeodot"},
	{0x2a56, L"veeonvee"},
	{0x2a59, L"veeonwedge"},
	{0x7c, L"vert"},
	{0x2317, L"viewdata"},
	{0x27dd, L"vlongdash"},
	{0x25af, L"vrectangle"},
	{0x25ae, L"vrectangleblack"},
	{0x2b1d, L"vysmlblksquare"},
	{0x2b1e, L"vysmlwhtsquare"},
	{0x299a, L"vzigzag"},
	{0x231a, L"watchicon"},
	{0x2227, L"wedge"},
	{0x2a5f, L"wedgebar"},
	{0x27d1, L"wedgedot"},
	{0x2a60, L"wedgedoublebar"},
	{0x2a5a, L"wedgemidvert"},
	{0x2a51, L"wedgeodot"},
	{0x2a55, L"wedgeonwedge"},
	{0x2259, L"wedgeq"},
	{0x21ea, L"whitearrowupfrombar"},
	{0x27c1, L"whiteinwhitetriangle"},
	{0x25c5, L"whitepointerleft"},
	{0x25bb, L"whitepointerright"},
	{0x27e4, L"whitesquaretickleft"},
	{0x27e5, L"whitesquaretickright"},
	{0x2b2d, L"whthorzoval"},
	{0x2b2f, L"whtvertoval"},
	{0x29a6, L"wideangledown"},
	{0x29a7, L"wideangleup"},
	{0x2118, L"wp"},
	{0x2240, L"wr"},
	{0x29f9, L"xbsol"},
	{0x3be, L"xi"},
	{0x29f8, L"xsol"},
	{0xa5, L"yen"},
	{0x3b6, L"zeta"},
	{0x2a20, L"zpipe"},
{0, L""}};
//-----------------------------------------------------------------------------
