/*!
  @file           KSQL_ResultSet.hpp
  @author         ThomasA
  @brief          Implements a class for result set handling

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#ifndef KSQL_RESULTSET_HPP
#define KSQL_RESULTSET_HPP

#include "SQLManager/SQLMan_Types.hpp"
#include "SAPDBCommon/SAPDB_Types.hpp"

namespace SQLDBC {
    class  SQLDBC_ResultSet;
};

class KSQL_ResultSet
{
public :
    int getInt2 (int Index, SAPDB_Int2& i2);
    int getInt4 (int Index, SAPDB_Int4& i4);
    int getSurrogate (int Index, SQLMan_Surrogate& surrogate);
    int getIdentifier (int Index, SQLMan_Identifier& identifier);
    int next();
private :
    KSQL_ResultSet(SQLDBC::SQLDBC_ResultSet*);
    SQLDBC::SQLDBC_ResultSet* m_resultSet;
    friend class KSQL_Statement;
};

#endif
