/****************************************************************************/
/*!

  @file        SysView_Sessions.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "Sessions" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "hgg01_3.h" // vtrace
#include "hgg03.h"
#include "hsp78.h"
#include "hgg04.h"
#include "hak51.h"
#include "hkb51_2.h"
#if defined (WIN32)
#include "gos003.h" /* nocheck */
#else
#include "hen53.h"  /* nocheck */
#endif
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_Sessions.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_Sessions::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Sessions::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_FIXED ,SV_SESSIONID, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_OWN, 3);
	m_Table->AppendCol (ITOCT_TIMESTAMP ,SV_STARTDATE, 0);
	m_Table->AppendCol (ITOCT_CHAR ,SV_APPLICATIONNODE, 64);
	m_Table->AppendCol (ITOCT_FIXED ,SV_APPLICATIONPROCESS, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_APPLICATIONTYPE, 3);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_USERNAME, 32);
	m_Table->AppendCol (ITOCT_FIXED ,SV_PEERPROCESSID, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_CONNECTSTATE, 32);
	m_Table->AppendCol (ITOCT_FIXED ,SV_TASKID, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_OMSHEAPUSEDSIZE, 20);
	m_Table->AppendCol (ITOCT_CHAR ,SV_TRACE, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_CATALOGCACHEUSEDSIZE, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDTEMPORARYSIZE, 10);
    m_Table->AppendCol (ITOCT_FIXED, SV_PAGINGFILEUSEDSIZE, 10);  
	m_Table->AppendCol (ITOCT_CHAR ,SV_SQLMODE, 8);
	m_Table->AppendCol (ITOCT_FIXED ,SV_ISOLATIONLEVEL, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_TIMEOUT, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_DATEFORMAT, 50);
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Sessions::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Sessions::GetColCount", SysView_Trace, 5);

    return SV_CC_SESSIONS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Sessions::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Sessions::EstimateRows", SysView_Trace, 5);

    return SV_ER_SESSIONS;
}

/*---------------------------------------------------------------------------*/

void SysView_Sessions::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Sessions::Execute", SysView_Trace, 5);
    m_Table->GetCatalogTable();
    pasbool isFirst = true;
    do
    {
        SQLMan_Context* pContext = reinterpret_cast<SQLMan_Context*> (a51NextSession(isFirst));
        if (pContext)
        {
            tgg91_SessionNo& session = pContext->TransContext().trSessionId_gg00;
            SAPDB_Int4 i4 = 256 * (256 * (256 * session[0] + session[1]) + session[2]) + session[3]; 
            AddColumn(i4);
            bool isOwn = (&m_Context == pContext);
            m_Table->MoveToCol (ITOVT_YESNO, &isOwn, 0);
            SAPDB_Int4 sessionStartDate;
            SAPDB_Int4 sessionStartTime;
            tgg00_TransContext auxTrans = pContext->TransContext();
            auxTrans.trTaskId_gg00      = m_Context.TransContext().trTaskId_gg00;
            kb51GetSessionStart (auxTrans, sessionStartDate, sessionStartTime);
            if (sessionStartDate > 0)
            {
                char tsString[TIMESTAMP_MXSP00+1];
                memset (tsString, '0', TIMESTAMP_MXSP00);
                tsString[TIMESTAMP_MXSP00] = 0;
                SAPDB_Int8 ts = ((SAPDB_Int8) sessionStartDate * 1000000) + sessionStartTime;
                SAPDB_ToStringClass str = ToStr(ts);
                memcpy (tsString, (char*) str, strlen(str));
                AddColumn(tsString);
            }
            else
            {
                AddColumn();
            }
            tsp00_NodeId applNode;
            tsp00_Int4   applPid;
            tsp00_Bool   ok;
            vgetapplpid (pContext->TransContext().trTaskId_gg00, applNode, applPid, ok);
            if (ok)
            {
                AddColumn((SAPDB_Char*)&applNode, sizeof(applNode));
                AddColumn(applPid);
            }
            else
            {
                AddColumn();
                AddColumn();
            }
            switch (pContext->a_comp_type)
            {
            case at_cpc :
                AddColumn (csp_comp_cpc);
                break;
            case at_cpp :
                AddColumn (csp_comp_cpp);
                break;
            case at_db_manager :
                AddColumn (csp_comp_db_manager);
                break;
            case at_gpc :
                AddColumn (csp_comp_gpc );
                break;
            case at_jdbc :
                AddColumn (csp_comp_jdbc);
                break;
            case at_load :
                AddColumn (csp_comp_load);
                break;
            case at_odbc :
                AddColumn (csp_comp_odbc);
                break;
            case at_util :
                AddColumn (csp_comp_util);
                break;
            case at_xci :
                AddColumn (csp_comp_xci);
                break;
            default :
                AddColumn("UNKNOWN");
            }
            m_Table->MoveToCol (ITOVT_KNLIDENTIFIER, &pContext->a_curr_user_name, 0);
            AddColumn();
            AddColumn();
            AddColumn(pContext->TransContext().trTaskId_gg00);
            AddColumn();
            bool vtrace = (g01vtrace.vtrAny_gg00 || (g01vtrace.vtrSession_gg00 == session));
            m_Table->MoveToCol (ITOVT_YESNO, &vtrace, 0);
            int kbFactor = PAGE_MXSP00 / 1024;
            AddColumn(a51CatalogCacheSize() * kbFactor);
            AddColumn(pContext->TransContext().trTempCount_gg00 * kbFactor);
            if (pContext->a_pars_curr_size > 0)
            {
                AddColumn(pContext->a_pars_curr_size * kbFactor);
            }
            else
            {
                AddColumn();
            }
            tsp00_SqlMode_Enum sqlmode(pContext->a_sqlmode);
            m_Table->MoveToCol (ITOVT_SQLMODE, &sqlmode, 0);
            AddColumn(pContext->a_iso_level);
            AddColumn(pContext->a_user_timeout);
            if (sqlm_oracle == pContext->a_sqlmode)
            {
                char UserDateFormat[50];
                s78df_clear(g03dictionary.dict[1], 
                    (tsp00_MoveObjPtr) &pContext->a_nls_params.date_format[0], pContext->a_nls_params.df_length,
                    (tsp00_MoveObjPtr) &UserDateFormat[0], sizeof(UserDateFormat));
                m_Table->MoveToCol (ITOVT_CHARPTR,  (SAPDB_Char *) &UserDateFormat[0], sizeof(UserDateFormat));
            }
            else
            {
                tgg00_DateTimeFormat_Enum dt_format(pContext->a_dt_format);
                m_Table->MoveToCol (ITOVT_DATETIMEFORMAT, &dt_format, 0);
            }
        }
        else
        {
            break;
        }
    }
    while (m_Context.IsOk());
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
