/*!
 * \file    LVCMem_GlobalUserAllocatorRegister.hpp
 * \author  IvanS
 * \brief   LiveCache global user allocator register.
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#ifndef __LVCMEM_GLOBALUSERALLOCATORREGISTER_HPP
#define __LVCMEM_GLOBALUSERALLOCATORREGISTER_HPP

#include "liveCache/MemoryManagement/LVCMem_UserAllocator.hpp"

class CIliveCacheSink;

class LVCMem_GlobalUserAllocatorRegister {
public:
  LVCMem_UserAllocator *get(SAPDBMem_IRawAllocator &alloc,
    SAPDBMem_IRawAllocator &blockalloc,
    const SAPDB_UTF8 *name, IliveCacheSink *sink);

  static inline LVCMem_GlobalUserAllocatorRegister &Instance()
  {
    return m_instance;
  }

private:
  static LVCMem_GlobalUserAllocatorRegister m_instance;
};

#endif  // __LVCMEM_GLOBALUSERALLOCATORREGISTER_HPP