#
#   FreeBlockManagement
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

* -except               # enable exception handling

regex(*\.hpp$)          inc=+Kernel_Common.hpp,FBM_Types.hpp

# -------------------------------------------------------------------------------------
# Master files
# -------------------------------------------------------------------------------------

FBM_IManager.hpp     inc=+RTE_Types.h,\
                         IOMan_ReservedBlockAddress.hpp,\
                         IOMan_BlockAddress.hpp,\
                         IOMan_IBlockAddressIterator.hpp,\
                         IOMan_ClusterAddress.hpp,\
                         -Kernel_Common.hpp

FBM_Manager.hpp     inc=+gsp00,\
                         ggg00,\
                         heo51.h,\
                         heo55k.h,\
                         hgg08.h,\
                         FBM_IManager.hpp,\
                         FBM_DataVolumeArray.hpp,\
                         Kernel_Dump.hpp,\
                         RTEMem_AllocatorWrapper.hpp,\
                         SAPDBMem_IRawAllocator.hpp,\
                         -FBM_Types.hpp

FBM_Manager.cpp     inc=+hgg08.h,\
                         hgg01.h,\
                         Container_Vector.hpp,\
                         FBM_Manager.hpp,\
                         FBM_DataVolume.hpp,\
                         FBM_SequentialDataVolume.hpp,\
                         FBM_Dump.hpp,\
                         FBM_Types.hpp,\
                         FBM_Exception.hpp,\
                         RTE_Crash.hpp,\
                         RTE_Message.hpp,\
                         RTEMem_Allocator.hpp,\
                         RTEConf_ParameterAccessKernelInterface.hpp,\
                         Log_Types.hpp,\
                         Log_Savepoint.hpp

# -------------------------------------------------------------------------------------
# Exceptions and errors
# -------------------------------------------------------------------------------------                          

FBM_Messages.genmsg                 ascii

FBM_Messages.hpp                    inc=SAPDBErr_MessageList.hpp

FBM_Exception.hpp                   inc=FBM_Messages.hpp,\
                                        FBM_Types.hpp

# -------------------------------------------------------------------------------------
# Interface to the old pascal sources
# -------------------------------------------------------------------------------------                          

FBM_PascalInterface.cpp inc=FBM_Manager.hpp,gbd00,gsp03_3,gsp03,hgg01_1.h,hbd11.h

# -------------------------------------------------------------------------------------
# Interfaces and basic types:
# -------------------------------------------------------------------------------------

FBM_Types.hpp          inc=SAPDBDiag_CheckTopic.hpp,\
                           SAPDBTrace_Topic.hpp

FBM_Dump.hpp           inc=SAPDB_Types.hpp

# -------------------------------------------------------------------------------------
# Utility structures:
# -------------------------------------------------------------------------------------

FBM_BlockStateList.hpp  inc=+SAPDBMem_IRawAllocator.hpp
                               
FBM_IDataVolume.hpp     inc=+Kernel_Dump.hpp,\
                             RTE_Types.h

FBM_DataVolumeArray.hpp      inc=+FBM_IDataVolume.hpp,\
                                  Container_Vector.hpp,\
                                 -FBM_Types.hpp,\
                                 -Kernel_Common.hpp

FBM_DataVolume.hpp      inc=+Container_Vector.hpp,\
                             FBM_BlockStateList.hpp,\
                             FBM_IDataVolume.hpp,\
                            -FBM_Types.hpp,\
                            -Kernel_Common.hpp

FBM_DataVolume.cpp      inc=+FBM_DataVolume.hpp,\
                             FBM_Dump.hpp,\
                             FBM_Exception.hpp,\
                             RTE_Message.hpp,\
                             RTE_Crash.hpp,\
                             FBM_Messages.hpp



FBM_SequentialDataVolume.hpp      inc=+FBM_IDataVolume.hpp,\
                                       SAPDBMem_IRawAllocator.hpp,\
                                     -FBM_Types.hpp,\
                                     -Kernel_Common.hpp

FBM_SequentialDataVolume.cpp      inc=+FBM_SequentialDataVolume.hpp,\
                             FBM_Dump.hpp,\
                             FBM_Exception.hpp,\
                             RTE_Message.hpp,\
                             RTE_Crash.hpp,\
                             FBM_Messages.hpp

