# ------------------------------------------------------------------------------
#
# IOManager Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

#regex(.*\.cpp$)    -except  NOT Exceptions in Release 7.X
regex(*\.hpp$)              inc=Kernel_Common.hpp

# ------------------------------------------------------------------------------
# Errors and messages:
# ------------------------------------------------------------------------------
#

IOMan_Messages.genmsg               ascii

IOMan_Messages.hpp                  inc=SAPDBErr_MessageList.hpp

IOMan_Exception.hpp                 inc=SAPDBErr_MessageList.hpp

# ------------------------------------------------------------------------------
# Interfaces:
# ------------------------------------------------------------------------------
#

IOMan_IConverterIO.hpp              inc=-Kernel_Common.hpp

IOMan_IDataInfo.hpp                 inc=+IOMan_Types.hpp

IOMan_IDataIO.hpp                   inc=-Kernel_Common.hpp,\
                                        +Data_Types.hpp,\
                                        IOMan_Types.hpp,\
                                        IOMan_DataPages.hpp
 
IOMan_IDataManager.hpp              inc=IOMan_Types.hpp

IOMan_IDiagnose.hpp                 inc=-Kernel_Common.hpp,\
                                        +gsp00,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_Types.hpp

IOMan_ILogInfo.hpp                  inc=+IOMan_Types.hpp

IOMan_ILogManager.hpp               inc=-Kernel_Common.hpp,\
                                         +IOMan_Types.hpp,\
                                         IOMan_LogPages.hpp


IOMan_ILogIO.hpp                    inc=-Kernel_Common.hpp,\
                                        +IOMan_LogPages.hpp

IOMan_IMigration.hpp                inc=gsp00

IOMan_IDataVolumeInfo.hpp           inc=gsp00,\
                                        Kernel_Common.hpp,\
                                        IOMan_Types.hpp

IOMan_IDataVolumeInfo.cpp           inc=IOMan_IDataVolumeInfo.hpp,\
                                        IOMan_Manager.hpp,\
                                        FBM_IManager.hpp

IOMan_ILogVolumeInfo.hpp            inc=gsp00,\
                                        Kernel_Common.hpp,\
                                        IOMan_Types.hpp

IOMan_ILogVolumeInfo.cpp            inc=IOMan_ILogVolumeInfo.hpp,\
                                        IOMan_Manager.hpp

# ------------------------------------------------------------------------------
# Basic types:
# ------------------------------------------------------------------------------
#

IOMan_Types.hpp                     inc=+SAPDB_EnhancedTypes.hpp,\
                                        SAPDBTrace_Topic.hpp,\
                                        SAPDBDiag_CheckTopic.hpp

IOMan_BlockAddress.hpp              inc=-Kernel_Common.hpp,\
                                        +IOMan_Types.hpp,\
                                        SAPDBErr_Assertions.hpp

IOMan_ClusterAddress.hpp            inc=-Kernel_Common.hpp,\
                                        +IOMan_BlockAddress.hpp,\
                                        IOMan_Types.hpp,\
                                        SAPDBErr_Assertions.hpp

IOMan_ConverterPages.hpp            inc=-Kernel_Common.hpp,\
                                        +Converter_Page.hpp,\
                                        IOMan_KernelPages.hpp

IOMan_DataPages.hpp                 inc=-Kernel_Common.hpp,\
                                        +Data_BasePage.hpp,\
                                        IOMan_KernelPages.hpp

IOMan_LogPages.hpp                  inc=-Kernel_Common.hpp,\
                                        +Log_Page.hpp,\
                                        IOMan_KernelPages.hpp

IOMan_KernelPages.hpp               inc=+gsp00,\
                                        Container_Vector.hpp,\
                                        Kernel_IPage.hpp,\
                                        RTEMem_AllocatorWrapper.hpp,\
                                        SAPDBMem_IRawAllocator.hpp

IOMan_InfoPage.hpp                  inc=+Kernel_Page74.hpp,\
                                        IOMan_Types.hpp

IOMan_PageFrameAllocator.hpp        inc=+gsp00,\
                                        FrameCtrl_IIOManager.hpp,\
                                        Kernel_IPage.hpp

IOMan_ReservedBlockAddress.hpp      inc=+IOMan_BlockAddress.hpp,\
                                        IOMan_Types.hpp

IOMan_IBlockAddressIterator.hpp     inc=SAPDB_Types.hpp,\
                                        IOMan_Types.hpp,\
                                        IOMan_BlockAddress.hpp

# ------------------------------------------------------------------------------
# Manager:
# ------------------------------------------------------------------------------
#

IOMan_Manager.hpp                   inc=+gsp00,\
                                        ggg00,\
                                        Converter_Page.hpp,\
                                        Data_BasePage.hpp,\
                                        Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_DataArea.hpp,\
                                        IOMan_ConverterPages.hpp,\
                                        IOMan_DataPages.hpp,\
                                        IOMan_LogArea.hpp,\
                                        IOMan_LogPages.hpp,\
                                        IOMan_PageFrameAllocator.hpp,\
                                        IOMan_ReservedBlockAddress.hpp,\
                                        IOMan_Types.hpp,\
                                        Kernel_Common.hpp,\
                                        Kernel_RestartPage.hpp,\
                                        Log_ClusterAddress.hpp,\
                                        Log_InfoPage.hpp,\
                                        Log_Page.hpp,\
                                        IOMan_IConverterIO.hpp,\
                                        IOMan_IDataInfo.hpp,\
                                        IOMan_IDataIO.hpp,\
                                        IOMan_IDataManager.hpp,\
                                        IOMan_IDiagnose.hpp,\
                                        IOMan_ILogInfo.hpp,\
                                        IOMan_ILogIO.hpp,\
                                        IOMan_ILogManager.hpp,\
                                        IOMan_IMigration.hpp,\
                                        RTEMem_AllocatorWrapper.hpp,\
                                        SAPDBMem_IRawAllocator.hpp

IOMan_Manager.cpp                   inc=+hbd73.h,\
                                        hkb57.h,\
                                        hgg01_3.h,\
                                        vsp002,\
                                        heo58.h,\
                                        heo56.h,\
                                        Converter_ICommon.hpp,\
                                        Converter_IPageNoMapping.hpp,\
                                        Converter_Types.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Manager.hpp,\
                                        IOMan_Messages.hpp,\
                                        IOMan_Migration.hpp,\
                                        IOMan_Types.hpp,\
                                        Kernel_FileIO.hpp,\
                                        KernelParam_IOManager.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        RTEMem_Allocator.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp,\
                                        RTEConf_ParameterAccess.hpp,\
                                        RTEConf_ParameterAccessKernelInterface.hpp,\
                                        SAPDB_ToString.hpp,\
                                        FBM_Types.hpp,\
                                        FBM_IManager.hpp,\
                                        Trace_DevSpaceIOEntry.hpp

# ------------------------------------------------------------------------------
# DataVolumes:
# ------------------------------------------------------------------------------
#

IOMan_DataArea.hpp                  inc=+gsp00,\
                                        Container_Vector.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_DataVolume.hpp,\
                                        IOMan_PageFrameAllocator.hpp,\
                                        IOMan_Types.hpp,\
                                        SAPDBMem_IRawAllocator.hpp

IOMan_DataArea.cpp                  inc=+heo79_1.h,\
                                         IOMan_DataArea.hpp,\
                                         IOMan_Exception.hpp,\
                                         IOMan_Messages.hpp,\
                                         Converter_IManager.hpp,\
                                         Kernel_IPage.hpp,\
                                         RTE_Crash.hpp,\
                                         RTE_Message.hpp

IOMan_DataVolume.hpp                inc=+gsp00,\
                                        vsp002,\
                                        Kernel_IPage.hpp,\
                                        IOMan_Volume.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_Types.hpp

# ------------------------------------------------------------------------------
# LogVolumes:
# ------------------------------------------------------------------------------
#

IOMan_LogArea.hpp                   inc=+Container_Vector.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_LogDevice.hpp,\
                                        IOMan_PageFrameAllocator.hpp,\
                                        IOMan_Types.hpp,\
                                        IOMan_LogPages.hpp,\
                                        IOMan_LogDevices.hpp,\
                                        Log_Types.hpp,\
                                        SAPDBMem_IRawAllocator.hpp

IOMan_LogArea.cpp                   inc=+heo79_1.h,\
                                        IOMan_LogArea.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        IOMan_ReservedBlockAddress.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp,\
                                        SAPDB_ToString.hpp


IOMan_LogVolume.hpp                 inc=+gsp00,\
                                        vsp002,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_Volume.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_Types.hpp,\
                                        Log_Types.hpp
                                        

IOMan_LogVolume.cpp                 inc=+heo56.h,\
                                        IOMan_LogVolume.hpp,\
                                        IOMan_ReservedBlockAddress.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        Kernel_FileIO.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp

IOMan_MirrorLogVolume.hpp           inc=+gsp00,\
                                        IOMan_LogVolume.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_Types.hpp

IOMan_MirrorLogVolume.cpp           inc=+IOMan_MirrorLogVolume.hpp,\
                                        IOMan_ReservedBlockAddress.hpp

IOMan_LogDevices.hpp                inc=+Container_Vector.hpp,\
                                        IOMan_LogDevice.hpp,\
                                        IOMan_DualLogDevice.hpp,\
                                        IOMan_Types.hpp,\
                                        SAPDBMem_IRawAllocator.hpp

IOMan_LogDevices.cpp                inc=SAPDBMem_NewDestroy.hpp,\
                                        IOMan_LogDevices.hpp,\
                                        IOMan_SingleLogDevice.hpp,\
                                        SAPDBMem_NewDestroy.hpp

IOMan_LogDevice.hpp                 inc=+gsp00,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_InfoPage.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_LogVolume.hpp,\
                                        IOMan_Types.hpp,\
                                        Kernel_IPage.hpp,\
                                        Log_Types.hpp

IOMan_SingleLogDevice.hpp           inc=+IOMan_LogDevice.hpp,\
                                        IOMan_LogVolume.hpp,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_InfoPage.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_Types.hpp,\
                                        Kernel_IPage.hpp,\
                                        Log_Types.hpp

IOMan_SingleLogDevice.cpp           inc=+IOMan_SingleLogDevice.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        RTE_Message.hpp

IOMan_DualLogDevice.hpp             inc=+gsp00,\
                                        IOMan_LogDevice.hpp,\
                                        IOMan_LogVolume.hpp,\
                                        IOMan_MirrorLogVolume.hpp

IOMan_DualLogDevice.cpp             inc=+vsp002,\
                                        heo54k.h,\
                                        IOMan_DualLogDevice.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        Kernel_FileIO.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp,\
                                        SAPDB_ToString.hpp


# ------------------------------------------------------------------------------
# Common DevSpace:
# ------------------------------------------------------------------------------
#

IOMan_Volume.hpp                  inc=+gsp00,\
                                        vsp002,\
                                        IOMan_ClusterAddress.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_Types.hpp,\
                                        IOMan_InfoPage.hpp,\
                                        Kernel_IPage.hpp,\
                                        RTEIO_DevSpaceInfo.hpp

IOMan_Volume.cpp                  inc=+hgg08.h,\
                                        heo54k.h,\
                                        heo55k.h,\
                                        heo56.h,\
                                        heo58.h,\
                                        IOMan_Volume.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        IOMan_ReservedBlockAddress.hpp,\
                                        FrameCtrl_ICommon.hpp,\
                                        Kernel_FileIO.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        RTE_Message.hpp,\
                                        RTE_Crash.hpp,\
                                        SAPDB_ToString.hpp

# ------------------------------------------------------------------------------
# Migration of system devspace and data devspaces 7.2/7.3 to 7.4
# ------------------------------------------------------------------------------
#

IOMan_Migration.hpp                 inc=+gsp00,\
                                        Container_Vector.hpp,\
                                        Converter_Page72.hpp,\
                                        Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_PageFrameAllocator.hpp,\
                                        IOMan_DataArea.hpp,\
                                        IOMan_LogArea.hpp,\
                                        IOMan_Types.hpp,\
                                        Kernel_IPage.hpp,\
                                        Kernel_Page72.hpp,\
                                        Kernel_RestartPage.hpp,\
                                        SAPDBMem_IRawAllocator.hpp


IOMan_Migration.cpp                 inc=ggg00,\
                                        vsp002,\
                                        hkb57.h,\
                                        hgg01.h,\
                                        hgg08.h,\
                                        heo54k.h,\
                                        heo55k.h,\
                                        heo56.h,\
                                        heo58.h,\
                                        heo79_1.h,\
                                        Converter_IMigration.hpp,\
                                        Converter_IManager.hpp,\
                                        Converter_IPageNoMapping.hpp,\
                                        Data_BasePage.hpp,\
                                        FBM_IManager.hpp,\
                                        IOMan_Exception.hpp,\
                                        IOMan_Messages.hpp,\
                                        IOMan_Migration.hpp,\
                                        IOMan_ReservedBlockAddress.hpp,\
                                        Kernel_FileIO.hpp,\
                                        Log_Volume.hpp,\
                                        Log_Types.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp,\
                                        SAPDB_ToString.hpp


# ------------------------------------------------------------------------------
# Wrapper:
# ------------------------------------------------------------------------------
#

IOMan_Wrapper.cpp                   inc=+gsp00,\
                                        ggg00,\
                                        gbd00,\
                                        gsp03,\
                                        hgg01.h,\
                                        hgg01_1.h,\
                                        hgg04.h,\
                                        Kernel_IPage.hpp,\
                                        Data_Types.hpp,\
                                        Data_BasePage.hpp,\
                                        Log_Page.hpp,\
                                        Log_Types.hpp,\
                                        Log_Volume.hpp,\
                                        FrameCtrl_ILog.hpp,\
                                        IOMan_IDataInfo.hpp,\
                                        IOMan_IDataIO.hpp,\
                                        IOMan_IDataManager.hpp,\
                                        IOMan_IDiagnose.hpp,\
                                        IOMan_ILogInfo.hpp,\
                                        IOMan_ILogManager.hpp,\
                                        IOMan_IMigration.hpp,\
                                        IOMan_KernelPages.hpp,\
                                        IOMan_Manager.hpp

