/*!
    \file    DBMSrvKnlSrv_ConnectInfo.cpp
    \author  TiloH
    \ingroup access to service db
    \brief   a class holding information about the service db connction

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

*/

#include "DBM/Srv/KernelAccess/ServiceDB/DBMSrvKnlSrv_ConnectInfo.hpp"

DBMSrvKnlSrv_ConnectInfo::DBMSrvKnlSrv_ConnectInfo(
    const tsp00_DbNamec   & dbName,
    const tcn00_UserNamec & userName,
    const tsp00_Namec     & userPassword)
  : m_DBName(dbName),
    m_UserName(userName),
    m_UserPassword(userPassword)
{
}

const char * DBMSrvKnlSrv_ConnectInfo::getDBName()
{
    return m_DBName.asCharp();
}

const char * DBMSrvKnlSrv_ConnectInfo::getUserName()
{
    return m_UserName.asCharp();
}

const char * DBMSrvKnlSrv_ConnectInfo::getUserPassword()
{
    return m_UserPassword.asCharp();
}
