/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_SINKCRITICALSECTION_HPP
#define __OMS_SINKCRITICALSECTION_HPP

#include "ilivecachesink.h" // nocheck
#include "Oms/OMS_DbpBase.hpp"
#include "liveCache/LVC_IliveCacheSink.hpp"

class OMS_SinkCriticalSection {
private :
  IliveCacheSink*   m_lcSink;
  int               m_regionId;
  bool              m_inSection;
public :
  OMS_SinkCriticalSection(IliveCacheSink* lcSink,int regionId) : m_lcSink(lcSink), m_regionId(regionId), m_inSection(false) {} 

  void Enter() {
    if (m_inSection) {
      throw DbpError(DbpError::RTE_ERROR, -1, __MY_FILE__, __LINE__); 
    }
    else {
      m_lcSink->EnterCriticalSection(m_regionId);
      m_inSection = true;
    }
  }

  void Leave() {
    if (m_inSection) {
      m_lcSink->LeaveCriticalSection(m_regionId);
      m_inSection = false;
    }
    else {
      throw DbpError(DbpError::RTE_ERROR, -1, __MY_FILE__, __LINE__); 
    }
  }
  ~OMS_SinkCriticalSection() {
    if (m_inSection) {
      Leave();
    }
  }
};

#endif  // __OMS_SINKCRITICALSECTION_HPP
