/*



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
#ifndef WDVDelete_INTERFACE_H
#define WDVDelete_INTERFACE_H

/*!**********************************************************************

  module: WDVDelete_Interface.h

  -----------------------------------------------------------------------

  responsible:  Daniel Kirmse (D027470 - Daniel.Kirmse@SAP.com)

  special area: WDVDeleteService

  description:  functions for WDVDeleteService

  see also:

  -----------------------------------------------------------------------


************************************************************************/

/*=======================================================================
 *  INCLUDES
 *=====================================================================*/
	#include "SAPDB/WebDAV/DeleteService/WDVDelete_CommonUtils.h"

	/*!-------------------------------------------------------------------------
		function:     WDVDeleteInit
		description:  called by webagent 
		arguments:	  [in] wa, webagent object	
					  
		return value: true if success
		--------------------------------------------------------------------------*/
	extern sapdbwa_Int2 WDVDeleteInit( sapdbwa_Handle wa );


	/*!-------------------------------------------------------------------------
		function:     WDVDeleteExit
		description:  called by webagent 
		arguments:	  [in] wa, webagent object	
					  
		return value: true if success
		--------------------------------------------------------------------------*/
	extern sapdbwa_Int2 WDVDeleteExit( sapdbwa_Handle wa );


	/*!-------------------------------------------------------------------------
		function:     WDVDeleteService
		description:  called by webagent 
		arguments:	  [in] wa, webagent object	
					  [in] req, webagent http request object
					  [in] rep, webagent http reply object
					  
		return value: true if success
		--------------------------------------------------------------------------*/
	extern sapdbwa_Int2 WDVDeleteService( sapdbwa_Handle		wa,
										   sapdbwa_HttpRequestP request,
										   sapdbwa_HttpReplyP   reply );

#endif