/*!**************************************************************************

  module      : LVC_Types.hpp

  -------------------------------------------------------------------------

  responsible : d025251

  special area: 
  description : 


  last changed: 2001-05-21  16:24
  see also    : 

  -------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


#ifndef LVC_TYPES_HPP
#define LVC_TYPES_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"
#include "gbd900.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

#define LVC_ROOT_PAGENO_ARRAY_SIZE (sizeof(tsp00_PageNo) * MAX_NUM_CHAINS_PER_CONTAINER_BD900)

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/


/*!-----------------------------------------------------------------------------
declaration: SAPDBERR_DEFINE_COMPONENT_EXCEPTION_CLASS( LVC )
description: defines common exception class of this component
             
             - class LVC_Exception
------------------------------------------------------------------------------*/
SAPDBERR_DEFINE_COMPONENT_EXCEPTION_CLASS( LVC );
  

/*!*****************************************************************************

   class:        LVC_RootPageNoArray
   description:  Array used to accomodate the root and subroot page numbers of a file.
            
*******************************************************************************/

class LVC_RootPageNoArray
{
private:
	tsp00_PageNo m_RootPageNo [MAX_NUM_CHAINS_PER_CONTAINER_BD900];
public:
	
    /*!-------------------------------------------------------------------------
    function:     LVC_RootPageNoArray()
    description:  default constructor
    arguments:    none
    return value: none
    --------------------------------------------------------------------------*/
	LVC_RootPageNoArray ()
	{
		for (SAPDB_UInt i=0; i<MAX_NUM_CHAINS_PER_CONTAINER_BD900; ++i)
			m_RootPageNo[i] = NIL_PAGE_NO_GG00;
	}
	
    /*!-------------------------------------------------------------------------
    function:     LVC_RootPageNoArray()
    description:  constructor used by redo
    arguments:    image  [in]
                  length [in]
    return value: none
    --------------------------------------------------------------------------*/
	LVC_RootPageNoArray (const SAPDB_Byte* image,
                         SAPDB_UInt        length)
	{
		SAPDBERR_ASSERT_STATE(length == sizeof(m_RootPageNo));
        memcpy (m_RootPageNo, image, length);
	}
	
	/*!-------------------------------------------------------------------------
    function:     operator[]()
    description:  access operator
    arguments:    i : index
    return value: page number stored at the wanted index position
    --------------------------------------------------------------------------*/
	tsp00_PageNo & operator[] (SAPDB_UInt i)
	{
		SAPDBERR_ASSERT_STATE(i < MAX_NUM_CHAINS_PER_CONTAINER_BD900);
		
		return m_RootPageNo[i];
	}

	/*!-------------------------------------------------------------------------
    function:     const operator[]()
    description:  access operator
    arguments:    i : index
    return value: page number stored at the wanted index position
    --------------------------------------------------------------------------*/
	const tsp00_PageNo & operator[] (SAPDB_UInt i) const
	{
		SAPDBERR_ASSERT_STATE(i < MAX_NUM_CHAINS_PER_CONTAINER_BD900);
		
		return m_RootPageNo[i];
	}

	/*!-------------------------------------------------------------------------
    function:     GetPersistentLength()
    description:  this is used by the logging to write the info to the log
    arguments:    none
    return value: length
    --------------------------------------------------------------------------*/
	static SAPDB_UInt GetPersistentLength()
	{
		return LVC_ROOT_PAGENO_ARRAY_SIZE;
	}
	/*!-------------------------------------------------------------------------
    function:     GetPersistentFormat()
    description:  this is used by the logging to write the info to the log
    arguments:    none
    return value: const SAPDB_Byte*
    --------------------------------------------------------------------------*/
	const SAPDB_Byte* GetPersistentFormat() const
	{
		return reinterpret_cast<const SAPDB_Byte*> (m_RootPageNo);
	}

};

	
/*! enddeclaration */


#endif  /* LVC_TYPES_HPP */
