/*!
 * \file    LVCMem_UserAllocatorBase.hpp
 * \author  IvanS
 * \brief   LiveCache user allocator base interface.
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

#ifndef __LVCMEM_USERALLOCATORBASE_HPP
#define __LVCMEM_USERALLOCATORBASE_HPP

#ifdef OMS_SIMULATOR
#undef OMS_IMPLEMENTATION
#endif

#include "Oms/OMS_AllocatorInterface.hpp"

class LVCMem_UserAllocatorBase : public OmsAllocatorInterface {
public:
  LVCMem_UserAllocatorBase() : callback(NULL)
  {
  }

  virtual void omsRegisterCallback(OmsCallbackInterface *cb);
  virtual OmsCallbackInterface *omsGetCallback() const;

protected:
  friend class LVCMem_UserAllocator;
  friend class LVCMem_CheckedUserAllocator;

  OmsCallbackInterface *callback;
};

#endif  // __LVCMEM_USERALLOCATORBASE_HPP