#!/devtool/local/bin/perl
#
# Open a xterm for the user in the chr
#

BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}
$| = 1;
   
use testdbchr;
use Getopt::Long;
use IniFile;

print "\n\nchr_term v0.1a (c)2004, SAP AG\n\n";

my %options = ();
if (! &GetOptions(  \%options,
            'h|help|?',
            'dir=s',
	    'display=s'
            )) {
    print("Run testdb.pl -h for help");
    exit(1);
}

my $tdb;

if ($options{'dir'}) {
	$options{'dir'} = ($options{'dir'} =~ /^0.*/ ? $options{'dir'} : "0$options{'dir'}");
	
	if (!($options{'display'})) {
		print "Specify a display-Parameter, please\nSee $0 --help for additional information\n";
		exit(0);
	}
	
	print "Reading configuration in /SAP_DB/chr/etc/$options{'dir'}..";
	
	my $etc_ref = IniFile::load("/SAP_DB/chr/etc/$options{'dir'}");
	unless($etc_ref) {
		print "..FAILED\n";
		exit(1);
	}
		
	print "OK\nChecking configuration parameters..";
	unless ($etc_ref->{'IDMAKE'} && $etc_ref->{'IDSESSION'}) {
		print "..FAILED\n\tIDMAKE = $etc_ref->{'IDMAKE'}\n\tIDSESSION = $etc_ref->{'IDSESSION'}\n";
		exit(1);
	}
	
	print "..OK\nCreating new testdbchr-Instance..\n";
	$tdb = testdbchr->new({'ID' => $etc_ref->{'IDMAKE'}, 'profile' => $options{'test_profile'}, 'DIR' => $options{'dir'}, 'profile' => $options{'test_profile'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)}, {'ID' => $etc_ref->{'IDSESSION'}});
	print "..OK\n";

	$tdb->verify_chr();
	$tdb->jump_in_chr();
	$tdb->term($options{'display'});
} else {
	print "$0 - Open a xterm with a complete Enviontmen from a chr-Area to your\nWorkstation. Syntax:\n$0 -dir <CHR_DIRECTORY> -display <X-DISPLAY-ADDR>\n";
}
exit(0);






