/*
 * Jar.xs
 * 
 * $Header: //sapdb/V74/develop/sys/src/install/perl/Jar.xs#9 $
 * $DateTime: 2002/10/02 10:20:49 $
 * $Change: 28156 $
 */

static char szWhatHeader[] = 
	"@(#) $Header: //sapdb/V74/develop/sys/src/install/perl/Jar.xs#9 $";

#ifndef __cplusplus
#ifndef HAS_BOOL
typedef char bool;
#endif
#endif

#ifndef WIN32
#define UNIX UNIX
#endif

#ifdef UNIX
#include <unistd.h>
#include <time.h>
#endif

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <io.h>
#include <malloc.h>

#ifndef alloca
#define alloca(size) _alloca(size)
#endif
#define R_OK 4
#endif

#include <sys/stat.h>
typedef struct stat stat_t;

#ifdef __hpux
#define DONT_DECLARE_STD
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#ifdef PERL_OBJECT
#define FILE struct _PerlIO
#endif

/*
 * expect compiler warning 4113 when using Microsoft C
 * in c code generated by xs preprocessor
 */
#if _MSC_VER >= 1200
#pragma warning(disable : 4113)
#endif

#ifdef _AIX
#define NEED_PRAGMA_ALLOCA NEED_PRAGMA_ALLOCA
#endif
#if defined UNIX && !defined _AIX && !defined SNI
#define NEED_ALLOCA_H  NEED_ALLOCA_H
#endif

#if defined NEED_ALLOCA_H
#include <alloca.h>
#elif defined NEED_PRAGMA_ALLOCA
#pragma alloca
#endif

#if defined _WIN64
typedef __int64 ptr_t;
#else
typedef long ptr_t;
#endif

#include "zip/zip.h"
#include "zip/unzip.h"

#define ZIP_MODE_RO 0
#define ZIP_MODE_WR 1
#define ZIP_MODE_WA 2

typedef struct zipobj {
	char *fn;
	void *fp;
	int mode;
	int idx;
	int eof;
	int num_of_files;
	int buffersize;
	char *buffer;
} zipobj_t;

static int
find_in_archive (zipobj_t *obj, char *my_filename) {
	int rc;
	char *their_filename;
	unz_file_info fi[1];

	if (unzGoToFirstFile (obj->fp) != 0)
		return -1;

	obj->idx = -1;

	for (;;) {
		if (obj->idx >= 0) {
			if (unzGoToNextFile (obj->fp) != 0)
				return -1;
		}

		obj->idx++;
	
		if (unzGetCurrentFileInfo (obj->fp, fi, 0, 0, 0, 0, 0, 0) != 0)
			return -1;

		their_filename = (char *) alloca (fi->size_filename + 1);
		
		if (unzGetCurrentFileInfo (obj->fp, fi, their_filename,
		fi->size_filename + 1, 0, 0, 0, 0) != 0)
			return -1;

		if (strcmp (my_filename, their_filename) == 0)
			return 0;
		
		if (obj->idx >= obj->num_of_files)
			return -1;
	}

	return -1;
}

/*
 * helper functions to access member variables
 */
static zipobj_t *
self_getobj (HV *self) {
	char *key_obj = "obj";
	SV **psv_obj;
	zipobj_t *obj;

	psv_obj = hv_fetch (self, key_obj, strlen (key_obj), 0);
	if (psv_obj == 0) {
        	return 0;
	}

	obj = (zipobj_t *) SvIV (*psv_obj);
	return (obj);
}

static SV *
self_getsverr (HV *self) {
	char *key_err = "err";
	SV **psv_err;

	psv_err = hv_fetch (self, key_err, strlen (key_err), 0);
	if (psv_err == 0) {
		return 0;
	}

	return (*psv_err);
}

#include "Jar.h"

MODULE = SAPDB::Install::Jar		PACKAGE = SAPDB::Install::Jar

PROTOTYPES: DISABLE

BOOT:
	perl_eval_pv ((char *) sz_text, 1);

void
new (...)
PREINIT:
	char *CLASS = 0;
	char *sz_class = "SAPDB::Install::Jar";
	char *key_err = "err";
	char *key_obj = "obj";
	HV *self;
	SV *sv_err;
	SV *sv_obj;
	zipobj_t *obj;
CODE:
	if (items > 1)
		XSRETURN_UNDEF;

	if (items == 1 && (strlen (SvPV (ST(0), PL_na)) > 0))
		CLASS = SvPV (ST(0), PL_na);

	if (items == 0)
		EXTEND (sp, 1);

	if (CLASS == 0)
		CLASS = sz_class;

	obj = (zipobj_t *) malloc (sizeof (zipobj_t));
	if (obj == 0)
		XSRETURN_UNDEF;

	memset (obj, 0, sizeof (zipobj_t));

	self = newHV ();
	ST(0) = sv_bless (newRV ((SV*) self), gv_stashpv (CLASS, 1));

	sv_obj = newSViv ((ptr_t) obj);
	sv_err = newSVsv (&PL_sv_undef);

	hv_store (self, key_obj, strlen (key_obj), sv_obj, 0);
	hv_store (self, key_err, strlen (key_err), sv_err, 0);

	sv_2mortal (ST(0));
	SvREFCNT_dec (self);

void
DESTROY (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
PPCODE:
	if (items != 1)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);
	if (obj != 0)
		free (obj);

	XSRETURN_UNDEF;

void
OpenArchive (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	char *zip_fn = 0;
	char *zip_mode = 0;
PPCODE:
	if (items < 2 || items > 3) 
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);
	if (obj == 0)
		XSRETURN_UNDEF;

	zip_fn = (char *) SvPV (ST (1), PL_na);
	if (strlen (zip_fn) == 0)
		XSRETURN_UNDEF;

	if (items == 3)
		zip_mode = (char *) SvPV (ST (2), PL_na);	

	if (zip_mode == 0 || strlen (zip_mode) == 0 || zip_mode[0] == 'r') {
		obj->mode = ZIP_MODE_RO;
	} else if (zip_mode[0] == 'w') {
		obj->mode = ZIP_MODE_WR;
	} else if (zip_mode[0] == 'a') {
		obj->mode = ZIP_MODE_WA;
	} else {
		XSRETURN_UNDEF;
	}

	obj->fn = (char *) malloc (strlen (zip_fn) + 1);
	if (obj->fn == 0)
		XSRETURN_UNDEF;

	strcpy (obj->fn, zip_fn);

	switch (obj->mode) {
	case ZIP_MODE_RO:
		obj->fp = (void *) unzOpen (zip_fn);
		break;
	case ZIP_MODE_WR:
		obj->fp = (void *) zipOpen (zip_fn, 0);
		break;
	case ZIP_MODE_WA:
		obj->fp = (void *) zipOpen (zip_fn, 1);
		break;
	default:
		obj->fp = 0;
		break;
	}

	if (obj->fp == 0) {
		free (obj->fn);
		obj->fn = 0;
		XSRETURN_UNDEF;
	}

	if (obj->mode == ZIP_MODE_RO) {
		int rc;
		unz_global_info gi[1];
		char *key_gi = "global";
		char *key_comm = "size_of_comment";
		char *key_num = "num_of_files";

		rc = unzGetGlobalInfo (obj->fp, gi);
		if (rc != 0) {
			XSRETURN_UNDEF;
		}

		obj->num_of_files = gi->number_entry;

		hv_store (self, key_num, strlen (key_num),
		newSViv (gi->number_entry), 0);

		hv_store (self, key_comm, strlen (key_comm),
		newSViv (gi->size_comment), 0);

		obj->idx = -1;
	}

	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

void
CloseArchive (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int rc;
PPCODE:
	if (items != 1)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);
	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	switch (obj->mode) {
	case ZIP_MODE_RO:
		rc = unzClose (obj->fp);
		break;
	case ZIP_MODE_WR:
	case ZIP_MODE_WA:
		rc = zipClose (obj->fp, 0);
		break;
	default:
		rc = -1;
		break;
	}

	if (rc != 0)
		XSRETURN_UNDEF;

	obj->fp = 0;

	if (obj->buffer != 0) {
		free (obj->buffer);
		obj->buffersize= 0;
		obj->buffer = 0;
	}

	if (obj->fn != 0) {
		free (obj->fn);
		obj->fn = 0;
	}

	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

void
Next (...)
PREINIT:
	int rc;
	HV *self;
	zipobj_t *obj;
	unz_file_info fi[1];
	char *filename;
	char *key_name = "filename";
	char *key_info = "fileinfo";
	HV *hv;
PPCODE:
	if (items != 1)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->fp == 0) {
		XPUSHs (sv_2mortal (newSViv (0)));
		XSRETURN (1);
	}

	if (obj->mode != ZIP_MODE_RO)
		XSRETURN_UNDEF;

	if (obj->idx >= 0) {
		rc = unzGoToNextFile (obj->fp);
		if (rc != 0)
			XSRETURN_UNDEF;
	}
	
	obj->idx++;

	rc = unzGetCurrentFileInfo (obj->fp, fi, 0, 0, 0, 0, 0, 0);
	if (rc != 0)
		XSRETURN_UNDEF;

	filename = (char *) malloc (fi->size_filename + 1);
	if (filename == 0)
		XSRETURN_UNDEF;

	rc = unzGetCurrentFileInfo
	(obj->fp, fi, filename, fi->size_filename + 1, 0, 0, 0, 0);

	hv = newHV ();
	hv_store (hv, key_name, strlen (key_name),
	          newSVpv (filename, strlen (filename)), 0);

	hv_store (hv, key_info, strlen (key_info),
	          newSVpv ((char *) fi, sizeof (unz_file_info)), 0);

	free (filename);

	XPUSHs (sv_2mortal (newRV ((SV *) hv)));
	XSRETURN (1);

void
Open (...)
PREINIT:
	HV *self;
	HV *hv;
	SV **psv_fi;
	SV **psv_fn;
	char *key_name = "filename";
	char *key_info = "fileinfo";
	char *filename = 0;
	unz_file_info *ufi;
	zip_fileinfo zfi[1];
	zipobj_t *obj;
	int rc;
PPCODE:
	if (items < 1 || items > 2)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;
	
	if (obj->mode == ZIP_MODE_WR && items != 2)
		XSRETURN_UNDEF;

	if (obj->mode == ZIP_MODE_WA && items != 2)
		XSRETURN_UNDEF;
	
	switch (obj->mode) {
	case ZIP_MODE_RO:	
		if (items == 2) {
			filename = SvPV (ST(1), PL_na);
			if (filename == 0 || strlen (filename) == 0)
				XSRETURN_UNDEF;

			if (find_in_archive (obj, filename) != 0)
				XSRETURN_UNDEF;
		}

		rc = unzOpenCurrentFile (obj->fp);
		break;

	case ZIP_MODE_WR:
	case ZIP_MODE_WA:
		hv = (HV*) SvRV (ST(1));
		psv_fn = hv_fetch (hv, key_name, strlen (key_name), 0);
		psv_fi = hv_fetch (hv, key_info, strlen (key_info), 0);
	
		filename = (char *) SvPV (*psv_fn, PL_na);
		ufi = (unz_file_info *) SvPV (*psv_fi, PL_na);

		if (strlen (filename) == 0)
			XSRETURN_UNDEF;
	
		zfi->dosDate = 0;
		zfi->internal_fa = ufi->internal_fa;
		zfi->external_fa = ufi->external_fa;
		memcpy (&zfi->tmz_date, &ufi->tmu_date, sizeof (tm_zip));

		rc = zipOpenNewFileInZip (obj->fp, filename, zfi,
		     0, 0, 0, 0, 0, Z_DEFLATED, Z_DEFAULT_COMPRESSION);

		SvREFCNT_dec (*psv_fn);
		SvREFCNT_dec (*psv_fi);

		break;

	default:
		rc = -1;
		break;
	}

	obj->eof = 0;

	if (rc != 0)
		XSRETURN_UNDEF;

	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

void
Close (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int rc;
PPCODE:
	if (items != 1)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->fp == 0) {
		XPUSHs (sv_2mortal (newSViv (0)));
		XSRETURN (1);
	}

	switch (obj->mode) {
	case ZIP_MODE_RO:	
		rc = unzCloseCurrentFile (obj->fp);
		break;

	case ZIP_MODE_WR:
	case ZIP_MODE_WA:
		rc = zipCloseFileInZip (obj->fp);
		break;

	default:
		rc = -1;
		break;
	}

	if (rc != 0)
		XSRETURN_UNDEF;

	if (obj->buffer != 0) {
		free (obj->buffer);
		obj->buffer = 0;
		obj->buffersize = 0;
	}
		
	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

void
Read (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int want;
	int got;
	char *buff;
PPCODE:
	if (items != 3)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_RO)
		XSRETURN_UNDEF;

	if (obj->fp == 0) {
		XPUSHs (sv_2mortal (newSViv (0)));
		XSRETURN (1);
	}

	want = SvIV (ST (2));
	buff = (char *) malloc (want);
	if (buff == 0)
		XSRETURN_UNDEF;

	got = unzReadCurrentFile (obj->fp, buff, want);
	if (got < 0) {
		free (buff);
		XSRETURN_UNDEF;
	}

	sv_setpvn (ST(1), (const char *) buff, got);
	free (buff);

	XPUSHs (sv_2mortal (newSViv (got)));
	XSRETURN (1);

void
Write (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int want;
	int got;
	char *buff;
PPCODE:
	if (items != 3)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_WR && obj->mode != ZIP_MODE_WA)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	want = SvIV (ST(2));
	buff = SvPV (ST(1), PL_na);

	got = zipWriteInFileInZip (obj->fp, buff, want);
	if (got < 0)
		XSRETURN_UNDEF;

	XPUSHs (sv_2mortal (newSViv (got)));
	XSRETURN (1);

void
ReadLine (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int chunksize = 3;
	char *pos;
	int want;
	int got;
PPCODE:
	if (items != 1)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_RO)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	if (obj->eof != 0) {
		if (obj->buffer != 0) {
			free (obj->buffer);
			obj->buffer = 0;
		}

		XSRETURN_UNDEF;
	}

	if (obj->buffer != 0 && strchr (obj->buffer, '\n')) {
		int len;
		char *line;

		len = strchr (obj->buffer, '\n') - obj->buffer;
		line = (char *) malloc (len + 1);
		memcpy (line, obj->buffer, len);
		line[len] = '\0';
		
		memcpy (obj->buffer,
		obj->buffer + len + 1, obj->buffersize - len - 1);
		obj->buffer[obj->buffersize - len - 1] = '\0';

		if (line[len - 1] == '\r') {
			len--;
			line[len] = '\0';
		}

		XPUSHs (sv_2mortal (newSVpvn (line, len)));
		free (line);

		XSRETURN (1);
	}

	if (obj->buffer == 0) {
		obj->buffer = (char *) malloc (chunksize + 1);
		if (obj->buffer != 0) {
			obj->buffersize = chunksize;
			obj->buffer[0] = '\0';
		}
	}

	if (obj->buffer == 0)
		XSRETURN_UNDEF;

	for (;;) {
		pos = obj->buffer + strlen (obj->buffer);
		want = obj->buffersize - strlen (obj->buffer);

		got = unzReadCurrentFile (obj->fp, pos, want);
		if (got < 0) {
			free (obj->buffer);
			obj->buffersize = 0;
			obj->buffer = 0;
			XSRETURN_UNDEF;
		}

		if (got < want) {
			pos[got] ='\0';
			break;
		}

		obj->buffer[obj->buffersize] = '\0';
		if (strchr (obj->buffer, '\n') != 0)
			break;

		obj->buffer =
		(char *) realloc (obj->buffer, obj->buffersize + chunksize + 1);

		if (obj->buffer == 0) {
			obj->buffersize = 0;
			XSRETURN_UNDEF;
		}
		
		obj->buffersize += chunksize;
	}

	if (obj->buffer != 0 && strchr (obj->buffer, '\n')) {
		int len;
		char *line;

		len = strchr (obj->buffer, '\n') - obj->buffer;
		line = (char *) malloc (len + 1);
		memcpy (line, obj->buffer, len);
		line[len] = '\0';

		memcpy (obj->buffer,
		obj->buffer + len + 1, obj->buffersize - len - 1);
		obj->buffer[obj->buffersize - len - 1] = '\0';

		if (line[len - 1] == '\r') {
			len--;
			line[len] = '\0';
		}

		XPUSHs (sv_2mortal (newSVpvn (line, len)));
		free (line);

		XSRETURN (1);
	}

	if (obj->buffer != 0 && got < want) {
		XPUSHs
		(sv_2mortal (newSVpvn (obj->buffer, strlen (obj->buffer))));
		obj->buffer[0] = '\0';
		obj->eof = 1;

		XSRETURN (1);
	}

	XSRETURN_UNDEF;

void
Print (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int want;
	int got;
	char *buff;
PPCODE:
	if (items != 2)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_WR && obj->mode != ZIP_MODE_WA)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	buff = SvPV (ST(1), PL_na);
	want = strlen (buff);

	got = zipWriteInFileInZip (obj->fp, buff, want);
	if (got < 0)
		XSRETURN_UNDEF;

	XPUSHs (sv_2mortal (newSViv (got)));
	XSRETURN (1);

void
CopyTo (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	zipobj_t *to;
	int total;
	int want;
	int got;
	int rc;
	unz_file_info ufi[1];
	zip_fileinfo zfi[1];
	int buffersize = 8192;
	char *buffer;
	char *filename;
PPCODE:
	if (items != 2)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_RO)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(1)) && (SvTYPE (SvRV (ST(1))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	to = self_getobj ((HV*) SvRV (ST(1)));
	if (to == 0)
		XSRETURN_UNDEF;

	if (to->mode != ZIP_MODE_WR && obj->mode != ZIP_MODE_WA)
		XSRETURN_UNDEF;

	if (to->fp == 0)
		XSRETURN_UNDEF;

	buffer = (char *) alloca (buffersize);
	want = buffersize;

	rc = unzGetCurrentFileInfo (obj->fp, ufi, 0, 0, 0, 0, 0, 0);
	if (rc != 0)
		XSRETURN_UNDEF;

	filename = (char *) alloca (ufi->size_filename + 1);

	rc = unzGetCurrentFileInfo
	(obj->fp, ufi, filename, ufi->size_filename + 1, 0, 0, 0, 0);
	if (rc != 0)
		XSRETURN_UNDEF;

	if (strlen (filename) == 0)
		XSRETURN_UNDEF;
	
	rc = unzOpenCurrentFile (obj->fp);
	if (rc != 0)
		XSRETURN_UNDEF;

	zfi->dosDate = 0;
	zfi->internal_fa = ufi->internal_fa;
	zfi->external_fa = ufi->external_fa;
	memcpy (&zfi->tmz_date, &ufi->tmu_date, sizeof (tm_zip));

	rc = zipOpenNewFileInZip (to->fp, filename, zfi,
	     0, 0, 0, 0, 0, Z_DEFLATED, Z_DEFAULT_COMPRESSION);

	if (rc != 0) {
		unzCloseCurrentFile (obj->fp);
		XSRETURN_UNDEF;
	}

	total = 0;
	for (;;) {
		got = unzReadCurrentFile (obj->fp, buffer, want);
		if (got < 0) {
			unzCloseCurrentFile (obj->fp);
			zipCloseFileInZip (to->fp);
			XSRETURN_UNDEF;
		}

		if (zipWriteInFileInZip (to->fp, buffer, got) != 0) {
			unzCloseCurrentFile (obj->fp);
			zipCloseFileInZip (to->fp);
			XSRETURN_UNDEF;
		}

		total += got;
		if (got < buffersize)
			break;
	}

	unzCloseCurrentFile (obj->fp);
	zipCloseFileInZip (to->fp);

	XPUSHs (sv_2mortal (newSViv (total)));
	XSRETURN (1);

void
RestoreZip (...)
PREINIT:
	char *filename_org;
	char *filename_wrk;
	FILE *fp_org;
	FILE *fp_wrk;
	char *buffer;
	int buffersize = 8192;
	int got;
	int want;
	int rc;
PPCODE:
	if (items != 2)
		XSRETURN_UNDEF;

	filename_org = SvPV (ST(0), PL_na);
	if (filename_org == 0 || strlen (filename_org) == 0)
		XSRETURN_UNDEF;

	filename_wrk = SvPV (ST(1), PL_na);
	if (filename_wrk == 0 || strlen (filename_wrk) == 0)
		XSRETURN_UNDEF;

	fp_org = fopen (filename_org, "wb");
	if (fp_org == 0)
		XSRETURN_UNDEF;

	fp_wrk = fopen (filename_wrk, "rb");
	if (fp_wrk == 0) {
		fclose (fp_org);
		XSRETURN_UNDEF;
	}

	for (buffer = (char *) alloca (buffersize);;) {
		got = fread (buffer, 1, buffersize, fp_wrk);
		if (got <= 0) {
			if (feof (fp_wrk) == 0) {
				fclose (fp_wrk);
				fclose (fp_org);
				XSRETURN_UNDEF;
			}
			break;
		}

		want = got;
		got = fwrite (buffer, 1, want, fp_org);
		if (got <= 0) {
			fclose (fp_wrk);
			fclose (fp_org);
			XSRETURN_UNDEF;
		}
	}

	fclose (fp_wrk);
	fclose (fp_org);

	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

void
Add (...)
PREINIT:
	HV *self;
	zipobj_t *obj;
	int rc;
	char *filename = 0;
	zip_fileinfo zfi[1];
	FILE *fp;
	char *ptr;
	stat_t statbuf[1];
PPCODE:
	if (items != 2)
		XSRETURN_UNDEF;

	if (!(sv_isobject (ST(0)) && (SvTYPE (SvRV (ST(0))) == SVt_PVHV)))
		XSRETURN_UNDEF;

	self = (HV*) SvRV (ST(0));
	obj = self_getobj (self);

	if (obj == 0)
		XSRETURN_UNDEF;

	if (obj->fp == 0)
		XSRETURN_UNDEF;

	if (obj->mode != ZIP_MODE_WR)
		XSRETURN_UNDEF;

	filename = (char *) SvPV (ST(1), PL_na);
	if (filename == 0 || strlen (filename) == 0)
		XSRETURN_UNDEF;

	rc = stat (filename, statbuf);
	if (rc != 0)
		XSRETURN_UNDEF;

	fp = fopen (filename, "rb");
	if (fp == 0)
		XSRETURN_UNDEF;
	
	memset (zfi, 0, sizeof (zip_fileinfo));

	for (ptr = filename; *ptr != '\0'; ptr++)
		if (*ptr == '/')
			*ptr = '\\';

	if (statbuf->st_mtime != 0) {
		struct tm *posix_time;

		posix_time = localtime ((time_t *) &(statbuf->st_mtime));
		
		zfi->tmz_date.tm_sec = posix_time->tm_sec;
		zfi->tmz_date.tm_min = posix_time->tm_min;
		zfi->tmz_date.tm_hour = posix_time->tm_hour;
		zfi->tmz_date.tm_mday = posix_time->tm_mday;
		zfi->tmz_date.tm_mon = posix_time->tm_mon;
		zfi->tmz_date.tm_year = posix_time->tm_year - 80;
	}

	rc = zipOpenNewFileInZip (obj->fp, filename, zfi,
	     0, 0, 0, 0, 0, Z_DEFLATED, Z_DEFAULT_COMPRESSION);

	if (rc != 0) {
		fclose (fp);
		XSRETURN_UNDEF;
	}
	
	for (;;) {
		char buff[8192];
		int got, want;

		got = fread (buff, 1, 8192, fp);
		if (got < 0) {
			fclose (fp);
			zipCloseFileInZip (obj->fp);
			XSRETURN_UNDEF;
		}

		want = got;
		got = zipWriteInFileInZip (obj->fp, buff, want);
		if (got < 0) {
			fclose (fp);
			zipCloseFileInZip (obj->fp);
			XSRETURN_UNDEF;
		}
		
		if (want < 8192)
			break;
	}

	fclose (fp);
	rc = zipCloseFileInZip (obj->fp);
	if (rc != 0)
		XSRETURN_UNDEF;

	XPUSHs (sv_2mortal (newSViv (0)));
	XSRETURN (1);

