"""Script to create a menu of RTC applications

  History:
    101105  mlr  Added the sumlog report and the backus average report
    101905  mlr  Allowed the RTC apps to be plugins when cplab starts
    121405  mlr  Allowed for the path variable to contain a ".."
"""

# import the cp directory
import cp

# A reload helps when making freqent changes
# import cp.rtc.rtc_bed_reports
# print "reload(cp.rtc.rtc_bed_reports)"
# reload(cp.rtc.rtc_bed_reports)
#
# import cp.rtc.rtc_sawtooth_reports
# print "reload(cp.rtc.rtc_sawtooth_reports)"
# reload(cp.rtc.rtc_sawtooth_reports)
#
# import cp.rtc.rtc_sumlog_reports
# print "reload(cp.rtc.rtc_sumlog_reports)"
# reload(cp.rtc.rtc_sumlog_reports)
#
# import cp.rtc.rtc_flagexpand_reports
# print "reload(cp.rtc.rtc_flagexpand_reports)"
# reload(cp.rtc.rtc_flagexpand_reports)
#
# import cp.rtc.rtc_backus_reports
# print "reload(cp.rtc.rtc_backus_reports)"
# reload(cp.rtc.rtc_backus_reports)
#
# import cp.rtc.rtc_medfilter_reports
# print "reload(cp.rtc.rtc_medfilter_reports)"
# reload(cp.rtc.rtc_medfilter_reports)

from cp.rtc.rtc_bed_reports \
    import BedReport

from cp.rtc.rtc_medfilter_reports \
    import MedfilterReport

from cp.rtc.rtc_sawtooth_reports \
    import SawtoothReport

from cp.rtc.rtc_sumlog_reports \
    import SumlogReport

from cp.rtc.rtc_flagexpand_reports \
    import FlagexpandReport

from cp.rtc.rtc_backus_reports \
    import BackusReport

from cp.rtc.script_action \
    import add_menu_action

path1 = "\\lib\\cp\\__init__.pyc"
path2 = "\\lib\\cp\\__init__.py"

def install_rtc():
    path = cp.__file__
    # change to the absolute path if ".." found
    if path.startswith(".."):
        abs_path = os.path.abspath(path)
    else:
        abs_path = path

    # look for either a .pyc or .py file
    if abs_path.endswith(path1):
        end_path = path1
        path = abs_path
    elif abs_path.endswith(path2):
        end_path = path2
        path = abs_path
    else:
        print "Unable to find cplab plugin definition file."
        return

    path = path[:-len(end_path)]
    in_path = path + "\\apps\\cplab\\plugin_definitions.py"
    out_path = path + "\\apps\\cplab\\plugin_definitions_tmp.py"
    save_path = path + "\\apps\\cplab\\plugin_definitions_sv.py"

    f1 = file(in_path, "r")
    f2 = file(out_path, "w")

    line = f1.readline()
    icflg = 0
    while line != '':
        if line.strip().startswith("#RTCPLUGIN"):
            icflg = 1
            first = line.index("#RTCPLUGIN")
            last = line.index("join")
            newline = line[:first] + line[last:]
            line = newline
        f2.write(line)

        line = f1.readline()

    f1.close()
    f2.close()

    # copy the files (if RTC comment line found)
    if icflg == 1:
        cmd = "copy " + in_path + " " + save_path
        os.system(cmd)
        cmd = "copy " + out_path + " " + in_path
        os.system(cmd)
    # erase the temporary file
    cmd = "erase " + out_path
    os.system(cmd)

    #--------------------------------------------------------------------------
    #  Define the context menu action for the appropriate resource type:  
    #--------------------------------------------------------------------------

    # Pure Traits UI version:                 
    add_menu_action("RTC Median filter", "RTC Median filter", MedfilterReport,
        False )
    add_menu_action("RTC Backus Average", "RTC Backus Average", BackusReport,
        False )
    add_menu_action("RTC Flagexpander", "RTC Flagexpander", FlagexpandReport,
        False )
    add_menu_action("RTC Sumlog", "RTC Sumlog", SumlogReport, False )
    add_menu_action("RTC Sawtooth discriminator", "RTC Sawtooth discriminator",
        SawtoothReport, False )
    add_menu_action("RTC Bed report", "RTC Bed report", BedReport, False )

# install the rtc applications
install_rtc()
