from enthought.traits.api \
    import HasPrivateTraits, Color, Font, Instance

from enthought.envisage.resource \
    import ResourceType
    
from enthought.naming.api \
    import ObjectSerializer
    
class TestColor ( HasPrivateTraits ):
    color = Color
    
class TestFont ( HasPrivateTraits ):
    font = Font    
        
class ColorResourceType ( ResourceType ):
    id         = 'TestColor',
    type       = Instance( TestColor )
    serializer = ObjectSerializer( ext = '.color' )
    
class FontResourceType ( ResourceType ):
    id         = 'TestFont',
    type       = Instance( TestFont )
    serializer = ObjectSerializer( ext = '.font' )
    
