




# Major package imports.
import wx


# Enthought library imports.
from enthought.traits.api import Any, Event, HasTraits, List, Str, Property


class PartPane(HasTraits):

    control = Property

    name = Str

    layout = Any


    _control = Any
    _sizer = Any
    

    ###########################################################################
    # 'LayoutPart' interface.
    ###########################################################################

    def _get_control(self):
        
        if self._control is None:
            panel = wx.Panel(self.layout.control, -1, style=wx.CLIP_CHILDREN)
            sizer = wx.BoxSizer(wx.VERTICAL)
            panel.SetSizer(sizer)
            panel.SetAutoLayout(True)
        
            self._control = panel
            self._sizer = sizer
        
        return self._control

    def set_content(self, content):
        """ Set the content. """
        
        self._sizer.Add(content, 1, wx.EXPAND)
        self._sizer.Fit(content)

        return

    def show(self):
        """ Show the part. """

        self.layout.show_pane(self)

        return

    def hide(self):
        """ Hide the part. """

        self.layout.hide_pane(self)

        return
    
#### EOF ######################################################################
