
def join(*args):
    """ Like 'os.path.join', but it allows only a module as the first argument.

    This is useful when creating lists of plug-in definition file names when
    defining an application.

    """

    import os.path
    import types

    if len(args) > 0 and type(args[0]) is types.ModuleType:
        args    = list(args)
        args[0] = os.path.abspath(os.path.dirname(args[0].__file__))
        args    = tuple(args)

    return os.path.join(*args)

def find_definition(fullname):
    import pkgutil
    import os.path
    
    if not hasattr(pkgutil, "find_loader"):
        from compat import pkgutil
    
    loader = pkgutil.get_loader(fullname)
    if loader is None:
        raise ImportError(fullname)
    
    # Handle symlinks if possible
    if hasattr(os.path, 'realpath'):
        return os.path.realpath(loader.filename)
    
    return loader.filename
        
        
    