""" A plugin that contributes a message to the Message plugin. """


# Enthought library imports.
from enthought.envisage.api import PluginDefinition

# Plugin definition imports.
# Imports from 'message' library which is one hierarchy up the directory
# containing this file
import os, sys
current_dir = os.path.abspath(os.path.dirname(__file__))
dir_name = os.path.dirname(current_dir)
add_path = not dir_name in sys.path
if add_path:
    sys.path.append(dir_name)

from message.plugin_definition import Message

if add_path:
    sys.path.pop(-1)

# from enthought.envisage.examples.plugin.message.plugin_definition import Message

# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = 'enthought.envisage.examples.plugin.hello_world'


###############################################################################
# Extensions.
###############################################################################

# This is the contribution to the hello world plugin.
hello_world = Message(text='Hello World')
    
###############################################################################
# The plugin definition.
###############################################################################

class HelloWorldPluginDefinition(PluginDefinition):
    """ A plugin that contributes a message to the Message plugin. """

    # The plugin's globally unique identifier.
    id = ID

    # General information about the plugin.
    name          = "Envisage 'Hello World' Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"

    # The IDs of the plugins that this plugin requires.
    requires = ["enthought.envisage.examples.plugin.message"]

    # The extension points offered by this plugin.
    extension_points = []
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [hello_world]

#### EOF ######################################################################
