%-----------------------------------------------------------------------------%
% Copyright (C) 2001 The University of Melbourne.
% This file may only be copied under the terms of the GNU General
% Public License - see the file COPYING in the Mercury distribution.
%-----------------------------------------------------------------------------%
%
% Definitions of Mercury types for representing layout structures within
% the compiler. Layout structures are generated by the compiler, and are
% used by the parts of the runtime system that need to look at the stacks
% (and sometimes the registers) and make sense of their contents. The parts
% of the runtime system that need to do this include exception handling,
% the debugger, and (eventually) the accurate garbage collector.
%
% When output by layout_out.m, values of most these types will correspond to
% the C types defined in runtime/mercury_stack_layout.h; the documentation of
% those types can be found there. The names of the C types are listed next to
% the function symbol whose arguments represent their contents.
%
% The code to generate values of these types is in stack_layout.m.
%
% This module is should be, but as yet isn't, independent of whether we are
% compiling to LLDS or MLDS.
%
% Author: zs.

%-----------------------------------------------------------------------------%

:- module layout.

:- interface.

:- import_module prog_data, trace_params, llds.
:- import_module std_util, list, assoc_list.

:- type layout_data
	--->	label_layout_data(		% defines MR_Label_Layout
			label			:: label,
			proc_layout_name	:: layout_name,
			maybe_port		:: maybe(trace_port),
			maybe_goal_path		:: maybe(int), % offset
			maybe_var_info		:: maybe(label_var_info)
		)
	;	proc_layout_data(		% defines MR_Proc_Layout
			proc_label,
			proc_layout_stack_traversal,
			maybe_proc_id_and_exec_trace
		)
	;	module_layout_data(		% defines MR_Module_Layout
			module_name		:: module_name,
			string_table_size	:: int,
			string_table		:: string,
			proc_layout_names	:: list(layout_name),
			file_layouts		:: list(file_layout_data),
			trace_level		:: trace_level
		)
	;	closure_proc_id_data(		% defines MR_Closure_Id
			caller_proc_label	:: proc_label,
			caller_closure_seq_no	:: int,
			closure_proc_label	:: proc_label,
			closure_module_name	:: module_name,
			closure_file_name	:: string,
			closure_line_number	:: int,
			closure_goal_path	:: string
		).

:- type label_var_info
	--->	label_var_info(			% part of MR_Label_Layout
			encoded_var_count	:: int,
			locns_types		:: rval,
			var_nums		:: rval,
			type_params		:: rval
		).

:- type proc_layout_stack_traversal		% defines MR_Stack_Traversal
	--->	proc_layout_stack_traversal(
			entry_label		:: maybe(label),
						% The proc entry label; will be
						% `no' if we don't have static
						% code addresses.
			succip_slot		:: maybe(int),
			stack_slot_count	:: int,
			detism			:: determinism
		).

:- type maybe_proc_id_and_exec_trace
	--->	no_proc_id
	;	proc_id_only
	;	proc_id_and_exec_trace(proc_layout_exec_trace).

:- type proc_layout_exec_trace			% defines MR_Exec_Trace
	--->	proc_layout_exec_trace(
			call_label_layout	:: layout_name,
			proc_body		:: maybe(rval),
			var_names		:: list(int), % offsets
			max_var_num		:: int,
			max_r_num		:: int,
			maybe_from_full_slot	:: maybe(int),
			maybe_io_seq_slot	:: maybe(int),
			maybe_trail_slot	:: maybe(int),
			maybe_maxfr_slot	:: maybe(int),
			eval_method		:: eval_method,
			maybe_call_table_slot	:: maybe(int),
			maybe_decl_debug_slot	:: maybe(int)
		).

:- type file_layout_data
	--->	file_layout_data(
			file_name		:: string,
			line_no_label_list	:: assoc_list(int, layout_name)
		).

%-----------------------------------------------------------------------------%

:- type layout_name
	--->	label_layout(label, label_vars)
	;	proc_layout(proc_label, proc_layout_kind)
		% A proc layout structure for stack tracing, accurate gc
		% and/or execution tracing.
	;	proc_layout_var_names(proc_label)
		% A vector of variable names (represented as offsets into
		% the string table) for a procedure layout structure.
	;	closure_proc_id(proc_label, int, proc_label)
	;	file_layout(module_name, int)
	;	file_layout_line_number_vector(module_name, int)
	;	file_layout_label_layout_vector(module_name, int)
	;	module_layout_string_table(module_name)
	;	module_layout_file_vector(module_name)
	;	module_layout_proc_vector(module_name)
	;	module_layout(module_name).

:- type label_vars
	--->	label_has_var_info
	;	label_has_no_var_info.

:- type proc_layout_kind
	--->	proc_layout_traversal
	;	proc_layout_proc_id(proc_layout_user_or_compiler)
	;	proc_layout_exec_trace(proc_layout_user_or_compiler).

:- type proc_layout_user_or_compiler
	--->	user
	;	compiler.

%-----------------------------------------------------------------------------%
