/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MetviewTask.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef MetviewTask_H
#define MetviewTask_H

#ifndef Task_H
#include "Task.h"
#endif

#ifndef Action_H
#include "Action.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#include "TaskObserver.h"
#include "IconObject.h"
#include "Dependancy.h"
#include "Request.h"


class MetviewTask : public Task, public ReplyObserver, public TaskObserver {
public:

// -- Exceptions
	// None

// -- Contructors

	MetviewTask(const string&,const Action&,IconObject*);

// -- Destructor

	virtual ~MetviewTask(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators


// -- Methods
	void addContext (const Request& req) { context_ = req; }

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	 void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MetviewTask(const MetviewTask&);
	MetviewTask& operator=(const MetviewTask&);

// -- Members

	string      service_;
	Action      action_;
	IconObjectH object_;
	bool        error_;
	int         waiting_;
	Request     context_;

	typedef map<TaskH,DependancyH> Map;
	Map tasks_;

// -- Methods

	void check();

// -- Overridden methods

	// From Task
	virtual void start();

	// From ReplyObserver

	virtual void reply(const Request&,int);
	virtual void progress(const Request&);
	virtual void message(const string&);

	// From TaskObserver

	virtual void success(Task*,const Request&);
	virtual void failure(Task*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MetviewTask& p)
	//	{ p.print(s); return s; }

};

inline void destroy(MetviewTask**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MetviewTask);
//#endif

#endif
