#!/usr/bin/perl
#
# $Id: migrate_services.pl,v 1.5 2002/01/15 18:06:12 lukeh Exp $
#
# Copyright (c) 1997 Luke Howard.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#        This product includes software developed by Luke Howard.
# 4. The name of the other may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE LUKE HOWARD ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL LUKE HOWARD BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# services migration tool
#
#

require 'migrate_common.ph';

$PROGRAM = "migrate_services.pl";
$NAMINGCONTEXT = &getsuffix($PROGRAM);

&parse_args();
&open_files();

while(<INFILE>)
{
	chop;
	next unless ($_);
	next if /^#/;
	s/#(.*)$//;
	local($servicename, $portproto, @aliases) = split(/\s+/);
	local($port, $proto) = split(/\//, $portproto);

	if (!grep(/^$proto$/, @protos)) {
		&ldif_entry($use_stdout ? STDOUT : OUTFILE, "ou=$proto", $NAMINGCONTEXT);
		push (@protos, $proto);
	}

	if ($use_stdout) {
		&dump_service(STDOUT, $servicename, $port, $proto, @aliases);
	} else {
		&dump_service(OUTFILE, $servicename, $port, $proto, @aliases);
	}
}

sub dump_service
{
	local($HANDLE, $servicename, $port, $proto, @aliases) = @_;
	
	
	return if (!$servicename);

	$servicenameEscaped = $servicename;
	$servicenameEscaped =~ s/\+/\\\+/g;
	print $HANDLE "dn: cn=$servicenameEscaped,ou=$proto,$NAMINGCONTEXT\n";
	print $HANDLE "objectClass: ipService\n";
	print $HANDLE "objectClass: top\n";
	print $HANDLE "ipServicePort: $port\n";
	print $HANDLE "ipServiceProtocol: $proto\n";
	print $HANDLE "cn: $servicename\n";
	@aliases = uniq($servicename, @aliases);
	foreach $_ (@aliases) {
		print $HANDLE "cn: $_\n";
	}
	print $HANDLE "\n";
}

close(INFILE);
if (OUTFILE != STDOUT) { close(OUTFILE); }

