// formantfilter.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "formantfilter.h"
#include "application.h"
#include "controller.h"
#include "lpcdata.h"
#include "formantrequester.h"

FormantFilter::FormantFilter(Data* input, Data* output,
	Data* lpcdata, double amp) : LPC_Filter(lpcdata, input->length()),
		  SimpleInputOutputFunction(input, output, lpcQueueSize, lpcQueueSize),
		  gain(amp), warpFactor(0), interpMode(Linear) {
	if(LPC_Filter::good())
		initialize();
}

FormantFilter::FormantFilter(Data* input, Data* output, Data* lpcdata)
		: LPC_Filter(lpcdata, input->length()),
		  SimpleInputOutputFunction(input, output, lpcQueueSize, lpcQueueSize),
		  gain(1.0), warpFactor(0), interpMode(Linear)
{
	okIf(LPC_Filter::good());
}

void
FormantFilter::initialize() {
	if(warpFactor != 0.0) {
		Data* warpData = new Data(FloatData, getLPC()->length() + 1);
		warpData->ref();
		Offset o(warpData, warpFactor);	// set to single value
		o.apply();
		setWarp(warpData);
		Resource::unref(warpData);
	}
	setInterpMode(InterpMode(interpMode));
	LPC_Filter::initialize();
	restoreState();
	SimpleInputOutputFunction::initialize();
}

void
FormantFilter::restoreState() {
	LPC_Filter::reset();
	SimpleInputOutputFunction::restoreState();
}

int
FormantFilter::doProcessing() {
	BUG("FormantFilter::doProcessing()");
	int status = true;
	while(!inQueueEmpty() && status == true) {
		status = processInput(false);
	}
	return status;
}

double
FormantFilter::doSimpleProcess(double sig) {
	BUG("FormantFilter::doSimpleProcess()");
	float amp = 0.0;
	float dummy1 = 0.0, dummy2 = 0.0;
	float* coeffs = getFrame(&amp, &dummy1, &dummy2);
	return filter(coeffs, sig * amp * gain);
}

Requester *
FormantFilter::createRequester() {
	return new FormantRequester("LPC (Formant) Filter Selected Region:",
	                            this, sampRate(), gain, warpFactor,
				    interpMode);
}

// this is here to remove ambiguity due to mult inheritance

Status
FormantFilter::configure(Controller *c) {
	return SimpleInputOutputFunction::configure(c);
}

