// textinput.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The TextInput class is a subclass of the InterViews StringEditor class,
// which is a GUI object for editing and displaying text strings in dialog
// windows.  The added functionality includes:  a QueryValue member into which
// the text is stored when the editing process is finished, and a linked list
// attachment allowing the user to select the "next" TextInput (if present) by
// typing a <tab> character.

#ifndef TEXTINPUT_H
#ifdef __GNUG__
#pragma interface
#endif
#define TEXTINPUT_H

#include <InterViews/streditor.h>

class ButtonState;
class QueryValue;

class TextInput : public StringEditor {
	typedef StringEditor Super;
public:
	TextInput* next;
	TextInput* head;
	TextInput(ButtonState *, const char *samp, QueryValue *value);
	TextInput(const char* name, ButtonState *, const char* samp, 
		QueryValue *value);
	virtual ~TextInput() {}
	redefined void Update();

	boolean setValue();
	TextInput *tail();
	void appendTo(TextInput *t);
protected:
	redefined void Reconfig();

	redefined boolean HandleChar(char c);
	virtual boolean checkChar(char c);
	void setText();
	virtual void doFinish();
	QueryValue* value() { return myValue; }
	virtual int setCurrent(const char*);
	virtual const char* stringValue();
private:
	void initialize();
	void selectNext();
	boolean valueChanged();
	QueryValue *myValue;
};

#endif
