// valueslider.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "adjtext.h"
#include "contscroller.h"
#include "numberlabel.h"
#include "queryvalue.h"
#include "valueslider.h"
#include <InterViews/adjuster.h>
#include <InterViews/border.h>
#include <InterViews/button.h>
#include <InterViews/box.h>
#include <InterViews/frame.h>
#include <InterViews/glue.h>
#include <InterViews/message.h>

ValueSlider::ValueSlider(ButtonState *state, QueryValue* value)
		: textInput(nil), slider(nil) {
	SetClassName("ValueSlider");
	Range bounds = value->range();
	numberMode = bounds.isInteger() ? Integer : Double;
	textInput = createTextInput(state, value, bounds);
	Box* interior;
	const int moverDelay = 2;	// .2 seconds delay on mover auto-repeat
    Frame* frame = new Frame(
        interior = new HBox(
			new Message("TextEntryLabel", value->label(), Center),
			new HGlue(5, 0),
			new Frame(textInput, 1),
			new HGlue(3, 0),
			new Frame(
				new HBox(
					createNumberLabel(bounds.min()),
					new VBorder,
					new LeftMover(textInput, moverDelay),
					slider = new ContinuousScroller(textInput, 20),
					new RightMover(textInput, moverDelay),
					new VBorder,
					createNumberLabel(bounds.max())
				), 1
			)
        ), 0	// no border around this
    );
	interior->Align(Center);
	Insert(frame);
}

void
ValueSlider::Resize() {
	MonoScene::Resize();
}

Interactor *
ValueSlider::createTextInput(
		ButtonState* state, QueryValue* value, const Range& bounds
	) {
	AdjustableText* text = (numberMode == Integer) ?
		(AdjustableText *) new AdjustableInteger(state, value, bounds)
		: (AdjustableText *) new AdjustableDouble(state, value, bounds);
	return text;
}

Interactor *
ValueSlider::createNumberLabel(double value) {
	static const int labelPad = 1;
	Interactor* label = nil;
	label = (numberMode == Integer) ?
		new NumberLabel(int(value), labelPad)
		: new NumberLabel(value, labelPad);
	return label;
}
