(* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of mlminidom, the Ocaml binding for minidom.
 * 
 * mlminidom is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * mlminidom is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mlminidom; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

exception Node_has_no_parent
exception Node_has_no_sibling of string
exception Node_has_no_children
exception Node_has_no_attributes
exception Attribute_has_no_sibling of string
exception Attribute_has_no_parent
exception Undefined_entity

class o_mDOMString : Minidom.mDOMString ->
  object
    method get_dom_string : Minidom.mDOMString
    method get_string : string
  end

val o_mDOMString_of_string : string -> o_mDOMString

class o_mDOMEntity : Minidom.mDOMEntity ->
  object
    method get_content : o_mDOMString
    method get_dom_entity : Minidom.mDOMEntity
  end

class o_mDOMDoc : Minidom.mDOMDoc ->
  object
    method add_entity : o_mDOMString -> o_mDOMString -> o_mDOMEntity
    method get_dom_doc : Minidom.mDOMDoc
    method get_entity : o_mDOMString -> o_mDOMEntity
    method get_predefined_entity : o_mDOMString -> o_mDOMEntity
    method get_root_node : o_mDOMNode
  end
and o_mDOMNode : Minidom.mDOMNode ->
  object
    method get_attribute : o_mDOMString -> o_mDOMString option
    method get_attribute_ns :
      o_mDOMString -> o_mDOMString -> o_mDOMString option
    method has_attribute : o_mDOMString -> bool
    method has_attribute_ns : o_mDOMString -> o_mDOMString -> bool
    method get_attributes : o_mDOMAttr list
    method get_children : o_mDOMNode list
    method get_content : o_mDOMString option
    method get_dom_node : Minidom.mDOMNode
    method get_first_attribute : o_mDOMAttr
    method get_first_child : o_mDOMNode
    method get_name : o_mDOMString option
    method get_next_sibling : o_mDOMNode
    method get_ns_uri : o_mDOMString option
    method get_parent : o_mDOMNode
    method get_prev_sibling : o_mDOMNode
    method get_type : int
    method is_blank : bool
    method is_element : bool
    method is_entity_ref : bool
    method is_first : bool
    method is_last : bool
    method is_text : bool
  end
and o_mDOMAttr : Minidom.mDOMAttr ->
  object
    method get_dom_attr : Minidom.mDOMAttr
    method get_name : o_mDOMString option
    method get_next_sibling : o_mDOMAttr
    method get_ns_uri : o_mDOMString option
    method get_parent : o_mDOMNode
    method get_prev_sibling : o_mDOMAttr
    method get_value : o_mDOMString option
  end
