/* Copyright (C) 2004 Mads Martin Joergensen <mmj at mmj.dk>
 *
 * $Id: statctrl.c,v 1.6 2004/11/22 14:12:56 mmj Exp $
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "strgen.h"
#include "statctrl.h"
#include "memory.h"
#include "log_error.h"

int statctrl(const char *listdir, const char *ctrlstr)
{
	char *filename = concatstr(3, listdir, "/control/", ctrlstr);
	struct stat st;
	int res;
	
	res = stat(filename, &st);
	myfree(filename);
	
	if(res < 0) {
		if(errno == ENOENT) {
			return 0;
		} else {
			log_error(LOG_ARGS, "Could not stat %s/control/%s. "
					    "Bailing out.", listdir, ctrlstr);
			exit(EXIT_FAILURE);
		}
	}

	return 1;
}
