/****** Object:  Table dbo.dict    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where name = 'dict' and type = 'U')
	drop table dict
GO

/****** Object:  Table dbo.url    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where name = 'url' and type = 'U')
	drop table url
GO

if (exists (select * from sysobjects where type = 'U' and name = 'server'))
	 drop table server
go
if (exists (select * from sysobjects where type = 'U' and name = 'urlinfo'))
	 drop table urlinfo
go

/****** Object:  Table dbo.dict    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE dict (
	url_id int NOT NULL ,
	word char (32) NOT NULL ,
	intag int NOT NULL 
)
GO

 CREATE  INDEX dict_url_id ON dict(url_id)
GO

 CREATE  INDEX dict_word_url_id ON dict(word, url_id)
GO

/****** Object:  Table dbo.url    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE url (
	rec_id numeric(9) IDENTITY PRIMARY KEY,
	status int NOT NULL ,
	url char (128) NOT NULL ,
	docsize int NULL ,
	next_index_time int NOT NULL ,
	last_mod_time int NULL,
	referrer int NULL ,
	hops int NULL ,
	crc32 int NULL ,
	seed int NOT NULL,
	bad_since_time int NULL,
	site_id int NULL
,
	pop_rank float NULL
)
GO

 CREATE  INDEX url_crc ON url(crc32)
GO

 CREATE  UNIQUE  INDEX url_url ON url(url) with ignore_dup_key
GO



CREATE TABLE urlinfo (
	url_id int4 NOT NULL,
	sname varchar(64),
	sval varchar(256)
)
go

CREATE INDEX urlinfo_id ON urlinfo (url_id)
go




CREATE TABLE server (
        rec_id numeric(10,0) identity PRIMARY KEY,
        active                int             default 0 			not null,
        url                   varchar(128)    default '' 			not null,
        alias                 varchar(128)    default '' 			not null,
        period                int             default 604800 	not null,
        tag                   varchar(16)     default '' 			not null,
        category              varchar(16)     default '' 			not null,
        charset               varchar(40)     default '' 			not null,
        lang                  varchar(32)     default '' 			not null,
        basic_auth            varchar(64)     default '' 			not null,
        proxy                 varchar(64)     default '' 			not null,
        proxy_port            int							default 3128 		not null,
        proxy_auth            varchar(64)     default '' 			not null,

        maxhops               int             default 9999 		not null,
        gindex                int             default 1 			not null,
        follow                int             default 1 			not null,
        deletebad             int             default 0				not null,
        use_robots            int             default 1				not null,
        use_clones            int             default 1				not null,

        max_net_errors        int             default 16			not null,
        net_delay_time        int             default 86400		not null,
        read_timeout          int             default 90			not null,

	command		      char(1)		not null	default 'S',
	match_type	      int				default 17,
	ordre		      int		not null,
	parent		      int		not null	default 0,
	weight		      float		not null	default 1,
	pop_weight	      float		not null	default 0
)
go

CREATE UNIQUE INDEX srv_url ON server (url)
go
CREATE INDEX srv_ordre ON server (ordre)
go
CREATE INDEX srv_parent ON server (parent)
go
CREATE INDEX srv_command ON server ("command")
go
