
#include <apr.h>
#include <apr_errno.h>
#include <apr_pools.h>
#include <apr_network_io.h>
#include <apr_strings.h>

#include <time.h>
#include <arpa/inet.h>

#include <libbtpeer/types/btp_peer.h>
#include <libbtpeer/bitfield.h>

const btp_peer new_btp_peer = {
    NULL,
    NULL,
    
    BT_EMPTY_PEERID,
    0,
    0,
    0,
    
    0,
    0,
    0,
    0,
    
    0,
    {0},
    0,
    NULL,
    0,
    0,
    
    {{0}},
    
    BTP_PEER_STATE_START,
    NULL
};

btp_peer* btp_peer_create(apr_pool_t* p, apr_socket_t* s) {
    btp_peer* peer = apr_palloc(p, sizeof(btp_peer));
    *peer = new_btp_peer;
    peer->p = p;
    peer->socket = s;
    peer->created = time(NULL);
    apr_socket_timeout_set(s, 0); /* non-blocking I/O */
    return peer;
}

apr_status_t btp_peer_send(btp_peer* p, const char* msg, apr_size_t* msglen) {
    apr_status_t ret;
    ret = apr_socket_send(p->socket, msg, msglen);
    if(*msglen) {
        p->last_sent = time(NULL);
        p->bytes_sent += *msglen;
    }
    return ret;
}

apr_status_t btp_peer_recv(btp_peer* p, char* msg, apr_size_t* msglen) {
    apr_status_t ret;
    ret = apr_socket_recv(p->socket, msg, msglen);
    if(*msglen) {
        p->last_received = time(NULL);
        p->bytes_received += *msglen;
    }
    return ret;
}

apr_status_t btp_peer_recv_no_cmd(btp_peer* p) {
    apr_size_t got = sizeof(p->netbuf) - p->netbuf_len;
    apr_status_t ret;
    btp_int_t cmdlen;
    ret = btp_peer_recv(p, p->netbuf + p->netbuf_len, &got);
    p->netbuf_len += got;
    
    if(p->netbuf_len >= sizeof(btp_int_t)) {
        int shave = 0;
        cmdlen = ntohl((btp_int_t)p->netbuf[0]);
        if(!cmdlen) {
            /* keepalive */
            shave = sizeof(btp_int_t);
        } else if(p->netbuf_len >= sizeof(btp_int_t) + sizeof(p->command)) {
            int copy = 0;
            shave = sizeof(btp_int_t) + sizeof(p->command);

            p->cmdbuf_expected = cmdlen - sizeof(p->command);

            if(p->cmdbuf_expected) {
                p->cmdbuf = apr_palloc(p->p, cmdlen - sizeof(p->command));
            
                if(p->cmdbuf_expected > (p->netbuf_len - shave)) {
                    copy = p->netbuf_len - shave;
                } else {
                    copy = p->cmdbuf_expected;
                }
            
                p->cmdbuf_len = p->netbuf_len - shave;
                
                memcpy(
                    &(p->command), p->netbuf + sizeof(btp_int_t),
                    sizeof(p->command)
                );
                
                memcpy(p->cmdbuf, p->netbuf + shave, copy);
            }
                
            shave += copy;
            p->state = p->state & BTP_PEER_STATE_IN_COMMAND;
        }
        
        if(shave) {
            memmove(p->netbuf, p->netbuf + shave, p->netbuf_len - shave);
            p->netbuf_len -= shave;
        }
    }
    return ret;
}

apr_status_t btp_peer_recv_in_cmd(btp_peer* p) {
    apr_size_t got = p->cmdbuf_expected - p->cmdbuf_len;
    apr_status_t ret;
    
    if(got) {
        ret = btp_peer_recv(p, p->cmdbuf + p->cmdbuf_len, &got);
        p->cmdbuf_len += got;
    } else {
        ret = APR_SUCCESS;
    }
    
    return ret;
}

apr_status_t btp_peer_add_request(btp_peer* p, btp_peer_request req) {
    int i;
    for(i=0;i<BTP_PEER_MAX_REQUESTS;i++)
        if(!p->requests[i].length)
            break;
    
    if(i == BTP_PEER_MAX_REQUESTS)
        return APR_ENOMEM;
    
    p->requests[i] = req;
    return APR_SUCCESS;
}

apr_status_t btp_peer_del_request(btp_peer* p, btp_peer_request req) {
    int i;
    for(i=0;i<BTP_PEER_MAX_REQUESTS;i++)
        if(!memcmp(&(p->requests[i]), &req, sizeof(req)))
            break;
        
    if(i == BTP_PEER_MAX_REQUESTS)
        return APR_NOTFOUND;

    p->requests[i].length = 0;
    return APR_SUCCESS;
}
