#ifndef __LIBBTPEER_TYPES_BTP_TORRENT_PIECES_H
#define __LIBBTPEER_TYPES_BTP_TORRENT_PIECES_H

#include <libbtpeer/types/btp_torrent.h>

#define BTP_TORRENT_PIECE_START(t,p) \
    (p * (t->info->piece_size / t->block_size))

#define BTP_TORRENT_PIECE_BLOCKS(t,p) ( \
    ( \
        p < t->info->piece_count - 1 || \
        !(t->block_count % (t->info->piece_size / t->block_size)) \
    ) \
    ? \
    (t->info->piece_size / t->block_size) \
    : \
    (t->block_count % (t->info->piece_size / t->block_size)) \
)

#define BTP_TORRENT_BLOCK_PIECE(t,b) \
    (b / (t->info->piece_size / t->block_size))


extern btp_torrent_pieces* btp_torrent_pieces_init(btp_torrent* torrent);
extern float btp_torrent_pieces_complete(btp_torrent* torrent);
extern int btp_torrent_piece_complete(btp_torrent* torrent, int piece);
extern void btp_torrent_piece_add(btp_torrent* torrent, int piece);
extern void btp_torrent_piece_add_block(btp_torrent* torrent, int block);
extern void btp_torrent_block_add_downloader(btp_torrent* torrent, int block);
extern void btp_torrent_block_remove_downloader(
    btp_torrent* torrent, int block
);
extern void btp_torrent_block_remove(btp_torrent* torrent, int block);
extern void btp_torrent_block_bits_set(btp_torrent* torrent);
extern int btp_torrent_piece_missing_block(btp_torrent* torrent, int piece);
extern int btp_torrent_piece_most_missing_block(
    btp_torrent* torrent, int piece, int* downloaders
);



#endif /* __LIBBTPEER_TYPES_BTP_TORRENT_PIECES_H */
