/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mconfig.h,v 1.31 2002/01/03 12:14:03 ostborn Exp $
*/

#ifndef _M_CONFIG_H_
#define _M_CONFIG_H_

#include "config.h"
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#ifdef HAVE_LIBADNS
#include <adns.h>
#endif

#include "mhash.h"

#if 0
#define IS_M_DEBUG(dbg, sec, lvl) \
		((dbg >> (sec * M_DEBUG_LEVEL_SHIFT) & M_DEBUG_LEVEL_MASK) >= lvl)
#else 
#define IS_M_DEBUG(dbg, sec, lvl) \
		(dbg >= lvl)
#endif


#ifdef HAVE_FUNCTION
#define M_DEBUG0(dbg, sec, lvl, fmt) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__); \
                } 


#define M_DEBUG1(dbg, sec, lvl, fmt, parm1) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1); \
                } 

#define M_DEBUG2(dbg, sec, lvl, fmt, parm1, parm2) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1, parm2); \
                } 

#define M_DEBUG3(dbg, sec, lvl, fmt, parm1, parm2, parm3) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1, parm2, parm3); \
                } 
#else
#define M_DEBUG0(dbg, sec, lvl, fmt) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__); \
                } 


#define M_DEBUG1(dbg, sec, lvl, fmt, parm1) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1); \
                } 

#define M_DEBUG2(dbg, sec, lvl, fmt, parm1, parm2) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1, parm2); \
                } 

#define M_DEBUG3(dbg, sec, lvl, fmt, parm1, parm2, parm3) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1, parm2, parm3); \
                } 
#endif
					

#define M_DEBUG_LEVEL_MASK              0x3
#define M_DEBUG_LEVEL_SHIFT             2
#define M_DEBUG_LEVEL_NONE              0
#define M_DEBUG_LEVEL_ERRORS            1
#define M_DEBUG_LEVEL_WARNINGS          2
#define M_DEBUG_LEVEL_VERBOSE           3

#define M_DEBUG_SECTION_INIT            0 
#define M_DEBUG_SECTION_PARSING         1
#define M_DEBUG_SECTION_PROCESSING      2
#define M_DEBUG_SECTION_GENERATING      3
#define M_DEBUG_SECTION_CLEANUP         4
#define M_DEBUG_SECTION_INTERNALS       5
#define M_DEBUG_SECTION_MAINLOOP        6


#define M_CONFIG_TYPE_STRING		0
#define M_CONFIG_TYPE_INT		1
#define M_CONFIG_TYPE_SUBSTITUTE	2
#define M_CONFIG_TYPE_MATCH		3
#define M_CONFIG_TYPE_COLTRIPPL		4
#define M_CONFIG_TYPE_CHAR		5
#define M_CONFIG_TYPE_STRING_LIST	6

#define M_CONFIG_VALUE_IGNORE		1
#define M_CONFIG_VALUE_OVERWRITE	2
#define M_CONFIG_VALUE_APPEND		3

typedef struct {
	char *string;	/* name of the entry */
	int type;	/* type of the value (M_CONFIG_TYPE...)*/
	int value_def;	/* how to handle an field with the same key (append, overwrite, ignore) */
	void *dest;	/* where to put the result into */
} mconfig_values;

typedef struct {
	mlist *loadplugins;
	mlist *include;
	mlist *includepath;
	
	char *outputdir;
	char *configfile;

	int incremental;

	int debug_level;
	int show_options;
	
	int compress_mode;
	
	int gen_report_threshold;
	int enable_resolver;
	
#ifdef HAVE_LIBADNS
	adns_state *adns;
	mhash	*query_hash;
#endif
	
	/* magic handler for the currently used plugin */
	void *plugin_conf;
	
	void *plugins;
	int plugin_count;
} mconfig;

mconfig* mconfig_init(const char *fn);
int mconfig_free(mconfig *);

int mconfig_parse_section(mconfig *conf, const char *cf, const char *section, const mconfig_values config_values[]);
FILE *mfopen (mconfig *ext_conf, const char *filename, const char *rights);

#endif
